/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import jdk.jfr.RecordingState;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.PlatformRecorder;
import jdk.jfr.internal.PlatformRecording;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.WriteableUserPath;

final class ShutdownHook
implements Runnable {
    private final PlatformRecorder recorder;
    Object tlabDummyObject;

    ShutdownHook(PlatformRecorder recorder) {
        this.recorder = recorder;
    }

    @Override
    public void run() {
        this.tlabDummyObject = new Object();
        for (PlatformRecording recording : this.recorder.getRecordings()) {
            if (!recording.getDumpOnExit() || recording.getState() != RecordingState.RUNNING) continue;
            this.dump(recording);
        }
        this.recorder.destroy();
    }

    private void dump(PlatformRecording recording) {
        try {
            WriteableUserPath dest = recording.getDestination();
            if (dest == null) {
                dest = this.makeDumpOnExitPath(recording);
                recording.setDestination(dest);
            }
            if (dest != null) {
                recording.stop("Dump on exit");
            }
        }
        catch (Exception e) {
            Logger.log(LogTag.JFR, LogLevel.DEBUG, () -> "Could not dump recording " + recording.getName() + " on exit.");
        }
    }

    private WriteableUserPath makeDumpOnExitPath(final PlatformRecording recording) {
        try {
            final String name = Utils.makeFilename(recording.getRecording());
            AccessControlContext acc = recording.getNoDestinationDumpOnExitAccessControlContext();
            return AccessController.doPrivileged(new PrivilegedExceptionAction<WriteableUserPath>(){

                @Override
                public WriteableUserPath run() throws Exception {
                    return new WriteableUserPath(recording.getDumpOnExitDirectory().toPath().resolve(name));
                }
            }, acc);
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof SecurityException) {
                Logger.log(LogTag.JFR, LogLevel.WARN, "Not allowed to create dump path for recording " + recording.getId() + " on exit.");
            }
            if (t instanceof IOException) {
                Logger.log(LogTag.JFR, LogLevel.WARN, "Could not dump " + recording.getId() + " on exit.");
            }
            return null;
        }
    }

    static final class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        ExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            JVM.getJVM().uncaughtException(t, e);
        }
    }
}

