/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.instrument;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import jdk.jfr.events.SocketReadEvent;
import jdk.jfr.events.SocketWriteEvent;
import jdk.jfr.internal.instrument.JIInstrumentationMethod;
import jdk.jfr.internal.instrument.JIInstrumentationTarget;

@JIInstrumentationTarget(value="sun.nio.ch.SocketChannelImpl")
final class SocketChannelImplInstrumentor {
    private InetSocketAddress remoteAddress;

    private SocketChannelImplInstrumentor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int read(ByteBuffer dst) throws IOException {
        SocketReadEvent event = SocketReadEvent.EVENT.get();
        if (!event.isEnabled()) {
            return this.read(dst);
        }
        int bytesRead = 0;
        try {
            event.begin();
            bytesRead = this.read(dst);
        }
        finally {
            event.end();
            if (event.shouldCommit()) {
                String hostString = this.remoteAddress.getAddress().toString();
                int delimiterIndex = hostString.lastIndexOf(47);
                event.host = hostString.substring(0, delimiterIndex);
                event.address = hostString.substring(delimiterIndex + 1);
                event.port = this.remoteAddress.getPort();
                if (bytesRead < 0) {
                    event.endOfStream = true;
                } else {
                    event.bytesRead = bytesRead;
                }
                event.timeout = 0L;
                event.commit();
                event.reset();
            }
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        SocketReadEvent event = SocketReadEvent.EVENT.get();
        if (!event.isEnabled()) {
            return this.read(dsts, offset, length);
        }
        long bytesRead = 0L;
        try {
            event.begin();
            bytesRead = this.read(dsts, offset, length);
        }
        finally {
            event.end();
            if (event.shouldCommit()) {
                String hostString = this.remoteAddress.getAddress().toString();
                int delimiterIndex = hostString.lastIndexOf(47);
                event.host = hostString.substring(0, delimiterIndex);
                event.address = hostString.substring(delimiterIndex + 1);
                event.port = this.remoteAddress.getPort();
                if (bytesRead < 0L) {
                    event.endOfStream = true;
                } else {
                    event.bytesRead = bytesRead;
                }
                event.timeout = 0L;
                event.commit();
                event.reset();
            }
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int write(ByteBuffer buf) throws IOException {
        SocketWriteEvent event = SocketWriteEvent.EVENT.get();
        if (!event.isEnabled()) {
            return this.write(buf);
        }
        int bytesWritten = 0;
        try {
            event.begin();
            bytesWritten = this.write(buf);
        }
        catch (Throwable throwable) {
            event.end();
            if (event.shouldCommit()) {
                String hostString = this.remoteAddress.getAddress().toString();
                int delimiterIndex = hostString.lastIndexOf(47);
                event.host = hostString.substring(0, delimiterIndex);
                event.address = hostString.substring(delimiterIndex + 1);
                event.port = this.remoteAddress.getPort();
                event.bytesWritten = bytesWritten < 0 ? 0L : (long)bytesWritten;
                event.commit();
                event.reset();
            }
            throw throwable;
        }
        event.end();
        if (event.shouldCommit()) {
            String hostString = this.remoteAddress.getAddress().toString();
            int delimiterIndex = hostString.lastIndexOf(47);
            event.host = hostString.substring(0, delimiterIndex);
            event.address = hostString.substring(delimiterIndex + 1);
            event.port = this.remoteAddress.getPort();
            event.bytesWritten = bytesWritten < 0 ? 0L : (long)bytesWritten;
            event.commit();
            event.reset();
        }
        return bytesWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        SocketWriteEvent event = SocketWriteEvent.EVENT.get();
        if (!event.isEnabled()) {
            return this.write(srcs, offset, length);
        }
        long bytesWritten = 0L;
        try {
            event.begin();
            bytesWritten = this.write(srcs, offset, length);
        }
        catch (Throwable throwable) {
            event.end();
            if (event.shouldCommit()) {
                String hostString = this.remoteAddress.getAddress().toString();
                int delimiterIndex = hostString.lastIndexOf(47);
                event.host = hostString.substring(0, delimiterIndex);
                event.address = hostString.substring(delimiterIndex + 1);
                event.port = this.remoteAddress.getPort();
                event.bytesWritten = bytesWritten < 0L ? 0L : bytesWritten;
                event.commit();
                event.reset();
            }
            throw throwable;
        }
        event.end();
        if (event.shouldCommit()) {
            String hostString = this.remoteAddress.getAddress().toString();
            int delimiterIndex = hostString.lastIndexOf(47);
            event.host = hostString.substring(0, delimiterIndex);
            event.address = hostString.substring(delimiterIndex + 1);
            event.port = this.remoteAddress.getPort();
            event.bytesWritten = bytesWritten < 0L ? 0L : bytesWritten;
            event.commit();
            event.reset();
        }
        return bytesWritten;
    }
}

