/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jdk.jfr.AnnotationElement;
import jdk.jfr.Event;
import jdk.jfr.EventType;
import jdk.jfr.Period;
import jdk.jfr.StackTrace;
import jdk.jfr.Threshold;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.internal.Cutoff;
import jdk.jfr.internal.EventControl;
import jdk.jfr.internal.EventHandlerCreator;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataDescriptor;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.RequestEngine;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.SettingsManager;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.TypeLibrary;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.handlers.EventHandler;

public final class MetadataRepository {
    private static final JVM jvm = JVM.getJVM();
    private static final MetadataRepository instace = new MetadataRepository();
    private final List<EventType> nativeEventTypes = new ArrayList<EventType>(100);
    private final List<EventControl> nativeControls = new ArrayList<EventControl>(100);
    private final TypeLibrary typeLibrary = TypeLibrary.getInstance();
    private final SettingsManager settingsManager = new SettingsManager();
    private boolean staleMetadata = true;
    private boolean unregistered;
    private long lastUnloaded = -1L;

    public MetadataRepository() {
        this.initializeJVMEventTypes();
    }

    private void initializeJVMEventTypes() {
        ArrayList<RequestEngine.RequestHook> requestHooks = new ArrayList<RequestEngine.RequestHook>();
        for (Type type : this.typeLibrary.getTypes()) {
            if (!(type instanceof PlatformEventType)) continue;
            PlatformEventType pEventType = (PlatformEventType)type;
            EventType eventType = PrivateAccess.getInstance().newEventType(pEventType);
            pEventType.setHasDuration(eventType.getAnnotation(Threshold.class) != null);
            pEventType.setHasStackTrace(eventType.getAnnotation(StackTrace.class) != null);
            pEventType.setHasCutoff(eventType.getAnnotation(Cutoff.class) != null);
            pEventType.setHasPeriod(eventType.getAnnotation(Period.class) != null);
            if (pEventType.hasPeriod()) {
                pEventType.setEventHook(true);
                if (!"jdk.ExecutionSample".equals(type.getName())) {
                    requestHooks.add(new RequestEngine.RequestHook(pEventType));
                }
            }
            this.nativeControls.add(new EventControl(pEventType));
            this.nativeEventTypes.add(eventType);
        }
        RequestEngine.addHooks(requestHooks);
    }

    public static MetadataRepository getInstance() {
        return instace;
    }

    public synchronized List<EventType> getRegisteredEventTypes() {
        List<EventHandler> handlers = MetadataRepository.getEventHandlers();
        ArrayList<EventType> eventTypes = new ArrayList<EventType>(handlers.size() + this.nativeEventTypes.size());
        for (EventHandler h : handlers) {
            if (!h.isRegistered()) continue;
            eventTypes.add(h.getEventType());
        }
        eventTypes.addAll(this.nativeEventTypes);
        return eventTypes;
    }

    public synchronized EventType getEventType(Class<? extends Event> eventClass) {
        EventHandler h = this.getHandler(eventClass);
        if (h != null && h.isRegistered()) {
            return h.getEventType();
        }
        throw new IllegalStateException("Event class " + eventClass.getName() + " is not registered");
    }

    public synchronized void unregister(Class<? extends Event> eventClass) {
        Utils.checkRegisterPermission();
        EventHandler handler = this.getHandler(eventClass);
        if (handler != null) {
            handler.setRegistered(false);
        }
    }

    public synchronized EventType register(Class<? extends Event> eventClass) {
        return this.register(eventClass, Collections.emptyList(), Collections.emptyList());
    }

    public synchronized EventType register(Class<? extends Event> eventClass, List<AnnotationElement> dynamicAnnotations, List<ValueDescriptor> dynamicFields) {
        Utils.checkRegisterPermission();
        EventHandler handler = this.getHandler(eventClass);
        if (handler == null) {
            handler = this.makeHandler(eventClass, dynamicAnnotations, dynamicFields);
        }
        handler.setRegistered(true);
        this.typeLibrary.addType(handler.getPlatformEventType());
        if (jvm.isRecording()) {
            this.storeDescriptorInJVM();
            this.settingsManager.setEventControl(handler.getEventControl());
            this.settingsManager.updateRetransform(Collections.singletonList(eventClass));
        } else {
            this.setStaleMetadata();
        }
        return handler.getEventType();
    }

    private EventHandler getHandler(Class<? extends Event> eventClass) {
        Utils.ensureValidEventSubclass(eventClass);
        SecuritySupport.makeVisibleToJFR(eventClass);
        Utils.ensureInitialized(eventClass);
        return Utils.getHandler(eventClass);
    }

    private EventHandler makeHandler(Class<? extends Event> eventClass, List<AnnotationElement> dynamicAnnotations, List<ValueDescriptor> dynamicFields) throws InternalError {
        SecuritySupport.addHandlerExport(eventClass);
        PlatformEventType pEventType = (PlatformEventType)TypeLibrary.createType(eventClass, dynamicAnnotations, dynamicFields);
        EventType eventType = PrivateAccess.getInstance().newEventType(pEventType);
        EventControl ec = new EventControl(pEventType, eventClass);
        Class<EventHandler> handlerClass = null;
        try {
            String eventHandlerName = EventHandlerCreator.makeEventHandlerName(eventType.getId());
            handlerClass = Class.forName(eventHandlerName, false, Event.class.getClassLoader()).asSubclass(EventHandler.class);
            pEventType.setInstrumented();
            Logger.log(LogTag.JFR_SYSTEM, LogLevel.DEBUG, "Found existing event handler for " + eventType.getName());
        }
        catch (ClassNotFoundException cne) {
            EventHandlerCreator ehc = new EventHandlerCreator(eventType.getId(), ec.getSettingInfos(), eventType, eventClass);
            handlerClass = ehc.makeEventHandlerClass();
            Logger.log(LogTag.JFR_SYSTEM, LogLevel.DEBUG, "Created event handler for " + eventType.getName());
        }
        EventHandler handler = EventHandlerCreator.instantiateEventHandler(handlerClass, true, eventType, ec);
        Utils.setHandler(eventClass, handler);
        return handler;
    }

    public synchronized void setSettings(List<Map<String, String>> list) {
        this.settingsManager.setSettings(list);
    }

    synchronized void disableEvents() {
        for (EventControl c : this.getEventControls()) {
            c.disable();
        }
    }

    public synchronized List<EventControl> getEventControls() {
        ArrayList<EventControl> controls = new ArrayList<EventControl>();
        controls.addAll(this.nativeControls);
        for (EventHandler eh : MetadataRepository.getEventHandlers()) {
            controls.add(eh.getEventControl());
        }
        return controls;
    }

    private void storeDescriptorInJVM() throws InternalError {
        jvm.storeMetadataDescriptor(this.getBinaryRepresentation());
        this.staleMetadata = false;
    }

    private static List<EventHandler> getEventHandlers() {
        List<Class<? extends Event>> allEventClasses = jvm.getAllEventClasses();
        ArrayList<EventHandler> eventHandlers = new ArrayList<EventHandler>(allEventClasses.size());
        for (Class<? extends Event> clazz : allEventClasses) {
            EventHandler eh = Utils.getHandler(clazz);
            if (eh == null) continue;
            eventHandlers.add(eh);
        }
        return eventHandlers;
    }

    private byte[] getBinaryRepresentation() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(40000);
        DataOutputStream daos = new DataOutputStream(baos);
        try {
            List<Type> types = this.typeLibrary.getTypes();
            Collections.sort(types);
            MetadataDescriptor.write(types, daos);
            daos.flush();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new InternalError(e);
        }
    }

    synchronized boolean isEnabled(String eventName) {
        return this.settingsManager.isEnabled(eventName);
    }

    synchronized void setStaleMetadata() {
        this.staleMetadata = true;
    }

    synchronized void setOutput(String filename) {
        jvm.setOutput(filename);
        this.unregisterUnloaded();
        if (this.unregistered) {
            this.staleMetadata = this.typeLibrary.clearUnregistered();
            this.unregistered = false;
        }
        if (this.staleMetadata) {
            this.storeDescriptorInJVM();
        }
    }

    private void unregisterUnloaded() {
        long unloaded = jvm.getUnloadedEventClassCount();
        if (this.lastUnloaded != unloaded) {
            this.lastUnloaded = unloaded;
            List<Class<? extends Event>> eventClasses = jvm.getAllEventClasses();
            HashSet<Long> knownIds = new HashSet<Long>(eventClasses.size());
            for (Class<? extends Event> ec : eventClasses) {
                knownIds.add(Type.getTypeId(ec));
            }
            for (Type type : this.typeLibrary.getTypes()) {
                PlatformEventType pe;
                if (!(type instanceof PlatformEventType) || knownIds.contains(type.getId()) || (pe = (PlatformEventType)type).isJVM()) continue;
                pe.setRegistered(false);
            }
        }
    }

    public synchronized void setUnregistered() {
        this.unregistered = true;
    }
}

