/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import jdk.jfr.Event;
import jdk.jfr.EventType;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataRepository;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.PrivateAccess;

public final class RequestEngine {
    private static final JVM jvm = JVM.getJVM();
    private static final List<RequestHook> entries = new CopyOnWriteArrayList<RequestHook>();
    private static long lastTimeMillis;

    public static void addHook(AccessControlContext acc, PlatformEventType type, Runnable hook) {
        Objects.requireNonNull(acc);
        RequestEngine.addHookInternal(acc, type, hook);
    }

    private static void addHookInternal(AccessControlContext acc, PlatformEventType type, Runnable hook) {
        RequestHook he = new RequestHook(acc, type, hook);
        for (RequestHook e : entries) {
            if (e.hook != hook) continue;
            throw new IllegalArgumentException("Hook has already been added");
        }
        he.type.setEventHook(true);
        entries.add(he);
        RequestEngine.logHook("Added", type);
    }

    public static void addTrustedJDKHook(Class<? extends Event> eventClass, Runnable runnable) {
        if (eventClass.getClassLoader() != null) {
            throw new SecurityException("Hook can only be registered for event classes that are loaded by the bootstrap class loader");
        }
        if (runnable.getClass().getClassLoader() != null) {
            throw new SecurityException("Runnable hook class must be loaded by the bootstrap class loader");
        }
        EventType eType = MetadataRepository.getInstance().getEventType(eventClass);
        PlatformEventType pType = PrivateAccess.getInstance().getPlatformEventType(eType);
        RequestEngine.addHookInternal(null, pType, runnable);
    }

    private static void logHook(String action, PlatformEventType type) {
        if (type.isJDK() || type.isJVM()) {
            Logger.log(LogTag.JFR_SYSTEM_EVENT, LogLevel.INFO, action + " periodic hook for " + type.getLogName());
        } else {
            Logger.log(LogTag.JFR_EVENT, LogLevel.INFO, action + " periodic hook for " + type.getLogName());
        }
    }

    public static boolean removeHook(Runnable hook) {
        for (RequestHook rh : entries) {
            if (rh.hook != hook) continue;
            entries.remove(rh);
            rh.type.setEventHook(false);
            RequestEngine.logHook("Removed", rh.type);
            return true;
        }
        return false;
    }

    static void addHooks(List<RequestHook> newEntries) {
        ArrayList<RequestHook> addEntries = new ArrayList<RequestHook>();
        for (RequestHook rh : newEntries) {
            rh.type.setEventHook(true);
            addEntries.add(rh);
            RequestEngine.logHook("Added", rh.type);
        }
        entries.addAll(newEntries);
    }

    static void doChunkEnd() {
        RequestEngine.doChunk(x -> x.isEndChunk());
    }

    static void doChunkBegin() {
        RequestEngine.doChunk(x -> x.isBeginChunk());
    }

    private static void doChunk(Predicate<PlatformEventType> predicate) {
        for (RequestHook requestHook : entries) {
            PlatformEventType s = requestHook.type;
            if (!s.isEnabled() || !predicate.test(s)) continue;
            requestHook.execute();
        }
    }

    static long doPeriodic() {
        return RequestEngine.run_requests(entries);
    }

    private static long run_requests(Collection<RequestHook> entries) {
        long last = lastTimeMillis;
        long now = System.currentTimeMillis();
        long min = 0L;
        long delta = 0L;
        if (last == 0L) {
            last = now;
        }
        if ((delta = now - last) < 0L) {
            lastTimeMillis = now;
            return 0L;
        }
        for (RequestHook he : entries) {
            long left = 0L;
            PlatformEventType es = he.type;
            if (!es.isEnabled() || es.isEveryChunk()) continue;
            long r_period = es.getPeriod();
            long r_delta = he.delta;
            if ((r_delta += delta) >= r_period) {
                r_delta = 0L;
                he.execute();
            }
            if ((left = r_period - r_delta) < 0L) {
                left = 0L;
            }
            he.delta = r_delta;
            if (min != 0L && left >= min) continue;
            min = left;
        }
        lastTimeMillis = now;
        return min;
    }

    static final class RequestHook {
        private final Runnable hook;
        private final PlatformEventType type;
        private final AccessControlContext accessControllerContext;
        private long delta;

        private RequestHook(AccessControlContext acc, PlatformEventType eventType, Runnable hook) {
            this.hook = hook;
            this.type = eventType;
            this.accessControllerContext = acc;
        }

        RequestHook(PlatformEventType eventType) {
            this(null, eventType, null);
        }

        private void execute() {
            try {
                if (this.accessControllerContext == null) {
                    if (this.type.isJDK()) {
                        this.hook.run();
                    } else {
                        jvm.emitEvent(this.type.getId(), JVM.counterTime(), 0L);
                    }
                    if (Logger.shouldLog(LogTag.JFR_EVENT, LogLevel.DEBUG)) {
                        Logger.log(LogTag.JFR_SYSTEM_EVENT, LogLevel.DEBUG, () -> "Executed periodic hook for " + this.type.getLogName());
                    }
                } else {
                    this.executeSecure();
                }
            }
            catch (Throwable e) {
                Logger.log(LogTag.JFR_SYSTEM_EVENT, LogLevel.WARN, "Exception occured during execution of period hook for " + this.type.getLogName());
            }
        }

        private void executeSecure() {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        hook.run();
                        if (Logger.shouldLog(LogTag.JFR_EVENT, LogLevel.DEBUG)) {
                            Logger.log(LogTag.JFR_EVENT, LogLevel.DEBUG, () -> "Executed periodic hook for " + type.getLogName());
                        }
                    }
                    catch (Throwable t) {
                        Logger.log(LogTag.JFR_EVENT, LogLevel.WARN, "Exception occured during execution of period hook for " + type.getLogName());
                    }
                    return null;
                }
            }, this.accessControllerContext);
        }
    }
}

