/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.tool;

import java.util.Arrays;
import java.util.LinkedList;
import jdk.jfr.internal.tool.Command;
import jdk.jfr.internal.tool.UserDataException;
import jdk.jfr.internal.tool.UserSyntaxException;

public final class Main {
    private static final int EXIT_OK = 0;
    private static final int EXIT_FAILED = 1;
    private static final int EXIT_WRONG_ARGUMENTS = 2;

    public static void main(String ... args) {
        LinkedList<String> argList = new LinkedList<String>(Arrays.asList(args));
        if (argList.isEmpty()) {
            System.out.println("Tool for working with Flight Recorder files (.jfr)");
            System.out.println();
            System.out.println("Before using this tool, you must have a recording file.");
            System.out.println("A file can be created by starting a recording from command line:");
            System.out.println();
            System.out.println(" java -XX:StartFlightRecording:filename=recording.jfr,duration=30s ... ");
            System.out.println();
            System.out.println("A recording can also be started on already running Java Virtual Machine:");
            System.out.println();
            System.out.println(" jcmd (to list available pids)");
            System.out.println(" jcmd <pid> JFR.start");
            System.out.println();
            System.out.println("Recording data can be dumped to file using the JFR.dump command:");
            System.out.println();
            System.out.println(" jcmd <pid> JFR.dump filename=recording.jfr");
            System.out.println();
            System.out.println("The contents of the recording can then be printed, for example:");
            System.out.println();
            System.out.println(" jfr print recording.jfr");
            System.out.println();
            System.out.println(" jfr print --events CPULoad,GarbageCollection recording.jfr");
            System.out.println();
            System.out.println(" jfr print --json --events CPULoad recording.jfr");
            System.out.println();
            System.out.println(" jfr print --categories \"GC,JVM,Java*\" recording.jfr");
            System.out.println();
            System.out.println(" jfr print --events \"jdk.*\" --stack-depth 64 recording.jfr");
            System.out.println();
            System.out.println(" jfr summary recording.jfr");
            System.out.println();
            System.out.println(" jfr metadata recording.jfr");
            System.out.println();
            System.out.println("For more information about available commands, use 'jfr help'");
            System.exit(0);
        }
        String command = (String)argList.remove();
        for (Command c : Command.getCommands()) {
            if (!c.matches(command)) continue;
            try {
                c.execute(argList);
                System.exit(0);
            }
            catch (UserDataException ude) {
                System.err.println("jfr " + c.getName() + ": " + ude.getMessage());
                System.exit(1);
            }
            catch (UserSyntaxException use) {
                System.err.println("jfr " + c.getName() + ": " + use.getMessage());
                System.err.println();
                System.err.println("Usage:");
                System.err.println();
                c.displayUsage(System.err);
                System.exit(2);
            }
            catch (Throwable e) {
                System.err.println("jfr " + c.getName() + ": unexpected internal error, " + e.getMessage());
                e.printStackTrace();
                System.exit(1);
            }
        }
        System.err.println("jfr: unknown command '" + command + "'");
        System.err.println();
        System.err.println("List of available commands:");
        System.err.println();
        Command.displayAvailableCommands(System.err);
        System.exit(2);
    }
}

