/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.jfr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import javax.management.openmbean.CompositeData;
import jdk.jfr.EventType;
import jdk.jfr.SettingDescriptor;
import jdk.management.jfr.SettingDescriptorInfo;
import jdk.management.jfr.Stringifier;

public final class EventTypeInfo {
    private final List<SettingDescriptorInfo> settings;
    private final long id;
    private final String name;
    private final String description;
    private final String label;
    private final List<String> categoryNames;

    EventTypeInfo(EventType eventType) {
        this.settings = EventTypeInfo.creatingSettingDescriptorInfos(eventType);
        this.id = eventType.getId();
        this.name = eventType.getName();
        this.label = eventType.getLabel();
        this.description = eventType.getDescription();
        this.categoryNames = eventType.getCategoryNames();
    }

    private EventTypeInfo(CompositeData cd) {
        this.settings = EventTypeInfo.createSettings(cd.get("settings"));
        this.id = (Long)cd.get("id");
        this.name = (String)cd.get("name");
        this.label = (String)cd.get("label");
        this.description = (String)cd.get("description");
        this.categoryNames = EventTypeInfo.createCategoryNames((Object[])cd.get("category"));
    }

    private static List<String> createCategoryNames(Object[] array) {
        ArrayList<String> list = new ArrayList<String>(array.length);
        for (int i = 0; i < array.length; ++i) {
            list.add((String)array[i]);
        }
        return Collections.unmodifiableList(list);
    }

    private static List<SettingDescriptorInfo> creatingSettingDescriptorInfos(EventType eventType) {
        List<SettingDescriptor> settings = eventType.getSettingDescriptors();
        ArrayList<SettingDescriptorInfo> settingDescriptorInfos = new ArrayList<SettingDescriptorInfo>(settings.size());
        for (SettingDescriptor s : settings) {
            settingDescriptorInfos.add(new SettingDescriptorInfo(s));
        }
        return Collections.unmodifiableList(settingDescriptorInfos);
    }

    private static List<SettingDescriptorInfo> createSettings(Object settings) {
        if (settings != null && settings.getClass().isArray()) {
            Object[] settingsArray = (Object[])settings;
            ArrayList<SettingDescriptorInfo> list = new ArrayList<SettingDescriptorInfo>(settingsArray.length);
            for (Object cd : settingsArray) {
                if (!(cd instanceof CompositeData)) continue;
                list.add(SettingDescriptorInfo.from((CompositeData)cd));
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public String getLabel() {
        return this.label;
    }

    public List<String> getCategoryNames() {
        return this.categoryNames;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<SettingDescriptorInfo> getSettingDescriptors() {
        return this.settings;
    }

    public String toString() {
        Stringifier s = new Stringifier();
        s.add("id", this.id);
        s.add("name", this.name);
        s.add("label", this.label);
        s.add("description", this.description);
        StringJoiner sj = new StringJoiner(", ", "{", "}");
        for (String categoryName : this.categoryNames) {
            sj.add(categoryName);
        }
        s.add("category", sj.toString());
        return s.toString();
    }

    public static EventTypeInfo from(CompositeData cd) {
        if (cd == null) {
            return null;
        }
        return new EventTypeInfo(cd);
    }
}

