/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.jfr;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Paths;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.StandardEmitterMBean;
import jdk.jfr.Configuration;
import jdk.jfr.EventType;
import jdk.jfr.FlightRecorder;
import jdk.jfr.FlightRecorderListener;
import jdk.jfr.FlightRecorderPermission;
import jdk.jfr.Recording;
import jdk.jfr.RecordingState;
import jdk.jfr.internal.management.ManagementSupport;
import jdk.management.jfr.ConfigurationInfo;
import jdk.management.jfr.EventTypeInfo;
import jdk.management.jfr.FlightRecorderMXBean;
import jdk.management.jfr.MBeanUtils;
import jdk.management.jfr.RecordingInfo;
import jdk.management.jfr.StreamManager;

final class FlightRecorderMXBeanImpl
extends StandardEmitterMBean
implements FlightRecorderMXBean,
NotificationEmitter {
    private static final String ATTRIBUTE_RECORDINGS = "Recordings";
    private static final String OPTION_MAX_SIZE = "maxSize";
    private static final String OPTION_MAX_AGE = "maxAge";
    private static final String OPTION_NAME = "name";
    private static final String OPTION_DISK = "disk";
    private static final String OPTION_DUMP_ON_EXIT = "dumpOnExit";
    private static final String OPTION_DURATION = "duration";
    private static final List<String> OPTIONS = Arrays.asList("dumpOnExit", "duration", "name", "maxAge", "maxSize", "disk");
    private final StreamManager streamHandler = new StreamManager();
    private final Map<Long, Object> changes = new ConcurrentHashMap<Long, Object>();
    private final AtomicLong sequenceNumber = new AtomicLong();
    private final List<MXBeanListener> listeners = new CopyOnWriteArrayList<MXBeanListener>();
    private FlightRecorder recorder;

    FlightRecorderMXBeanImpl() {
        super(FlightRecorderMXBean.class, true, (NotificationEmitter)new NotificationBroadcasterSupport(FlightRecorderMXBeanImpl.createNotificationInfo()));
    }

    @Override
    public void startRecording(long id) {
        MBeanUtils.checkControl();
        this.getExistingRecording(id).start();
    }

    @Override
    public boolean stopRecording(long id) {
        MBeanUtils.checkControl();
        return this.getExistingRecording(id).stop();
    }

    @Override
    public void closeRecording(long id) {
        MBeanUtils.checkControl();
        this.getExistingRecording(id).close();
    }

    @Override
    public long openStream(long id, Map<String, String> options) throws IOException {
        MBeanUtils.checkControl();
        if (!FlightRecorder.isInitialized()) {
            throw new IllegalArgumentException("No recording available with id " + id);
        }
        HashMap s = options == null ? new HashMap() : new HashMap<String, String>(options);
        Instant starttime = MBeanUtils.parseTimestamp((String)s.get("startTime"), Instant.MIN);
        Instant endtime = MBeanUtils.parseTimestamp((String)s.get("endTime"), Instant.MAX);
        int blockSize = MBeanUtils.parseBlockSize((String)s.get("blockSize"), 50000);
        InputStream is = this.getExistingRecording(id).getStream(starttime, endtime);
        if (is == null) {
            throw new IOException("No recording data available");
        }
        return this.streamHandler.create(is, blockSize).getId();
    }

    @Override
    public void closeStream(long streamIdentifier) throws IOException {
        MBeanUtils.checkControl();
        this.streamHandler.getStream(streamIdentifier).close();
    }

    @Override
    public byte[] readStream(long streamIdentifier) throws IOException {
        MBeanUtils.checkMonitor();
        return this.streamHandler.getStream(streamIdentifier).read();
    }

    @Override
    public List<RecordingInfo> getRecordings() {
        MBeanUtils.checkMonitor();
        if (!FlightRecorder.isInitialized()) {
            return Collections.emptyList();
        }
        return MBeanUtils.transformList(this.getRecorder().getRecordings(), RecordingInfo::new);
    }

    @Override
    public List<ConfigurationInfo> getConfigurations() {
        MBeanUtils.checkMonitor();
        return MBeanUtils.transformList(Configuration.getConfigurations(), ConfigurationInfo::new);
    }

    @Override
    public List<EventTypeInfo> getEventTypes() {
        MBeanUtils.checkMonitor();
        List<EventType> eventTypes = AccessController.doPrivileged(new PrivilegedAction<List<EventType>>(){

            @Override
            public List<EventType> run() {
                return ManagementSupport.getEventTypes();
            }
        }, null, new FlightRecorderPermission("accessFlightRecorder"));
        return MBeanUtils.transformList(eventTypes, EventTypeInfo::new);
    }

    @Override
    public Map<String, String> getRecordingSettings(long recording) throws IllegalArgumentException {
        MBeanUtils.checkMonitor();
        return this.getExistingRecording(recording).getSettings();
    }

    @Override
    public void setRecordingSettings(long recording, Map<String, String> values) throws IllegalArgumentException {
        Objects.requireNonNull(values);
        MBeanUtils.checkControl();
        this.getExistingRecording(recording).setSettings(values);
    }

    @Override
    public long newRecording() {
        MBeanUtils.checkControl();
        this.getRecorder();
        return AccessController.doPrivileged(new PrivilegedAction<Recording>(){

            @Override
            public Recording run() {
                return new Recording();
            }
        }, null, new FlightRecorderPermission("accessFlightRecorder")).getId();
    }

    @Override
    public long takeSnapshot() {
        MBeanUtils.checkControl();
        return this.getRecorder().takeSnapshot().getId();
    }

    @Override
    public void setConfiguration(long recording, String configuration) throws IllegalArgumentException {
        Objects.requireNonNull(configuration);
        MBeanUtils.checkControl();
        try {
            Configuration c = Configuration.create(new StringReader(configuration));
            this.getExistingRecording(recording).setSettings(c.getSettings());
        }
        catch (IOException | ParseException e) {
            throw new IllegalArgumentException("Could not parse configuration", e);
        }
    }

    @Override
    public void setPredefinedConfiguration(long recording, String configurationName) throws IllegalArgumentException {
        Objects.requireNonNull(configurationName);
        MBeanUtils.checkControl();
        Recording r = this.getExistingRecording(recording);
        for (Configuration c : Configuration.getConfigurations()) {
            if (!c.getName().equals(configurationName)) continue;
            r.setSettings(c.getSettings());
            return;
        }
        throw new IllegalArgumentException("Could not find configuration with name " + configurationName);
    }

    @Override
    public void copyTo(long recording, String path) throws IOException {
        Objects.requireNonNull(path);
        MBeanUtils.checkControl();
        this.getExistingRecording(recording).dump(Paths.get(path, new String[0]));
    }

    @Override
    public void setRecordingOptions(long recording, Map<String, String> options) throws IllegalArgumentException {
        Objects.requireNonNull(options);
        MBeanUtils.checkControl();
        HashMap<String, String> ops = new HashMap<String, String>(options);
        for (Map.Entry entry : ops.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("Option key must not be null, or other type than " + String.class);
            }
            if (!OPTIONS.contains(key)) {
                throw new IllegalArgumentException("Unknown recording option: " + key + ". Valid options are " + OPTIONS + ".");
            }
            if (value == null || value instanceof String) continue;
            throw new IllegalArgumentException("Incorrect value for option " + key + ". Values must be of type " + String.class + " .");
        }
        Recording r = this.getExistingRecording(recording);
        FlightRecorderMXBeanImpl.validateOption(ops, OPTION_DUMP_ON_EXIT, MBeanUtils::booleanValue);
        FlightRecorderMXBeanImpl.validateOption(ops, OPTION_DISK, MBeanUtils::booleanValue);
        FlightRecorderMXBeanImpl.validateOption(ops, OPTION_NAME, Function.identity());
        FlightRecorderMXBeanImpl.validateOption(ops, OPTION_MAX_AGE, MBeanUtils::duration);
        FlightRecorderMXBeanImpl.validateOption(ops, OPTION_MAX_SIZE, MBeanUtils::size);
        FlightRecorderMXBeanImpl.validateOption(ops, OPTION_DURATION, MBeanUtils::duration);
        FlightRecorderMXBeanImpl.setOption(ops, OPTION_DUMP_ON_EXIT, "false", MBeanUtils::booleanValue, x -> r.setDumpOnExit((boolean)x));
        FlightRecorderMXBeanImpl.setOption(ops, OPTION_DISK, "true", MBeanUtils::booleanValue, x -> r.setToDisk((boolean)x));
        FlightRecorderMXBeanImpl.setOption(ops, OPTION_NAME, String.valueOf(r.getId()), Function.identity(), x -> r.setName((String)x));
        FlightRecorderMXBeanImpl.setOption(ops, OPTION_MAX_AGE, null, MBeanUtils::duration, x -> r.setMaxAge((Duration)x));
        FlightRecorderMXBeanImpl.setOption(ops, OPTION_MAX_SIZE, "0", MBeanUtils::size, x -> r.setMaxSize((long)x));
        FlightRecorderMXBeanImpl.setOption(ops, OPTION_DURATION, null, MBeanUtils::duration, x -> r.setDuration((Duration)x));
    }

    @Override
    public Map<String, String> getRecordingOptions(long recording) throws IllegalArgumentException {
        MBeanUtils.checkMonitor();
        Recording r = this.getExistingRecording(recording);
        HashMap<String, String> options = new HashMap<String, String>(10);
        options.put(OPTION_DUMP_ON_EXIT, String.valueOf(r.getDumpOnExit()));
        options.put(OPTION_DISK, String.valueOf(r.isToDisk()));
        options.put(OPTION_NAME, String.valueOf(r.getName()));
        options.put(OPTION_MAX_AGE, ManagementSupport.formatTimespan(r.getMaxAge(), " "));
        Long maxSize = r.getMaxSize();
        options.put(OPTION_MAX_SIZE, String.valueOf(maxSize == null ? "0" : maxSize.toString()));
        options.put(OPTION_DURATION, ManagementSupport.formatTimespan(r.getDuration(), " "));
        return options;
    }

    @Override
    public long cloneRecording(long id, boolean stop) throws IllegalStateException, SecurityException {
        MBeanUtils.checkControl();
        return this.getRecording(id).copy(stop).getId();
    }

    @Override
    public ObjectName getObjectName() {
        return MBeanUtils.createObjectName();
    }

    private Recording getExistingRecording(long id) {
        Recording recording;
        if (FlightRecorder.isInitialized() && (recording = this.getRecording(id)) != null) {
            return recording;
        }
        throw new IllegalArgumentException("No recording available with id " + id);
    }

    private Recording getRecording(long id) {
        List<Recording> recs = this.getRecorder().getRecordings();
        return recs.stream().filter(r -> r.getId() == id).findFirst().orElse(null);
    }

    private static <T, U> void setOption(Map<String, String> options, String name, String defaultValue, Function<String, U> converter, Consumer<U> setter) {
        if (!options.containsKey(name)) {
            return;
        }
        String v = options.get(name);
        if (v == null) {
            v = defaultValue;
        }
        try {
            setter.accept(converter.apply(v));
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Not a valid value for option '" + name + "'. " + iae.getMessage());
        }
    }

    private static <T, U> void validateOption(Map<String, String> options, String name, Function<String, U> validator) {
        try {
            String v = options.get(name);
            if (v == null) {
                return;
            }
            validator.apply(v);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Not a valid value for option '" + name + "'. " + iae.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FlightRecorder getRecorder() throws SecurityException {
        StreamManager streamManager = this.streamHandler;
        synchronized (streamManager) {
            if (this.recorder == null) {
                this.recorder = AccessController.doPrivileged(new PrivilegedAction<FlightRecorder>(){

                    @Override
                    public FlightRecorder run() {
                        return FlightRecorder.getFlightRecorder();
                    }
                }, null, new FlightRecorderPermission("accessFlightRecorder"));
            }
            return this.recorder;
        }
    }

    private static MBeanNotificationInfo[] createNotificationInfo() {
        String[] types = new String[]{"jmx.attribute.change"};
        String name = AttributeChangeNotification.class.getName();
        String description = "Notifies if the RecordingState has changed for one of the recordings, for example if a recording starts or stops";
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, name, description);
        return new MBeanNotificationInfo[]{info};
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        final MXBeanListener mxbeanListener = new MXBeanListener(listener, filter, handback);
        this.listeners.add(mxbeanListener);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                FlightRecorder.addListener(mxbeanListener);
                return null;
            }
        }, null, new FlightRecorderPermission("accessFlightRecorder"));
        super.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.removeListeners(x -> listener == ((MXBeanListener)x).listener);
        super.removeNotificationListener(listener);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.removeListeners(x -> listener == ((MXBeanListener)x).listener && filter == ((MXBeanListener)x).filter && handback == ((MXBeanListener)x).handback);
        super.removeNotificationListener(listener, filter, handback);
    }

    private void removeListeners(Predicate<MXBeanListener> p) {
        ArrayList<MXBeanListener> toBeRemoved = new ArrayList<MXBeanListener>(this.listeners.size());
        for (MXBeanListener l : this.listeners) {
            if (!p.test(l)) continue;
            toBeRemoved.add(l);
            FlightRecorder.removeListener(l);
        }
        this.listeners.removeAll(toBeRemoved);
    }

    private Notification createNotication(Recording recording) {
        try {
            Long id = recording.getId();
            Object oldValue = this.changes.get(recording.getId());
            Object newValue = this.getAttribute(ATTRIBUTE_RECORDINGS);
            if (recording.getState() != RecordingState.CLOSED) {
                this.changes.put(id, newValue);
            } else {
                this.changes.remove(id);
            }
            return new AttributeChangeNotification(this.getObjectName(), this.sequenceNumber.incrementAndGet(), System.currentTimeMillis(), "Recording " + recording.getName() + " is " + (Object)((Object)recording.getState()), ATTRIBUTE_RECORDINGS, newValue.getClass().getName(), oldValue, newValue);
        }
        catch (AttributeNotFoundException | MBeanException | ReflectionException e) {
            throw new RuntimeException("Could not create notifcation for FlightRecorderMXBean. " + e.getMessage(), e);
        }
    }

    final class MXBeanListener
    implements FlightRecorderListener {
        private final NotificationListener listener;
        private final NotificationFilter filter;
        private final Object handback;
        private final AccessControlContext context = AccessController.getContext();

        public MXBeanListener(NotificationListener listener, NotificationFilter filter, Object handback) {
            this.listener = listener;
            this.filter = filter;
            this.handback = handback;
        }

        @Override
        public void recordingStateChanged(final Recording recording) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    FlightRecorderMXBeanImpl.this.sendNotification(FlightRecorderMXBeanImpl.this.createNotication(recording));
                    return null;
                }
            }, this.context);
        }
    }
}

