/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XRenderDirectFormat;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XRenderPictFormat
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 40;
    }

    @Override
    public int getDataSize() {
        return XRenderPictFormat.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XRenderPictFormat(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public XRenderPictFormat() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XRenderPictFormat.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public long get_id() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_id(long v) {
        log.finest("");
        Native.putLong(this.pData + 0L, v);
    }

    public int get_type() {
        log.finest("");
        return Native.getInt(this.pData + 8L);
    }

    public void set_type(int v) {
        log.finest("");
        Native.putInt(this.pData + 8L, v);
    }

    public int get_depth() {
        log.finest("");
        return Native.getInt(this.pData + 12L);
    }

    public void set_depth(int v) {
        log.finest("");
        Native.putInt(this.pData + 12L, v);
    }

    public XRenderDirectFormat get_direct() {
        log.finest("");
        return new XRenderDirectFormat(this.pData + 16L);
    }

    public long get_colormap() {
        log.finest("");
        return Native.getLong(this.pData + 32L);
    }

    public void set_colormap(long v) {
        log.finest("");
        Native.putLong(this.pData + 32L, v);
    }

    @Override
    String getName() {
        return "XRenderPictFormat";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(200);
        ret.append("id = ").append(this.get_id()).append(", ");
        ret.append("type = ").append(XlibWrapper.eventToString[this.get_type()]).append(", ");
        ret.append("depth = ").append(this.get_depth()).append(", ");
        ret.append("direct = ").append(this.get_direct()).append(", ");
        ret.append("colormap = ").append(this.get_colormap()).append(", ");
        return ret.toString();
    }
}

