/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicToolTipUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;
import javax.swing.text.View;

public class SynthToolTipUI
extends BasicToolTipUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;

    public static ComponentUI createUI(JComponent c) {
        return new SynthToolTipUI();
    }

    @Override
    protected void installDefaults(JComponent c) {
        this.updateStyle(c);
    }

    private void updateStyle(JComponent c) {
        SynthContext context = this.getContext(c, 1);
        this.style = SynthLookAndFeel.updateStyle(context, this);
        context.dispose();
    }

    @Override
    protected void uninstallDefaults(JComponent c) {
        SynthContext context = this.getContext(c, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
    }

    @Override
    protected void installListeners(JComponent c) {
        c.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners(JComponent c) {
        c.removePropertyChangeListener(this);
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(c, this.style, state);
    }

    private int getComponentState(JComponent c) {
        JComponent comp = ((JToolTip)c).getComponent();
        if (comp != null && !comp.isEnabled()) {
            return 8;
        }
        return SynthLookAndFeel.getComponentState(c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintToolTipBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintToolTipBorder(context, g, x, y, w, h);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
        JToolTip tip = (JToolTip)context.getComponent();
        Insets insets = tip.getInsets();
        View v = (View)tip.getClientProperty("html");
        if (v != null) {
            Rectangle paintTextR = new Rectangle(insets.left, insets.top, tip.getWidth() - (insets.left + insets.right), tip.getHeight() - (insets.top + insets.bottom));
            v.paint(g, paintTextR);
        } else {
            g.setColor(context.getStyle().getColor(context, ColorType.TEXT_FOREGROUND));
            g.setFont(this.style.getFont(context));
            context.getStyle().getGraphicsUtils(context).paintText(context, g, tip.getTipText(), insets.left, insets.top, -1);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        SynthContext context = this.getContext(c);
        Insets insets = c.getInsets();
        Dimension prefSize = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        String text = ((JToolTip)c).getTipText();
        if (text != null) {
            View v;
            View view = v = c != null ? (View)c.getClientProperty("html") : null;
            if (v != null) {
                prefSize.width += (int)v.getPreferredSpan(0);
                prefSize.height += (int)v.getPreferredSpan(1);
            } else {
                Font font = context.getStyle().getFont(context);
                FontMetrics fm = c.getFontMetrics(font);
                prefSize.width += context.getStyle().getGraphicsUtils(context).computeStringWidth(context, font, fm, text);
                prefSize.height += fm.getHeight();
            }
        }
        context.dispose();
        return prefSize;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name;
        if (SynthLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle((JToolTip)e.getSource());
        }
        if ((name = e.getPropertyName()).equals("tiptext") || "font".equals(name) || "foreground".equals(name)) {
            JToolTip tip = (JToolTip)e.getSource();
            String text = tip.getTipText();
            BasicHTML.updateRenderer(tip, text);
        }
    }
}

