/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.platform.cgroupv1;

import java.util.Map;
import jdk.internal.platform.CgroupInfo;
import jdk.internal.platform.CgroupSubsystem;
import jdk.internal.platform.CgroupSubsystemController;
import jdk.internal.platform.CgroupV1Metrics;
import jdk.internal.platform.cgroupv1.CgroupV1MemorySubSystemController;
import jdk.internal.platform.cgroupv1.CgroupV1SubsystemController;

public class CgroupV1Subsystem
implements CgroupSubsystem,
CgroupV1Metrics {
    private CgroupV1MemorySubSystemController memory;
    private CgroupV1SubsystemController cpu;
    private CgroupV1SubsystemController cpuacct;
    private CgroupV1SubsystemController cpuset;
    private CgroupV1SubsystemController blkio;
    private static volatile CgroupV1Subsystem INSTANCE;
    private static final String PROVIDER_NAME = "cgroupv1";

    private CgroupV1Subsystem() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CgroupV1Subsystem getInstance(Map<String, CgroupInfo> infos) {
        if (INSTANCE != null) return INSTANCE;
        CgroupV1Subsystem tmpSubsystem = CgroupV1Subsystem.initSubSystem(infos);
        Class<CgroupV1Subsystem> clazz = CgroupV1Subsystem.class;
        synchronized (CgroupV1Subsystem.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = tmpSubsystem;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static CgroupV1Subsystem initSubSystem(Map<String, CgroupInfo> infos) {
        CgroupV1Subsystem subsystem = new CgroupV1Subsystem();
        boolean anyActiveControllers = false;
        block14: for (CgroupInfo info : infos.values()) {
            switch (info.getName()) {
                case "memory": {
                    if (info.getMountRoot() == null || info.getMountPoint() == null) continue block14;
                    CgroupV1SubsystemController controller = new CgroupV1MemorySubSystemController(info.getMountRoot(), info.getMountPoint());
                    controller.setPath(info.getCgroupPath());
                    boolean isHierarchial = CgroupV1Subsystem.getHierarchical((CgroupV1MemorySubSystemController)controller);
                    ((CgroupV1MemorySubSystemController)controller).setHierarchical(isHierarchial);
                    boolean isSwapEnabled = CgroupV1Subsystem.getSwapEnabled((CgroupV1MemorySubSystemController)controller);
                    ((CgroupV1MemorySubSystemController)controller).setSwapEnabled(isSwapEnabled);
                    subsystem.setMemorySubSystem((CgroupV1MemorySubSystemController)controller);
                    anyActiveControllers = true;
                    continue block14;
                }
                case "cpuset": {
                    if (info.getMountRoot() == null || info.getMountPoint() == null) continue block14;
                    CgroupV1SubsystemController controller = new CgroupV1SubsystemController(info.getMountRoot(), info.getMountPoint());
                    controller.setPath(info.getCgroupPath());
                    subsystem.setCpuSetController(controller);
                    anyActiveControllers = true;
                    continue block14;
                }
                case "cpuacct": {
                    if (info.getMountRoot() == null || info.getMountPoint() == null) continue block14;
                    CgroupV1SubsystemController controller = new CgroupV1SubsystemController(info.getMountRoot(), info.getMountPoint());
                    controller.setPath(info.getCgroupPath());
                    subsystem.setCpuAcctController(controller);
                    anyActiveControllers = true;
                    continue block14;
                }
                case "cpu": {
                    if (info.getMountRoot() == null || info.getMountPoint() == null) continue block14;
                    CgroupV1SubsystemController controller = new CgroupV1SubsystemController(info.getMountRoot(), info.getMountPoint());
                    controller.setPath(info.getCgroupPath());
                    subsystem.setCpuController(controller);
                    anyActiveControllers = true;
                    continue block14;
                }
                case "blkio": {
                    if (info.getMountRoot() == null || info.getMountPoint() == null) continue block14;
                    CgroupV1SubsystemController controller = new CgroupV1SubsystemController(info.getMountRoot(), info.getMountPoint());
                    controller.setPath(info.getCgroupPath());
                    subsystem.setBlkIOController(controller);
                    anyActiveControllers = true;
                    continue block14;
                }
            }
            throw new AssertionError((Object)("Unrecognized controller in infos: " + info.getName()));
        }
        if (anyActiveControllers) {
            return subsystem;
        }
        return null;
    }

    private static boolean getSwapEnabled(CgroupV1MemorySubSystemController controller) {
        long retval = CgroupV1Subsystem.getLongValue(controller, "memory.memsw.limit_in_bytes");
        return retval > 0L;
    }

    private static boolean getHierarchical(CgroupV1MemorySubSystemController controller) {
        long hierarchical = CgroupV1Subsystem.getLongValue(controller, "memory.use_hierarchy");
        return hierarchical > 0L;
    }

    private void setMemorySubSystem(CgroupV1MemorySubSystemController memory) {
        this.memory = memory;
    }

    private void setCpuController(CgroupV1SubsystemController cpu) {
        this.cpu = cpu;
    }

    private void setCpuAcctController(CgroupV1SubsystemController cpuacct) {
        this.cpuacct = cpuacct;
    }

    private void setCpuSetController(CgroupV1SubsystemController cpuset) {
        this.cpuset = cpuset;
    }

    private void setBlkIOController(CgroupV1SubsystemController blkio) {
        this.blkio = blkio;
    }

    private static long getLongValue(CgroupSubsystemController controller, String parm) {
        return CgroupSubsystemController.getLongValue(controller, parm, CgroupV1SubsystemController::convertStringToLong, -1L);
    }

    @Override
    public String getProvider() {
        return PROVIDER_NAME;
    }

    @Override
    public long getCpuUsage() {
        return CgroupV1Subsystem.getLongValue(this.cpuacct, "cpuacct.usage");
    }

    @Override
    public long[] getPerCpuUsage() {
        String usagelist = CgroupSubsystemController.getStringValue(this.cpuacct, "cpuacct.usage_percpu");
        if (usagelist == null) {
            return null;
        }
        String[] list = usagelist.split(" ");
        long[] percpu = new long[list.length];
        for (int i = 0; i < list.length; ++i) {
            percpu[i] = Long.parseLong(list[i]);
        }
        return percpu;
    }

    @Override
    public long getCpuUserUsage() {
        return CgroupV1SubsystemController.getLongEntry(this.cpuacct, "cpuacct.stat", "user");
    }

    @Override
    public long getCpuSystemUsage() {
        return CgroupV1SubsystemController.getLongEntry(this.cpuacct, "cpuacct.stat", "system");
    }

    @Override
    public long getCpuPeriod() {
        return CgroupV1Subsystem.getLongValue(this.cpuacct, "cpu.cfs_period_us");
    }

    @Override
    public long getCpuQuota() {
        return CgroupV1Subsystem.getLongValue(this.cpuacct, "cpu.cfs_quota_us");
    }

    @Override
    public long getCpuShares() {
        long retval = CgroupV1Subsystem.getLongValue(this.cpuacct, "cpu.shares");
        if (retval == 0L || retval == 1024L) {
            return -1L;
        }
        return retval;
    }

    @Override
    public long getCpuNumPeriods() {
        return CgroupV1SubsystemController.getLongEntry(this.cpu, "cpu.stat", "nr_periods");
    }

    @Override
    public long getCpuNumThrottled() {
        return CgroupV1SubsystemController.getLongEntry(this.cpu, "cpu.stat", "nr_throttled");
    }

    @Override
    public long getCpuThrottledTime() {
        return CgroupV1SubsystemController.getLongEntry(this.cpu, "cpu.stat", "throttled_time");
    }

    @Override
    public long getEffectiveCpuCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public int[] getCpuSetCpus() {
        return CgroupSubsystemController.stringRangeToIntArray(CgroupSubsystemController.getStringValue(this.cpuset, "cpuset.cpus"));
    }

    @Override
    public int[] getEffectiveCpuSetCpus() {
        return CgroupSubsystemController.stringRangeToIntArray(CgroupSubsystemController.getStringValue(this.cpuset, "cpuset.effective_cpus"));
    }

    @Override
    public int[] getCpuSetMems() {
        return CgroupSubsystemController.stringRangeToIntArray(CgroupSubsystemController.getStringValue(this.cpuset, "cpuset.mems"));
    }

    @Override
    public int[] getEffectiveCpuSetMems() {
        return CgroupSubsystemController.stringRangeToIntArray(CgroupSubsystemController.getStringValue(this.cpuset, "cpuset.effective_mems"));
    }

    @Override
    public double getCpuSetMemoryPressure() {
        return CgroupV1SubsystemController.getDoubleValue(this.cpuset, "cpuset.memory_pressure");
    }

    @Override
    public Boolean isCpuSetMemoryPressureEnabled() {
        long val = CgroupV1Subsystem.getLongValue(this.cpuset, "cpuset.memory_pressure_enabled");
        return val == 1L;
    }

    @Override
    public long getMemoryFailCount() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.failcnt");
    }

    @Override
    public long getMemoryLimit() {
        long retval = CgroupV1Subsystem.getLongValue(this.memory, "memory.limit_in_bytes");
        if (retval > CgroupV1SubsystemController.UNLIMITED_MIN && this.memory.isHierarchical()) {
            String match = "hierarchical_memory_limit";
            retval = CgroupV1SubsystemController.getLongValueMatchingLine(this.memory, "memory.stat", match);
        }
        return CgroupV1SubsystemController.longValOrUnlimited(retval);
    }

    @Override
    public long getMemoryMaxUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.max_usage_in_bytes");
    }

    @Override
    public long getMemoryUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.usage_in_bytes");
    }

    @Override
    public long getKernelMemoryFailCount() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.failcnt");
    }

    @Override
    public long getKernelMemoryLimit() {
        return CgroupV1SubsystemController.longValOrUnlimited(CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.limit_in_bytes"));
    }

    @Override
    public long getKernelMemoryMaxUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.max_usage_in_bytes");
    }

    @Override
    public long getKernelMemoryUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.usage_in_bytes");
    }

    @Override
    public long getTcpMemoryFailCount() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.tcp.failcnt");
    }

    @Override
    public long getTcpMemoryLimit() {
        return CgroupV1SubsystemController.longValOrUnlimited(CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.tcp.limit_in_bytes"));
    }

    @Override
    public long getTcpMemoryMaxUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.tcp.max_usage_in_bytes");
    }

    @Override
    public long getTcpMemoryUsage() {
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.kmem.tcp.usage_in_bytes");
    }

    @Override
    public long getMemoryAndSwapFailCount() {
        if (this.memory != null && !this.memory.isSwapEnabled()) {
            return this.getMemoryFailCount();
        }
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.memsw.failcnt");
    }

    @Override
    public long getMemoryAndSwapLimit() {
        if (this.memory != null && !this.memory.isSwapEnabled()) {
            return this.getMemoryLimit();
        }
        long retval = CgroupV1Subsystem.getLongValue(this.memory, "memory.memsw.limit_in_bytes");
        if (retval > CgroupV1SubsystemController.UNLIMITED_MIN && this.memory.isHierarchical()) {
            String match = "hierarchical_memsw_limit";
            retval = CgroupV1SubsystemController.getLongValueMatchingLine(this.memory, "memory.stat", match);
        }
        return CgroupV1SubsystemController.longValOrUnlimited(retval);
    }

    @Override
    public long getMemoryAndSwapMaxUsage() {
        if (this.memory != null && !this.memory.isSwapEnabled()) {
            return this.getMemoryMaxUsage();
        }
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.memsw.max_usage_in_bytes");
    }

    @Override
    public long getMemoryAndSwapUsage() {
        if (this.memory != null && !this.memory.isSwapEnabled()) {
            return this.getMemoryUsage();
        }
        return CgroupV1Subsystem.getLongValue(this.memory, "memory.memsw.usage_in_bytes");
    }

    @Override
    public Boolean isMemoryOOMKillEnabled() {
        long val = CgroupV1SubsystemController.getLongEntry(this.memory, "memory.oom_control", "oom_kill_disable");
        return val == 0L;
    }

    @Override
    public long getMemorySoftLimit() {
        return CgroupV1SubsystemController.longValOrUnlimited(CgroupV1Subsystem.getLongValue(this.memory, "memory.soft_limit_in_bytes"));
    }

    @Override
    public long getBlkIOServiceCount() {
        return CgroupV1SubsystemController.getLongEntry(this.blkio, "blkio.throttle.io_service_bytes", "Total");
    }

    @Override
    public long getBlkIOServiced() {
        return CgroupV1SubsystemController.getLongEntry(this.blkio, "blkio.throttle.io_serviced", "Total");
    }
}

