/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import sun.awt.geom.PathConsumer2D;
import sun.java2d.marlin.ArrayCache;
import sun.java2d.marlin.Curve;
import sun.java2d.marlin.FloatMath;
import sun.java2d.marlin.IntArrayCache;
import sun.java2d.marlin.MarlinCache;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.MarlinProperties;
import sun.java2d.marlin.MarlinUtils;
import sun.java2d.marlin.MergeSort;
import sun.java2d.marlin.OffHeapArray;
import sun.java2d.marlin.RendererContext;
import sun.misc.Unsafe;

final class Renderer
implements PathConsumer2D,
MarlinConst {
    static final boolean DISABLE_RENDER = false;
    static final boolean ENABLE_BLOCK_FLAGS = MarlinProperties.isUseTileFlags();
    static final boolean ENABLE_BLOCK_FLAGS_HEURISTICS = MarlinProperties.isUseTileFlagsWithHeuristics();
    private static final int ALL_BUT_LSB = -2;
    private static final int ERR_STEP_MAX = Integer.MAX_VALUE;
    private static final double POWER_2_TO_32 = 4.294967296E9;
    public static final float f_SUBPIXEL_POSITIONS_X = SUBPIXEL_POSITIONS_X;
    public static final float f_SUBPIXEL_POSITIONS_Y = SUBPIXEL_POSITIONS_Y;
    public static final int SUBPIXEL_MASK_X = SUBPIXEL_POSITIONS_X - 1;
    public static final int SUBPIXEL_MASK_Y = SUBPIXEL_POSITIONS_Y - 1;
    private static final int SUBPIXEL_TILE = TILE_SIZE << SUBPIXEL_LG_POSITIONS_Y;
    static final int INITIAL_BUCKET_ARRAY = INITIAL_PIXEL_DIM * SUBPIXEL_POSITIONS_Y;
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    public static final long OFF_CURX_OR = 0L;
    public static final long OFF_ERROR = 0L + (long)OffHeapArray.SIZE_INT;
    public static final long OFF_BUMP_X = OFF_ERROR + (long)OffHeapArray.SIZE_INT;
    public static final long OFF_BUMP_ERR = OFF_BUMP_X + (long)OffHeapArray.SIZE_INT;
    public static final long OFF_NEXT = OFF_BUMP_ERR + (long)OffHeapArray.SIZE_INT;
    public static final long OFF_YMAX = OFF_NEXT + (long)OffHeapArray.SIZE_INT;
    public static final int SIZEOF_EDGE_BYTES = (int)(OFF_YMAX + (long)OffHeapArray.SIZE_INT);
    private static final float CUB_DEC_ERR_SUBPIX = 2.5f * (NORM_SUBPIXELS / 8.0f);
    private static final float CUB_INC_ERR_SUBPIX = 1.0f * (NORM_SUBPIXELS / 8.0f);
    public static final float CUB_DEC_BND = 8.0f * CUB_DEC_ERR_SUBPIX;
    public static final float CUB_INC_BND = 8.0f * CUB_INC_ERR_SUBPIX;
    public static final int CUB_COUNT_LG = 2;
    private static final int CUB_COUNT = 4;
    private static final int CUB_COUNT_2 = 16;
    private static final int CUB_COUNT_3 = 64;
    private static final float CUB_INV_COUNT = 0.25f;
    private static final float CUB_INV_COUNT_2 = 0.0625f;
    private static final float CUB_INV_COUNT_3 = 0.015625f;
    private static final float QUAD_DEC_ERR_SUBPIX = 1.0f * (NORM_SUBPIXELS / 8.0f);
    public static final float QUAD_DEC_BND = 8.0f * QUAD_DEC_ERR_SUBPIX;
    private int[] crossings;
    private int[] aux_crossings;
    private int edgeCount;
    private int[] edgePtrs;
    private int[] aux_edgePtrs;
    private int activeEdgeMaxUsed;
    private final int[] crossings_initial = new int[1024];
    private final int[] edgePtrs_initial = new int[1025];
    private final int[] aux_crossings_initial = new int[1024];
    private final int[] aux_edgePtrs_initial = new int[1025];
    private int edgeMinY = Integer.MAX_VALUE;
    private int edgeMaxY = Integer.MIN_VALUE;
    private float edgeMinX = Float.POSITIVE_INFINITY;
    private float edgeMaxX = Float.NEGATIVE_INFINITY;
    private final OffHeapArray edges;
    private int[] edgeBuckets;
    private int[] edgeBucketCounts;
    private int buckets_minY;
    private int buckets_maxY;
    private int edgeSumDeltaY;
    private final int[] edgeBuckets_initial = new int[INITIAL_BUCKET_ARRAY + 1];
    private final int[] edgeBucketCounts_initial = new int[INITIAL_BUCKET_ARRAY + 1];
    final MarlinCache cache;
    private int boundsMinX;
    private int boundsMinY;
    private int boundsMaxX;
    private int boundsMaxY;
    private int windingRule;
    private float x0;
    private float y0;
    private float sx0;
    private float sy0;
    final RendererContext rdrCtx;
    private final Curve curve;
    private int[] alphaLine;
    private final int[] alphaLine_initial = new int[INITIAL_AA_ARRAY];
    private int bbox_spminX;
    private int bbox_spmaxX;
    private int bbox_spminY;
    private int bbox_spmaxY;
    private boolean enableBlkFlags = false;
    private boolean prevUseBlkFlags = false;
    private final int[] blkFlags_initial = new int[256];
    private int[] blkFlags = this.blkFlags_initial;

    private void quadBreakIntoLinesAndAdd(float x0, float y0, Curve c, float x2, float y2) {
        int count = 1;
        float maxDD = FloatMath.max(Math.abs(c.dbx), Math.abs(c.dby));
        float _DEC_BND = QUAD_DEC_BND;
        while (maxDD >= _DEC_BND) {
            maxDD /= 4.0f;
            count <<= 1;
            if (!doStats) continue;
            RendererContext.stats.stat_rdr_quadBreak_dec.add(count);
        }
        int nL = 0;
        if (count > 1) {
            float icount = 1.0f / (float)count;
            float icount2 = icount * icount;
            float ddx = c.dbx * icount2;
            float ddy = c.dby * icount2;
            float dx = c.bx * icount2 + c.cx * icount;
            float dy = c.by * icount2 + c.cy * icount;
            while (--count > 0) {
                float x1 = x0 + dx;
                dx += ddx;
                float y1 = y0 + dy;
                dy += ddy;
                this.addLine(x0, y0, x1, y1);
                if (doStats) {
                    ++nL;
                }
                x0 = x1;
                y0 = y1;
            }
        }
        this.addLine(x0, y0, x2, y2);
        if (doStats) {
            RendererContext.stats.stat_rdr_quadBreak.add(nL + 1);
        }
    }

    private void curveBreakIntoLinesAndAdd(float x0, float y0, Curve c, float x3, float y3) {
        int count = 4;
        float icount = 0.25f;
        float icount2 = 0.0625f;
        float icount3 = 0.015625f;
        float dddx = 2.0f * c.dax * 0.015625f;
        float dddy = 2.0f * c.day * 0.015625f;
        float ddx = dddx + c.dbx * 0.0625f;
        float ddy = dddy + c.dby * 0.0625f;
        float dx = c.ax * 0.015625f + c.bx * 0.0625f + c.cx * 0.25f;
        float dy = c.ay * 0.015625f + c.by * 0.0625f + c.cy * 0.25f;
        float x1 = x0;
        float y1 = y0;
        int nL = 0;
        float _DEC_BND = CUB_DEC_BND;
        float _INC_BND = CUB_INC_BND;
        while (count > 0) {
            while (Math.abs(ddx) >= _DEC_BND || Math.abs(ddy) >= _DEC_BND) {
                ddx = ddx / 4.0f - (dddx /= 8.0f);
                ddy = ddy / 4.0f - (dddy /= 8.0f);
                dx = (dx - ddx) / 2.0f;
                dy = (dy - ddy) / 2.0f;
                count <<= 1;
                if (!doStats) continue;
                RendererContext.stats.stat_rdr_curveBreak_dec.add(count);
            }
            while (count % 2 == 0 && Math.abs(dx) <= _INC_BND && Math.abs(dy) <= _INC_BND) {
                dx = 2.0f * dx + ddx;
                dy = 2.0f * dy + ddy;
                ddx = 4.0f * (ddx + dddx);
                ddy = 4.0f * (ddy + dddy);
                dddx *= 8.0f;
                dddy *= 8.0f;
                count >>= 1;
                if (!doStats) continue;
                RendererContext.stats.stat_rdr_curveBreak_inc.add(count);
            }
            if (--count > 0) {
                x1 += dx;
                dx += ddx;
                ddx += dddx;
                y1 += dy;
                dy += ddy;
                ddy += dddy;
            } else {
                x1 = x3;
                y1 = y3;
            }
            this.addLine(x0, y0, x1, y1);
            if (doStats) {
                ++nL;
            }
            x0 = x1;
            y0 = y1;
        }
        if (doStats) {
            RendererContext.stats.stat_rdr_curveBreak.add(nL);
        }
    }

    private void addLine(float x1, float y1, float x2, float y2) {
        double y1d;
        double x1d;
        double slope;
        int lastCrossing;
        int firstCrossing;
        if (doStats) {
            RendererContext.stats.stat_rdr_addLine.add(1);
        }
        int or = 1;
        if (y2 < y1) {
            or = 0;
            float tmp = y2;
            y2 = y1;
            y1 = tmp;
            tmp = x2;
            x2 = x1;
            x1 = tmp;
        }
        if ((firstCrossing = FloatMath.max(FloatMath.ceil_int(y1), this.boundsMinY)) >= (lastCrossing = FloatMath.min(FloatMath.ceil_int(y2), this.boundsMaxY))) {
            if (doStats) {
                RendererContext.stats.stat_rdr_addLine_skip.add(1);
            }
            return;
        }
        if (firstCrossing < this.edgeMinY) {
            this.edgeMinY = firstCrossing;
        }
        if (lastCrossing > this.edgeMaxY) {
            this.edgeMaxY = lastCrossing;
        }
        if ((slope = ((x1d = (double)x1) - (double)x2) / ((y1d = (double)y1) - (double)y2)) >= 0.0) {
            if (x1 < this.edgeMinX) {
                this.edgeMinX = x1;
            }
            if (x2 > this.edgeMaxX) {
                this.edgeMaxX = x2;
            }
        } else {
            if (x2 < this.edgeMinX) {
                this.edgeMinX = x2;
            }
            if (x1 > this.edgeMaxX) {
                this.edgeMaxX = x1;
            }
        }
        int _SIZEOF_EDGE_BYTES = SIZEOF_EDGE_BYTES;
        OffHeapArray _edges = this.edges;
        int edgePtr = _edges.used;
        if (_edges.length - (long)edgePtr < (long)_SIZEOF_EDGE_BYTES) {
            long edgeNewSize = ArrayCache.getNewLargeSize(_edges.length, edgePtr + _SIZEOF_EDGE_BYTES);
            if (doStats) {
                RendererContext.stats.stat_rdr_edges_resizes.add(edgeNewSize);
            }
            _edges.resize(edgeNewSize);
        }
        Unsafe _unsafe = OffHeapArray.unsafe;
        long SIZE_INT = 4L;
        long addr = _edges.address + (long)edgePtr;
        double x1_intercept = x1d + ((double)firstCrossing - y1d) * slope;
        long x1_fixed_biased = (long)(4.294967296E9 * x1_intercept) + Integer.MAX_VALUE;
        _unsafe.putInt(addr, (int)(x1_fixed_biased >> 31) & 0xFFFFFFFE | or);
        _unsafe.putInt(addr += 4L, (int)x1_fixed_biased >>> 1);
        long slope_fixed = (long)(4.294967296E9 * slope);
        _unsafe.putInt(addr += 4L, (int)(slope_fixed >> 31) & 0xFFFFFFFE);
        _unsafe.putInt(addr += 4L, (int)slope_fixed >>> 1);
        int[] _edgeBuckets = this.edgeBuckets;
        int[] _edgeBucketCounts = this.edgeBucketCounts;
        int _boundsMinY = this.boundsMinY;
        int bucketIdx = firstCrossing - _boundsMinY;
        _unsafe.putInt(addr += 4L, _edgeBuckets[bucketIdx]);
        _unsafe.putInt(addr += 4L, lastCrossing);
        _edgeBuckets[bucketIdx] = edgePtr;
        int n = bucketIdx;
        _edgeBucketCounts[n] = _edgeBucketCounts[n] + 2;
        int n2 = lastCrossing - _boundsMinY;
        _edgeBucketCounts[n2] = _edgeBucketCounts[n2] | 1;
        this.edgeSumDeltaY += lastCrossing - firstCrossing;
        _edges.used += _SIZEOF_EDGE_BYTES;
    }

    Renderer(RendererContext rdrCtx) {
        this.rdrCtx = rdrCtx;
        this.edges = new OffHeapArray(rdrCtx, 98304L);
        this.curve = rdrCtx.curve;
        this.edgeBuckets = this.edgeBuckets_initial;
        this.edgeBucketCounts = this.edgeBucketCounts_initial;
        this.alphaLine = this.alphaLine_initial;
        this.cache = rdrCtx.cache;
        this.crossings = this.crossings_initial;
        this.aux_crossings = this.aux_crossings_initial;
        this.edgePtrs = this.edgePtrs_initial;
        this.aux_edgePtrs = this.aux_edgePtrs_initial;
        this.edgeCount = 0;
        this.activeEdgeMaxUsed = 0;
    }

    Renderer init(int pix_boundsX, int pix_boundsY, int pix_boundsWidth, int pix_boundsHeight, int windingRule) {
        int edgeBucketsLength;
        this.windingRule = windingRule;
        this.boundsMinX = pix_boundsX << SUBPIXEL_LG_POSITIONS_X;
        this.boundsMaxX = pix_boundsX + pix_boundsWidth << SUBPIXEL_LG_POSITIONS_X;
        this.boundsMinY = pix_boundsY << SUBPIXEL_LG_POSITIONS_Y;
        this.boundsMaxY = pix_boundsY + pix_boundsHeight << SUBPIXEL_LG_POSITIONS_Y;
        if (doLogBounds) {
            MarlinUtils.logInfo("boundsXY = [" + this.boundsMinX + " ... " + this.boundsMaxX + "[ [" + this.boundsMinY + " ... " + this.boundsMaxY + "[");
        }
        if ((edgeBucketsLength = this.boundsMaxY - this.boundsMinY + 1) > INITIAL_BUCKET_ARRAY) {
            if (doStats) {
                RendererContext.stats.stat_array_renderer_edgeBuckets.add(edgeBucketsLength);
                RendererContext.stats.stat_array_renderer_edgeBucketCounts.add(edgeBucketsLength);
            }
            this.edgeBuckets = this.rdrCtx.getIntArray(edgeBucketsLength);
            this.edgeBucketCounts = this.rdrCtx.getIntArray(edgeBucketsLength);
        }
        this.edgeMinY = Integer.MAX_VALUE;
        this.edgeMaxY = Integer.MIN_VALUE;
        this.edgeMinX = Float.POSITIVE_INFINITY;
        this.edgeMaxX = Float.NEGATIVE_INFINITY;
        this.edgeCount = 0;
        this.activeEdgeMaxUsed = 0;
        this.edges.used = 0;
        this.edgeSumDeltaY = 0;
        return this;
    }

    void dispose() {
        if (doStats) {
            RendererContext.stats.stat_rdr_activeEdges.add(this.activeEdgeMaxUsed);
            RendererContext.stats.stat_rdr_edges.add(this.edges.used);
            RendererContext.stats.stat_rdr_edges_count.add(this.edges.used / SIZEOF_EDGE_BYTES);
        }
        if (this.crossings != this.crossings_initial) {
            this.rdrCtx.putDirtyIntArray(this.crossings);
            this.crossings = this.crossings_initial;
            if (this.aux_crossings != this.aux_crossings_initial) {
                this.rdrCtx.putDirtyIntArray(this.aux_crossings);
                this.aux_crossings = this.aux_crossings_initial;
            }
        }
        if (this.edgePtrs != this.edgePtrs_initial) {
            this.rdrCtx.putDirtyIntArray(this.edgePtrs);
            this.edgePtrs = this.edgePtrs_initial;
            if (this.aux_edgePtrs != this.aux_edgePtrs_initial) {
                this.rdrCtx.putDirtyIntArray(this.aux_edgePtrs);
                this.aux_edgePtrs = this.aux_edgePtrs_initial;
            }
        }
        if (this.alphaLine != this.alphaLine_initial) {
            this.rdrCtx.putIntArray(this.alphaLine, 0, 0);
            this.alphaLine = this.alphaLine_initial;
        }
        if (this.blkFlags != this.blkFlags_initial) {
            this.rdrCtx.putIntArray(this.blkFlags, 0, 0);
            this.blkFlags = this.blkFlags_initial;
        }
        if (this.edgeMinY != Integer.MAX_VALUE) {
            if (this.rdrCtx.dirty) {
                this.buckets_minY = 0;
                this.buckets_maxY = this.boundsMaxY - this.boundsMinY;
            }
            if (this.edgeBuckets == this.edgeBuckets_initial) {
                IntArrayCache.fill(this.edgeBuckets, this.buckets_minY, this.buckets_maxY, 0);
                IntArrayCache.fill(this.edgeBucketCounts, this.buckets_minY, this.buckets_maxY + 1, 0);
            } else {
                this.rdrCtx.putIntArray(this.edgeBuckets, this.buckets_minY, this.buckets_maxY);
                this.edgeBuckets = this.edgeBuckets_initial;
                this.rdrCtx.putIntArray(this.edgeBucketCounts, this.buckets_minY, this.buckets_maxY + 1);
                this.edgeBucketCounts = this.edgeBucketCounts_initial;
            }
        } else if (this.edgeBuckets != this.edgeBuckets_initial) {
            this.rdrCtx.putIntArray(this.edgeBuckets, 0, 0);
            this.edgeBuckets = this.edgeBuckets_initial;
            this.rdrCtx.putIntArray(this.edgeBucketCounts, 0, 0);
            this.edgeBucketCounts = this.edgeBucketCounts_initial;
        }
        if (this.edges.length != 98304L) {
            this.edges.resize(98304L);
        }
    }

    private static float tosubpixx(float pix_x) {
        return f_SUBPIXEL_POSITIONS_X * pix_x;
    }

    private static float tosubpixy(float pix_y) {
        return f_SUBPIXEL_POSITIONS_Y * pix_y - 0.5f;
    }

    @Override
    public void moveTo(float pix_x0, float pix_y0) {
        this.closePath();
        float sx = Renderer.tosubpixx(pix_x0);
        float sy = Renderer.tosubpixy(pix_y0);
        this.sx0 = sx;
        this.sy0 = sy;
        this.x0 = sx;
        this.y0 = sy;
    }

    @Override
    public void lineTo(float pix_x1, float pix_y1) {
        float x1 = Renderer.tosubpixx(pix_x1);
        float y1 = Renderer.tosubpixy(pix_y1);
        this.addLine(this.x0, this.y0, x1, y1);
        this.x0 = x1;
        this.y0 = y1;
    }

    @Override
    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        float xe = Renderer.tosubpixx(x3);
        float ye = Renderer.tosubpixy(y3);
        this.curve.set(this.x0, this.y0, Renderer.tosubpixx(x1), Renderer.tosubpixy(y1), Renderer.tosubpixx(x2), Renderer.tosubpixy(y2), xe, ye);
        this.curveBreakIntoLinesAndAdd(this.x0, this.y0, this.curve, xe, ye);
        this.x0 = xe;
        this.y0 = ye;
    }

    @Override
    public void quadTo(float x1, float y1, float x2, float y2) {
        float xe = Renderer.tosubpixx(x2);
        float ye = Renderer.tosubpixy(y2);
        this.curve.set(this.x0, this.y0, Renderer.tosubpixx(x1), Renderer.tosubpixy(y1), xe, ye);
        this.quadBreakIntoLinesAndAdd(this.x0, this.y0, this.curve, xe, ye);
        this.x0 = xe;
        this.y0 = ye;
    }

    @Override
    public void closePath() {
        this.addLine(this.x0, this.y0, this.sx0, this.sy0);
        this.x0 = this.sx0;
        this.y0 = this.sy0;
    }

    @Override
    public void pathDone() {
        this.closePath();
    }

    @Override
    public long getNativeConsumer() {
        throw new InternalError("Renderer does not use a native consumer.");
    }

    private void _endRendering(int ymin, int ymax) {
        int bboxx0 = this.bbox_spminX;
        int bboxx1 = this.bbox_spmaxX;
        boolean windingRuleEvenOdd = this.windingRule == 0;
        int[] _alpha = this.alphaLine;
        MarlinCache _cache = this.cache;
        OffHeapArray _edges = this.edges;
        int[] _edgeBuckets = this.edgeBuckets;
        int[] _edgeBucketCounts = this.edgeBucketCounts;
        int[] _crossings = this.crossings;
        int[] _edgePtrs = this.edgePtrs;
        int[] _aux_crossings = this.aux_crossings;
        int[] _aux_edgePtrs = this.aux_edgePtrs;
        long _OFF_ERROR = OFF_ERROR;
        long _OFF_BUMP_X = OFF_BUMP_X;
        long _OFF_BUMP_ERR = OFF_BUMP_ERR;
        long _OFF_NEXT = OFF_NEXT;
        long _OFF_YMAX = OFF_YMAX;
        int _ALL_BUT_LSB = -2;
        int _ERR_STEP_MAX = Integer.MAX_VALUE;
        Unsafe _unsafe = OffHeapArray.unsafe;
        long addr0 = _edges.address;
        int _SUBPIXEL_LG_POSITIONS_X = SUBPIXEL_LG_POSITIONS_X;
        int _SUBPIXEL_LG_POSITIONS_Y = SUBPIXEL_LG_POSITIONS_Y;
        int _SUBPIXEL_MASK_X = SUBPIXEL_MASK_X;
        int _SUBPIXEL_MASK_Y = SUBPIXEL_MASK_Y;
        int _SUBPIXEL_POSITIONS_X = SUBPIXEL_POSITIONS_X;
        int _MIN_VALUE = Integer.MIN_VALUE;
        int _MAX_VALUE = Integer.MAX_VALUE;
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int y = ymin;
        int bucket = y - this.boundsMinY;
        int numCrossings = this.edgeCount;
        int edgePtrsLen = _edgePtrs.length;
        int crossingsLen = _crossings.length;
        int _arrayMaxUsed = this.activeEdgeMaxUsed;
        int ptrLen = 0;
        int[] _blkFlags = this.blkFlags;
        int _BLK_SIZE_LG = BLOCK_SIZE_LG;
        int _BLK_SIZE = BLOCK_SIZE;
        boolean _enableBlkFlagsHeuristics = ENABLE_BLOCK_FLAGS_HEURISTICS && this.enableBlkFlags;
        boolean useBlkFlags = this.prevUseBlkFlags;
        int stroking = this.rdrCtx.stroking;
        int lastY = -1;
        while (y < ymax) {
            int tmp;
            int ecur;
            int i;
            long addr;
            int bucketcount = _edgeBucketCounts[bucket];
            int prevNumCrossings = numCrossings;
            if (bucketcount != 0) {
                if (doStats) {
                    RendererContext.stats.stat_rdr_activeEdges_updates.add(numCrossings);
                }
                if ((bucketcount & 1) != 0) {
                    addr = addr0 + _OFF_YMAX;
                    int newCount = 0;
                    for (i = 0; i < numCrossings; ++i) {
                        ecur = _edgePtrs[i];
                        if (_unsafe.getInt(addr + (long)ecur) <= y) continue;
                        _edgePtrs[newCount++] = ecur;
                    }
                    prevNumCrossings = numCrossings = newCount;
                }
                if ((ptrLen = bucketcount >> 1) != 0) {
                    int ptrEnd;
                    if (doStats) {
                        RendererContext.stats.stat_rdr_activeEdges_adds.add(ptrLen);
                        if (ptrLen > 10) {
                            RendererContext.stats.stat_rdr_activeEdges_adds_high.add(ptrLen);
                        }
                    }
                    if (edgePtrsLen < (ptrEnd = numCrossings + ptrLen)) {
                        if (doStats) {
                            RendererContext.stats.stat_array_renderer_edgePtrs.add(ptrEnd);
                        }
                        this.edgePtrs = _edgePtrs = this.rdrCtx.widenDirtyIntArray(_edgePtrs, numCrossings, ptrEnd);
                        edgePtrsLen = _edgePtrs.length;
                        if (_aux_edgePtrs != this.aux_edgePtrs_initial) {
                            this.rdrCtx.putDirtyIntArray(_aux_edgePtrs);
                        }
                        if (doStats) {
                            RendererContext.stats.stat_array_renderer_aux_edgePtrs.add(ptrEnd);
                        }
                        this.aux_edgePtrs = _aux_edgePtrs = this.rdrCtx.getDirtyIntArray(ArrayCache.getNewSize(numCrossings, ptrEnd));
                    }
                    addr = addr0 + _OFF_NEXT;
                    ecur = _edgeBuckets[bucket];
                    while (numCrossings < ptrEnd) {
                        _edgePtrs[numCrossings] = ecur;
                        ecur = _unsafe.getInt(addr + (long)ecur);
                        ++numCrossings;
                    }
                    if (crossingsLen < numCrossings) {
                        if (_crossings != this.crossings_initial) {
                            this.rdrCtx.putDirtyIntArray(_crossings);
                        }
                        if (doStats) {
                            RendererContext.stats.stat_array_renderer_crossings.add(numCrossings);
                        }
                        this.crossings = _crossings = this.rdrCtx.getDirtyIntArray(numCrossings);
                        if (_aux_crossings != this.aux_crossings_initial) {
                            this.rdrCtx.putDirtyIntArray(_aux_crossings);
                        }
                        if (doStats) {
                            RendererContext.stats.stat_array_renderer_aux_crossings.add(numCrossings);
                        }
                        this.aux_crossings = _aux_crossings = this.rdrCtx.getDirtyIntArray(numCrossings);
                        crossingsLen = _crossings.length;
                    }
                    if (doStats && numCrossings > _arrayMaxUsed) {
                        _arrayMaxUsed = numCrossings;
                    }
                }
            }
            if (numCrossings != 0) {
                int pix_xmax;
                int pix_xmaxm1;
                int pix_x;
                int sum;
                int x1;
                int j;
                int err;
                int cross;
                int curx;
                int lastCross;
                if (ptrLen < 10 || numCrossings < 40) {
                    if (doStats) {
                        RendererContext.stats.hist_rdr_crossings.add(numCrossings);
                        RendererContext.stats.hist_rdr_crossings_adds.add(ptrLen);
                    }
                    boolean useBinarySearch = numCrossings >= 20;
                    lastCross = Integer.MIN_VALUE;
                    for (i = 0; i < numCrossings; ++i) {
                        ecur = _edgePtrs[i];
                        addr = addr0 + (long)ecur;
                        cross = curx = _unsafe.getInt(addr);
                        err = _unsafe.getInt(addr + _OFF_ERROR) + _unsafe.getInt(addr + _OFF_BUMP_ERR);
                        _unsafe.putInt(addr, (curx += _unsafe.getInt(addr + _OFF_BUMP_X)) - (err >> 30 & 0xFFFFFFFE));
                        _unsafe.putInt(addr + _OFF_ERROR, err & Integer.MAX_VALUE);
                        if (doStats) {
                            RendererContext.stats.stat_rdr_crossings_updates.add(numCrossings);
                        }
                        if (cross < lastCross) {
                            if (doStats) {
                                RendererContext.stats.stat_rdr_crossings_sorts.add(i);
                            }
                            if (useBinarySearch && i >= prevNumCrossings) {
                                if (doStats) {
                                    RendererContext.stats.stat_rdr_crossings_bsearch.add(i);
                                }
                                int low = 0;
                                int high = i - 1;
                                do {
                                    int mid;
                                    if (_crossings[mid = low + high >> 1] < cross) {
                                        low = mid + 1;
                                        continue;
                                    }
                                    high = mid - 1;
                                } while (low <= high);
                                for (j = i - 1; j >= low; --j) {
                                    _crossings[j + 1] = _crossings[j];
                                    _edgePtrs[j + 1] = _edgePtrs[j];
                                }
                                _crossings[low] = cross;
                                _edgePtrs[low] = ecur;
                                continue;
                            }
                            j = i - 1;
                            _crossings[i] = _crossings[j];
                            _edgePtrs[i] = _edgePtrs[j];
                            while (--j >= 0 && _crossings[j] > cross) {
                                _crossings[j + 1] = _crossings[j];
                                _edgePtrs[j + 1] = _edgePtrs[j];
                            }
                            _crossings[j + 1] = cross;
                            _edgePtrs[j + 1] = ecur;
                            continue;
                        }
                        _crossings[i] = lastCross = cross;
                    }
                } else {
                    if (doStats) {
                        RendererContext.stats.stat_rdr_crossings_msorts.add(numCrossings);
                        RendererContext.stats.hist_rdr_crossings_ratio.add(1000 * ptrLen / numCrossings);
                        RendererContext.stats.hist_rdr_crossings_msorts.add(numCrossings);
                        RendererContext.stats.hist_rdr_crossings_msorts_adds.add(ptrLen);
                    }
                    lastCross = Integer.MIN_VALUE;
                    for (i = 0; i < numCrossings; ++i) {
                        ecur = _edgePtrs[i];
                        addr = addr0 + (long)ecur;
                        cross = curx = _unsafe.getInt(addr);
                        err = _unsafe.getInt(addr + _OFF_ERROR) + _unsafe.getInt(addr + _OFF_BUMP_ERR);
                        _unsafe.putInt(addr, (curx += _unsafe.getInt(addr + _OFF_BUMP_X)) - (err >> 30 & 0xFFFFFFFE));
                        _unsafe.putInt(addr + _OFF_ERROR, err & Integer.MAX_VALUE);
                        if (doStats) {
                            RendererContext.stats.stat_rdr_crossings_updates.add(numCrossings);
                        }
                        if (i >= prevNumCrossings) {
                            _crossings[i] = cross;
                            continue;
                        }
                        if (cross < lastCross) {
                            if (doStats) {
                                RendererContext.stats.stat_rdr_crossings_sorts.add(i);
                            }
                            j = i - 1;
                            _aux_crossings[i] = _aux_crossings[j];
                            _aux_edgePtrs[i] = _aux_edgePtrs[j];
                            while (--j >= 0 && _aux_crossings[j] > cross) {
                                _aux_crossings[j + 1] = _aux_crossings[j];
                                _aux_edgePtrs[j + 1] = _aux_edgePtrs[j];
                            }
                            _aux_crossings[j + 1] = cross;
                            _aux_edgePtrs[j + 1] = ecur;
                            continue;
                        }
                        _aux_crossings[i] = lastCross = cross;
                        _aux_edgePtrs[i] = ecur;
                    }
                    MergeSort.mergeSortNoCopy(_crossings, _edgePtrs, _aux_crossings, _aux_edgePtrs, numCrossings, prevNumCrossings);
                }
                ptrLen = 0;
                int curxo = _crossings[0];
                int x0 = curxo >> 1;
                if (x0 < minX) {
                    minX = x0;
                }
                if ((x1 = _crossings[numCrossings - 1] >> 1) > maxX) {
                    maxX = x1;
                }
                int prev = curx = x0;
                int crorientation = ((curxo & 1) << 1) - 1;
                if (windingRuleEvenOdd) {
                    sum = crorientation;
                    for (i = 1; i < numCrossings; ++i) {
                        curxo = _crossings[i];
                        curx = curxo >> 1;
                        crorientation = ((curxo & 1) << 1) - 1;
                        if ((sum & 1) != 0) {
                            x0 = prev > bboxx0 ? prev : bboxx0;
                            int n = x1 = curx < bboxx1 ? curx : bboxx1;
                            if (x0 < x1) {
                                pix_x = (x0 -= bboxx0) >> _SUBPIXEL_LG_POSITIONS_X;
                                pix_xmaxm1 = (x1 -= bboxx0) - 1 >> _SUBPIXEL_LG_POSITIONS_X;
                                if (pix_x == pix_xmaxm1) {
                                    tmp = x1 - x0;
                                    int n2 = pix_x;
                                    _alpha[n2] = _alpha[n2] + tmp;
                                    int n3 = pix_x + 1;
                                    _alpha[n3] = _alpha[n3] - tmp;
                                    if (useBlkFlags) {
                                        _blkFlags[pix_x >> _BLK_SIZE_LG] = 1;
                                    }
                                } else {
                                    tmp = x0 & _SUBPIXEL_MASK_X;
                                    int n4 = pix_x;
                                    _alpha[n4] = _alpha[n4] + (_SUBPIXEL_POSITIONS_X - tmp);
                                    int n5 = pix_x + 1;
                                    _alpha[n5] = _alpha[n5] + tmp;
                                    pix_xmax = x1 >> _SUBPIXEL_LG_POSITIONS_X;
                                    tmp = x1 & _SUBPIXEL_MASK_X;
                                    int n6 = pix_xmax;
                                    _alpha[n6] = _alpha[n6] - (_SUBPIXEL_POSITIONS_X - tmp);
                                    int n7 = pix_xmax + 1;
                                    _alpha[n7] = _alpha[n7] - tmp;
                                    if (useBlkFlags) {
                                        _blkFlags[pix_x >> _BLK_SIZE_LG] = 1;
                                        _blkFlags[pix_xmax >> _BLK_SIZE_LG] = 1;
                                    }
                                }
                            }
                        }
                        sum += crorientation;
                        prev = curx;
                    }
                } else {
                    i = 1;
                    sum = 0;
                    while (true) {
                        if ((sum += crorientation) != 0) {
                            if (prev > curx) {
                                prev = curx;
                            }
                        } else {
                            x0 = prev > bboxx0 ? prev : bboxx0;
                            int n = x1 = curx < bboxx1 ? curx : bboxx1;
                            if (x0 < x1) {
                                pix_x = (x0 -= bboxx0) >> _SUBPIXEL_LG_POSITIONS_X;
                                pix_xmaxm1 = (x1 -= bboxx0) - 1 >> _SUBPIXEL_LG_POSITIONS_X;
                                if (pix_x == pix_xmaxm1) {
                                    tmp = x1 - x0;
                                    int n8 = pix_x;
                                    _alpha[n8] = _alpha[n8] + tmp;
                                    int n9 = pix_x + 1;
                                    _alpha[n9] = _alpha[n9] - tmp;
                                    if (useBlkFlags) {
                                        _blkFlags[pix_x >> _BLK_SIZE_LG] = 1;
                                    }
                                } else {
                                    tmp = x0 & _SUBPIXEL_MASK_X;
                                    int n10 = pix_x;
                                    _alpha[n10] = _alpha[n10] + (_SUBPIXEL_POSITIONS_X - tmp);
                                    int n11 = pix_x + 1;
                                    _alpha[n11] = _alpha[n11] + tmp;
                                    pix_xmax = x1 >> _SUBPIXEL_LG_POSITIONS_X;
                                    tmp = x1 & _SUBPIXEL_MASK_X;
                                    int n12 = pix_xmax;
                                    _alpha[n12] = _alpha[n12] - (_SUBPIXEL_POSITIONS_X - tmp);
                                    int n13 = pix_xmax + 1;
                                    _alpha[n13] = _alpha[n13] - tmp;
                                    if (useBlkFlags) {
                                        _blkFlags[pix_x >> _BLK_SIZE_LG] = 1;
                                        _blkFlags[pix_xmax >> _BLK_SIZE_LG] = 1;
                                    }
                                }
                            }
                            prev = Integer.MAX_VALUE;
                        }
                        if (i == numCrossings) break;
                        curxo = _crossings[i];
                        curx = curxo >> 1;
                        crorientation = ((curxo & 1) << 1) - 1;
                        ++i;
                    }
                }
            }
            if ((y & _SUBPIXEL_MASK_Y) == _SUBPIXEL_MASK_Y) {
                lastY = y >> _SUBPIXEL_LG_POSITIONS_Y;
                minX = FloatMath.max(minX, bboxx0) >> _SUBPIXEL_LG_POSITIONS_X;
                if ((maxX = FloatMath.min(maxX, bboxx1) >> _SUBPIXEL_LG_POSITIONS_X) >= minX) {
                    this.copyAARow(_alpha, lastY, minX, maxX + 2, useBlkFlags);
                    if (_enableBlkFlagsHeuristics) {
                        boolean bl = useBlkFlags = (maxX -= minX) > _BLK_SIZE && maxX > (numCrossings >> stroking) - 1 << _BLK_SIZE_LG;
                        if (doStats) {
                            tmp = FloatMath.max(1, (numCrossings >> stroking) - 1);
                            RendererContext.stats.hist_tile_generator_encoding_dist.add(maxX / tmp);
                        }
                    }
                } else {
                    _cache.clearAARow(lastY);
                }
                minX = Integer.MAX_VALUE;
                maxX = Integer.MIN_VALUE;
            }
            ++y;
            ++bucket;
        }
        --y;
        y >>= _SUBPIXEL_LG_POSITIONS_Y;
        minX = FloatMath.max(minX, bboxx0) >> _SUBPIXEL_LG_POSITIONS_X;
        if ((maxX = FloatMath.min(maxX, bboxx1) >> _SUBPIXEL_LG_POSITIONS_X) >= minX) {
            this.copyAARow(_alpha, y, minX, maxX + 2, useBlkFlags);
        } else if (y != lastY) {
            _cache.clearAARow(y);
        }
        this.edgeCount = numCrossings;
        this.prevUseBlkFlags = useBlkFlags;
        if (doStats) {
            this.activeEdgeMaxUsed = _arrayMaxUsed;
        }
    }

    boolean endRendering() {
        int width;
        int spmaxY;
        if (this.edgeMinY == Integer.MAX_VALUE) {
            return false;
        }
        int _boundsMinY = this.boundsMinY;
        int _boundsMaxY = this.boundsMaxY;
        int spminX = FloatMath.max(FloatMath.ceil_int(this.edgeMinX - 0.5f), this.boundsMinX);
        int spmaxX = FloatMath.min(FloatMath.ceil_int(this.edgeMaxX - 0.5f), this.boundsMaxX - 1);
        int spminY = this.edgeMinY;
        int maxY = this.edgeMaxY;
        if (maxY <= _boundsMaxY - 1) {
            spmaxY = maxY;
        } else {
            spmaxY = _boundsMaxY - 1;
            maxY = _boundsMaxY;
        }
        this.buckets_minY = spminY - _boundsMinY;
        this.buckets_maxY = maxY - _boundsMinY;
        if (doLogBounds) {
            MarlinUtils.logInfo("edgesXY = [" + this.edgeMinX + " ... " + this.edgeMaxX + "][" + this.edgeMinY + " ... " + this.edgeMaxY + "]");
            MarlinUtils.logInfo("spXY    = [" + spminX + " ... " + spmaxX + "][" + spminY + " ... " + spmaxY + "]");
        }
        if (spminX > spmaxX || spminY > spmaxY) {
            return false;
        }
        int pminX = spminX >> SUBPIXEL_LG_POSITIONS_X;
        int pmaxX = spmaxX + SUBPIXEL_MASK_X >> SUBPIXEL_LG_POSITIONS_X;
        int pminY = spminY >> SUBPIXEL_LG_POSITIONS_Y;
        int pmaxY = spmaxY + SUBPIXEL_MASK_Y >> SUBPIXEL_LG_POSITIONS_Y;
        this.cache.init(pminX, pminY, pmaxX, pmaxY, this.edgeSumDeltaY);
        if (ENABLE_BLOCK_FLAGS) {
            int nxTiles;
            this.enableBlkFlags = this.cache.useRLE;
            boolean bl = this.prevUseBlkFlags = this.enableBlkFlags && !ENABLE_BLOCK_FLAGS_HEURISTICS;
            if (this.enableBlkFlags && (nxTiles = (pmaxX - pminX >> TILE_SIZE_LG) + 2) > 256) {
                this.blkFlags = this.rdrCtx.getIntArray(nxTiles);
            }
        }
        this.bbox_spminX = pminX << SUBPIXEL_LG_POSITIONS_X;
        this.bbox_spmaxX = pmaxX << SUBPIXEL_LG_POSITIONS_X;
        this.bbox_spminY = spminY;
        this.bbox_spmaxY = FloatMath.min(spmaxY + 1, pmaxY << SUBPIXEL_LG_POSITIONS_Y);
        if (doLogBounds) {
            MarlinUtils.logInfo("pXY       = [" + pminX + " ... " + pmaxX + "[ [" + pminY + " ... " + pmaxY + "[");
            MarlinUtils.logInfo("bbox_spXY = [" + this.bbox_spminX + " ... " + this.bbox_spmaxX + "[ [" + this.bbox_spminY + " ... " + this.bbox_spmaxY + "[");
        }
        if ((width = pmaxX - pminX + 2) > INITIAL_AA_ARRAY) {
            if (doStats) {
                RendererContext.stats.stat_array_renderer_alphaline.add(width);
            }
            this.alphaLine = this.rdrCtx.getIntArray(width);
        }
        this.endRendering(pminY);
        return true;
    }

    void endRendering(int pminY) {
        int spminY = pminY << SUBPIXEL_LG_POSITIONS_Y;
        int fixed_spminY = FloatMath.max(this.bbox_spminY, spminY);
        if (fixed_spminY < this.bbox_spmaxY) {
            int spmaxY = FloatMath.min(this.bbox_spmaxY, spminY + SUBPIXEL_TILE);
            this.cache.resetTileLine(pminY);
            this._endRendering(fixed_spminY, spmaxY);
        }
    }

    void copyAARow(int[] alphaRow, int pix_y, int pix_from, int pix_to, boolean useBlockFlags) {
        if (useBlockFlags) {
            if (doStats) {
                RendererContext.stats.hist_tile_generator_encoding.add(1);
            }
            this.cache.copyAARowRLE_WithBlockFlags(this.blkFlags, alphaRow, pix_y, pix_from, pix_to);
        } else {
            if (doStats) {
                RendererContext.stats.hist_tile_generator_encoding.add(0);
            }
            this.cache.copyAARowNoRLE(alphaRow, pix_y, pix_from, pix_to);
        }
    }
}

