/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import org.ietf.jgss.GSSException;
import sun.security.action.GetBooleanAction;
import sun.security.jgss.krb5.InitialToken;
import sun.security.jgss.krb5.Krb5Context;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbApRep;
import sun.security.krb5.KrbApReq;
import sun.security.krb5.KrbException;
import sun.security.util.DerValue;

class AcceptSecContextToken
extends InitialToken {
    private KrbApRep apRep = null;

    public AcceptSecContextToken(Krb5Context context, KrbApReq apReq) throws KrbException, IOException, GSSException {
        boolean useSubkey = AccessController.doPrivileged(new GetBooleanAction("sun.security.krb5.acceptor.subkey"));
        boolean useSequenceNumber = true;
        EncryptionKey subKey = null;
        if (useSubkey) {
            subKey = new EncryptionKey(apReq.getCreds().getSessionKey());
            context.setKey(2, subKey);
        }
        this.apRep = new KrbApRep(apReq, useSequenceNumber, subKey);
        context.resetMySequenceNumber(this.apRep.getSeqNumber());
    }

    public AcceptSecContextToken(Krb5Context context, Credentials serviceCreds, KrbApReq apReq, InputStream is) throws IOException, GSSException, KrbException {
        Integer apRepSeqNumber;
        int tokenId = is.read() << 8 | is.read();
        if (tokenId != 512) {
            throw new GSSException(10, -1, "AP_REP token id does not match!");
        }
        byte[] apRepBytes = new DerValue(is).toByteArray();
        KrbApRep apRep = new KrbApRep(apRepBytes, serviceCreds, apReq);
        EncryptionKey subKey = apRep.getSubKey();
        if (subKey != null) {
            context.setKey(2, subKey);
        }
        int peerSeqNumber = (apRepSeqNumber = apRep.getSeqNumber()) != null ? apRepSeqNumber : 0;
        context.resetPeerSequenceNumber(peerSeqNumber);
    }

    @Override
    public final byte[] encode() throws IOException {
        byte[] apRepBytes = this.apRep.getMessage();
        byte[] retVal = new byte[2 + apRepBytes.length];
        AcceptSecContextToken.writeInt(512, retVal, 0);
        System.arraycopy(apRepBytes, 0, retVal, 2, apRepBytes.length);
        return retVal;
    }
}

