/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rmi.rmid;

import java.io.FilePermission;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Vector;

public final class ExecPermission
extends Permission {
    private static final long serialVersionUID = -6208470287358147919L;
    private transient FilePermission fp;

    public ExecPermission(String path) {
        super(path);
        this.init(path);
    }

    public ExecPermission(String path, String actions) {
        this(path);
    }

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof ExecPermission)) {
            return false;
        }
        ExecPermission that = (ExecPermission)p;
        return this.fp.implies(that.fp);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExecPermission)) {
            return false;
        }
        ExecPermission that = (ExecPermission)obj;
        return this.fp.equals(that.fp);
    }

    @Override
    public int hashCode() {
        return this.fp.hashCode();
    }

    @Override
    public String getActions() {
        return "";
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new ExecPermissionCollection();
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init(this.getName());
    }

    private void init(String path) {
        this.fp = new FilePermission(path, "execute");
    }

    private static class ExecPermissionCollection
    extends PermissionCollection
    implements Serializable {
        private Vector<Permission> permissions = new Vector();
        private static final long serialVersionUID = -3352558508888368273L;

        @Override
        public void add(Permission permission) {
            if (!(permission instanceof ExecPermission)) {
                throw new IllegalArgumentException("invalid permission: " + permission);
            }
            if (this.isReadOnly()) {
                throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
            }
            this.permissions.addElement(permission);
        }

        @Override
        public boolean implies(Permission permission) {
            if (!(permission instanceof ExecPermission)) {
                return false;
            }
            Enumeration<Permission> e = this.permissions.elements();
            while (e.hasMoreElements()) {
                ExecPermission x = (ExecPermission)e.nextElement();
                if (!x.implies(permission)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Enumeration<Permission> elements() {
            return this.permissions.elements();
        }
    }
}

