/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import sun.security.pkcs.PKCS8Key;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAUtil;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public final class RSAPrivateKeyImpl
extends PKCS8Key
implements RSAPrivateKey {
    private static final long serialVersionUID = -33106691987952810L;
    private final BigInteger n;
    private final BigInteger d;
    private final AlgorithmParameterSpec keyParams;

    RSAPrivateKeyImpl(AlgorithmId rsaId, BigInteger n, BigInteger d) throws InvalidKeyException {
        RSAKeyFactory.checkRSAProviderKeyLengths(n.bitLength(), null);
        this.n = n;
        this.d = d;
        this.keyParams = RSAUtil.getParamSpec(rsaId);
        this.algid = rsaId;
        try {
            DerOutputStream out = new DerOutputStream();
            out.putInteger(0);
            out.putInteger(n);
            out.putInteger(0);
            out.putInteger(d);
            out.putInteger(0);
            out.putInteger(0);
            out.putInteger(0);
            out.putInteger(0);
            out.putInteger(0);
            DerValue val = new DerValue(48, out.toByteArray());
            this.key = val.toByteArray();
        }
        catch (IOException exc) {
            throw new InvalidKeyException(exc);
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algid.getName();
    }

    @Override
    public BigInteger getModulus() {
        return this.n;
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.d;
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        return this.keyParams;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("RSAPrivateKeyImpl keys are not directly deserializable");
    }
}

