/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.naming.pcosnaming;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

class CounterDB
implements Serializable {
    private Integer counter;
    private static String counterFileName = "counter";
    private transient File counterFile;
    public static final int rootCounter = 0;

    CounterDB(File logDir) {
        counterFileName = "counter";
        this.counterFile = new File(logDir, counterFileName);
        if (!this.counterFile.exists()) {
            this.counter = new Integer(0);
            this.writeCounter();
        } else {
            this.readCounter();
        }
    }

    private void readCounter() {
        try {
            FileInputStream fis = new FileInputStream(this.counterFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.counter = (Integer)ois.readObject();
            ois.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeCounter() {
        try {
            this.counterFile.delete();
            FileOutputStream fos = new FileOutputStream(this.counterFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.counter);
            oos.flush();
            oos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized int getNextCounter() {
        int counterVal = this.counter;
        this.counter = new Integer(++counterVal);
        this.writeCounter();
        return counterVal;
    }
}

