/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.util.Vector;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.MarlinUtils;
import sun.misc.ThreadGroupUtils;
import sun.misc.Unsafe;

final class OffHeapArray {
    static final Unsafe unsafe;
    static final int SIZE_INT;
    private static final ReferenceQueue<Object> rdrQueue;
    private static final Vector<OffHeapReference> refList;
    long address;
    long length;
    int used;

    OffHeapArray(Object parent, long len) {
        this.address = unsafe.allocateMemory(len);
        this.length = len;
        this.used = 0;
        if (MarlinConst.logUnsafeMalloc) {
            MarlinUtils.logInfo(System.currentTimeMillis() + ": OffHeapArray.allocateMemory = " + len + " to addr = " + this.address);
        }
        refList.add(new OffHeapReference(parent, this));
    }

    void resize(long len) {
        this.address = unsafe.reallocateMemory(this.address, len);
        this.length = len;
        if (MarlinConst.logUnsafeMalloc) {
            MarlinUtils.logInfo(System.currentTimeMillis() + ": OffHeapArray.reallocateMemory = " + len + " to addr = " + this.address);
        }
    }

    void free() {
        unsafe.freeMemory(this.address);
        if (MarlinConst.logUnsafeMalloc) {
            MarlinUtils.logInfo(System.currentTimeMillis() + ": OffHeapEdgeArray.free = " + this.length + " at addr = " + this.address);
        }
    }

    void fill(byte val) {
        unsafe.setMemory(this.address, this.length, val);
    }

    static {
        rdrQueue = new ReferenceQueue();
        refList = new Vector(32);
        unsafe = Unsafe.getUnsafe();
        SIZE_INT = Unsafe.ARRAY_INT_INDEX_SCALE;
        AccessController.doPrivileged(() -> {
            ThreadGroup rootTG = ThreadGroupUtils.getRootThreadGroup();
            Thread t = new Thread(rootTG, new OffHeapDisposer(), "MarlinRenderer Disposer");
            t.setContextClassLoader(null);
            t.setDaemon(true);
            t.setPriority(10);
            t.start();
            return null;
        });
    }

    static final class OffHeapDisposer
    implements Runnable {
        OffHeapDisposer() {
        }

        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            while (!currentThread.isInterrupted()) {
                try {
                    OffHeapReference ref = (OffHeapReference)rdrQueue.remove();
                    ref.dispose();
                    refList.remove(ref);
                }
                catch (InterruptedException ie) {
                    MarlinUtils.logException("OffHeapDisposer interrupted:", ie);
                }
            }
        }
    }

    static final class OffHeapReference
    extends PhantomReference<Object> {
        private final OffHeapArray array;

        OffHeapReference(Object parent, OffHeapArray edges) {
            super(parent, rdrQueue);
            this.array = edges;
        }

        void dispose() {
            this.array.free();
        }
    }
}

