/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.ServerSocket;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import sun.rmi.registry.RegistryImpl;
import sun.rmi.server.InactiveGroupException;

public class ActivationGroupImpl
extends ActivationGroup {
    private static final long serialVersionUID = 5758693559430427303L;
    private final Hashtable<ActivationID, ActiveEntry> active = new Hashtable();
    private boolean groupInactive = false;
    private final ActivationGroupID groupID;
    private final List<ActivationID> lockedIDs = new ArrayList<ActivationID>();

    public ActivationGroupImpl(ActivationGroupID id, MarshalledObject<?> data) throws RemoteException {
        super(id);
        this.groupID = id;
        ActivationGroupImpl.unexportObject(this, true);
        ServerSocketFactoryImpl ssf = new ServerSocketFactoryImpl();
        UnicastRemoteObject.exportObject(this, 0, null, ssf);
        if (System.getSecurityManager() == null) {
            try {
                System.setSecurityManager(new SecurityManager());
            }
            catch (Exception e) {
                throw new RemoteException("unable to set security manager", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireLock(ActivationID id) {
        while (true) {
            ActivationID waitForID;
            Object object = this.lockedIDs;
            synchronized (object) {
                int index = this.lockedIDs.indexOf(id);
                if (index < 0) {
                    this.lockedIDs.add(id);
                    return;
                }
                waitForID = this.lockedIDs.get(index);
            }
            object = waitForID;
            synchronized (object) {
                List<ActivationID> list = this.lockedIDs;
                synchronized (list) {
                    int index = this.lockedIDs.indexOf(waitForID);
                    if (index < 0) {
                        continue;
                    }
                    ActivationID actualID = this.lockedIDs.get(index);
                    if (actualID != waitForID) {
                        continue;
                    }
                }
                try {
                    waitForID.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLock(ActivationID id) {
        Object object = this.lockedIDs;
        synchronized (object) {
            id = this.lockedIDs.remove(this.lockedIDs.indexOf(id));
        }
        object = id;
        synchronized (object) {
            id.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MarshalledObject<? extends Remote> newInstance(final ActivationID id, final ActivationDesc desc) throws ActivationException, RemoteException {
        RegistryImpl.checkAccess("ActivationInstantiator.newInstance");
        if (!this.groupID.equals(desc.getGroupID())) {
            throw new ActivationException("newInstance in wrong group");
        }
        try {
            Remote impl;
            ActiveEntry entry;
            block21: {
                this.acquireLock(id);
                ActivationGroupImpl activationGroupImpl = this;
                synchronized (activationGroupImpl) {
                    if (this.groupInactive) {
                        throw new InactiveGroupException("group is inactive");
                    }
                }
                entry = this.active.get(id);
                if (entry != null) {
                    MarshalledObject<Remote> marshalledObject = entry.mobj;
                    return marshalledObject;
                }
                String className = desc.getClassName();
                final Class<Remote> cl = RMIClassLoader.loadClass(desc.getLocation(), className).asSubclass(Remote.class);
                impl = null;
                final Thread t = Thread.currentThread();
                final ClassLoader savedCcl = t.getContextClassLoader();
                ClassLoader objcl = cl.getClassLoader();
                final ClassLoader ccl = ActivationGroupImpl.covers(objcl, savedCcl) ? objcl : savedCcl;
                try {
                    impl = AccessController.doPrivileged(new PrivilegedExceptionAction<Remote>(){

                        @Override
                        public Remote run() throws InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
                            Constructor constructor = cl.getDeclaredConstructor(ActivationID.class, MarshalledObject.class);
                            constructor.setAccessible(true);
                            try {
                                t.setContextClassLoader(ccl);
                                Remote remote = (Remote)constructor.newInstance(id, desc.getData());
                                return remote;
                            }
                            finally {
                                t.setContextClassLoader(savedCcl);
                            }
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    Exception e = pae.getException();
                    if (e instanceof InstantiationException) {
                        throw (InstantiationException)e;
                    }
                    if (e instanceof NoSuchMethodException) {
                        throw (NoSuchMethodException)e;
                    }
                    if (e instanceof IllegalAccessException) {
                        throw (IllegalAccessException)e;
                    }
                    if (e instanceof InvocationTargetException) {
                        throw (InvocationTargetException)e;
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (!(e instanceof Error)) break block21;
                    throw (Error)((Object)e);
                }
            }
            entry = new ActiveEntry(impl);
            this.active.put(id, entry);
            MarshalledObject<Remote> marshalledObject = entry.mobj;
            return marshalledObject;
        }
        catch (NoSuchMethodError | NoSuchMethodException e) {
            throw new ActivationException("Activatable object must provide an activation constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new ActivationException("exception in object constructor", e.getTargetException());
        }
        catch (Exception e) {
            throw new ActivationException("unable to activate object", e);
        }
        finally {
            this.releaseLock(id);
            this.checkInactiveGroup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean inactiveObject(ActivationID id) throws ActivationException, UnknownObjectException, RemoteException {
        try {
            this.acquireLock(id);
            ActivationGroupImpl activationGroupImpl = this;
            synchronized (activationGroupImpl) {
                if (this.groupInactive) {
                    throw new ActivationException("group is inactive");
                }
            }
            ActiveEntry entry = this.active.get(id);
            if (entry == null) {
                throw new UnknownObjectException("object not active");
            }
            try {
                if (!Activatable.unexportObject(entry.impl, false)) {
                    boolean bl = false;
                    return bl;
                }
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
            try {
                super.inactiveObject(id);
            }
            catch (UnknownObjectException unknownObjectException) {
                // empty catch block
            }
            this.active.remove(id);
        }
        finally {
            this.releaseLock(id);
            this.checkInactiveGroup();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInactiveGroup() {
        boolean groupMarkedInactive = false;
        ActivationGroupImpl activationGroupImpl = this;
        synchronized (activationGroupImpl) {
            if (this.active.size() == 0 && this.lockedIDs.size() == 0 && !this.groupInactive) {
                this.groupInactive = true;
                groupMarkedInactive = true;
            }
        }
        if (groupMarkedInactive) {
            try {
                super.inactiveGroup();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activeObject(ActivationID id, Remote impl) throws ActivationException, UnknownObjectException, RemoteException {
        try {
            this.acquireLock(id);
            ActivationGroupImpl activationGroupImpl = this;
            synchronized (activationGroupImpl) {
                if (this.groupInactive) {
                    throw new ActivationException("group is inactive");
                }
            }
            if (!this.active.contains(id)) {
                ActiveEntry entry = new ActiveEntry(impl);
                this.active.put(id, entry);
                try {
                    super.activeObject(id, entry.mobj);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.releaseLock(id);
            this.checkInactiveGroup();
        }
    }

    private static boolean covers(ClassLoader sub, ClassLoader sup) {
        if (sup == null) {
            return true;
        }
        if (sub == null) {
            return false;
        }
        do {
            if (sub != sup) continue;
            return true;
        } while ((sub = sub.getParent()) != null);
        return false;
    }

    private static class ActiveEntry {
        Remote impl;
        MarshalledObject<Remote> mobj;

        ActiveEntry(Remote impl) throws ActivationException {
            this.impl = impl;
            try {
                this.mobj = new MarshalledObject<Remote>(impl);
            }
            catch (IOException e) {
                throw new ActivationException("failed to marshal remote object", e);
            }
        }
    }

    private static class ServerSocketFactoryImpl
    implements RMIServerSocketFactory {
        private ServerSocketFactoryImpl() {
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            RMISocketFactory sf = RMISocketFactory.getSocketFactory();
            if (sf == null) {
                sf = RMISocketFactory.getDefaultSocketFactory();
            }
            return sf.createServerSocket(port);
        }
    }
}

