/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Locale;
import sun.security.action.GetPropertyAction;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbTgsReq;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.AuthorizationData;
import sun.security.krb5.internal.CredentialsUtil;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.Ticket;
import sun.security.krb5.internal.TicketFlags;
import sun.security.krb5.internal.ccache.CredentialsCache;
import sun.security.krb5.internal.crypto.EType;

public class Credentials {
    Ticket ticket;
    PrincipalName client;
    PrincipalName clientAlias;
    PrincipalName server;
    PrincipalName serverAlias;
    EncryptionKey key;
    TicketFlags flags;
    KerberosTime authTime;
    KerberosTime startTime;
    KerberosTime endTime;
    KerberosTime renewTill;
    HostAddresses cAddr;
    AuthorizationData authzData;
    private static boolean DEBUG = Krb5.DEBUG;
    private static CredentialsCache cache;
    static boolean alreadyLoaded;
    private static boolean alreadyTried;
    private Credentials proxy = null;

    public Credentials getProxy() {
        return this.proxy;
    }

    public Credentials setProxy(Credentials proxy) {
        this.proxy = proxy;
        return this;
    }

    private static native Credentials acquireDefaultNativeCreds(int[] var0);

    public Credentials(Ticket new_ticket, PrincipalName new_client, PrincipalName new_client_alias, PrincipalName new_server, PrincipalName new_server_alias, EncryptionKey new_key, TicketFlags new_flags, KerberosTime authTime, KerberosTime new_startTime, KerberosTime new_endTime, KerberosTime renewTill, HostAddresses cAddr, AuthorizationData authzData) {
        this(new_ticket, new_client, new_client_alias, new_server, new_server_alias, new_key, new_flags, authTime, new_startTime, new_endTime, renewTill, cAddr);
        this.authzData = authzData;
    }

    public Credentials(Ticket new_ticket, PrincipalName new_client, PrincipalName new_client_alias, PrincipalName new_server, PrincipalName new_server_alias, EncryptionKey new_key, TicketFlags new_flags, KerberosTime authTime, KerberosTime new_startTime, KerberosTime new_endTime, KerberosTime renewTill, HostAddresses cAddr) {
        this.ticket = new_ticket;
        this.client = new_client;
        this.clientAlias = new_client_alias;
        this.server = new_server;
        this.serverAlias = new_server_alias;
        this.key = new_key;
        this.flags = new_flags;
        this.authTime = authTime;
        this.startTime = new_startTime;
        this.endTime = new_endTime;
        this.renewTill = renewTill;
        this.cAddr = cAddr;
    }

    public Credentials(byte[] encoding, String client, String clientAlias, String server, String serverAlias, byte[] keyBytes, int keyType, boolean[] flags, Date authTime, Date startTime, Date endTime, Date renewTill, InetAddress[] cAddrs) throws KrbException, IOException {
        this(new Ticket(encoding), new PrincipalName(client, 1), clientAlias == null ? null : new PrincipalName(clientAlias, 1), new PrincipalName(server, 2), serverAlias == null ? null : new PrincipalName(serverAlias, 2), new EncryptionKey(keyType, keyBytes), flags == null ? null : new TicketFlags(flags), authTime == null ? null : new KerberosTime(authTime), startTime == null ? null : new KerberosTime(startTime), endTime == null ? null : new KerberosTime(endTime), renewTill == null ? null : new KerberosTime(renewTill), null);
    }

    public final PrincipalName getClient() {
        return this.client;
    }

    public final PrincipalName getClientAlias() {
        return this.clientAlias;
    }

    public final PrincipalName getServer() {
        return this.server;
    }

    public final PrincipalName getServerAlias() {
        return this.serverAlias;
    }

    public final EncryptionKey getSessionKey() {
        return this.key;
    }

    public final Date getAuthTime() {
        if (this.authTime != null) {
            return this.authTime.toDate();
        }
        return null;
    }

    public final Date getStartTime() {
        if (this.startTime != null) {
            return this.startTime.toDate();
        }
        return null;
    }

    public final Date getEndTime() {
        if (this.endTime != null) {
            return this.endTime.toDate();
        }
        return null;
    }

    public final Date getRenewTill() {
        if (this.renewTill != null) {
            return this.renewTill.toDate();
        }
        return null;
    }

    public final boolean[] getFlags() {
        if (this.flags == null) {
            return null;
        }
        return this.flags.toBooleanArray();
    }

    public final InetAddress[] getClientAddresses() {
        if (this.cAddr == null) {
            return null;
        }
        return this.cAddr.getInetAddresses();
    }

    public final byte[] getEncoded() {
        byte[] retVal;
        block4: {
            retVal = null;
            try {
                retVal = this.ticket.asn1Encode();
            }
            catch (Asn1Exception e) {
                if (DEBUG) {
                    System.out.println(e);
                }
            }
            catch (IOException ioe) {
                if (!DEBUG) break block4;
                System.out.println(ioe);
            }
        }
        return retVal;
    }

    public boolean isForwardable() {
        return this.flags.get(1);
    }

    public boolean isRenewable() {
        return this.flags.get(8);
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public TicketFlags getTicketFlags() {
        return this.flags;
    }

    public AuthorizationData getAuthzData() {
        return this.authzData;
    }

    public boolean checkDelegate() {
        return this.flags.get(13);
    }

    public void resetDelegate() {
        this.flags.set(13, false);
    }

    public Credentials renew() throws KrbException, IOException {
        KDCOptions options = new KDCOptions();
        options.set(30, true);
        options.set(8, true);
        return new KrbTgsReq(options, this, this.server, this.serverAlias, null, null, null, null, this.cAddr, null, null, null).sendAndGetCreds();
    }

    public static Credentials acquireTGTFromCache(PrincipalName princ, String ticketCache) throws KrbException, IOException {
        String os;
        if (ticketCache == null && ((os = AccessController.doPrivileged(new GetPropertyAction("os.name"))).toUpperCase(Locale.ENGLISH).startsWith("WINDOWS") || os.toUpperCase(Locale.ENGLISH).contains("OS X"))) {
            Credentials creds = Credentials.acquireDefaultCreds();
            if (creds == null) {
                if (DEBUG) {
                    System.out.println(">>> Found no TGT's in LSA");
                }
                return null;
            }
            if (princ != null) {
                if (creds.getClient().equals(princ)) {
                    if (DEBUG) {
                        System.out.println(">>> Obtained TGT from LSA: " + creds);
                    }
                    return creds;
                }
                if (DEBUG) {
                    System.out.println(">>> LSA contains TGT for " + creds.getClient() + " not " + princ);
                }
                return null;
            }
            if (DEBUG) {
                System.out.println(">>> Obtained TGT from LSA: " + creds);
            }
            return creds;
        }
        CredentialsCache ccache = CredentialsCache.getInstance(princ, ticketCache);
        if (ccache == null) {
            return null;
        }
        Credentials tgtCred = ccache.getInitialCreds();
        if (tgtCred == null) {
            return null;
        }
        if (EType.isSupported(tgtCred.key.getEType())) {
            return tgtCred;
        }
        if (DEBUG) {
            System.out.println(">>> unsupported key type found the default TGT: " + tgtCred.key.getEType());
        }
        return null;
    }

    public static synchronized Credentials acquireDefaultCreds() {
        Credentials temp;
        Credentials result = null;
        if (cache == null) {
            cache = CredentialsCache.getInstance();
        }
        if (cache != null && (temp = cache.getInitialCreds()) != null) {
            if (DEBUG) {
                System.out.println(">>> KrbCreds found the default ticket granting ticket in credential cache.");
            }
            if (EType.isSupported(temp.key.getEType())) {
                result = temp;
            } else if (DEBUG) {
                System.out.println(">>> unsupported key type found the default TGT: " + temp.key.getEType());
            }
        }
        if (result == null) {
            if (!alreadyTried) {
                try {
                    Credentials.ensureLoaded();
                }
                catch (Exception e) {
                    if (DEBUG) {
                        System.out.println("Can not load credentials cache");
                        e.printStackTrace();
                    }
                    alreadyTried = true;
                }
            }
            if (alreadyLoaded) {
                if (DEBUG) {
                    System.out.println(">> Acquire default native Credentials");
                }
                try {
                    result = Credentials.acquireDefaultNativeCreds(EType.getDefaults("default_tkt_enctypes"));
                }
                catch (KrbException krbException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public static Credentials acquireServiceCreds(String service, Credentials ccreds) throws KrbException, IOException {
        return CredentialsUtil.acquireServiceCreds(service, ccreds);
    }

    public static Credentials acquireS4U2selfCreds(PrincipalName user, Credentials ccreds) throws KrbException, IOException {
        return CredentialsUtil.acquireS4U2selfCreds(user, ccreds);
    }

    public static Credentials acquireS4U2proxyCreds(String service, Ticket second, PrincipalName client, Credentials ccreds) throws KrbException, IOException {
        return CredentialsUtil.acquireS4U2proxyCreds(service, second, client, ccreds);
    }

    public CredentialsCache getCache() {
        return cache;
    }

    public static void printDebug(Credentials c) {
        System.out.println(">>> DEBUG: ----Credentials----");
        System.out.println("\tclient: " + c.client.toString());
        if (c.clientAlias != null) {
            System.out.println("\tclient alias: " + c.clientAlias.toString());
        }
        System.out.println("\tserver: " + c.server.toString());
        if (c.serverAlias != null) {
            System.out.println("\tserver alias: " + c.serverAlias.toString());
        }
        System.out.println("\tticket: sname: " + c.ticket.sname.toString());
        if (c.startTime != null) {
            System.out.println("\tstartTime: " + c.startTime.getTime());
        }
        System.out.println("\tendTime: " + c.endTime.getTime());
        System.out.println("        ----Credentials end----");
    }

    static void ensureLoaded() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (System.getProperty("os.name").contains("OS X")) {
                    System.loadLibrary("osxkrb5");
                } else {
                    System.loadLibrary("w2k_lsa_auth");
                }
                return null;
            }
        });
        alreadyLoaded = true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Credentials:");
        buffer.append("\n      client=").append(this.client);
        if (this.clientAlias != null) {
            buffer.append("\n      clientAlias=").append(this.clientAlias);
        }
        buffer.append("\n      server=").append(this.server);
        if (this.serverAlias != null) {
            buffer.append("\n      serverAlias=").append(this.serverAlias);
        }
        if (this.authTime != null) {
            buffer.append("\n    authTime=").append(this.authTime);
        }
        if (this.startTime != null) {
            buffer.append("\n   startTime=").append(this.startTime);
        }
        buffer.append("\n     endTime=").append(this.endTime);
        buffer.append("\n   renewTill=").append(this.renewTill);
        buffer.append("\n       flags=").append(this.flags);
        buffer.append("\nEType (skey)=").append(this.key.getEType());
        buffer.append("\n   (tkt key)=").append(this.ticket.encPart.eType);
        return buffer.toString();
    }

    public sun.security.krb5.internal.ccache.Credentials toCCacheCreds() {
        return new sun.security.krb5.internal.ccache.Credentials(this.getClient(), this.getServer(), this.getSessionKey(), Credentials.date2kt(this.getAuthTime()), Credentials.date2kt(this.getStartTime()), Credentials.date2kt(this.getEndTime()), Credentials.date2kt(this.getRenewTill()), false, this.flags, new HostAddresses(this.getClientAddresses()), this.getAuthzData(), this.getTicket(), null);
    }

    private static KerberosTime date2kt(Date d) {
        return d == null ? null : new KerberosTime(d);
    }

    static {
        alreadyLoaded = false;
        alreadyTried = false;
    }
}

