/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.cmm.lcms;

import java.awt.color.CMMException;
import java.awt.color.ICC_Profile;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.java2d.cmm.ColorTransform;
import sun.java2d.cmm.PCMM;
import sun.java2d.cmm.Profile;
import sun.java2d.cmm.lcms.LCMSImageLayout;
import sun.java2d.cmm.lcms.LCMSProfile;
import sun.java2d.cmm.lcms.LCMSTransform;

public class LCMS
implements PCMM {
    private static LCMS theLcms = null;

    @Override
    public Profile loadProfile(byte[] data) {
        Object disposerRef = new Object();
        long ptr = this.loadProfileNative(data, disposerRef);
        if (ptr != 0L) {
            return new LCMSProfile(ptr, disposerRef);
        }
        return null;
    }

    private native long loadProfileNative(byte[] var1, Object var2);

    private LCMSProfile getLcmsProfile(Profile p) {
        if (p instanceof LCMSProfile) {
            return (LCMSProfile)p;
        }
        throw new CMMException("Invalid profile: " + p);
    }

    @Override
    public void freeProfile(Profile p) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getProfileSize(Profile p) {
        Profile profile = p;
        synchronized (profile) {
            return this.getProfileSizeNative(this.getLcmsProfile(p).getLcmsPtr());
        }
    }

    private native int getProfileSizeNative(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getProfileData(Profile p, byte[] data) {
        Profile profile = p;
        synchronized (profile) {
            this.getProfileDataNative(this.getLcmsProfile(p).getLcmsPtr(), data);
        }
    }

    private native void getProfileDataNative(long var1, byte[] var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTagSize(Profile p, int tagSignature) {
        LCMSProfile profile;
        LCMSProfile lCMSProfile = profile = this.getLcmsProfile(p);
        synchronized (lCMSProfile) {
            LCMSProfile.TagData t = profile.getTag(tagSignature);
            return t == null ? 0 : t.getSize();
        }
    }

    static native byte[] getTagNative(long var0, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getTagData(Profile p, int tagSignature, byte[] data) {
        LCMSProfile profile;
        LCMSProfile lCMSProfile = profile = this.getLcmsProfile(p);
        synchronized (lCMSProfile) {
            LCMSProfile.TagData t = profile.getTag(tagSignature);
            if (t != null) {
                t.copyDataTo(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setTagData(Profile p, int tagSignature, byte[] data) {
        LCMSProfile profile;
        LCMSProfile lCMSProfile = profile = this.getLcmsProfile(p);
        synchronized (lCMSProfile) {
            profile.clearTagCache();
            this.setTagDataNative(profile.getLcmsPtr(), tagSignature, data);
        }
    }

    private native void setTagDataNative(long var1, int var3, byte[] var4);

    public static synchronized native LCMSProfile getProfileID(ICC_Profile var0);

    static long createTransform(LCMSProfile[] profiles, int renderType, int inFormatter, boolean isInIntPacked, int outFormatter, boolean isOutIntPacked, Object disposerRef) {
        long[] ptrs = new long[profiles.length];
        for (int i = 0; i < profiles.length; ++i) {
            if (profiles[i] == null) {
                throw new CMMException("Unknown profile ID");
            }
            ptrs[i] = profiles[i].getLcmsPtr();
        }
        return LCMS.createNativeTransform(ptrs, renderType, inFormatter, isInIntPacked, outFormatter, isOutIntPacked, disposerRef);
    }

    private static native long createNativeTransform(long[] var0, int var1, int var2, boolean var3, int var4, boolean var5, Object var6);

    @Override
    public ColorTransform createTransform(ICC_Profile profile, int renderType, int transformType) {
        return new LCMSTransform(profile, renderType, renderType);
    }

    @Override
    public synchronized ColorTransform createTransform(ColorTransform[] transforms) {
        return new LCMSTransform(transforms);
    }

    public static native void colorConvert(LCMSTransform var0, LCMSImageLayout var1, LCMSImageLayout var2);

    public static native void freeTransform(long var0);

    public static native void initLCMS(Class var0, Class var1, Class var2);

    private LCMS() {
    }

    static synchronized PCMM getModule() {
        if (theLcms != null) {
            return theLcms;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("awt");
                System.loadLibrary("lcms");
                return null;
            }
        });
        LCMS.initLCMS(LCMSTransform.class, LCMSImageLayout.class, ICC_Profile.class);
        theLcms = new LCMS();
        return theLcms;
    }
}

