/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.internal.KerberosTime;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class EncAPRepPart {
    public KerberosTime ctime;
    public int cusec;
    EncryptionKey subKey;
    Integer seqNumber;

    public EncAPRepPart(KerberosTime new_ctime, int new_cusec, EncryptionKey new_subKey, Integer new_seqNumber) {
        this.ctime = new_ctime;
        this.cusec = new_cusec;
        this.subKey = new_subKey;
        this.seqNumber = new_seqNumber;
    }

    public EncAPRepPart(byte[] data) throws Asn1Exception, IOException {
        this.init(new DerValue(data));
    }

    public EncAPRepPart(DerValue encoding) throws Asn1Exception, IOException {
        this.init(encoding);
    }

    private void init(DerValue encoding) throws Asn1Exception, IOException {
        if ((encoding.getTag() & 0x1F) != 27 || !encoding.isApplication() || !encoding.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if (der.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        this.ctime = KerberosTime.parse(der.getData(), (byte)0, true);
        DerValue subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.cusec = subDer.getData().getBigInteger().intValue();
        if (der.getData().available() > 0) {
            this.subKey = EncryptionKey.parse(der.getData(), (byte)2, true);
        } else {
            this.subKey = null;
            this.seqNumber = null;
        }
        if (der.getData().available() > 0) {
            subDer = der.getData().getDerValue();
            if ((subDer.getTag() & 0x1F) != 3) {
                throw new Asn1Exception(906);
            }
            this.seqNumber = new Integer(subDer.getData().getBigInteger().intValue());
        } else {
            this.seqNumber = null;
        }
        if (der.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        Vector<DerValue> v = new Vector<DerValue>();
        DerOutputStream temp = new DerOutputStream();
        v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)0), this.ctime.asn1Encode()));
        temp.putInteger(BigInteger.valueOf(this.cusec));
        v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)1), temp.toByteArray()));
        if (this.subKey != null) {
            v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)2), this.subKey.asn1Encode()));
        }
        if (this.seqNumber != null) {
            temp = new DerOutputStream();
            temp.putInteger(BigInteger.valueOf(this.seqNumber.longValue()));
            v.addElement(new DerValue(DerValue.createTag((byte)-128, true, (byte)3), temp.toByteArray()));
        }
        Object[] der = new DerValue[v.size()];
        v.copyInto(der);
        temp = new DerOutputStream();
        temp.putSequence((DerValue[])der);
        DerOutputStream out = new DerOutputStream();
        out.write(DerValue.createTag((byte)64, true, (byte)27), temp);
        return out.toByteArray();
    }

    public final EncryptionKey getSubKey() {
        return this.subKey;
    }

    public final Integer getSeqNumber() {
        return this.seqNumber;
    }
}

