/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.misc.FDBigInteger;

public class FloatingDecimal {
    static final int EXP_SHIFT = 52;
    static final long FRACT_HOB = 0x10000000000000L;
    static final long EXP_ONE = 0x3FF0000000000000L;
    static final int MAX_SMALL_BIN_EXP = 62;
    static final int MIN_SMALL_BIN_EXP = -21;
    static final int MAX_DECIMAL_DIGITS = 15;
    static final int MAX_DECIMAL_EXPONENT = 308;
    static final int MIN_DECIMAL_EXPONENT = -324;
    static final int BIG_DECIMAL_EXPONENT = 324;
    static final int MAX_NDIGITS = 1100;
    static final int SINGLE_EXP_SHIFT = 23;
    static final int SINGLE_FRACT_HOB = 0x800000;
    static final int SINGLE_MAX_DECIMAL_DIGITS = 7;
    static final int SINGLE_MAX_DECIMAL_EXPONENT = 38;
    static final int SINGLE_MIN_DECIMAL_EXPONENT = -45;
    static final int SINGLE_MAX_NDIGITS = 200;
    static final int INT_DECIMAL_DIGITS = 9;
    private static final String INFINITY_REP = "Infinity";
    private static final int INFINITY_LENGTH = "Infinity".length();
    private static final String NAN_REP = "NaN";
    private static final int NAN_LENGTH = "NaN".length();
    private static final BinaryToASCIIConverter B2AC_POSITIVE_INFINITY = new ExceptionalBinaryToASCIIBuffer("Infinity", false);
    private static final BinaryToASCIIConverter B2AC_NEGATIVE_INFINITY = new ExceptionalBinaryToASCIIBuffer("-Infinity", true);
    private static final BinaryToASCIIConverter B2AC_NOT_A_NUMBER = new ExceptionalBinaryToASCIIBuffer("NaN", false);
    private static final BinaryToASCIIConverter B2AC_POSITIVE_ZERO = new BinaryToASCIIBuffer(false, new char[]{'0'});
    private static final BinaryToASCIIConverter B2AC_NEGATIVE_ZERO = new BinaryToASCIIBuffer(true, new char[]{'0'});
    private static final ThreadLocal<BinaryToASCIIBuffer> threadLocalBinaryToASCIIBuffer = new ThreadLocal<BinaryToASCIIBuffer>(){

        @Override
        protected BinaryToASCIIBuffer initialValue() {
            return new BinaryToASCIIBuffer();
        }
    };
    static final ASCIIToBinaryConverter A2BC_POSITIVE_INFINITY = new PreparedASCIIToBinaryBuffer(Double.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
    static final ASCIIToBinaryConverter A2BC_NEGATIVE_INFINITY = new PreparedASCIIToBinaryBuffer(Double.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
    static final ASCIIToBinaryConverter A2BC_NOT_A_NUMBER = new PreparedASCIIToBinaryBuffer(Double.NaN, Float.NaN);
    static final ASCIIToBinaryConverter A2BC_POSITIVE_ZERO = new PreparedASCIIToBinaryBuffer(0.0, 0.0f);
    static final ASCIIToBinaryConverter A2BC_NEGATIVE_ZERO = new PreparedASCIIToBinaryBuffer(-0.0, -0.0f);

    public static String toJavaFormatString(double d) {
        return FloatingDecimal.getBinaryToASCIIConverter(d).toJavaFormatString();
    }

    public static String toJavaFormatString(float f) {
        return FloatingDecimal.getBinaryToASCIIConverter(f).toJavaFormatString();
    }

    public static void appendTo(double d, Appendable buf) {
        FloatingDecimal.getBinaryToASCIIConverter(d).appendTo(buf);
    }

    public static void appendTo(float f, Appendable buf) {
        FloatingDecimal.getBinaryToASCIIConverter(f).appendTo(buf);
    }

    public static double parseDouble(String s) throws NumberFormatException {
        return FloatingDecimal.readJavaFormatString(s).doubleValue();
    }

    public static float parseFloat(String s) throws NumberFormatException {
        return FloatingDecimal.readJavaFormatString(s).floatValue();
    }

    private static BinaryToASCIIBuffer getBinaryToASCIIBuffer() {
        return threadLocalBinaryToASCIIBuffer.get();
    }

    public static BinaryToASCIIConverter getBinaryToASCIIConverter(double d) {
        return FloatingDecimal.getBinaryToASCIIConverter(d, true);
    }

    static BinaryToASCIIConverter getBinaryToASCIIConverter(double d, boolean isCompatibleFormat) {
        int nSignificantBits;
        long dBits = Double.doubleToRawLongBits(d);
        boolean isNegative = (dBits & Long.MIN_VALUE) != 0L;
        long fractBits = dBits & 0xFFFFFFFFFFFFFL;
        int binExp = (int)((dBits & 0x7FF0000000000000L) >> 52);
        if (binExp == 2047) {
            if (fractBits == 0L) {
                return isNegative ? B2AC_NEGATIVE_INFINITY : B2AC_POSITIVE_INFINITY;
            }
            return B2AC_NOT_A_NUMBER;
        }
        if (binExp == 0) {
            if (fractBits == 0L) {
                return isNegative ? B2AC_NEGATIVE_ZERO : B2AC_POSITIVE_ZERO;
            }
            int leadingZeros = Long.numberOfLeadingZeros(fractBits);
            int shift = leadingZeros - 11;
            fractBits <<= shift;
            binExp = 1 - shift;
            nSignificantBits = 64 - leadingZeros;
        } else {
            fractBits |= 0x10000000000000L;
            nSignificantBits = 53;
        }
        BinaryToASCIIBuffer buf = FloatingDecimal.getBinaryToASCIIBuffer();
        buf.setSign(isNegative);
        buf.dtoa(binExp -= 1023, fractBits, nSignificantBits, isCompatibleFormat);
        return buf;
    }

    private static BinaryToASCIIConverter getBinaryToASCIIConverter(float f) {
        int nSignificantBits;
        int fBits = Float.floatToRawIntBits(f);
        boolean isNegative = (fBits & Integer.MIN_VALUE) != 0;
        int fractBits = fBits & 0x7FFFFF;
        int binExp = (fBits & 0x7F800000) >> 23;
        if (binExp == 255) {
            if ((long)fractBits == 0L) {
                return isNegative ? B2AC_NEGATIVE_INFINITY : B2AC_POSITIVE_INFINITY;
            }
            return B2AC_NOT_A_NUMBER;
        }
        if (binExp == 0) {
            if (fractBits == 0) {
                return isNegative ? B2AC_NEGATIVE_ZERO : B2AC_POSITIVE_ZERO;
            }
            int leadingZeros = Integer.numberOfLeadingZeros(fractBits);
            int shift = leadingZeros - 8;
            fractBits <<= shift;
            binExp = 1 - shift;
            nSignificantBits = 32 - leadingZeros;
        } else {
            fractBits |= 0x800000;
            nSignificantBits = 24;
        }
        BinaryToASCIIBuffer buf = FloatingDecimal.getBinaryToASCIIBuffer();
        buf.setSign(isNegative);
        buf.dtoa(binExp -= 127, (long)fractBits << 29, nSignificantBits, true);
        return buf;
    }

    static ASCIIToBinaryConverter readJavaFormatString(String in) throws NumberFormatException {
        block35: {
            boolean isNegative = false;
            boolean signSeen = false;
            try {
                boolean isZero;
                char ch;
                in = in.trim();
                int len = in.length();
                if (len == 0) {
                    throw new NumberFormatException("empty String");
                }
                int i = 0;
                switch (in.charAt(i)) {
                    case '-': {
                        isNegative = true;
                    }
                    case '+': {
                        ++i;
                        signSeen = true;
                    }
                }
                char c = in.charAt(i);
                if (c == 'N') {
                    if (len - i == NAN_LENGTH && in.indexOf(NAN_REP, i) == i) {
                        return A2BC_NOT_A_NUMBER;
                    }
                    break block35;
                }
                if (c == 'I') {
                    if (len - i == INFINITY_LENGTH && in.indexOf(INFINITY_REP, i) == i) {
                        return isNegative ? A2BC_NEGATIVE_INFINITY : A2BC_POSITIVE_INFINITY;
                    }
                    break block35;
                }
                if (c == '0' && len > i + 1 && ((ch = in.charAt(i + 1)) == 'x' || ch == 'X')) {
                    return FloatingDecimal.parseHexString(in);
                }
                char[] digits = new char[len];
                int nDigits = 0;
                boolean decSeen = false;
                int decPt = 0;
                int nLeadZero = 0;
                int nTrailZero = 0;
                while (i < len) {
                    c = in.charAt(i);
                    if (c == '0') {
                        ++nLeadZero;
                    } else {
                        if (c != '.') break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                while (i < len) {
                    c = in.charAt(i);
                    if (c >= '1' && c <= '9') {
                        digits[nDigits++] = c;
                        nTrailZero = 0;
                    } else if (c == '0') {
                        digits[nDigits++] = c;
                        ++nTrailZero;
                    } else {
                        if (c != '.') break;
                        if (decSeen) {
                            throw new NumberFormatException("multiple points");
                        }
                        decPt = i;
                        if (signSeen) {
                            --decPt;
                        }
                        decSeen = true;
                    }
                    ++i;
                }
                boolean bl = isZero = (nDigits -= nTrailZero) == 0;
                if (isZero && nLeadZero == 0) break block35;
                int decExp = decSeen ? decPt - nLeadZero : nDigits + nTrailZero;
                if (i < len && ((c = in.charAt(i)) == 'e' || c == 'E')) {
                    int expSign = 1;
                    int expVal = 0;
                    int reallyBig = 0xCCCCCCC;
                    boolean expOverflow = false;
                    switch (in.charAt(++i)) {
                        case '-': {
                            expSign = -1;
                        }
                        case '+': {
                            ++i;
                        }
                    }
                    int expAt = i;
                    while (i < len) {
                        if (expVal >= reallyBig) {
                            expOverflow = true;
                        }
                        if ((c = in.charAt(i++)) >= '0' && c <= '9') {
                            expVal = expVal * 10 + (c - 48);
                            continue;
                        }
                        --i;
                        break;
                    }
                    int expLimit = 324 + nDigits + nTrailZero;
                    decExp = expOverflow || expVal > expLimit ? expSign * expLimit : (decExp += expSign * expVal);
                    if (i == expAt) break block35;
                }
                if (i >= len || i == len - 1 && (in.charAt(i) == 'f' || in.charAt(i) == 'F' || in.charAt(i) == 'd' || in.charAt(i) == 'D')) {
                    if (isZero) {
                        return isNegative ? A2BC_NEGATIVE_ZERO : A2BC_POSITIVE_ZERO;
                    }
                    return new ASCIIToBinaryBuffer(isNegative, decExp, digits, nDigits);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        throw new NumberFormatException("For input string: \"" + in + "\"");
    }

    static ASCIIToBinaryConverter parseHexString(String s) {
        boolean leastZero;
        int iValue;
        boolean floatSticky;
        int threshShift;
        int floatBits;
        long currentDigit;
        long unsignedRawExponent;
        Matcher m = HexFloatPattern.VALUE.matcher(s);
        boolean validInput = m.matches();
        if (!validInput) {
            throw new NumberFormatException("For input string: \"" + s + "\"");
        }
        String group1 = m.group(1);
        boolean isNegative = group1 != null && group1.equals("-");
        String significandString = null;
        int signifLength = 0;
        int exponentAdjust = 0;
        int leftDigits = 0;
        int rightDigits = 0;
        String group4 = m.group(4);
        if (group4 != null) {
            significandString = FloatingDecimal.stripLeadingZeros(group4);
            leftDigits = significandString.length();
        } else {
            String group6 = FloatingDecimal.stripLeadingZeros(m.group(6));
            leftDigits = group6.length();
            String group7 = m.group(7);
            rightDigits = group7.length();
            significandString = (group6 == null ? "" : group6) + group7;
        }
        significandString = FloatingDecimal.stripLeadingZeros(significandString);
        signifLength = significandString.length();
        exponentAdjust = leftDigits >= 1 ? 4 * (leftDigits - 1) : -4 * (rightDigits - signifLength + 1);
        if (signifLength == 0) {
            return isNegative ? A2BC_NEGATIVE_ZERO : A2BC_POSITIVE_ZERO;
        }
        String group8 = m.group(8);
        boolean positiveExponent = group8 == null || group8.equals("+");
        try {
            unsignedRawExponent = Integer.parseInt(m.group(9));
        }
        catch (NumberFormatException e) {
            return isNegative ? (positiveExponent ? A2BC_NEGATIVE_INFINITY : A2BC_NEGATIVE_ZERO) : (positiveExponent ? A2BC_POSITIVE_INFINITY : A2BC_POSITIVE_ZERO);
        }
        long rawExponent = (positiveExponent ? 1L : -1L) * unsignedRawExponent;
        long exponent = rawExponent + (long)exponentAdjust;
        boolean round = false;
        boolean sticky = false;
        int nextShift = 0;
        long significand = 0L;
        long leadingDigit = FloatingDecimal.getHexDigit(significandString, 0);
        if (leadingDigit == 1L) {
            significand |= leadingDigit << 52;
            nextShift = 48;
        } else if (leadingDigit <= 3L) {
            significand |= leadingDigit << 51;
            nextShift = 47;
            ++exponent;
        } else if (leadingDigit <= 7L) {
            significand |= leadingDigit << 50;
            nextShift = 46;
            exponent += 2L;
        } else if (leadingDigit <= 15L) {
            significand |= leadingDigit << 49;
            nextShift = 45;
            exponent += 3L;
        } else {
            throw new AssertionError((Object)"Result from digit conversion too large!");
        }
        int i = 0;
        for (i = 1; i < signifLength && nextShift >= 0; nextShift -= 4, ++i) {
            currentDigit = FloatingDecimal.getHexDigit(significandString, i);
            significand |= currentDigit << nextShift;
        }
        if (i < signifLength) {
            currentDigit = FloatingDecimal.getHexDigit(significandString, i);
            switch (nextShift) {
                case -1: {
                    significand |= (currentDigit & 0xEL) >> 1;
                    round = (currentDigit & 1L) != 0L;
                    break;
                }
                case -2: {
                    significand |= (currentDigit & 0xCL) >> 2;
                    round = (currentDigit & 2L) != 0L;
                    sticky = (currentDigit & 1L) != 0L;
                    break;
                }
                case -3: {
                    significand |= (currentDigit & 8L) >> 3;
                    round = (currentDigit & 4L) != 0L;
                    sticky = (currentDigit & 3L) != 0L;
                    break;
                }
                case -4: {
                    round = (currentDigit & 8L) != 0L;
                    sticky = (currentDigit & 7L) != 0L;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unexpected shift distance remainder.");
                }
            }
            ++i;
            while (i < signifLength && !sticky) {
                currentDigit = FloatingDecimal.getHexDigit(significandString, i);
                sticky = sticky || currentDigit != 0L;
                ++i;
            }
        }
        int n = floatBits = isNegative ? Integer.MIN_VALUE : 0;
        if (exponent >= -126L) {
            if (exponent > 127L) {
                floatBits |= 0x7F800000;
            } else {
                threshShift = 28;
                floatSticky = (significand & (1L << threshShift) - 1L) != 0L || round || sticky;
                iValue = (int)(significand >>> threshShift);
                if ((iValue & 3) != 1 || floatSticky) {
                    ++iValue;
                }
                floatBits |= ((int)exponent + 126 << 23) + (iValue >> 1);
            }
        } else if (exponent >= -150L) {
            threshShift = (int)(-98L - exponent);
            assert (threshShift >= 29);
            assert (threshShift < 53);
            floatSticky = (significand & (1L << threshShift) - 1L) != 0L || round || sticky;
            iValue = (int)(significand >>> threshShift);
            if ((iValue & 3) != 1 || floatSticky) {
                ++iValue;
            }
            floatBits |= iValue >> 1;
        }
        float fValue = Float.intBitsToFloat(floatBits);
        if (exponent > 1023L) {
            return isNegative ? A2BC_NEGATIVE_INFINITY : A2BC_POSITIVE_INFINITY;
        }
        if (exponent <= 1023L && exponent >= -1022L) {
            significand = exponent + 1023L << 52 & 0x7FF0000000000000L | 0xFFFFFFFFFFFFFL & significand;
        } else {
            if (exponent < -1075L) {
                return isNegative ? A2BC_NEGATIVE_ZERO : A2BC_POSITIVE_ZERO;
            }
            sticky = sticky || round;
            round = false;
            int bitsDiscarded = 53 - ((int)exponent - -1074 + 1);
            assert (bitsDiscarded >= 1 && bitsDiscarded <= 53);
            boolean bl = round = (significand & 1L << bitsDiscarded - 1) != 0L;
            if (bitsDiscarded > 1) {
                long mask = -1L << bitsDiscarded - 1 ^ 0xFFFFFFFFFFFFFFFFL;
                sticky = sticky || (significand & mask) != 0L;
            }
            significand >>= bitsDiscarded;
            significand = 0L | 0xFFFFFFFFFFFFFL & significand;
        }
        boolean bl = leastZero = (significand & 1L) == 0L;
        if (leastZero && round && sticky || !leastZero && round) {
            ++significand;
        }
        double value = isNegative ? Double.longBitsToDouble(significand | Long.MIN_VALUE) : Double.longBitsToDouble(significand);
        return new PreparedASCIIToBinaryBuffer(value, fValue);
    }

    static String stripLeadingZeros(String s) {
        if (!s.isEmpty() && s.charAt(0) == '0') {
            for (int i = 1; i < s.length(); ++i) {
                if (s.charAt(i) == '0') continue;
                return s.substring(i);
            }
            return "";
        }
        return s;
    }

    static int getHexDigit(String s, int position) {
        int value = Character.digit(s.charAt(position), 16);
        if (value <= -1 || value >= 16) {
            throw new AssertionError((Object)("Unexpected failure of digit conversion of " + s.charAt(position)));
        }
        return value;
    }

    private static class HexFloatPattern {
        private static final Pattern VALUE = Pattern.compile("([-+])?0[xX](((\\p{XDigit}+)\\.?)|((\\p{XDigit}*)\\.(\\p{XDigit}+)))[pP]([-+])?(\\p{Digit}+)[fFdD]?");

        private HexFloatPattern() {
        }
    }

    static class ASCIIToBinaryBuffer
    implements ASCIIToBinaryConverter {
        boolean isNegative;
        int decExponent;
        char[] digits;
        int nDigits;
        private static final double[] SMALL_10_POW = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
        private static final float[] SINGLE_SMALL_10_POW = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};
        private static final double[] BIG_10_POW = new double[]{1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
        private static final double[] TINY_10_POW = new double[]{1.0E-16, 1.0E-32, 1.0E-64, 1.0E-128, 1.0E-256};
        private static final int MAX_SMALL_TEN = SMALL_10_POW.length - 1;
        private static final int SINGLE_MAX_SMALL_TEN = SINGLE_SMALL_10_POW.length - 1;

        ASCIIToBinaryBuffer(boolean negSign, int decExponent, char[] digits, int n) {
            this.isNegative = negSign;
            this.decExponent = decExponent;
            this.digits = digits;
            this.nDigits = n;
        }

        @Override
        public double doubleValue() {
            boolean overvalue;
            double t;
            int j;
            int kDigits = Math.min(this.nDigits, 16);
            int iValue = this.digits[0] - 48;
            int iDigits = Math.min(kDigits, 9);
            for (int i = 1; i < iDigits; ++i) {
                iValue = iValue * 10 + this.digits[i] - 48;
            }
            long lValue = iValue;
            for (int i = iDigits; i < kDigits; ++i) {
                lValue = lValue * 10L + (long)(this.digits[i] - 48);
            }
            double dValue = lValue;
            int exp = this.decExponent - kDigits;
            if (this.nDigits <= 15) {
                if (exp == 0 || dValue == 0.0) {
                    return this.isNegative ? -dValue : dValue;
                }
                if (exp >= 0) {
                    if (exp <= MAX_SMALL_TEN) {
                        double rValue = dValue * SMALL_10_POW[exp];
                        return this.isNegative ? -rValue : rValue;
                    }
                    int slop = 15 - kDigits;
                    if (exp <= MAX_SMALL_TEN + slop) {
                        double rValue = (dValue *= SMALL_10_POW[slop]) * SMALL_10_POW[exp - slop];
                        return this.isNegative ? -rValue : rValue;
                    }
                } else if (exp >= -MAX_SMALL_TEN) {
                    double rValue = dValue / SMALL_10_POW[-exp];
                    return this.isNegative ? -rValue : rValue;
                }
            }
            if (exp > 0) {
                if (this.decExponent > 309) {
                    return this.isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                }
                if ((exp & 0xF) != 0) {
                    dValue *= SMALL_10_POW[exp & 0xF];
                }
                if ((exp >>= 4) != 0) {
                    j = 0;
                    while (exp > 1) {
                        if ((exp & 1) != 0) {
                            dValue *= BIG_10_POW[j];
                        }
                        ++j;
                        exp >>= 1;
                    }
                    t = dValue * BIG_10_POW[j];
                    if (Double.isInfinite(t)) {
                        t = dValue / 2.0;
                        if (Double.isInfinite(t *= BIG_10_POW[j])) {
                            return this.isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                        }
                        t = Double.MAX_VALUE;
                    }
                    dValue = t;
                }
            } else if (exp < 0) {
                exp = -exp;
                if (this.decExponent < -325) {
                    return this.isNegative ? -0.0 : 0.0;
                }
                if ((exp & 0xF) != 0) {
                    dValue /= SMALL_10_POW[exp & 0xF];
                }
                if ((exp >>= 4) != 0) {
                    j = 0;
                    while (exp > 1) {
                        if ((exp & 1) != 0) {
                            dValue *= TINY_10_POW[j];
                        }
                        ++j;
                        exp >>= 1;
                    }
                    t = dValue * TINY_10_POW[j];
                    if (t == 0.0) {
                        t = dValue * 2.0;
                        if ((t *= TINY_10_POW[j]) == 0.0) {
                            return this.isNegative ? -0.0 : 0.0;
                        }
                        t = Double.MIN_VALUE;
                    }
                    dValue = t;
                }
            }
            if (this.nDigits > 1100) {
                this.nDigits = 1101;
                this.digits[1100] = 49;
            }
            FDBigInteger bigD0 = new FDBigInteger(lValue, this.digits, kDigits, this.nDigits);
            exp = this.decExponent - this.nDigits;
            long ieeeBits = Double.doubleToRawLongBits(dValue);
            int B5 = Math.max(0, -exp);
            int D5 = Math.max(0, exp);
            bigD0 = bigD0.multByPow52(D5, 0);
            bigD0.makeImmutable();
            FDBigInteger bigD = null;
            int prevD2 = 0;
            do {
                FDBigInteger diff;
                int cmpResult;
                int binexp = (int)(ieeeBits >>> 52);
                long bigBbits = ieeeBits & 0xFFFFFFFFFFFFFL;
                if (binexp > 0) {
                    bigBbits |= 0x10000000000000L;
                } else {
                    assert (bigBbits != 0L) : bigBbits;
                    int leadingZeros = Long.numberOfLeadingZeros(bigBbits);
                    int shift = leadingZeros - 11;
                    bigBbits <<= shift;
                    binexp = 1 - shift;
                }
                int lowOrderZeros = Long.numberOfTrailingZeros(bigBbits);
                bigBbits >>>= lowOrderZeros;
                int bigIntExp = (binexp -= 1023) - 52 + lowOrderZeros;
                int bigIntNBits = 53 - lowOrderZeros;
                int B2 = B5;
                int D2 = D5;
                if (bigIntExp >= 0) {
                    B2 += bigIntExp;
                } else {
                    D2 -= bigIntExp;
                }
                int Ulp2 = B2;
                int hulpbias = binexp <= -1023 ? binexp + lowOrderZeros + 1023 : 1 + lowOrderZeros;
                int common2 = Math.min(B2 += hulpbias, Math.min(D2 += hulpbias, Ulp2));
                Ulp2 -= common2;
                FDBigInteger bigB = FDBigInteger.valueOfMulPow52(bigBbits, B5, B2 -= common2);
                if (bigD == null || prevD2 != (D2 -= common2)) {
                    bigD = bigD0.leftShift(D2);
                    prevD2 = D2;
                }
                if ((cmpResult = bigB.cmp(bigD)) > 0) {
                    overvalue = true;
                    diff = bigB.leftInplaceSub(bigD);
                    if (bigIntNBits == 1 && bigIntExp > -1022 && --Ulp2 < 0) {
                        Ulp2 = 0;
                        diff = diff.leftShift(1);
                    }
                } else {
                    if (cmpResult >= 0) break;
                    overvalue = false;
                    diff = bigD.rightInplaceSub(bigB);
                }
                if ((cmpResult = diff.cmpPow52(B5, Ulp2)) < 0) break;
                if (cmpResult != 0) continue;
                if ((ieeeBits & 1L) == 0L) break;
                ieeeBits += overvalue ? -1L : 1L;
                break;
            } while ((ieeeBits += overvalue ? -1L : 1L) != 0L && ieeeBits != 0x7FF0000000000000L);
            if (this.isNegative) {
                ieeeBits |= Long.MIN_VALUE;
            }
            return Double.longBitsToDouble(ieeeBits);
        }

        @Override
        public float floatValue() {
            boolean overvalue;
            int j;
            int kDigits = Math.min(this.nDigits, 8);
            int iValue = this.digits[0] - 48;
            for (int i = 1; i < kDigits; ++i) {
                iValue = iValue * 10 + this.digits[i] - 48;
            }
            float fValue = iValue;
            int exp = this.decExponent - kDigits;
            if (this.nDigits <= 7) {
                if (exp == 0 || fValue == 0.0f) {
                    return this.isNegative ? -fValue : fValue;
                }
                if (exp >= 0) {
                    if (exp <= SINGLE_MAX_SMALL_TEN) {
                        return this.isNegative ? -fValue : (fValue *= SINGLE_SMALL_10_POW[exp]);
                    }
                    int slop = 7 - kDigits;
                    if (exp <= SINGLE_MAX_SMALL_TEN + slop) {
                        fValue *= SINGLE_SMALL_10_POW[slop];
                        return this.isNegative ? -fValue : (fValue *= SINGLE_SMALL_10_POW[exp - slop]);
                    }
                } else if (exp >= -SINGLE_MAX_SMALL_TEN) {
                    return this.isNegative ? -fValue : (fValue /= SINGLE_SMALL_10_POW[-exp]);
                }
            } else if (this.decExponent >= this.nDigits && this.nDigits + this.decExponent <= 15) {
                long lValue = iValue;
                for (int i = kDigits; i < this.nDigits; ++i) {
                    lValue = lValue * 10L + (long)(this.digits[i] - 48);
                }
                double dValue = lValue;
                exp = this.decExponent - this.nDigits;
                fValue = (float)(dValue *= SMALL_10_POW[exp]);
                return this.isNegative ? -fValue : fValue;
            }
            double dValue = fValue;
            if (exp > 0) {
                if (this.decExponent > 39) {
                    return this.isNegative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
                }
                if ((exp & 0xF) != 0) {
                    dValue *= SMALL_10_POW[exp & 0xF];
                }
                if ((exp >>= 4) != 0) {
                    j = 0;
                    while (exp > 0) {
                        if ((exp & 1) != 0) {
                            dValue *= BIG_10_POW[j];
                        }
                        ++j;
                        exp >>= 1;
                    }
                }
            } else if (exp < 0) {
                exp = -exp;
                if (this.decExponent < -46) {
                    return this.isNegative ? -0.0f : 0.0f;
                }
                if ((exp & 0xF) != 0) {
                    dValue /= SMALL_10_POW[exp & 0xF];
                }
                if ((exp >>= 4) != 0) {
                    j = 0;
                    while (exp > 0) {
                        if ((exp & 1) != 0) {
                            dValue *= TINY_10_POW[j];
                        }
                        ++j;
                        exp >>= 1;
                    }
                }
            }
            fValue = Math.max(Float.MIN_VALUE, Math.min(Float.MAX_VALUE, (float)dValue));
            if (this.nDigits > 200) {
                this.nDigits = 201;
                this.digits[200] = 49;
            }
            FDBigInteger bigD0 = new FDBigInteger(iValue, this.digits, kDigits, this.nDigits);
            exp = this.decExponent - this.nDigits;
            int ieeeBits = Float.floatToRawIntBits(fValue);
            int B5 = Math.max(0, -exp);
            int D5 = Math.max(0, exp);
            bigD0 = bigD0.multByPow52(D5, 0);
            bigD0.makeImmutable();
            FDBigInteger bigD = null;
            int prevD2 = 0;
            do {
                FDBigInteger diff;
                int cmpResult;
                int binexp = ieeeBits >>> 23;
                int bigBbits = ieeeBits & 0x7FFFFF;
                if (binexp > 0) {
                    bigBbits |= 0x800000;
                } else {
                    assert (bigBbits != 0) : bigBbits;
                    int leadingZeros = Integer.numberOfLeadingZeros(bigBbits);
                    int shift = leadingZeros - 8;
                    bigBbits <<= shift;
                    binexp = 1 - shift;
                }
                int lowOrderZeros = Integer.numberOfTrailingZeros(bigBbits);
                bigBbits >>>= lowOrderZeros;
                int bigIntExp = (binexp -= 127) - 23 + lowOrderZeros;
                int bigIntNBits = 24 - lowOrderZeros;
                int B2 = B5;
                int D2 = D5;
                if (bigIntExp >= 0) {
                    B2 += bigIntExp;
                } else {
                    D2 -= bigIntExp;
                }
                int Ulp2 = B2;
                int hulpbias = binexp <= -127 ? binexp + lowOrderZeros + 127 : 1 + lowOrderZeros;
                int common2 = Math.min(B2 += hulpbias, Math.min(D2 += hulpbias, Ulp2));
                Ulp2 -= common2;
                FDBigInteger bigB = FDBigInteger.valueOfMulPow52(bigBbits, B5, B2 -= common2);
                if (bigD == null || prevD2 != (D2 -= common2)) {
                    bigD = bigD0.leftShift(D2);
                    prevD2 = D2;
                }
                if ((cmpResult = bigB.cmp(bigD)) > 0) {
                    overvalue = true;
                    diff = bigB.leftInplaceSub(bigD);
                    if (bigIntNBits == 1 && bigIntExp > -126 && --Ulp2 < 0) {
                        Ulp2 = 0;
                        diff = diff.leftShift(1);
                    }
                } else {
                    if (cmpResult >= 0) break;
                    overvalue = false;
                    diff = bigD.rightInplaceSub(bigB);
                }
                if ((cmpResult = diff.cmpPow52(B5, Ulp2)) < 0) break;
                if (cmpResult != 0) continue;
                if ((ieeeBits & 1) == 0) break;
                ieeeBits += overvalue ? -1 : 1;
                break;
            } while ((ieeeBits += overvalue ? -1 : 1) != 0 && ieeeBits != 2139095040);
            if (this.isNegative) {
                ieeeBits |= Integer.MIN_VALUE;
            }
            return Float.intBitsToFloat(ieeeBits);
        }
    }

    static class PreparedASCIIToBinaryBuffer
    implements ASCIIToBinaryConverter {
        private final double doubleVal;
        private final float floatVal;

        public PreparedASCIIToBinaryBuffer(double doubleVal, float floatVal) {
            this.doubleVal = doubleVal;
            this.floatVal = floatVal;
        }

        @Override
        public double doubleValue() {
            return this.doubleVal;
        }

        @Override
        public float floatValue() {
            return this.floatVal;
        }
    }

    static interface ASCIIToBinaryConverter {
        public double doubleValue();

        public float floatValue();
    }

    static class BinaryToASCIIBuffer
    implements BinaryToASCIIConverter {
        private boolean isNegative;
        private int decExponent;
        private int firstDigitIndex;
        private int nDigits;
        private final char[] digits;
        private final char[] buffer = new char[26];
        private boolean exactDecimalConversion = false;
        private boolean decimalDigitsRoundedUp = false;
        private static int[] insignificantDigitsNumber = new int[]{0, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 14, 14, 14, 15, 15, 15, 15, 16, 16, 16, 17, 17, 17, 18, 18, 18, 19};
        private static final int[] N_5_BITS = new int[]{0, 3, 5, 7, 10, 12, 14, 17, 19, 21, 24, 26, 28, 31, 33, 35, 38, 40, 42, 45, 47, 49, 52, 54, 56, 59, 61};

        BinaryToASCIIBuffer() {
            this.digits = new char[20];
        }

        BinaryToASCIIBuffer(boolean isNegative, char[] digits) {
            this.isNegative = isNegative;
            this.decExponent = 0;
            this.digits = digits;
            this.firstDigitIndex = 0;
            this.nDigits = digits.length;
        }

        @Override
        public String toJavaFormatString() {
            int len = this.getChars(this.buffer);
            return new String(this.buffer, 0, len);
        }

        @Override
        public void appendTo(Appendable buf) {
            int len = this.getChars(this.buffer);
            if (buf instanceof StringBuilder) {
                ((StringBuilder)buf).append(this.buffer, 0, len);
            } else if (buf instanceof StringBuffer) {
                ((StringBuffer)buf).append(this.buffer, 0, len);
            } else assert (false);
        }

        @Override
        public int getDecimalExponent() {
            return this.decExponent;
        }

        @Override
        public int getDigits(char[] digits) {
            System.arraycopy(this.digits, this.firstDigitIndex, digits, 0, this.nDigits);
            return this.nDigits;
        }

        @Override
        public boolean isNegative() {
            return this.isNegative;
        }

        @Override
        public boolean isExceptional() {
            return false;
        }

        @Override
        public boolean digitsRoundedUp() {
            return this.decimalDigitsRoundedUp;
        }

        @Override
        public boolean decimalDigitsExact() {
            return this.exactDecimalConversion;
        }

        private void setSign(boolean isNegative) {
            this.isNegative = isNegative;
        }

        private void developLongDigits(int decExponent, long lvalue, int insignificantDigits) {
            if (insignificantDigits != 0) {
                long pow10 = FDBigInteger.LONG_5_POW[insignificantDigits] << insignificantDigits;
                long residue = lvalue % pow10;
                lvalue /= pow10;
                decExponent += insignificantDigits;
                if (residue >= pow10 >> 1) {
                    ++lvalue;
                }
            }
            int digitno = this.digits.length - 1;
            if (lvalue <= Integer.MAX_VALUE) {
                assert (lvalue > 0L) : lvalue;
                int ivalue = (int)lvalue;
                int c = ivalue % 10;
                ivalue /= 10;
                while (c == 0) {
                    ++decExponent;
                    c = ivalue % 10;
                    ivalue /= 10;
                }
                while (ivalue != 0) {
                    this.digits[digitno--] = (char)(c + 48);
                    ++decExponent;
                    c = ivalue % 10;
                    ivalue /= 10;
                }
                this.digits[digitno] = (char)(c + 48);
            } else {
                int c = (int)(lvalue % 10L);
                lvalue /= 10L;
                while (c == 0) {
                    ++decExponent;
                    c = (int)(lvalue % 10L);
                    lvalue /= 10L;
                }
                while (lvalue != 0L) {
                    this.digits[digitno--] = (char)(c + 48);
                    ++decExponent;
                    c = (int)(lvalue % 10L);
                    lvalue /= 10L;
                }
                this.digits[digitno] = (char)(c + 48);
            }
            this.decExponent = decExponent + 1;
            this.firstDigitIndex = digitno;
            this.nDigits = this.digits.length - digitno;
        }

        private void dtoa(int binExp, long fractBits, int nSignificantBits, boolean isCompatibleFormat) {
            long lowDigitDifference;
            boolean high;
            boolean low;
            assert (fractBits > 0L);
            assert ((fractBits & 0x10000000000000L) != 0L);
            int tailZeros = Long.numberOfTrailingZeros(fractBits);
            int nFractBits = 53 - tailZeros;
            this.decimalDigitsRoundedUp = false;
            this.exactDecimalConversion = false;
            int nTinyBits = Math.max(0, nFractBits - binExp - 1);
            if (binExp <= 62 && binExp >= -21 && nTinyBits < FDBigInteger.LONG_5_POW.length && nFractBits + N_5_BITS[nTinyBits] < 64 && nTinyBits == 0) {
                int insignificant = binExp > nSignificantBits ? BinaryToASCIIBuffer.insignificantDigitsForPow2(binExp - nSignificantBits - 1) : 0;
                fractBits = binExp >= 52 ? (fractBits <<= binExp - 52) : (fractBits >>>= 52 - binExp);
                this.developLongDigits(0, fractBits, insignificant);
                return;
            }
            int decExp = BinaryToASCIIBuffer.estimateDecExp(fractBits, binExp);
            int B5 = Math.max(0, -decExp);
            int B2 = B5 + nTinyBits + binExp;
            int S5 = Math.max(0, decExp);
            int S2 = S5 + nTinyBits;
            int M5 = B5;
            int M2 = B2 - nSignificantBits;
            fractBits >>>= tailZeros;
            int common2factor = Math.min(B2 -= nFractBits - 1, S2);
            B2 -= common2factor;
            S2 -= common2factor;
            M2 -= common2factor;
            if (nFractBits == 1) {
                --M2;
            }
            if (M2 < 0) {
                B2 -= M2;
                S2 -= M2;
                M2 = 0;
            }
            int ndigit = 0;
            int Bbits = nFractBits + B2 + (B5 < N_5_BITS.length ? N_5_BITS[B5] : B5 * 3);
            int tenSbits = S2 + 1 + (S5 + 1 < N_5_BITS.length ? N_5_BITS[S5 + 1] : (S5 + 1) * 3);
            if (Bbits < 64 && tenSbits < 64) {
                if (Bbits < 32 && tenSbits < 32) {
                    int b = (int)fractBits * FDBigInteger.SMALL_5_POW[B5] << B2;
                    int s = FDBigInteger.SMALL_5_POW[S5] << S2;
                    int m = FDBigInteger.SMALL_5_POW[M5] << M2;
                    int tens = s * 10;
                    ndigit = 0;
                    int q = b / s;
                    low = (b = 10 * (b % s)) < (m *= 10);
                    boolean bl = high = b + m > tens;
                    assert (q < 10) : q;
                    if (q == 0 && !high) {
                        --decExp;
                    } else {
                        this.digits[ndigit++] = (char)(48 + q);
                    }
                    if (!isCompatibleFormat || decExp < -3 || decExp >= 8) {
                        low = false;
                        high = false;
                    }
                    while (!low && !high) {
                        q = b / s;
                        b = 10 * (b % s);
                        m *= 10;
                        assert (q < 10) : q;
                        if ((long)m > 0L) {
                            low = b < m;
                            high = b + m > tens;
                        } else {
                            low = true;
                            high = true;
                        }
                        this.digits[ndigit++] = (char)(48 + q);
                    }
                    lowDigitDifference = (b << 1) - tens;
                    this.exactDecimalConversion = b == 0;
                } else {
                    long b = fractBits * FDBigInteger.LONG_5_POW[B5] << B2;
                    long s = FDBigInteger.LONG_5_POW[S5] << S2;
                    long m = FDBigInteger.LONG_5_POW[M5] << M2;
                    long tens = s * 10L;
                    ndigit = 0;
                    int q = (int)(b / s);
                    low = (b = 10L * (b % s)) < (m *= 10L);
                    boolean bl = high = b + m > tens;
                    assert (q < 10) : q;
                    if (q == 0 && !high) {
                        --decExp;
                    } else {
                        this.digits[ndigit++] = (char)(48 + q);
                    }
                    if (!isCompatibleFormat || decExp < -3 || decExp >= 8) {
                        low = false;
                        high = false;
                    }
                    while (!low && !high) {
                        q = (int)(b / s);
                        b = 10L * (b % s);
                        m *= 10L;
                        assert (q < 10) : q;
                        if (m > 0L) {
                            low = b < m;
                            high = b + m > tens;
                        } else {
                            low = true;
                            high = true;
                        }
                        this.digits[ndigit++] = (char)(48 + q);
                    }
                    lowDigitDifference = (b << 1) - tens;
                    this.exactDecimalConversion = b == 0L;
                }
            } else {
                FDBigInteger Sval = FDBigInteger.valueOfPow52(S5, S2);
                int shiftBias = Sval.getNormalizationBias();
                Sval = Sval.leftShift(shiftBias);
                FDBigInteger Bval = FDBigInteger.valueOfMulPow52(fractBits, B5, B2 + shiftBias);
                FDBigInteger Mval = FDBigInteger.valueOfPow52(M5 + 1, M2 + shiftBias + 1);
                FDBigInteger tenSval = FDBigInteger.valueOfPow52(S5 + 1, S2 + shiftBias + 1);
                ndigit = 0;
                int q = Bval.quoRemIteration(Sval);
                low = Bval.cmp(Mval) < 0;
                boolean bl = high = tenSval.addAndCmp(Bval, Mval) <= 0;
                assert (q < 10) : q;
                if (q == 0 && !high) {
                    --decExp;
                } else {
                    this.digits[ndigit++] = (char)(48 + q);
                }
                if (!isCompatibleFormat || decExp < -3 || decExp >= 8) {
                    low = false;
                    high = false;
                }
                while (!low && !high) {
                    q = Bval.quoRemIteration(Sval);
                    assert (q < 10) : q;
                    low = Bval.cmp(Mval = Mval.multBy10()) < 0;
                    high = tenSval.addAndCmp(Bval, Mval) <= 0;
                    this.digits[ndigit++] = (char)(48 + q);
                }
                if (high && low) {
                    Bval = Bval.leftShift(1);
                    lowDigitDifference = Bval.cmp(tenSval);
                } else {
                    lowDigitDifference = 0L;
                }
                this.exactDecimalConversion = Bval.cmp(FDBigInteger.ZERO) == 0;
            }
            this.decExponent = decExp + 1;
            this.firstDigitIndex = 0;
            this.nDigits = ndigit;
            if (high) {
                if (low) {
                    if (lowDigitDifference == 0L) {
                        if ((this.digits[this.firstDigitIndex + this.nDigits - 1] & '\u0001') != 0) {
                            this.roundup();
                        }
                    } else if (lowDigitDifference > 0L) {
                        this.roundup();
                    }
                } else {
                    this.roundup();
                }
            }
        }

        private void roundup() {
            int i = this.firstDigitIndex + this.nDigits - 1;
            char q = this.digits[i];
            if (q == '9') {
                while (q == '9' && i > this.firstDigitIndex) {
                    this.digits[i] = 48;
                    q = this.digits[--i];
                }
                if (q == '9') {
                    ++this.decExponent;
                    this.digits[this.firstDigitIndex] = 49;
                    return;
                }
            }
            this.digits[i] = (char)(q + '\u0001');
            this.decimalDigitsRoundedUp = true;
        }

        static int estimateDecExp(long fractBits, int binExp) {
            boolean isNegative;
            double d2 = Double.longBitsToDouble(0x3FF0000000000000L | fractBits & 0xFFFFFFFFFFFFFL);
            double d = (d2 - 1.5) * 0.289529654 + 0.176091259 + (double)binExp * 0.301029995663981;
            long dBits = Double.doubleToRawLongBits(d);
            int exponent = (int)((dBits & 0x7FF0000000000000L) >> 52) - 1023;
            boolean bl = isNegative = (dBits & Long.MIN_VALUE) != 0L;
            if (exponent >= 0 && exponent < 52) {
                long mask = 0xFFFFFFFFFFFFFL >> exponent;
                int r = (int)((dBits & 0xFFFFFFFFFFFFFL | 0x10000000000000L) >> 52 - exponent);
                return isNegative ? ((mask & dBits) == 0L ? -r : -r - 1) : r;
            }
            if (exponent < 0) {
                return (dBits & Long.MAX_VALUE) == 0L ? 0 : (isNegative ? -1 : 0);
            }
            return (int)d;
        }

        private static int insignificantDigits(int insignificant) {
            int i = 0;
            while ((long)insignificant >= 10L) {
                insignificant = (int)((long)insignificant / 10L);
                ++i;
            }
            return i;
        }

        private static int insignificantDigitsForPow2(int p2) {
            if (p2 > 1 && p2 < insignificantDigitsNumber.length) {
                return insignificantDigitsNumber[p2];
            }
            return 0;
        }

        private int getChars(char[] result) {
            assert (this.nDigits <= 19) : this.nDigits;
            int i = 0;
            if (this.isNegative) {
                result[0] = 45;
                i = 1;
            }
            if (this.decExponent > 0 && this.decExponent < 8) {
                int charLength = Math.min(this.nDigits, this.decExponent);
                System.arraycopy(this.digits, this.firstDigitIndex, result, i, charLength);
                i += charLength;
                if (charLength < this.decExponent) {
                    charLength = this.decExponent - charLength;
                    Arrays.fill(result, i, i + charLength, '0');
                    i += charLength;
                    result[i++] = 46;
                    result[i++] = 48;
                } else {
                    result[i++] = 46;
                    if (charLength < this.nDigits) {
                        int t = this.nDigits - charLength;
                        System.arraycopy(this.digits, this.firstDigitIndex + charLength, result, i, t);
                        i += t;
                    } else {
                        result[i++] = 48;
                    }
                }
            } else if (this.decExponent <= 0 && this.decExponent > -3) {
                result[i++] = 48;
                result[i++] = 46;
                if (this.decExponent != 0) {
                    Arrays.fill(result, i, i - this.decExponent, '0');
                    i -= this.decExponent;
                }
                System.arraycopy(this.digits, this.firstDigitIndex, result, i, this.nDigits);
                i += this.nDigits;
            } else {
                int e;
                result[i++] = this.digits[this.firstDigitIndex];
                result[i++] = 46;
                if (this.nDigits > 1) {
                    System.arraycopy(this.digits, this.firstDigitIndex + 1, result, i, this.nDigits - 1);
                    i += this.nDigits - 1;
                } else {
                    result[i++] = 48;
                }
                result[i++] = 69;
                if (this.decExponent <= 0) {
                    result[i++] = 45;
                    e = -this.decExponent + 1;
                } else {
                    e = this.decExponent - 1;
                }
                if (e <= 9) {
                    result[i++] = (char)(e + 48);
                } else if (e <= 99) {
                    result[i++] = (char)(e / 10 + 48);
                    result[i++] = (char)(e % 10 + 48);
                } else {
                    result[i++] = (char)(e / 100 + 48);
                    result[i++] = (char)((e %= 100) / 10 + 48);
                    result[i++] = (char)(e % 10 + 48);
                }
            }
            return i;
        }
    }

    private static class ExceptionalBinaryToASCIIBuffer
    implements BinaryToASCIIConverter {
        private final String image;
        private boolean isNegative;

        public ExceptionalBinaryToASCIIBuffer(String image, boolean isNegative) {
            this.image = image;
            this.isNegative = isNegative;
        }

        @Override
        public String toJavaFormatString() {
            return this.image;
        }

        @Override
        public void appendTo(Appendable buf) {
            if (buf instanceof StringBuilder) {
                ((StringBuilder)buf).append(this.image);
            } else if (buf instanceof StringBuffer) {
                ((StringBuffer)buf).append(this.image);
            } else assert (false);
        }

        @Override
        public int getDecimalExponent() {
            throw new IllegalArgumentException("Exceptional value does not have an exponent");
        }

        @Override
        public int getDigits(char[] digits) {
            throw new IllegalArgumentException("Exceptional value does not have digits");
        }

        @Override
        public boolean isNegative() {
            return this.isNegative;
        }

        @Override
        public boolean isExceptional() {
            return true;
        }

        @Override
        public boolean digitsRoundedUp() {
            throw new IllegalArgumentException("Exceptional value is not rounded");
        }

        @Override
        public boolean decimalDigitsExact() {
            throw new IllegalArgumentException("Exceptional value is not exact");
        }
    }

    public static interface BinaryToASCIIConverter {
        public String toJavaFormatString();

        public void appendTo(Appendable var1);

        public int getDecimalExponent();

        public int getDigits(char[] var1);

        public boolean isNegative();

        public boolean isExceptional();

        public boolean digitsRoundedUp();

        public boolean decimalDigitsExact();
    }
}

