/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.MethodRef;
import java.beans.ParameterDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class MethodDescriptor
extends FeatureDescriptor {
    private final MethodRef methodRef = new MethodRef();
    private String[] paramNames;
    private List<WeakReference<Class<?>>> params;
    private ParameterDescriptor[] parameterDescriptors;

    public MethodDescriptor(Method method) {
        this(method, null);
    }

    public MethodDescriptor(Method method, ParameterDescriptor[] parameterDescriptors) {
        this.setName(method.getName());
        this.setMethod(method);
        this.parameterDescriptors = parameterDescriptors != null ? (ParameterDescriptor[])parameterDescriptors.clone() : null;
    }

    public synchronized Method getMethod() {
        Method method = this.methodRef.get();
        if (method == null) {
            Class<?> cls = this.getClass0();
            String name = this.getName();
            if (cls != null && name != null) {
                Class[] params = this.getParams();
                if (params == null) {
                    for (int i = 0; i < 3 && (method = Introspector.findMethod(cls, name, i, null)) == null; ++i) {
                    }
                } else {
                    method = Introspector.findMethod(cls, name, params.length, params);
                }
                this.setMethod(method);
            }
        }
        return method;
    }

    private synchronized void setMethod(Method method) {
        if (method == null) {
            return;
        }
        if (this.getClass0() == null) {
            this.setClass0(method.getDeclaringClass());
        }
        this.setParams(MethodDescriptor.getParameterTypes(this.getClass0(), method));
        this.methodRef.set(method);
    }

    private synchronized void setParams(Class<?>[] param) {
        if (param == null) {
            return;
        }
        this.paramNames = new String[param.length];
        this.params = new ArrayList(param.length);
        for (int i = 0; i < param.length; ++i) {
            this.paramNames[i] = param[i].getName();
            this.params.add(new WeakReference(param[i]));
        }
    }

    String[] getParamNames() {
        return this.paramNames;
    }

    private synchronized Class<?>[] getParams() {
        Class[] clss = new Class[this.params.size()];
        for (int i = 0; i < this.params.size(); ++i) {
            Reference ref = this.params.get(i);
            Class cls = (Class)ref.get();
            if (cls == null) {
                return null;
            }
            clss[i] = cls;
        }
        return clss;
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        return this.parameterDescriptors != null ? (ParameterDescriptor[])this.parameterDescriptors.clone() : null;
    }

    private static Method resolve(Method oldMethod, Method newMethod) {
        if (oldMethod == null) {
            return newMethod;
        }
        if (newMethod == null) {
            return oldMethod;
        }
        return !oldMethod.isSynthetic() && newMethod.isSynthetic() ? oldMethod : newMethod;
    }

    MethodDescriptor(MethodDescriptor x, MethodDescriptor y) {
        super(x, y);
        this.methodRef.set(MethodDescriptor.resolve(x.methodRef.get(), y.methodRef.get()));
        this.params = x.params;
        if (y.params != null) {
            this.params = y.params;
        }
        this.paramNames = x.paramNames;
        if (y.paramNames != null) {
            this.paramNames = y.paramNames;
        }
        this.parameterDescriptors = x.parameterDescriptors;
        if (y.parameterDescriptors != null) {
            this.parameterDescriptors = y.parameterDescriptors;
        }
    }

    MethodDescriptor(MethodDescriptor old) {
        super(old);
        this.methodRef.set(old.getMethod());
        this.params = old.params;
        this.paramNames = old.paramNames;
        if (old.parameterDescriptors != null) {
            int len = old.parameterDescriptors.length;
            this.parameterDescriptors = new ParameterDescriptor[len];
            for (int i = 0; i < len; ++i) {
                this.parameterDescriptors[i] = new ParameterDescriptor(old.parameterDescriptors[i]);
            }
        }
    }

    @Override
    void appendTo(StringBuilder sb) {
        MethodDescriptor.appendTo(sb, "method", this.methodRef.get());
        if (this.parameterDescriptors != null) {
            sb.append("; parameterDescriptors={");
            for (ParameterDescriptor pd : this.parameterDescriptors) {
                sb.append(pd).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append("}");
        }
    }
}

