/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.AccessController;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.DefaultSynthStyleFactory;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthButtonUI;
import javax.swing.plaf.synth.SynthCheckBoxMenuItemUI;
import javax.swing.plaf.synth.SynthCheckBoxUI;
import javax.swing.plaf.synth.SynthColorChooserUI;
import javax.swing.plaf.synth.SynthComboBoxUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthDefaultLookup;
import javax.swing.plaf.synth.SynthDesktopIconUI;
import javax.swing.plaf.synth.SynthDesktopPaneUI;
import javax.swing.plaf.synth.SynthEditorPaneUI;
import javax.swing.plaf.synth.SynthFormattedTextFieldUI;
import javax.swing.plaf.synth.SynthInternalFrameUI;
import javax.swing.plaf.synth.SynthLabelUI;
import javax.swing.plaf.synth.SynthListUI;
import javax.swing.plaf.synth.SynthMenuBarUI;
import javax.swing.plaf.synth.SynthMenuItemUI;
import javax.swing.plaf.synth.SynthMenuUI;
import javax.swing.plaf.synth.SynthOptionPaneUI;
import javax.swing.plaf.synth.SynthPanelUI;
import javax.swing.plaf.synth.SynthParser;
import javax.swing.plaf.synth.SynthPasswordFieldUI;
import javax.swing.plaf.synth.SynthPopupMenuUI;
import javax.swing.plaf.synth.SynthProgressBarUI;
import javax.swing.plaf.synth.SynthRadioButtonMenuItemUI;
import javax.swing.plaf.synth.SynthRadioButtonUI;
import javax.swing.plaf.synth.SynthRootPaneUI;
import javax.swing.plaf.synth.SynthScrollBarUI;
import javax.swing.plaf.synth.SynthScrollPaneUI;
import javax.swing.plaf.synth.SynthSeparatorUI;
import javax.swing.plaf.synth.SynthSliderUI;
import javax.swing.plaf.synth.SynthSpinnerUI;
import javax.swing.plaf.synth.SynthSplitPaneUI;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import javax.swing.plaf.synth.SynthTabbedPaneUI;
import javax.swing.plaf.synth.SynthTableHeaderUI;
import javax.swing.plaf.synth.SynthTableUI;
import javax.swing.plaf.synth.SynthTextAreaUI;
import javax.swing.plaf.synth.SynthTextFieldUI;
import javax.swing.plaf.synth.SynthTextPaneUI;
import javax.swing.plaf.synth.SynthToggleButtonUI;
import javax.swing.plaf.synth.SynthToolBarUI;
import javax.swing.plaf.synth.SynthToolTipUI;
import javax.swing.plaf.synth.SynthTreeUI;
import javax.swing.plaf.synth.SynthUI;
import javax.swing.plaf.synth.SynthViewportUI;
import sun.awt.AppContext;
import sun.security.action.GetPropertyAction;
import sun.swing.DefaultLookup;
import sun.swing.SwingUtilities2;
import sun.swing.plaf.synth.SynthFileChooserUI;

public class SynthLookAndFeel
extends BasicLookAndFeel {
    static final Insets EMPTY_UIRESOURCE_INSETS = new InsetsUIResource(0, 0, 0, 0);
    private static final Object STYLE_FACTORY_KEY = new StringBuffer("com.sun.java.swing.plaf.gtk.StyleCache");
    private static final Object SELECTED_UI_KEY = new StringBuilder("selectedUI");
    private static final Object SELECTED_UI_STATE_KEY = new StringBuilder("selectedUIState");
    private static SynthStyleFactory lastFactory;
    private static AppContext lastContext;
    private SynthStyleFactory factory = new DefaultSynthStyleFactory();
    private Map<String, Object> defaultsMap;
    private Handler _handler = new Handler();
    private static ReferenceQueue<LookAndFeel> queue;

    static ComponentUI getSelectedUI() {
        return (ComponentUI)AppContext.getAppContext().get(SELECTED_UI_KEY);
    }

    static void setSelectedUI(ComponentUI uix, boolean selected, boolean focused, boolean enabled, boolean rollover) {
        int selectedUIState = 0;
        if (selected) {
            selectedUIState = 512;
            if (focused) {
                selectedUIState |= 0x100;
            }
        } else if (rollover && enabled) {
            selectedUIState |= 3;
            if (focused) {
                selectedUIState |= 0x100;
            }
        } else if (enabled) {
            selectedUIState |= 1;
            if (focused) {
                selectedUIState |= 0x100;
            }
        } else {
            selectedUIState |= 8;
        }
        AppContext context = AppContext.getAppContext();
        context.put(SELECTED_UI_KEY, uix);
        context.put(SELECTED_UI_STATE_KEY, selectedUIState);
    }

    static int getSelectedUIState() {
        Integer result = (Integer)AppContext.getAppContext().get(SELECTED_UI_STATE_KEY);
        return result == null ? 0 : result;
    }

    static void resetSelectedUI() {
        AppContext.getAppContext().remove(SELECTED_UI_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStyleFactory(SynthStyleFactory cache) {
        Class<SynthLookAndFeel> clazz = SynthLookAndFeel.class;
        synchronized (SynthLookAndFeel.class) {
            AppContext context = AppContext.getAppContext();
            lastFactory = cache;
            lastContext = context;
            context.put(STYLE_FACTORY_KEY, cache);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SynthStyleFactory getStyleFactory() {
        Class<SynthLookAndFeel> clazz = SynthLookAndFeel.class;
        synchronized (SynthLookAndFeel.class) {
            AppContext context = AppContext.getAppContext();
            if (lastContext == context) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return lastFactory;
            }
            lastContext = context;
            lastFactory = (SynthStyleFactory)context.get(STYLE_FACTORY_KEY);
            // ** MonitorExit[var0] (shouldn't be in output)
            return lastFactory;
        }
    }

    static int getComponentState(Component c) {
        if (c.isEnabled()) {
            if (c.isFocusOwner()) {
                return 257;
            }
            return 1;
        }
        return 8;
    }

    public static SynthStyle getStyle(JComponent c, Region region) {
        return SynthLookAndFeel.getStyleFactory().getStyle(c, region);
    }

    static boolean shouldUpdateStyle(PropertyChangeEvent event) {
        LookAndFeel laf = UIManager.getLookAndFeel();
        return laf instanceof SynthLookAndFeel && ((SynthLookAndFeel)laf).shouldUpdateStyleOnEvent(event);
    }

    static SynthStyle updateStyle(SynthContext context, SynthUI ui) {
        SynthStyle oldStyle;
        SynthStyle newStyle = SynthLookAndFeel.getStyle(context.getComponent(), context.getRegion());
        if (newStyle != (oldStyle = context.getStyle())) {
            if (oldStyle != null) {
                oldStyle.uninstallDefaults(context);
            }
            context.setStyle(newStyle);
            newStyle.installDefaults(context, ui);
        }
        return newStyle;
    }

    public static void updateStyles(Component c) {
        if (c instanceof JComponent) {
            String name = c.getName();
            c.setName(null);
            if (name != null) {
                c.setName(name);
            }
            ((JComponent)c).revalidate();
        }
        Component[] children = null;
        if (c instanceof JMenu) {
            children = ((JMenu)c).getMenuComponents();
        } else if (c instanceof Container) {
            children = ((Container)c).getComponents();
        }
        if (children != null) {
            for (Component child : children) {
                SynthLookAndFeel.updateStyles(child);
            }
        }
        c.repaint();
    }

    public static Region getRegion(JComponent c) {
        return Region.getRegion(c);
    }

    static Insets getPaintingInsets(SynthContext state, Insets insets) {
        insets = state.isSubregion() ? state.getStyle().getInsets(state, insets) : state.getComponent().getInsets(insets);
        return insets;
    }

    static void update(SynthContext state, Graphics g) {
        SynthLookAndFeel.paintRegion(state, g, null);
    }

    static void updateSubregion(SynthContext state, Graphics g, Rectangle bounds) {
        SynthLookAndFeel.paintRegion(state, g, bounds);
    }

    private static void paintRegion(SynthContext state, Graphics g, Rectangle bounds) {
        int height;
        int width;
        int y;
        int x;
        JComponent c = state.getComponent();
        SynthStyle style = state.getStyle();
        if (bounds == null) {
            x = 0;
            y = 0;
            width = c.getWidth();
            height = c.getHeight();
        } else {
            x = bounds.x;
            y = bounds.y;
            width = bounds.width;
            height = bounds.height;
        }
        boolean subregion = state.isSubregion();
        if (subregion && style.isOpaque(state) || !subregion && c.isOpaque()) {
            g.setColor(style.getColor(state, ColorType.BACKGROUND));
            g.fillRect(x, y, width, height);
        }
    }

    static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    static Object getUIOfType(ComponentUI ui, Class klass) {
        if (klass.isInstance(ui)) {
            return ui;
        }
        return null;
    }

    public static ComponentUI createUI(JComponent c) {
        String key = c.getUIClassID().intern();
        if (key == "ButtonUI") {
            return SynthButtonUI.createUI(c);
        }
        if (key == "CheckBoxUI") {
            return SynthCheckBoxUI.createUI(c);
        }
        if (key == "CheckBoxMenuItemUI") {
            return SynthCheckBoxMenuItemUI.createUI(c);
        }
        if (key == "ColorChooserUI") {
            return SynthColorChooserUI.createUI(c);
        }
        if (key == "ComboBoxUI") {
            return SynthComboBoxUI.createUI(c);
        }
        if (key == "DesktopPaneUI") {
            return SynthDesktopPaneUI.createUI(c);
        }
        if (key == "DesktopIconUI") {
            return SynthDesktopIconUI.createUI(c);
        }
        if (key == "EditorPaneUI") {
            return SynthEditorPaneUI.createUI(c);
        }
        if (key == "FileChooserUI") {
            return SynthFileChooserUI.createUI(c);
        }
        if (key == "FormattedTextFieldUI") {
            return SynthFormattedTextFieldUI.createUI(c);
        }
        if (key == "InternalFrameUI") {
            return SynthInternalFrameUI.createUI(c);
        }
        if (key == "LabelUI") {
            return SynthLabelUI.createUI(c);
        }
        if (key == "ListUI") {
            return SynthListUI.createUI(c);
        }
        if (key == "MenuBarUI") {
            return SynthMenuBarUI.createUI(c);
        }
        if (key == "MenuUI") {
            return SynthMenuUI.createUI(c);
        }
        if (key == "MenuItemUI") {
            return SynthMenuItemUI.createUI(c);
        }
        if (key == "OptionPaneUI") {
            return SynthOptionPaneUI.createUI(c);
        }
        if (key == "PanelUI") {
            return SynthPanelUI.createUI(c);
        }
        if (key == "PasswordFieldUI") {
            return SynthPasswordFieldUI.createUI(c);
        }
        if (key == "PopupMenuSeparatorUI") {
            return SynthSeparatorUI.createUI(c);
        }
        if (key == "PopupMenuUI") {
            return SynthPopupMenuUI.createUI(c);
        }
        if (key == "ProgressBarUI") {
            return SynthProgressBarUI.createUI(c);
        }
        if (key == "RadioButtonUI") {
            return SynthRadioButtonUI.createUI(c);
        }
        if (key == "RadioButtonMenuItemUI") {
            return SynthRadioButtonMenuItemUI.createUI(c);
        }
        if (key == "RootPaneUI") {
            return SynthRootPaneUI.createUI(c);
        }
        if (key == "ScrollBarUI") {
            return SynthScrollBarUI.createUI(c);
        }
        if (key == "ScrollPaneUI") {
            return SynthScrollPaneUI.createUI(c);
        }
        if (key == "SeparatorUI") {
            return SynthSeparatorUI.createUI(c);
        }
        if (key == "SliderUI") {
            return SynthSliderUI.createUI(c);
        }
        if (key == "SpinnerUI") {
            return SynthSpinnerUI.createUI(c);
        }
        if (key == "SplitPaneUI") {
            return SynthSplitPaneUI.createUI(c);
        }
        if (key == "TabbedPaneUI") {
            return SynthTabbedPaneUI.createUI(c);
        }
        if (key == "TableUI") {
            return SynthTableUI.createUI(c);
        }
        if (key == "TableHeaderUI") {
            return SynthTableHeaderUI.createUI(c);
        }
        if (key == "TextAreaUI") {
            return SynthTextAreaUI.createUI(c);
        }
        if (key == "TextFieldUI") {
            return SynthTextFieldUI.createUI(c);
        }
        if (key == "TextPaneUI") {
            return SynthTextPaneUI.createUI(c);
        }
        if (key == "ToggleButtonUI") {
            return SynthToggleButtonUI.createUI(c);
        }
        if (key == "ToolBarSeparatorUI") {
            return SynthSeparatorUI.createUI(c);
        }
        if (key == "ToolBarUI") {
            return SynthToolBarUI.createUI(c);
        }
        if (key == "ToolTipUI") {
            return SynthToolTipUI.createUI(c);
        }
        if (key == "TreeUI") {
            return SynthTreeUI.createUI(c);
        }
        if (key == "ViewportUI") {
            return SynthViewportUI.createUI(c);
        }
        return null;
    }

    public void load(InputStream input, Class<?> resourceBase) throws ParseException {
        if (resourceBase == null) {
            throw new IllegalArgumentException("You must supply a valid resource base Class");
        }
        if (this.defaultsMap == null) {
            this.defaultsMap = new HashMap<String, Object>();
        }
        new SynthParser().parse(input, (DefaultSynthStyleFactory)this.factory, null, resourceBase, this.defaultsMap);
    }

    public void load(URL url) throws ParseException, IOException {
        if (url == null) {
            throw new IllegalArgumentException("You must supply a valid Synth set URL");
        }
        if (this.defaultsMap == null) {
            this.defaultsMap = new HashMap<String, Object>();
        }
        InputStream input = url.openStream();
        new SynthParser().parse(input, (DefaultSynthStyleFactory)this.factory, url, null, this.defaultsMap);
    }

    @Override
    public void initialize() {
        super.initialize();
        DefaultLookup.setDefaultLookup(new SynthDefaultLookup());
        SynthLookAndFeel.setStyleFactory(this.factory);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this._handler);
    }

    @Override
    public void uninitialize() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this._handler);
        super.uninitialize();
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults table = new UIDefaults(60, 0.75f);
        Region.registerUIs(table);
        table.setDefaultLocale(Locale.getDefault());
        table.addResourceBundle("com.sun.swing.internal.plaf.basic.resources.basic");
        table.addResourceBundle("com.sun.swing.internal.plaf.synth.resources.synth");
        table.put("TabbedPane.isTabRollover", Boolean.TRUE);
        table.put("ColorChooser.swatchesRecentSwatchSize", new Dimension(10, 10));
        table.put("ColorChooser.swatchesDefaultRecentColor", Color.RED);
        table.put("ColorChooser.swatchesSwatchSize", new Dimension(10, 10));
        table.put("html.pendingImage", SwingUtilities2.makeIcon(this.getClass(), BasicLookAndFeel.class, "icons/image-delayed.png"));
        table.put("html.missingImage", SwingUtilities2.makeIcon(this.getClass(), BasicLookAndFeel.class, "icons/image-failed.png"));
        table.put("PopupMenu.selectedWindowInputMapBindings", new Object[]{"ESCAPE", "cancel", "DOWN", "selectNext", "KP_DOWN", "selectNext", "UP", "selectPrevious", "KP_UP", "selectPrevious", "LEFT", "selectParent", "KP_LEFT", "selectParent", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "ENTER", "return", "SPACE", "return"});
        table.put("PopupMenu.selectedWindowInputMapBindings.RightToLeft", new Object[]{"LEFT", "selectChild", "KP_LEFT", "selectChild", "RIGHT", "selectParent", "KP_RIGHT", "selectParent"});
        SynthLookAndFeel.flushUnreferenced();
        Object aaTextInfo = SynthLookAndFeel.getAATextInfo();
        table.put(SwingUtilities2.AA_TEXT_PROPERTY_KEY, aaTextInfo);
        new AATextListener(this);
        if (this.defaultsMap != null) {
            table.putAll(this.defaultsMap);
        }
        return table;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Synth look and feel";
    }

    @Override
    public String getName() {
        return "Synth look and feel";
    }

    @Override
    public String getID() {
        return "Synth";
    }

    public boolean shouldUpdateStyleOnAncestorChanged() {
        return false;
    }

    protected boolean shouldUpdateStyleOnEvent(PropertyChangeEvent ev) {
        String eName = ev.getPropertyName();
        if ("name" == eName || "componentOrientation" == eName) {
            return true;
        }
        if ("ancestor" == eName && ev.getNewValue() != null) {
            return this.shouldUpdateStyleOnAncestorChanged();
        }
        return false;
    }

    private static Object getAATextInfo() {
        String language = Locale.getDefault().getLanguage();
        String desktop = AccessController.doPrivileged(new GetPropertyAction("sun.desktop"));
        boolean isCjkLocale = Locale.CHINESE.getLanguage().equals(language) || Locale.JAPANESE.getLanguage().equals(language) || Locale.KOREAN.getLanguage().equals(language);
        boolean isGnome = "gnome".equals(desktop);
        boolean isLocal = SwingUtilities2.isLocalDisplay();
        boolean setAA = isLocal && (!isGnome || !isCjkLocale);
        SwingUtilities2.AATextInfo aaTextInfo = SwingUtilities2.AATextInfo.getAATextInfo(setAA);
        return aaTextInfo;
    }

    private static void flushUnreferenced() {
        AATextListener aatl;
        while ((aatl = (AATextListener)queue.poll()) != null) {
            aatl.dispose();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException(this.getClass().getName());
    }

    static {
        queue = new ReferenceQueue();
    }

    private class Handler
    implements PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            Object newValue = evt.getNewValue();
            Object oldValue = evt.getOldValue();
            if ("focusOwner" == propertyName) {
                if (oldValue instanceof JComponent) {
                    this.repaintIfBackgroundsDiffer((JComponent)oldValue);
                }
                if (newValue instanceof JComponent) {
                    this.repaintIfBackgroundsDiffer((JComponent)newValue);
                }
            } else if ("managingFocus" == propertyName) {
                KeyboardFocusManager manager = (KeyboardFocusManager)evt.getSource();
                if (newValue.equals(Boolean.FALSE)) {
                    manager.removePropertyChangeListener(SynthLookAndFeel.this._handler);
                } else {
                    manager.addPropertyChangeListener(SynthLookAndFeel.this._handler);
                }
            }
        }

        private void repaintIfBackgroundsDiffer(JComponent comp) {
            ComponentUI ui = (ComponentUI)comp.getClientProperty(SwingUtilities2.COMPONENT_UI_PROPERTY_KEY);
            if (ui instanceof SynthUI) {
                SynthUI synthUI = (SynthUI)((Object)ui);
                SynthContext context = synthUI.getContext(comp);
                SynthStyle style = context.getStyle();
                int state = context.getComponentState();
                Color currBG = style.getColor(context, ColorType.BACKGROUND);
                context.setComponentState(state ^= 0x100);
                Color lastBG = style.getColor(context, ColorType.BACKGROUND);
                context.setComponentState(state ^= 0x100);
                if (currBG != null && !currBG.equals(lastBG)) {
                    comp.repaint();
                }
                context.dispose();
            }
        }
    }

    private static class AATextListener
    extends WeakReference<LookAndFeel>
    implements PropertyChangeListener {
        private String key = "awt.font.desktophints";
        private static boolean updatePending;

        AATextListener(LookAndFeel laf) {
            super(laf, queue);
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.addPropertyChangeListener(this.key, this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            UIDefaults defaults = UIManager.getLookAndFeelDefaults();
            if (defaults.getBoolean("Synth.doNotSetTextAA")) {
                this.dispose();
                return;
            }
            LookAndFeel laf = (LookAndFeel)this.get();
            if (laf == null || laf != UIManager.getLookAndFeel()) {
                this.dispose();
                return;
            }
            Object aaTextInfo = SynthLookAndFeel.getAATextInfo();
            defaults.put(SwingUtilities2.AA_TEXT_PROPERTY_KEY, aaTextInfo);
            this.updateUI();
        }

        void dispose() {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.removePropertyChangeListener(this.key, this);
        }

        private static void updateWindowUI(Window window) {
            Window[] ownedWins;
            SynthLookAndFeel.updateStyles(window);
            for (Window w : ownedWins = window.getOwnedWindows()) {
                AATextListener.updateWindowUI(w);
            }
        }

        private static void updateAllUIs() {
            Frame[] appFrames;
            for (Frame frame : appFrames = Frame.getFrames()) {
                AATextListener.updateWindowUI(frame);
            }
        }

        private static synchronized void setUpdatePending(boolean update) {
            updatePending = update;
        }

        private static synchronized boolean isUpdatePending() {
            return updatePending;
        }

        protected void updateUI() {
            if (!AATextListener.isUpdatePending()) {
                AATextListener.setUpdatePending(true);
                Runnable uiUpdater = new Runnable(){

                    @Override
                    public void run() {
                        AATextListener.updateAllUIs();
                        AATextListener.setUpdatePending(false);
                    }
                };
                SwingUtilities.invokeLater(uiUpdater);
            }
        }
    }
}

