/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.chrono.Era;
import java.time.chrono.JapaneseChronology;
import java.time.chrono.JapaneseDate;
import java.time.chrono.Ser;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.time.temporal.ValueRange;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import sun.util.calendar.CalendarDate;

public final class JapaneseEra
implements Era,
Serializable {
    static final int ERA_OFFSET = 2;
    static final sun.util.calendar.Era[] ERA_CONFIG;
    public static final JapaneseEra MEIJI;
    public static final JapaneseEra TAISHO;
    public static final JapaneseEra SHOWA;
    public static final JapaneseEra HEISEI;
    private static final JapaneseEra REIWA;
    private static final int N_ERA_CONSTANTS;
    private static final long serialVersionUID = 1466499369062886794L;
    private static final JapaneseEra[] KNOWN_ERAS;
    private final transient int eraValue;
    private final transient LocalDate since;

    private JapaneseEra(int eraValue, LocalDate since) {
        this.eraValue = eraValue;
        this.since = since;
    }

    sun.util.calendar.Era getPrivateEra() {
        return ERA_CONFIG[JapaneseEra.ordinal(this.eraValue)];
    }

    public static JapaneseEra of(int japaneseEra) {
        if (japaneseEra < JapaneseEra.MEIJI.eraValue || japaneseEra + 2 > KNOWN_ERAS.length) {
            throw new DateTimeException("Invalid era: " + japaneseEra);
        }
        return KNOWN_ERAS[JapaneseEra.ordinal(japaneseEra)];
    }

    public static JapaneseEra valueOf(String japaneseEra) {
        Objects.requireNonNull(japaneseEra, "japaneseEra");
        for (JapaneseEra era : KNOWN_ERAS) {
            if (!era.getName().equals(japaneseEra)) continue;
            return era;
        }
        throw new IllegalArgumentException("japaneseEra is invalid");
    }

    public static JapaneseEra[] values() {
        return Arrays.copyOf(KNOWN_ERAS, KNOWN_ERAS.length);
    }

    @Override
    public String getDisplayName(TextStyle style, Locale locale) {
        if (this.getValue() > N_ERA_CONSTANTS - 2) {
            Objects.requireNonNull(locale, "locale");
            return style.asNormal() == TextStyle.NARROW ? this.getAbbreviation() : this.getName();
        }
        return new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.ERA, style).toFormatter(locale).withChronology(JapaneseChronology.INSTANCE).format(this == MEIJI ? JapaneseDate.MEIJI_6_ISODATE : this.since);
    }

    static JapaneseEra from(LocalDate date) {
        if (date.isBefore(JapaneseDate.MEIJI_6_ISODATE)) {
            throw new DateTimeException("JapaneseDate before Meiji 6 are not supported");
        }
        for (int i = KNOWN_ERAS.length - 1; i > 0; --i) {
            JapaneseEra era = KNOWN_ERAS[i];
            if (date.compareTo(era.since) < 0) continue;
            return era;
        }
        return null;
    }

    static JapaneseEra toJapaneseEra(sun.util.calendar.Era privateEra) {
        for (int i = ERA_CONFIG.length - 1; i >= 0; --i) {
            if (!ERA_CONFIG[i].equals(privateEra)) continue;
            return KNOWN_ERAS[i];
        }
        return null;
    }

    static sun.util.calendar.Era privateEraFrom(LocalDate isoDate) {
        for (int i = KNOWN_ERAS.length - 1; i > 0; --i) {
            JapaneseEra era = KNOWN_ERAS[i];
            if (isoDate.compareTo(era.since) < 0) continue;
            return ERA_CONFIG[i];
        }
        return null;
    }

    private static int ordinal(int eraValue) {
        return eraValue + 2 - 1;
    }

    @Override
    public int getValue() {
        return this.eraValue;
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field == ChronoField.ERA) {
            return JapaneseChronology.INSTANCE.range(ChronoField.ERA);
        }
        return Era.super.range(field);
    }

    String getAbbreviation() {
        return ERA_CONFIG[JapaneseEra.ordinal(this.getValue())].getAbbreviation();
    }

    String getName() {
        return ERA_CONFIG[JapaneseEra.ordinal(this.getValue())].getName();
    }

    public String toString() {
        return this.getName();
    }

    private void readObject(ObjectInputStream s) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    private Object writeReplace() {
        return new Ser(5, this);
    }

    void writeExternal(DataOutput out) throws IOException {
        out.writeByte(this.getValue());
    }

    static JapaneseEra readExternal(DataInput in) throws IOException {
        byte eraValue = in.readByte();
        return JapaneseEra.of(eraValue);
    }

    static {
        MEIJI = new JapaneseEra(-1, LocalDate.of(1868, 1, 1));
        TAISHO = new JapaneseEra(0, LocalDate.of(1912, 7, 30));
        SHOWA = new JapaneseEra(1, LocalDate.of(1926, 12, 25));
        HEISEI = new JapaneseEra(2, LocalDate.of(1989, 1, 8));
        REIWA = new JapaneseEra(3, LocalDate.of(2019, 5, 1));
        N_ERA_CONSTANTS = REIWA.getValue() + 2;
        ERA_CONFIG = JapaneseChronology.JCAL.getEras();
        KNOWN_ERAS = new JapaneseEra[ERA_CONFIG.length];
        JapaneseEra.KNOWN_ERAS[0] = MEIJI;
        JapaneseEra.KNOWN_ERAS[1] = TAISHO;
        JapaneseEra.KNOWN_ERAS[2] = SHOWA;
        JapaneseEra.KNOWN_ERAS[3] = HEISEI;
        JapaneseEra.KNOWN_ERAS[4] = REIWA;
        for (int i = N_ERA_CONSTANTS; i < ERA_CONFIG.length; ++i) {
            CalendarDate date = ERA_CONFIG[i].getSinceDate();
            LocalDate isoDate = LocalDate.of(date.getYear(), date.getMonth(), date.getDayOfMonth());
            JapaneseEra.KNOWN_ERAS[i] = new JapaneseEra(i - 2 + 1, isoDate);
        }
    }
}

