/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sun.security.action.GetPropertyAction;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.Era;
import sun.util.calendar.Gregorian;
import sun.util.calendar.LocalGregorianCalendar;

public abstract class CalendarSystem {
    private static volatile boolean initialized = false;
    private static ConcurrentMap<String, String> names;
    private static ConcurrentMap<String, CalendarSystem> calendars;
    private static final String PACKAGE_NAME = "sun.util.calendar.";
    private static final String[] namePairs;
    private static final Gregorian GREGORIAN_INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initNames() {
        ConcurrentHashMap<String, String> nameMap = new ConcurrentHashMap<String, String>();
        StringBuilder clName = new StringBuilder();
        for (int i = 0; i < namePairs.length; i += 2) {
            clName.setLength(0);
            String cl = clName.append(PACKAGE_NAME).append(namePairs[i + 1]).toString();
            nameMap.put(namePairs[i], cl);
        }
        Class<CalendarSystem> clazz = CalendarSystem.class;
        synchronized (CalendarSystem.class) {
            if (!initialized) {
                names = nameMap;
                calendars = new ConcurrentHashMap<String, CalendarSystem>();
                initialized = true;
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    public static Gregorian getGregorianCalendar() {
        return GREGORIAN_INSTANCE;
    }

    public static CalendarSystem forName(String calendarName) {
        CalendarSystem cal;
        if ("gregorian".equals(calendarName)) {
            return GREGORIAN_INSTANCE;
        }
        if (!initialized) {
            CalendarSystem.initNames();
        }
        if ((cal = (CalendarSystem)calendars.get(calendarName)) != null) {
            return cal;
        }
        String className = (String)names.get(calendarName);
        if (className == null) {
            return null;
        }
        if (className.endsWith("LocalGregorianCalendar")) {
            cal = LocalGregorianCalendar.getLocalGregorianCalendar(calendarName);
        } else {
            try {
                Class<?> cl = Class.forName(className);
                cal = (CalendarSystem)cl.newInstance();
            }
            catch (Exception e) {
                throw new InternalError(e);
            }
        }
        if (cal == null) {
            return null;
        }
        CalendarSystem cs = calendars.putIfAbsent(calendarName, cal);
        return cs == null ? cal : cs;
    }

    public static Properties getCalendarProperties() throws IOException {
        Properties calendarProps = null;
        try {
            String homeDir = AccessController.doPrivileged(new GetPropertyAction("java.home"));
            final String fname = homeDir + File.separator + "lib" + File.separator + "calendars.properties";
            calendarProps = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                @Override
                public Properties run() throws IOException {
                    Properties props = new Properties();
                    try (FileInputStream fis = new FileInputStream(fname);){
                        props.load(fis);
                    }
                    return props;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)cause;
            }
            throw new InternalError(cause);
        }
        return calendarProps;
    }

    public abstract String getName();

    public abstract CalendarDate getCalendarDate();

    public abstract CalendarDate getCalendarDate(long var1);

    public abstract CalendarDate getCalendarDate(long var1, CalendarDate var3);

    public abstract CalendarDate getCalendarDate(long var1, TimeZone var3);

    public abstract CalendarDate newCalendarDate();

    public abstract CalendarDate newCalendarDate(TimeZone var1);

    public abstract long getTime(CalendarDate var1);

    public abstract int getYearLength(CalendarDate var1);

    public abstract int getYearLengthInMonths(CalendarDate var1);

    public abstract int getMonthLength(CalendarDate var1);

    public abstract int getWeekLength();

    public abstract Era getEra(String var1);

    public abstract Era[] getEras();

    public abstract void setEra(CalendarDate var1, String var2);

    public abstract CalendarDate getNthDayOfWeek(int var1, int var2, CalendarDate var3);

    public abstract CalendarDate setTimeOfDay(CalendarDate var1, int var2);

    public abstract boolean validate(CalendarDate var1);

    public abstract boolean normalize(CalendarDate var1);

    static {
        namePairs = new String[]{"gregorian", "Gregorian", "japanese", "LocalGregorianCalendar", "julian", "JulianCalendar"};
        GREGORIAN_INSTANCE = new Gregorian();
    }
}

