/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.CallSite;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.DontInline;
import java.lang.invoke.ForceInline;
import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.Stable;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Array;
import java.util.Arrays;

class Invokers {
    private final MethodType targetType;
    @Stable
    private final MethodHandle[] invokers = new MethodHandle[3];
    static final int INV_EXACT = 0;
    static final int INV_GENERIC = 1;
    static final int INV_BASIC = 2;
    static final int INV_LIMIT = 3;
    private static final int MH_LINKER_ARG_APPENDED = 1;
    private static final LambdaForm.NamedFunction NF_checkExactType;
    private static final LambdaForm.NamedFunction NF_checkGenericType;
    private static final LambdaForm.NamedFunction NF_getCallSiteTarget;
    private static final LambdaForm.NamedFunction NF_checkCustomized;

    Invokers(MethodType targetType) {
        this.targetType = targetType;
    }

    MethodHandle exactInvoker() {
        MethodHandle invoker = this.cachedInvoker(0);
        if (invoker != null) {
            return invoker;
        }
        invoker = this.makeExactOrGeneralInvoker(true);
        return this.setCachedInvoker(0, invoker);
    }

    MethodHandle genericInvoker() {
        MethodHandle invoker = this.cachedInvoker(1);
        if (invoker != null) {
            return invoker;
        }
        invoker = this.makeExactOrGeneralInvoker(false);
        return this.setCachedInvoker(1, invoker);
    }

    MethodHandle basicInvoker() {
        MethodHandle invoker = this.cachedInvoker(2);
        if (invoker != null) {
            return invoker;
        }
        MethodType basicType = this.targetType.basicType();
        if (basicType != this.targetType) {
            return this.setCachedInvoker(2, basicType.invokers().basicInvoker());
        }
        invoker = basicType.form().cachedMethodHandle(0);
        if (invoker == null) {
            MemberName method = Invokers.invokeBasicMethod(basicType);
            invoker = DirectMethodHandle.make(method);
            assert (this.checkInvoker(invoker));
            invoker = basicType.form().setCachedMethodHandle(0, invoker);
        }
        return this.setCachedInvoker(2, invoker);
    }

    private MethodHandle cachedInvoker(int idx) {
        return this.invokers[idx];
    }

    private synchronized MethodHandle setCachedInvoker(int idx, MethodHandle invoker) {
        MethodHandle prev = this.invokers[idx];
        if (prev != null) {
            return prev;
        }
        this.invokers[idx] = invoker;
        return this.invokers[idx];
    }

    private MethodHandle makeExactOrGeneralInvoker(boolean isExact) {
        MethodType mtype = this.targetType;
        MethodType invokerType = mtype.invokerType();
        int which = isExact ? 11 : 13;
        LambdaForm lform = Invokers.invokeHandleForm(mtype, false, which);
        MethodHandle invoker = BoundMethodHandle.bindSingle(invokerType, lform, mtype);
        String whichName = isExact ? "invokeExact" : "invoke";
        invoker = invoker.withInternalMemberName(MemberName.makeMethodHandleInvoke(whichName, mtype), false);
        assert (this.checkInvoker(invoker));
        this.maybeCompileToBytecode(invoker);
        return invoker;
    }

    private void maybeCompileToBytecode(MethodHandle invoker) {
        int EAGER_COMPILE_ARITY_LIMIT = 10;
        if (this.targetType == this.targetType.erase() && this.targetType.parameterCount() < 10) {
            invoker.form.compileToBytecode();
        }
    }

    static MemberName invokeBasicMethod(MethodType basicType) {
        assert (basicType == basicType.basicType());
        try {
            return MethodHandles.Lookup.IMPL_LOOKUP.resolveOrFail((byte)5, MethodHandle.class, "invokeBasic", basicType);
        }
        catch (ReflectiveOperationException ex) {
            throw MethodHandleStatics.newInternalError("JVM cannot find invoker for " + basicType, ex);
        }
    }

    private boolean checkInvoker(MethodHandle invoker) {
        assert (this.targetType.invokerType().equals((Object)invoker.type())) : Arrays.asList(this.targetType, this.targetType.invokerType(), invoker);
        assert (invoker.internalMemberName() == null || invoker.internalMemberName().getMethodType().equals((Object)this.targetType));
        assert (!invoker.isVarargsCollector());
        return true;
    }

    MethodHandle spreadInvoker(int leadingArgCount) {
        int spreadArgCount = this.targetType.parameterCount() - leadingArgCount;
        MethodType postSpreadType = this.targetType;
        Class<?> argArrayType = Invokers.impliedRestargType(postSpreadType, leadingArgCount);
        if (postSpreadType.parameterSlotCount() <= 253) {
            return this.genericInvoker().asSpreader(argArrayType, spreadArgCount);
        }
        MethodType preSpreadType = postSpreadType.replaceParameterTypes(leadingArgCount, postSpreadType.parameterCount(), argArrayType);
        MethodHandle arrayInvoker = MethodHandles.invoker(preSpreadType);
        MethodHandle makeSpreader = MethodHandles.insertArguments(Lazy.MH_asSpreader, 1, argArrayType, spreadArgCount);
        return MethodHandles.filterArgument(arrayInvoker, 0, makeSpreader);
    }

    private static Class<?> impliedRestargType(MethodType restargType, int fromPos) {
        if (restargType.isGeneric()) {
            return Object[].class;
        }
        int maxPos = restargType.parameterCount();
        if (fromPos >= maxPos) {
            return Object[].class;
        }
        Class<?> argType = restargType.parameterType(fromPos);
        for (int i = fromPos + 1; i < maxPos; ++i) {
            if (argType == restargType.parameterType(i)) continue;
            throw MethodHandleStatics.newIllegalArgumentException("need homogeneous rest arguments", restargType);
        }
        if (argType == Object.class) {
            return Object[].class;
        }
        return Array.newInstance(argType, 0).getClass();
    }

    public String toString() {
        return "Invokers" + this.targetType;
    }

    static MemberName methodHandleInvokeLinkerMethod(String name, MethodType mtype, Object[] appendixResult) {
        LambdaForm lform;
        int which;
        switch (name) {
            case "invokeExact": {
                which = 10;
                break;
            }
            case "invoke": {
                which = 12;
                break;
            }
            default: {
                throw new InternalError("not invoker: " + name);
            }
        }
        if (mtype.parameterSlotCount() <= 253) {
            lform = Invokers.invokeHandleForm(mtype, false, which);
            appendixResult[0] = mtype;
        } else {
            lform = Invokers.invokeHandleForm(mtype, true, which);
        }
        return lform.vmentry;
    }

    private static LambdaForm invokeHandleForm(MethodType mtype, boolean customized, int which) {
        MethodType mtypeArg;
        LambdaForm lform;
        String debugName;
        boolean isGeneric;
        boolean isLinker;
        boolean isCached;
        if (!customized) {
            mtype = mtype.basicType();
            isCached = true;
        } else {
            isCached = false;
        }
        switch (which) {
            case 10: {
                isLinker = true;
                isGeneric = false;
                debugName = "invokeExact_MT";
                break;
            }
            case 11: {
                isLinker = false;
                isGeneric = false;
                debugName = "exactInvoker";
                break;
            }
            case 12: {
                isLinker = true;
                isGeneric = true;
                debugName = "invoke_MT";
                break;
            }
            case 13: {
                isLinker = false;
                isGeneric = true;
                debugName = "invoker";
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        if (isCached && (lform = mtype.form().cachedLambdaForm(which)) != null) {
            return lform;
        }
        boolean THIS_MH = false;
        int CALL_MH = 0 + (isLinker ? 0 : 1);
        int ARG_BASE = CALL_MH + 1;
        int OUTARG_LIMIT = ARG_BASE + mtype.parameterCount();
        int INARG_LIMIT = OUTARG_LIMIT + (isLinker && !customized ? 1 : 0);
        int nameCursor = OUTARG_LIMIT;
        int MTYPE_ARG = customized ? -1 : nameCursor++;
        int CHECK_TYPE = nameCursor++;
        int CHECK_CUSTOM = MethodHandleStatics.CUSTOMIZE_THRESHOLD >= 0 ? nameCursor++ : -1;
        int LINKER_CALL = nameCursor++;
        MethodType invokerFormType = mtype.invokerType();
        if (isLinker) {
            if (!customized) {
                invokerFormType = invokerFormType.appendParameterTypes(MemberName.class);
            }
        } else {
            invokerFormType = invokerFormType.invokerType();
        }
        LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - INARG_LIMIT, invokerFormType);
        assert (names.length == nameCursor) : Arrays.asList(mtype, customized, which, nameCursor, names.length);
        if (MTYPE_ARG >= INARG_LIMIT) {
            assert (names[MTYPE_ARG] == null);
            BoundMethodHandle.SpeciesData speciesData = BoundMethodHandle.speciesData_L();
            names[0] = names[0].withConstraint(speciesData);
            LambdaForm.NamedFunction getter = speciesData.getterFunction(0);
            names[MTYPE_ARG] = new LambdaForm.Name(getter, names[0]);
        }
        MethodType outCallType = mtype.basicType();
        Object[] outArgs = Arrays.copyOfRange(names, CALL_MH, OUTARG_LIMIT, Object[].class);
        MethodType methodType = mtypeArg = customized ? mtype : names[MTYPE_ARG];
        if (!isGeneric) {
            names[CHECK_TYPE] = new LambdaForm.Name(NF_checkExactType, names[CALL_MH], mtypeArg);
        } else {
            names[CHECK_TYPE] = new LambdaForm.Name(NF_checkGenericType, names[CALL_MH], mtypeArg);
            outArgs[0] = names[CHECK_TYPE];
        }
        if (CHECK_CUSTOM != -1) {
            names[CHECK_CUSTOM] = new LambdaForm.Name(NF_checkCustomized, outArgs[0]);
        }
        names[LINKER_CALL] = new LambdaForm.Name(outCallType, outArgs);
        lform = new LambdaForm(debugName, INARG_LIMIT, names);
        if (isLinker) {
            lform.compileToBytecode();
        }
        if (isCached) {
            lform = mtype.form().setCachedLambdaForm(which, lform);
        }
        return lform;
    }

    static WrongMethodTypeException newWrongMethodTypeException(MethodType actual, MethodType expected) {
        return new WrongMethodTypeException("expected " + expected + " but found " + actual);
    }

    @ForceInline
    static void checkExactType(Object mhObj, Object expectedObj) {
        MethodHandle mh = (MethodHandle)mhObj;
        MethodType expected = (MethodType)expectedObj;
        MethodType actual = mh.type();
        if (actual != expected) {
            throw Invokers.newWrongMethodTypeException(expected, actual);
        }
    }

    @ForceInline
    static Object checkGenericType(Object mhObj, Object expectedObj) {
        MethodHandle mh = (MethodHandle)mhObj;
        MethodType expected = (MethodType)expectedObj;
        return mh.asType(expected);
    }

    static MemberName linkToCallSiteMethod(MethodType mtype) {
        LambdaForm lform = Invokers.callSiteForm(mtype, false);
        return lform.vmentry;
    }

    static MemberName linkToTargetMethod(MethodType mtype) {
        LambdaForm lform = Invokers.callSiteForm(mtype, true);
        return lform.vmentry;
    }

    private static LambdaForm callSiteForm(MethodType mtype, boolean skipCallSite) {
        mtype = mtype.basicType();
        int which = skipCallSite ? 15 : 14;
        LambdaForm lform = mtype.form().cachedLambdaForm(which);
        if (lform != null) {
            return lform;
        }
        boolean ARG_BASE = false;
        int OUTARG_LIMIT = 0 + mtype.parameterCount();
        int INARG_LIMIT = OUTARG_LIMIT + 1;
        int nameCursor = OUTARG_LIMIT;
        int APPENDIX_ARG = nameCursor++;
        int CSITE_ARG = skipCallSite ? -1 : APPENDIX_ARG;
        int CALL_MH = skipCallSite ? APPENDIX_ARG : nameCursor++;
        int LINKER_CALL = nameCursor++;
        MethodType invokerFormType = mtype.appendParameterTypes(skipCallSite ? MethodHandle.class : CallSite.class);
        LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - INARG_LIMIT, invokerFormType);
        assert (names.length == nameCursor);
        assert (names[APPENDIX_ARG] != null);
        if (!skipCallSite) {
            names[CALL_MH] = new LambdaForm.Name(NF_getCallSiteTarget, names[CSITE_ARG]);
        }
        boolean PREPEND_MH = false;
        boolean PREPEND_COUNT = true;
        Object[] outArgs = Arrays.copyOfRange(names, 0, OUTARG_LIMIT + 1, Object[].class);
        System.arraycopy(outArgs, 0, outArgs, 1, outArgs.length - 1);
        outArgs[0] = names[CALL_MH];
        names[LINKER_CALL] = new LambdaForm.Name(mtype, outArgs);
        lform = new LambdaForm(skipCallSite ? "linkToTargetMethod" : "linkToCallSite", INARG_LIMIT, names);
        lform.compileToBytecode();
        lform = mtype.form().setCachedLambdaForm(which, lform);
        return lform;
    }

    @ForceInline
    static Object getCallSiteTarget(Object site) {
        return ((CallSite)site).getTarget();
    }

    @ForceInline
    static void checkCustomized(Object o) {
        MethodHandle mh = (MethodHandle)o;
        if (mh.form.customized == null) {
            Invokers.maybeCustomize(mh);
        }
    }

    @DontInline
    static void maybeCustomize(MethodHandle mh) {
        byte count = mh.customizationCount;
        if (count >= MethodHandleStatics.CUSTOMIZE_THRESHOLD) {
            mh.customize();
        } else {
            mh.customizationCount = (byte)(count + 1);
        }
    }

    static {
        try {
            LambdaForm.NamedFunction[] nfs;
            NF_checkExactType = new LambdaForm.NamedFunction(Invokers.class.getDeclaredMethod("checkExactType", Object.class, Object.class));
            for (LambdaForm.NamedFunction nf : nfs = new LambdaForm.NamedFunction[]{NF_checkExactType, NF_checkGenericType = new LambdaForm.NamedFunction(Invokers.class.getDeclaredMethod("checkGenericType", Object.class, Object.class)), NF_getCallSiteTarget = new LambdaForm.NamedFunction(Invokers.class.getDeclaredMethod("getCallSiteTarget", Object.class)), NF_checkCustomized = new LambdaForm.NamedFunction(Invokers.class.getDeclaredMethod("checkCustomized", Object.class))}) {
                assert (InvokerBytecodeGenerator.isStaticallyInvocable(nf.member)) : nf;
                nf.resolve();
            }
        }
        catch (ReflectiveOperationException ex) {
            throw MethodHandleStatics.newInternalError(ex);
        }
    }

    private static class Lazy {
        private static final MethodHandle MH_asSpreader;

        private Lazy() {
        }

        static {
            try {
                MH_asSpreader = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(MethodHandle.class, "asSpreader", MethodType.methodType(MethodHandle.class, Class.class, Integer.TYPE));
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.newInternalError(ex);
            }
        }
    }
}

