/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.ConvertingMethod;
import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MBeanAnalyzer;
import com.sun.jmx.mbeanserver.MBeanIntrospector;
import com.sun.jmx.mbeanserver.MXBeanLookup;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.management.Descriptor;
import javax.management.ImmutableDescriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;

class MXBeanIntrospector
extends MBeanIntrospector<ConvertingMethod> {
    private static final MXBeanIntrospector instance = new MXBeanIntrospector();
    private final MBeanIntrospector.PerInterfaceMap<ConvertingMethod> perInterfaceMap = new MBeanIntrospector.PerInterfaceMap();
    private static final MBeanIntrospector.MBeanInfoMap mbeanInfoMap = new MBeanIntrospector.MBeanInfoMap();

    MXBeanIntrospector() {
    }

    static MXBeanIntrospector getInstance() {
        return instance;
    }

    @Override
    MBeanIntrospector.PerInterfaceMap<ConvertingMethod> getPerInterfaceMap() {
        return this.perInterfaceMap;
    }

    @Override
    MBeanIntrospector.MBeanInfoMap getMBeanInfoMap() {
        return mbeanInfoMap;
    }

    @Override
    MBeanAnalyzer<ConvertingMethod> getAnalyzer(Class<?> mbeanInterface) throws NotCompliantMBeanException {
        return MBeanAnalyzer.analyzer(mbeanInterface, this);
    }

    @Override
    boolean isMXBean() {
        return true;
    }

    @Override
    ConvertingMethod mFrom(Method m) {
        return ConvertingMethod.from(m);
    }

    @Override
    String getName(ConvertingMethod m) {
        return m.getName();
    }

    @Override
    Type getGenericReturnType(ConvertingMethod m) {
        return m.getGenericReturnType();
    }

    @Override
    Type[] getGenericParameterTypes(ConvertingMethod m) {
        return m.getGenericParameterTypes();
    }

    @Override
    String[] getSignature(ConvertingMethod m) {
        return m.getOpenSignature();
    }

    @Override
    void checkMethod(ConvertingMethod m) {
        m.checkCallFromOpen();
    }

    @Override
    Object invokeM2(ConvertingMethod m, Object target, Object[] args, Object cookie) throws InvocationTargetException, IllegalAccessException, MBeanException {
        return m.invokeWithOpenReturn((MXBeanLookup)cookie, target, args);
    }

    @Override
    boolean validParameter(ConvertingMethod m, Object value, int paramNo, Object cookie) {
        Object v;
        if (value == null) {
            Type t = m.getGenericParameterTypes()[paramNo];
            return !(t instanceof Class) || !((Class)t).isPrimitive();
        }
        try {
            v = m.fromOpenParameter((MXBeanLookup)cookie, value, paramNo);
        }
        catch (Exception e) {
            return true;
        }
        return MXBeanIntrospector.isValidParameter(m.getMethod(), v, paramNo);
    }

    @Override
    MBeanAttributeInfo getMBeanAttributeInfo(String attributeName, ConvertingMethod getter, ConvertingMethod setter) {
        Type originalType;
        OpenType<?> openType;
        boolean isReadable = getter != null;
        boolean isWritable = setter != null;
        boolean isIs = isReadable && this.getName(getter).startsWith("is");
        String description = attributeName;
        if (isReadable) {
            openType = getter.getOpenReturnType();
            originalType = getter.getGenericReturnType();
        } else {
            openType = setter.getOpenParameterTypes()[0];
            originalType = setter.getGenericParameterTypes()[0];
        }
        Descriptor descriptor = MXBeanIntrospector.typeDescriptor(openType, originalType);
        if (isReadable) {
            descriptor = ImmutableDescriptor.union(descriptor, getter.getDescriptor());
        }
        if (isWritable) {
            descriptor = ImmutableDescriptor.union(descriptor, setter.getDescriptor());
        }
        MBeanAttributeInfo ai = MXBeanIntrospector.canUseOpenInfo(originalType) ? new OpenMBeanAttributeInfoSupport(attributeName, description, openType, isReadable, isWritable, isIs, descriptor) : new MBeanAttributeInfo(attributeName, MXBeanIntrospector.originalTypeString(originalType), description, isReadable, isWritable, isIs, descriptor);
        return ai;
    }

    @Override
    MBeanOperationInfo getMBeanOperationInfo(String operationName, ConvertingMethod operation) {
        MBeanOperationInfo oi;
        Method method = operation.getMethod();
        String description = operationName;
        int impact = 3;
        OpenType<?> returnType = operation.getOpenReturnType();
        Type originalReturnType = operation.getGenericReturnType();
        OpenType<?>[] paramTypes = operation.getOpenParameterTypes();
        Type[] originalParamTypes = operation.getGenericParameterTypes();
        MBeanParameterInfo[] params = new MBeanParameterInfo[paramTypes.length];
        boolean openReturnType = MXBeanIntrospector.canUseOpenInfo(originalReturnType);
        boolean openParameterTypes = true;
        Annotation[][] annots = method.getParameterAnnotations();
        for (int i = 0; i < paramTypes.length; ++i) {
            MBeanParameterInfo pi;
            String paramName;
            String paramDescription = paramName = "p" + i;
            OpenType<?> openType = paramTypes[i];
            Type originalType = originalParamTypes[i];
            Descriptor descriptor = MXBeanIntrospector.typeDescriptor(openType, originalType);
            descriptor = ImmutableDescriptor.union(descriptor, Introspector.descriptorForAnnotations(annots[i]));
            if (MXBeanIntrospector.canUseOpenInfo(originalType)) {
                pi = new OpenMBeanParameterInfoSupport(paramName, paramDescription, openType, descriptor);
            } else {
                openParameterTypes = false;
                pi = new MBeanParameterInfo(paramName, MXBeanIntrospector.originalTypeString(originalType), paramDescription, descriptor);
            }
            params[i] = pi;
        }
        Descriptor descriptor = MXBeanIntrospector.typeDescriptor(returnType, originalReturnType);
        descriptor = ImmutableDescriptor.union(descriptor, Introspector.descriptorForElement(method));
        if (openReturnType && openParameterTypes) {
            OpenMBeanParameterInfo[] oparams = new OpenMBeanParameterInfo[params.length];
            System.arraycopy(params, 0, oparams, 0, params.length);
            oi = new OpenMBeanOperationInfoSupport(operationName, description, oparams, returnType, 3, descriptor);
        } else {
            oi = new MBeanOperationInfo(operationName, description, params, openReturnType ? returnType.getClassName() : MXBeanIntrospector.originalTypeString(originalReturnType), 3, descriptor);
        }
        return oi;
    }

    @Override
    Descriptor getBasicMBeanDescriptor() {
        return new ImmutableDescriptor("mxbean=true", "immutableInfo=true");
    }

    @Override
    Descriptor getMBeanDescriptor(Class<?> resourceClass) {
        return ImmutableDescriptor.EMPTY_DESCRIPTOR;
    }

    private static Descriptor typeDescriptor(OpenType<?> openType, Type originalType) {
        return new ImmutableDescriptor(new String[]{"openType", "originalType"}, new Object[]{openType, MXBeanIntrospector.originalTypeString(originalType)});
    }

    private static boolean canUseOpenInfo(Type type) {
        if (type instanceof GenericArrayType) {
            return MXBeanIntrospector.canUseOpenInfo(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof Class && ((Class)type).isArray()) {
            return MXBeanIntrospector.canUseOpenInfo(((Class)type).getComponentType());
        }
        return !(type instanceof Class) || !((Class)type).isPrimitive();
    }

    private static String originalTypeString(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        return MXBeanIntrospector.typeName(type);
    }

    static String typeName(Type type) {
        if (type instanceof Class) {
            Class c = (Class)type;
            if (c.isArray()) {
                return MXBeanIntrospector.typeName(c.getComponentType()) + "[]";
            }
            return c.getName();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            return MXBeanIntrospector.typeName(gat.getGenericComponentType()) + "[]";
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            StringBuilder sb = new StringBuilder();
            sb.append(MXBeanIntrospector.typeName(pt.getRawType())).append("<");
            String sep = "";
            for (Type t : pt.getActualTypeArguments()) {
                sb.append(sep).append(MXBeanIntrospector.typeName(t));
                sep = ", ";
            }
            return sb.append(">").toString();
        }
        return "???";
    }
}

