/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.plugins.jpeg;

import java.util.Locale;
import javax.imageio.ImageWriteParam;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGQTable;

public class JPEGImageWriteParam
extends ImageWriteParam {
    private JPEGQTable[] qTables = null;
    private JPEGHuffmanTable[] DCHuffmanTables = null;
    private JPEGHuffmanTable[] ACHuffmanTables = null;
    private boolean optimizeHuffman = false;
    private String[] compressionNames = new String[]{"JPEG"};
    private float[] qualityVals = new float[]{0.0f, 0.3f, 0.75f, 1.0f};
    private String[] qualityDescs = new String[]{"Low quality", "Medium quality", "Visually lossless"};

    public JPEGImageWriteParam(Locale locale) {
        super(locale);
        this.canWriteProgressive = true;
        this.progressiveMode = 0;
        this.canWriteCompressed = true;
        this.compressionTypes = this.compressionNames;
        this.compressionType = this.compressionTypes[0];
        this.compressionQuality = 0.75f;
    }

    @Override
    public void unsetCompression() {
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException("Compression mode not MODE_EXPLICIT!");
        }
        this.compressionQuality = 0.75f;
    }

    @Override
    public boolean isCompressionLossless() {
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException("Compression mode not MODE_EXPLICIT!");
        }
        return false;
    }

    @Override
    public String[] getCompressionQualityDescriptions() {
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException("Compression mode not MODE_EXPLICIT!");
        }
        if (this.getCompressionTypes() != null && this.getCompressionType() == null) {
            throw new IllegalStateException("No compression type set!");
        }
        return (String[])this.qualityDescs.clone();
    }

    @Override
    public float[] getCompressionQualityValues() {
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException("Compression mode not MODE_EXPLICIT!");
        }
        if (this.getCompressionTypes() != null && this.getCompressionType() == null) {
            throw new IllegalStateException("No compression type set!");
        }
        return (float[])this.qualityVals.clone();
    }

    public boolean areTablesSet() {
        return this.qTables != null;
    }

    public void setEncodeTables(JPEGQTable[] qTables, JPEGHuffmanTable[] DCHuffmanTables, JPEGHuffmanTable[] ACHuffmanTables) {
        if (qTables == null || DCHuffmanTables == null || ACHuffmanTables == null || qTables.length > 4 || DCHuffmanTables.length > 4 || ACHuffmanTables.length > 4 || DCHuffmanTables.length != ACHuffmanTables.length) {
            throw new IllegalArgumentException("Invalid JPEG table arrays");
        }
        this.qTables = (JPEGQTable[])qTables.clone();
        this.DCHuffmanTables = (JPEGHuffmanTable[])DCHuffmanTables.clone();
        this.ACHuffmanTables = (JPEGHuffmanTable[])ACHuffmanTables.clone();
    }

    public void unsetEncodeTables() {
        this.qTables = null;
        this.DCHuffmanTables = null;
        this.ACHuffmanTables = null;
    }

    public JPEGQTable[] getQTables() {
        return this.qTables != null ? (JPEGQTable[])this.qTables.clone() : null;
    }

    public JPEGHuffmanTable[] getDCHuffmanTables() {
        return this.DCHuffmanTables != null ? (JPEGHuffmanTable[])this.DCHuffmanTables.clone() : null;
    }

    public JPEGHuffmanTable[] getACHuffmanTables() {
        return this.ACHuffmanTables != null ? (JPEGHuffmanTable[])this.ACHuffmanTables.clone() : null;
    }

    public void setOptimizeHuffmanTables(boolean optimize) {
        this.optimizeHuffman = optimize;
    }

    public boolean getOptimizeHuffmanTables() {
        return this.optimizeHuffman;
    }
}

