/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MidiFileFormat {
    public static final int UNKNOWN_LENGTH = -1;
    protected int type;
    protected float divisionType;
    protected int resolution;
    protected int byteLength;
    protected long microsecondLength;
    private HashMap<String, Object> properties;

    public MidiFileFormat(int type, float divisionType, int resolution, int bytes, long microseconds) {
        this.type = type;
        this.divisionType = divisionType;
        this.resolution = resolution;
        this.byteLength = bytes;
        this.microsecondLength = microseconds;
        this.properties = null;
    }

    public MidiFileFormat(int type, float divisionType, int resolution, int bytes, long microseconds, Map<String, Object> properties) {
        this(type, divisionType, resolution, bytes, microseconds);
        this.properties = new HashMap<String, Object>(properties);
    }

    public int getType() {
        return this.type;
    }

    public float getDivisionType() {
        return this.divisionType;
    }

    public int getResolution() {
        return this.resolution;
    }

    public int getByteLength() {
        return this.byteLength;
    }

    public long getMicrosecondLength() {
        return this.microsecondLength;
    }

    public Map<String, Object> properties() {
        Map ret = this.properties == null ? new HashMap(0) : (Map)this.properties.clone();
        return Collections.unmodifiableMap(ret);
    }

    public Object getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }
}

