/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Executable;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Type;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;
import sun.reflect.ConstantPool;
import sun.reflect.annotation.AnnotatedTypeFactory;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.TypeAnnotation;

public final class TypeAnnotationParser {
    private static final TypeAnnotation[] EMPTY_TYPE_ANNOTATION_ARRAY = new TypeAnnotation[0];
    private static final byte CLASS_TYPE_PARAMETER = 0;
    private static final byte METHOD_TYPE_PARAMETER = 1;
    private static final byte CLASS_EXTENDS = 16;
    private static final byte CLASS_TYPE_PARAMETER_BOUND = 17;
    private static final byte METHOD_TYPE_PARAMETER_BOUND = 18;
    private static final byte FIELD = 19;
    private static final byte METHOD_RETURN = 20;
    private static final byte METHOD_RECEIVER = 21;
    private static final byte METHOD_FORMAL_PARAMETER = 22;
    private static final byte THROWS = 23;
    private static final byte LOCAL_VARIABLE = 64;
    private static final byte RESOURCE_VARIABLE = 65;
    private static final byte EXCEPTION_PARAMETER = 66;
    private static final byte INSTANCEOF = 67;
    private static final byte NEW = 68;
    private static final byte CONSTRUCTOR_REFERENCE = 69;
    private static final byte METHOD_REFERENCE = 70;
    private static final byte CAST = 71;
    private static final byte CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT = 72;
    private static final byte METHOD_INVOCATION_TYPE_ARGUMENT = 73;
    private static final byte CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT = 74;
    private static final byte METHOD_REFERENCE_TYPE_ARGUMENT = 75;

    public static AnnotatedType buildAnnotatedType(byte[] rawAnnotations, ConstantPool cp, AnnotatedElement decl, Class<?> container, Type type, TypeAnnotation.TypeAnnotationTarget filter) {
        TypeAnnotation[] tas = TypeAnnotationParser.parseTypeAnnotations(rawAnnotations, cp, decl, container);
        ArrayList<TypeAnnotation> l = new ArrayList<TypeAnnotation>(tas.length);
        for (TypeAnnotation t : tas) {
            TypeAnnotation.TypeAnnotationTargetInfo ti = t.getTargetInfo();
            if (ti.getTarget() != filter) continue;
            l.add(t);
        }
        TypeAnnotation[] typeAnnotations = l.toArray(EMPTY_TYPE_ANNOTATION_ARRAY);
        return AnnotatedTypeFactory.buildAnnotatedType(type, TypeAnnotation.LocationInfo.BASE_LOCATION, typeAnnotations, typeAnnotations, decl);
    }

    public static AnnotatedType[] buildAnnotatedTypes(byte[] rawAnnotations, ConstantPool cp, AnnotatedElement decl, Class<?> container, Type[] types, TypeAnnotation.TypeAnnotationTarget filter) {
        TypeAnnotation[] tas;
        int size = types.length;
        Object[] result = new AnnotatedType[size];
        Arrays.fill(result, AnnotatedTypeFactory.EMPTY_ANNOTATED_TYPE);
        ArrayList[] l = new ArrayList[size];
        for (TypeAnnotation t : tas = TypeAnnotationParser.parseTypeAnnotations(rawAnnotations, cp, decl, container)) {
            ArrayList<TypeAnnotation> tmp;
            TypeAnnotation.TypeAnnotationTargetInfo ti = t.getTargetInfo();
            if (ti.getTarget() != filter) continue;
            int pos = ti.getCount();
            if (l[pos] == null) {
                l[pos] = tmp = new ArrayList<TypeAnnotation>(tas.length);
            }
            tmp = l[pos];
            tmp.add(t);
        }
        for (int i = 0; i < size; ++i) {
            ArrayList list = l[i];
            TypeAnnotation[] typeAnnotations = list != null ? list.toArray(new TypeAnnotation[list.size()]) : EMPTY_TYPE_ANNOTATION_ARRAY;
            result[i] = AnnotatedTypeFactory.buildAnnotatedType(types[i], TypeAnnotation.LocationInfo.BASE_LOCATION, typeAnnotations, typeAnnotations, decl);
        }
        return result;
    }

    public static AnnotatedType buildAnnotatedSuperclass(byte[] rawAnnotations, ConstantPool cp, Class<?> decl) {
        Type supertype = decl.getGenericSuperclass();
        if (supertype == null) {
            return AnnotatedTypeFactory.EMPTY_ANNOTATED_TYPE;
        }
        return TypeAnnotationParser.buildAnnotatedType(rawAnnotations, cp, decl, decl, supertype, TypeAnnotation.TypeAnnotationTarget.CLASS_EXTENDS);
    }

    public static AnnotatedType[] buildAnnotatedInterfaces(byte[] rawAnnotations, ConstantPool cp, Class<?> decl) {
        if (decl == Object.class || decl.isArray() || decl.isPrimitive() || decl == Void.TYPE) {
            return AnnotatedTypeFactory.EMPTY_ANNOTATED_TYPE_ARRAY;
        }
        return TypeAnnotationParser.buildAnnotatedTypes(rawAnnotations, cp, decl, decl, decl.getGenericInterfaces(), TypeAnnotation.TypeAnnotationTarget.CLASS_IMPLEMENTS);
    }

    public static <D extends GenericDeclaration> Annotation[] parseTypeVariableAnnotations(D genericDecl, int typeVarIndex) {
        TypeAnnotation.TypeAnnotationTarget predicate;
        GenericDeclaration decl;
        if (genericDecl instanceof Class) {
            decl = (Class)genericDecl;
            predicate = TypeAnnotation.TypeAnnotationTarget.CLASS_TYPE_PARAMETER;
        } else if (genericDecl instanceof Executable) {
            decl = (Executable)genericDecl;
            predicate = TypeAnnotation.TypeAnnotationTarget.METHOD_TYPE_PARAMETER;
        } else {
            throw new AssertionError((Object)("Unknown GenericDeclaration " + genericDecl + "\nthis should not happen."));
        }
        List<TypeAnnotation> typeVarAnnos = TypeAnnotation.filter(TypeAnnotationParser.parseAllTypeAnnotations(decl), predicate);
        ArrayList<Annotation> res = new ArrayList<Annotation>(typeVarAnnos.size());
        for (TypeAnnotation t : typeVarAnnos) {
            if (t.getTargetInfo().getCount() != typeVarIndex) continue;
            res.add(t.getAnnotation());
        }
        return res.toArray(new Annotation[0]);
    }

    public static <D extends GenericDeclaration> AnnotatedType[] parseAnnotatedBounds(Type[] bounds, D decl, int typeVarIndex) {
        return TypeAnnotationParser.parseAnnotatedBounds(bounds, decl, typeVarIndex, TypeAnnotation.LocationInfo.BASE_LOCATION);
    }

    private static <D extends GenericDeclaration> AnnotatedType[] parseAnnotatedBounds(Type[] bounds, D decl, int typeVarIndex, TypeAnnotation.LocationInfo loc) {
        List<TypeAnnotation> candidates = TypeAnnotationParser.fetchBounds(decl);
        if (bounds != null) {
            int startIndex = 0;
            AnnotatedType[] res = new AnnotatedType[bounds.length];
            if (bounds.length > 0) {
                Type b0 = bounds[0];
                if (!(b0 instanceof Class)) {
                    startIndex = 1;
                } else {
                    Class c = (Class)b0;
                    if (c.isInterface()) {
                        startIndex = 1;
                    }
                }
            }
            for (int i = 0; i < bounds.length; ++i) {
                ArrayList<TypeAnnotation> l = new ArrayList<TypeAnnotation>(candidates.size());
                for (TypeAnnotation t : candidates) {
                    TypeAnnotation.TypeAnnotationTargetInfo tInfo = t.getTargetInfo();
                    if (tInfo.getSecondaryIndex() != i + startIndex || tInfo.getCount() != typeVarIndex) continue;
                    l.add(t);
                }
                res[i] = AnnotatedTypeFactory.buildAnnotatedType(bounds[i], loc, l.toArray(EMPTY_TYPE_ANNOTATION_ARRAY), candidates.toArray(EMPTY_TYPE_ANNOTATION_ARRAY), decl);
            }
            return res;
        }
        return new AnnotatedType[0];
    }

    private static <D extends GenericDeclaration> List<TypeAnnotation> fetchBounds(D decl) {
        GenericDeclaration boundsDecl;
        TypeAnnotation.TypeAnnotationTarget target;
        if (decl instanceof Class) {
            target = TypeAnnotation.TypeAnnotationTarget.CLASS_TYPE_PARAMETER_BOUND;
            boundsDecl = (Class)decl;
        } else {
            target = TypeAnnotation.TypeAnnotationTarget.METHOD_TYPE_PARAMETER_BOUND;
            boundsDecl = (Executable)decl;
        }
        return TypeAnnotation.filter(TypeAnnotationParser.parseAllTypeAnnotations(boundsDecl), target);
    }

    static TypeAnnotation[] parseAllTypeAnnotations(AnnotatedElement decl) {
        byte[] rawBytes;
        Class<?> container;
        JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();
        if (decl instanceof Class) {
            container = (Class<?>)decl;
            rawBytes = javaLangAccess.getRawClassTypeAnnotations(container);
        } else if (decl instanceof Executable) {
            container = ((Executable)decl).getDeclaringClass();
            rawBytes = javaLangAccess.getRawExecutableTypeAnnotations((Executable)decl);
        } else {
            return EMPTY_TYPE_ANNOTATION_ARRAY;
        }
        return TypeAnnotationParser.parseTypeAnnotations(rawBytes, javaLangAccess.getConstantPool(container), decl, container);
    }

    private static TypeAnnotation[] parseTypeAnnotations(byte[] rawAnnotations, ConstantPool cp, AnnotatedElement baseDecl, Class<?> container) {
        if (rawAnnotations == null) {
            return EMPTY_TYPE_ANNOTATION_ARRAY;
        }
        ByteBuffer buf = ByteBuffer.wrap(rawAnnotations);
        int annotationCount = buf.getShort() & 0xFFFF;
        ArrayList<TypeAnnotation> typeAnnotations = new ArrayList<TypeAnnotation>(annotationCount);
        for (int i = 0; i < annotationCount; ++i) {
            TypeAnnotation ta = TypeAnnotationParser.parseTypeAnnotation(buf, cp, baseDecl, container);
            if (ta == null) continue;
            typeAnnotations.add(ta);
        }
        return typeAnnotations.toArray(EMPTY_TYPE_ANNOTATION_ARRAY);
    }

    static Map<Class<? extends Annotation>, Annotation> mapTypeAnnotations(TypeAnnotation[] typeAnnos) {
        LinkedHashMap<Class<? extends Annotation>, Annotation> result = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
        for (TypeAnnotation t : typeAnnos) {
            Annotation a = t.getAnnotation();
            Class<? extends Annotation> klass = a.annotationType();
            AnnotationType type = AnnotationType.getInstance(klass);
            if (type.retention() != RetentionPolicy.RUNTIME || result.put(klass, a) == null) continue;
            throw new AnnotationFormatError("Duplicate annotation for class: " + klass + ": " + a);
        }
        return result;
    }

    private static TypeAnnotation parseTypeAnnotation(ByteBuffer buf, ConstantPool cp, AnnotatedElement baseDecl, Class<?> container) {
        try {
            TypeAnnotation.TypeAnnotationTargetInfo ti = TypeAnnotationParser.parseTargetInfo(buf);
            TypeAnnotation.LocationInfo locationInfo = TypeAnnotation.LocationInfo.parseLocationInfo(buf);
            Annotation a = AnnotationParser.parseAnnotation(buf, cp, container, false);
            if (ti == null) {
                return null;
            }
            return new TypeAnnotation(ti, locationInfo, a, baseDecl);
        }
        catch (IllegalArgumentException | BufferUnderflowException e) {
            throw new AnnotationFormatError(e);
        }
    }

    private static TypeAnnotation.TypeAnnotationTargetInfo parseTargetInfo(ByteBuffer buf) {
        int posCode = buf.get() & 0xFF;
        switch (posCode) {
            case 0: 
            case 1: {
                int index = buf.get() & 0xFF;
                TypeAnnotation.TypeAnnotationTargetInfo res = posCode == 0 ? new TypeAnnotation.TypeAnnotationTargetInfo(TypeAnnotation.TypeAnnotationTarget.CLASS_TYPE_PARAMETER, index) : new TypeAnnotation.TypeAnnotationTargetInfo(TypeAnnotation.TypeAnnotationTarget.METHOD_TYPE_PARAMETER, index);
                return res;
            }
            case 16: {
                short index = buf.getShort();
                if (index == -1) {
                    return new TypeAnnotation.TypeAnnotationTargetInfo(TypeAnnotation.TypeAnnotationTarget.CLASS_EXTENDS);
                }
                if (index < 0) break;
                TypeAnnotation.TypeAnnotationTargetInfo res = new TypeAnnotation.TypeAnnotationTargetInfo(TypeAnnotation.TypeAnnotationTarget.CLASS_IMPLEMENTS, index);
                return res;
            }
            case 17: {
                return TypeAnnotationParser.parse2ByteTarget(TypeAnnotation.TypeAnnotationTarget.CLASS_TYPE_PARAMETER_BOUND, buf);
            }
            case 18: {
                return TypeAnnotationParser.parse2ByteTarget(TypeAnnotation.TypeAnnotationTarget.METHOD_TYPE_PARAMETER_BOUND, buf);
            }
            case 19: {
                return new TypeAnnotation.TypeAnnotationTargetInfo(TypeAnnotation.TypeAnnotationTarget.FIELD);
            }
            case 20: {
                return new TypeAnnotation.TypeAnnotationTargetInfo(TypeAnnotation.TypeAnnotationTarget.METHOD_RETURN);
            }
            case 21: {
                return new TypeAnnotation.TypeAnnotationTargetInfo(TypeAnnotation.TypeAnnotationTarget.METHOD_RECEIVER);
            }
            case 22: {
                int index = buf.get() & 0xFF;
                return new TypeAnnotation.TypeAnnotationTargetInfo(TypeAnnotation.TypeAnnotationTarget.METHOD_FORMAL_PARAMETER, index);
            }
            case 23: {
                return TypeAnnotationParser.parseShortTarget(TypeAnnotation.TypeAnnotationTarget.THROWS, buf);
            }
            case 64: 
            case 65: {
                int length = buf.getShort();
                for (int i = 0; i < length; ++i) {
                    short offset = buf.getShort();
                    short varLength = buf.getShort();
                    short s = buf.getShort();
                }
                return null;
            }
            case 66: {
                byte i = buf.get();
                return null;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                short i = buf.getShort();
                return null;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                short offset = buf.getShort();
                byte by = buf.get();
                return null;
            }
        }
        throw new AnnotationFormatError("Could not parse bytes for type annotations");
    }

    private static TypeAnnotation.TypeAnnotationTargetInfo parseShortTarget(TypeAnnotation.TypeAnnotationTarget target, ByteBuffer buf) {
        int index = buf.getShort() & 0xFFFF;
        return new TypeAnnotation.TypeAnnotationTargetInfo(target, index);
    }

    private static TypeAnnotation.TypeAnnotationTargetInfo parse2ByteTarget(TypeAnnotation.TypeAnnotationTarget target, ByteBuffer buf) {
        int count = buf.get() & 0xFF;
        int secondaryIndex = buf.get() & 0xFF;
        return new TypeAnnotation.TypeAnnotationTargetInfo(target, count, secondaryIndex);
    }
}

