/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.io.FileDescriptor;
import java.net.SocketException;
import java.net.SocketOption;
import java.security.AccessController;
import jdk.net.NetworkPermission;
import jdk.net.SocketFlow;

public class ExtendedOptionsImpl {
    private ExtendedOptionsImpl() {
    }

    public static void checkSetOptionPermission(SocketOption<?> option) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        String check = "setOption." + option.name();
        sm.checkPermission(new NetworkPermission(check));
    }

    public static void checkGetOptionPermission(SocketOption<?> option) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        String check = "getOption." + option.name();
        sm.checkPermission(new NetworkPermission(check));
    }

    public static void checkValueType(Object value, Class<?> type) {
        if (!type.isAssignableFrom(value.getClass())) {
            String s = "Found: " + value.getClass().toString() + " Expected: " + type.toString();
            throw new IllegalArgumentException(s);
        }
    }

    private static native void init();

    public static native void setFlowOption(FileDescriptor var0, SocketFlow var1);

    public static native void getFlowOption(FileDescriptor var0, SocketFlow var1);

    public static native boolean flowSupported();

    public static native void setTcpKeepAliveProbes(FileDescriptor var0, int var1) throws SocketException;

    public static native void setTcpKeepAliveTime(FileDescriptor var0, int var1) throws SocketException;

    public static native void setTcpKeepAliveIntvl(FileDescriptor var0, int var1) throws SocketException;

    public static native int getTcpKeepAliveProbes(FileDescriptor var0) throws SocketException;

    public static native int getTcpKeepAliveTime(FileDescriptor var0) throws SocketException;

    public static native int getTcpKeepAliveIntvl(FileDescriptor var0) throws SocketException;

    public static native boolean keepAliveOptionsSupported();

    static {
        AccessController.doPrivileged(() -> {
            System.loadLibrary("net");
            return null;
        });
        ExtendedOptionsImpl.init();
    }
}

