/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.internal.ccache.CCacheOutputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class AuthorizationDataEntry
implements Cloneable {
    public int adType;
    public byte[] adData;

    private AuthorizationDataEntry() {
    }

    public AuthorizationDataEntry(int new_adType, byte[] new_adData) {
        this.adType = new_adType;
        this.adData = new_adData;
    }

    public Object clone() {
        AuthorizationDataEntry new_authorizationDataEntry = new AuthorizationDataEntry();
        new_authorizationDataEntry.adType = this.adType;
        if (this.adData != null) {
            new_authorizationDataEntry.adData = new byte[this.adData.length];
            System.arraycopy(this.adData, 0, new_authorizationDataEntry.adData, 0, this.adData.length);
        }
        return new_authorizationDataEntry;
    }

    public AuthorizationDataEntry(DerValue encoding) throws Asn1Exception, IOException {
        if (encoding.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.adType = der.getData().getBigInteger().intValue();
        der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.adData = der.getData().getOctetString();
        if (encoding.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        temp.putInteger(this.adType);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        temp = new DerOutputStream();
        temp.putOctetString(this.adData);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        return temp.toByteArray();
    }

    public void writeEntry(CCacheOutputStream cos) throws IOException {
        cos.write16(this.adType);
        cos.write32(this.adData.length);
        cos.write(this.adData, 0, this.adData.length);
    }

    public String toString() {
        return "adType=" + this.adType + " adData.length=" + this.adData.length;
    }
}

