/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.Color;
import java.util.ArrayList;
import sun.java2d.xr.DirtyRegion;
import sun.java2d.xr.GrowableRectArray;
import sun.java2d.xr.MaskTile;
import sun.java2d.xr.XRBackend;
import sun.java2d.xr.XRColor;
import sun.java2d.xr.XRCompositeManager;
import sun.java2d.xr.XRSurfaceData;
import sun.java2d.xr.XRUtils;

public class MaskTileManager {
    public static final int MASK_SIZE = 256;
    MaskTile mainTile = new MaskTile();
    ArrayList<MaskTile> tileList = new ArrayList();
    int allocatedTiles = 0;
    int xTiles;
    int yTiles;
    XRCompositeManager xrMgr;
    XRBackend con;
    int maskPixmap;
    int maskPicture;
    long maskGC;

    public MaskTileManager(XRCompositeManager xrMgr, int parentXid) {
        this.xrMgr = xrMgr;
        this.con = xrMgr.getBackend();
        this.maskPixmap = this.con.createPixmap(parentXid, 8, 256, 256);
        this.maskPicture = this.con.createPicture(this.maskPixmap, 2);
        this.con.renderRectangle(this.maskPicture, (byte)0, new XRColor(Color.black), 0, 0, 256, 256);
        this.maskGC = this.con.createGC(this.maskPixmap);
        this.con.setGCExposures(this.maskGC, false);
    }

    public void fillMask(XRSurfaceData dst) {
        boolean maskRequired = this.xrMgr.maskRequired();
        boolean maskEvaluated = XRUtils.isMaskEvaluated(this.xrMgr.compRule);
        if (maskRequired && maskEvaluated) {
            this.mainTile.calculateDirtyAreas();
            DirtyRegion dirtyArea = this.mainTile.getDirtyArea().cloneRegion();
            this.mainTile.translate(-dirtyArea.x, -dirtyArea.y);
            XRColor maskColor = this.xrMgr.getMaskColor();
            if (dirtyArea.getWidth() <= 256 && dirtyArea.getHeight() <= 256) {
                this.compositeSingleTile(dst, this.mainTile, dirtyArea, maskRequired, 0, 0, maskColor);
            } else {
                this.allocTiles(dirtyArea);
                this.tileRects();
                for (int i = 0; i < this.yTiles; ++i) {
                    for (int m = 0; m < this.xTiles; ++m) {
                        MaskTile tile = this.tileList.get(i * this.xTiles + m);
                        int tileStartX = m * 256;
                        int tileStartY = i * 256;
                        this.compositeSingleTile(dst, tile, dirtyArea, maskRequired, tileStartX, tileStartY, maskColor);
                    }
                }
            }
        } else if (this.xrMgr.isSolidPaintActive()) {
            this.xrMgr.XRRenderRectangles(dst, this.mainTile.getRects());
        } else {
            this.xrMgr.XRCompositeRectangles(dst, this.mainTile.getRects());
        }
        this.mainTile.reset();
    }

    public int uploadMask(int w, int h, int maskscan, int maskoff, byte[] mask) {
        int maskPic = 0;
        if (mask != null) {
            float maskAlpha = this.xrMgr.isTexturePaintActive() ? this.xrMgr.getExtraAlpha() : 1.0f;
            this.con.putMaskImage(this.maskPixmap, this.maskGC, mask, 0, 0, 0, 0, w, h, maskoff, maskscan, maskAlpha);
            maskPic = this.maskPicture;
        } else if (this.xrMgr.isTexturePaintActive()) {
            maskPic = this.xrMgr.getExtraAlphaMask();
        }
        return maskPic;
    }

    public void clearUploadMask(int mask, int w, int h) {
        if (mask == this.maskPicture) {
            this.con.renderRectangle(this.maskPicture, (byte)0, XRColor.NO_ALPHA, 0, 0, w, h);
        }
    }

    protected void compositeSingleTile(XRSurfaceData dst, MaskTile tile, DirtyRegion dirtyArea, boolean maskRequired, int tileStartX, int tileStartY, XRColor maskColor) {
        if (tile.rects.getSize() > 0) {
            DirtyRegion tileDirtyArea = tile.getDirtyArea();
            int x = tileDirtyArea.x + tileStartX + dirtyArea.x;
            int y = tileDirtyArea.y + tileStartY + dirtyArea.y;
            int width = tileDirtyArea.x2 - tileDirtyArea.x;
            int height = tileDirtyArea.y2 - tileDirtyArea.y;
            width = Math.min(width, 256);
            height = Math.min(height, 256);
            int rectCnt = tile.rects.getSize();
            if (maskRequired) {
                int mask = 0;
                if (rectCnt > 1) {
                    this.con.renderRectangles(this.maskPicture, (byte)1, maskColor, tile.rects);
                    mask = this.maskPicture;
                } else if (this.xrMgr.isTexturePaintActive()) {
                    mask = this.xrMgr.getExtraAlphaMask();
                }
                this.xrMgr.XRComposite(0, mask, dst.getPicture(), x, y, tileDirtyArea.x, tileDirtyArea.y, x, y, width, height);
                if (rectCnt > 1) {
                    this.con.renderRectangle(this.maskPicture, (byte)0, XRColor.NO_ALPHA, tileDirtyArea.x, tileDirtyArea.y, width, height);
                }
                tile.reset();
            } else if (rectCnt > 0) {
                tile.rects.translateRects(tileStartX + dirtyArea.x, tileStartY + dirtyArea.y);
                this.xrMgr.XRRenderRectangles(dst, tile.rects);
            }
        }
    }

    protected void allocTiles(DirtyRegion maskArea) {
        this.xTiles = maskArea.getWidth() / 256 + 1;
        this.yTiles = maskArea.getHeight() / 256 + 1;
        int tileCnt = this.xTiles * this.yTiles;
        if (tileCnt > this.allocatedTiles) {
            for (int i = 0; i < tileCnt; ++i) {
                if (i < this.allocatedTiles) {
                    this.tileList.get(i).reset();
                    continue;
                }
                this.tileList.add(new MaskTile());
            }
            this.allocatedTiles = tileCnt;
        }
    }

    protected void tileRects() {
        GrowableRectArray rects = this.mainTile.rects;
        for (int i = 0; i < rects.getSize(); ++i) {
            int tileXStartIndex = rects.getX(i) / 256;
            int tileYStartIndex = rects.getY(i) / 256;
            int tileXLength = (rects.getX(i) + rects.getWidth(i)) / 256 + 1 - tileXStartIndex;
            int tileYLength = (rects.getY(i) + rects.getHeight(i)) / 256 + 1 - tileYStartIndex;
            for (int n = 0; n < tileYLength; ++n) {
                for (int m = 0; m < tileXLength; ++m) {
                    int tileIndex = this.xTiles * (tileYStartIndex + n) + tileXStartIndex + m;
                    MaskTile tile = this.tileList.get(tileIndex);
                    GrowableRectArray rectTileList = tile.getRects();
                    int tileArrayIndex = rectTileList.getNextIndex();
                    int tileStartPosX = (tileXStartIndex + m) * 256;
                    int tileStartPosY = (tileYStartIndex + n) * 256;
                    rectTileList.setX(tileArrayIndex, rects.getX(i) - tileStartPosX);
                    rectTileList.setY(tileArrayIndex, rects.getY(i) - tileStartPosY);
                    rectTileList.setWidth(tileArrayIndex, rects.getWidth(i));
                    rectTileList.setHeight(tileArrayIndex, rects.getHeight(i));
                    this.limitRectCoords(rectTileList, tileArrayIndex);
                    tile.getDirtyArea().growDirtyRegion(rectTileList.getX(tileArrayIndex), rectTileList.getY(tileArrayIndex), rectTileList.getWidth(tileArrayIndex) + rectTileList.getX(tileArrayIndex), rectTileList.getHeight(tileArrayIndex) + rectTileList.getY(tileArrayIndex));
                }
            }
        }
    }

    private void limitRectCoords(GrowableRectArray rects, int index) {
        if (rects.getX(index) + rects.getWidth(index) > 256) {
            rects.setWidth(index, 256 - rects.getX(index));
        }
        if (rects.getY(index) + rects.getHeight(index) > 256) {
            rects.setHeight(index, 256 - rects.getY(index));
        }
        if (rects.getX(index) < 0) {
            rects.setWidth(index, rects.getWidth(index) + rects.getX(index));
            rects.setX(index, 0);
        }
        if (rects.getY(index) < 0) {
            rects.setHeight(index, rects.getHeight(index) + rects.getY(index));
            rects.setY(index, 0);
        }
    }

    public MaskTile getMainTile() {
        return this.mainTile;
    }
}

