/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.IOException;
import java.io.ObjectOutput;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.LogStream;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import sun.rmi.runtime.Log;
import sun.rmi.server.Dispatcher;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.ObjectEndpoint;
import sun.rmi.transport.ObjectTable;
import sun.rmi.transport.Target;
import sun.security.action.GetPropertyAction;

public abstract class Transport {
    static final int logLevel = LogStream.parseLevel(Transport.getLogLevel());
    static final Log transportLog = Log.getLog("sun.rmi.transport.misc", "transport", logLevel);
    private static final ThreadLocal<Transport> currentTransport = new ThreadLocal();
    private static final ObjID dgcID = new ObjID(2);
    private static final AccessControlContext SETCCL_ACC;

    private static String getLogLevel() {
        return AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.logLevel"));
    }

    public abstract Channel getChannel(Endpoint var1);

    public abstract void free(Endpoint var1);

    public void exportObject(Target target) throws RemoteException {
        target.setExportedTransport(this);
        ObjectTable.putTarget(target);
    }

    protected void targetUnexported() {
    }

    static Transport currentTransport() {
        return currentTransport.get();
    }

    protected abstract void checkAcceptPermission(AccessControlContext var1);

    private static void setContextClassLoader(ClassLoader ccl) {
        AccessController.doPrivileged(() -> {
            Thread.currentThread().setContextClassLoader(ccl);
            return null;
        }, SETCCL_ACC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean serviceCall(final RemoteCall call) {
        Remote impl;
        ObjID id;
        try {
            id = ObjID.read(call.getInputStream());
        }
        catch (IOException e) {
            throw new MarshalException("unable to read objID", e);
        }
        Transport transport2 = id.equals(dgcID) ? null : this;
        Target target = ObjectTable.getTarget(new ObjectEndpoint(id, transport2));
        if (target == null || (impl = target.getImpl()) == null) {
            throw new NoSuchObjectException("no such object in table");
        }
        final Dispatcher disp = target.getDispatcher();
        target.incrementCallCount();
        try {
            transportLog.log(Log.VERBOSE, "call dispatcher");
            final AccessControlContext acc = target.getAccessControlContext();
            ClassLoader ccl = target.getContextClassLoader();
            ClassLoader savedCcl = Thread.currentThread().getContextClassLoader();
            try {
                Transport.setContextClassLoader(ccl);
                currentTransport.set(this);
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws IOException {
                            Transport.this.checkAcceptPermission(acc);
                            disp.dispatch(impl, call);
                            return null;
                        }
                    }, acc);
                }
                catch (PrivilegedActionException pae) {
                    throw (IOException)pae.getException();
                }
            }
            finally {
                Transport.setContextClassLoader(savedCcl);
                currentTransport.set(null);
            }
            target.decrementCallCount();
        }
        catch (IOException ex) {
            try {
                transportLog.log(Log.BRIEF, "exception thrown by dispatcher: ", ex);
                boolean bl = false;
                target.decrementCallCount();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    target.decrementCallCount();
                    throw throwable;
                }
                catch (RemoteException e) {
                    if (UnicastServerRef.callLog.isLoggable(Log.BRIEF)) {
                        String clientHost = "";
                        try {
                            clientHost = "[" + RemoteServer.getClientHost() + "] ";
                        }
                        catch (ServerNotActiveException transport2) {
                            // empty catch block
                        }
                        String message = clientHost + "exception: ";
                        UnicastServerRef.callLog.log(Log.BRIEF, message, e);
                    }
                    try {
                        ObjectOutput out = call.getResultStream(false);
                        UnicastServerRef.clearStackTraces(e);
                        out.writeObject(e);
                        call.releaseOutputStream();
                    }
                    catch (IOException ie) {
                        transportLog.log(Log.BRIEF, "exception thrown marshalling exception: ", ie);
                        return false;
                    }
                }
            }
        }
        return true;
    }

    static {
        Permissions perms = new Permissions();
        perms.add(new RuntimePermission("setContextClassLoader"));
        ProtectionDomain[] pd = new ProtectionDomain[]{new ProtectionDomain(null, perms)};
        SETCCL_ACC = new AccessControlContext(pd);
    }
}

