/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.ccache;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import sun.misc.IOUtils;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.AuthorizationData;
import sun.security.krb5.internal.AuthorizationDataEntry;
import sun.security.krb5.internal.HostAddress;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.Ticket;
import sun.security.krb5.internal.TicketFlags;
import sun.security.krb5.internal.ccache.Credentials;
import sun.security.krb5.internal.ccache.CredentialsCache;
import sun.security.krb5.internal.ccache.FileCCacheConstants;
import sun.security.krb5.internal.ccache.Tag;
import sun.security.krb5.internal.util.KrbDataInputStream;

public class CCacheInputStream
extends KrbDataInputStream
implements FileCCacheConstants {
    private static boolean DEBUG = Krb5.DEBUG;

    public CCacheInputStream(InputStream is) {
        super(is);
    }

    public Tag readTag() throws IOException {
        char[] buf = new char[1024];
        int tag = -1;
        Integer time_offset = null;
        Integer usec_offset = null;
        int len = this.read(2);
        if (len < 0) {
            throw new IOException("stop.");
        }
        if (len > buf.length) {
            throw new IOException("Invalid tag length.");
        }
        while (len > 0) {
            tag = this.read(2);
            int taglen = this.read(2);
            switch (tag) {
                case 1: {
                    time_offset = new Integer(this.read(4));
                    usec_offset = new Integer(this.read(4));
                    break;
                }
            }
            len -= 4 + taglen;
        }
        return new Tag(len, tag, time_offset, usec_offset);
    }

    public PrincipalName readPrincipal(int version) throws IOException, RealmException {
        Object pname = null;
        int type = version == 1281 ? 0 : this.read(4);
        int length = this.readLength4();
        ArrayList<String> result = new ArrayList<String>();
        if (version == 1281) {
            --length;
        }
        for (int i = 0; i <= length; ++i) {
            int namelength = this.readLength4();
            byte[] bytes = IOUtils.readExactlyNBytes(this, namelength);
            result.add(new String(bytes));
        }
        if (result.isEmpty()) {
            throw new IOException("No realm or principal");
        }
        if (this.isRealm((String)result.get(0))) {
            String realm = (String)result.remove(0);
            if (result.isEmpty()) {
                throw new IOException("No principal name components");
            }
            return new PrincipalName(type, result.toArray(new String[result.size()]), new Realm(realm));
        }
        try {
            return new PrincipalName(type, result.toArray(new String[result.size()]), Realm.getDefault());
        }
        catch (RealmException re) {
            return null;
        }
    }

    boolean isRealm(String str) {
        try {
            Realm realm = new Realm(str);
        }
        catch (Exception e) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(str, ".");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) < '\u008d') continue;
                return false;
            }
        }
        return true;
    }

    EncryptionKey readKey(int version) throws IOException {
        int keyType = this.read(2);
        if (version == 1283) {
            this.read(2);
        }
        int keyLen = this.readLength4();
        byte[] bytes = IOUtils.readExactlyNBytes(this, keyLen);
        return new EncryptionKey(bytes, keyType, new Integer(version));
    }

    long[] readTimes() throws IOException {
        long[] times = new long[]{(long)this.read(4) * 1000L, (long)this.read(4) * 1000L, (long)this.read(4) * 1000L, (long)this.read(4) * 1000L};
        return times;
    }

    boolean readskey() throws IOException {
        return this.read() != 0;
    }

    HostAddress[] readAddr() throws IOException, KrbApErrException {
        int numAddrs = this.readLength4();
        if (numAddrs > 0) {
            ArrayList<HostAddress> addrs = new ArrayList<HostAddress>();
            for (int i = 0; i < numAddrs; ++i) {
                int addrType = this.read(2);
                int addrLength = this.readLength4();
                if (addrLength != 4 && addrLength != 16) {
                    if (DEBUG) {
                        System.out.println("Incorrect address format.");
                    }
                    return null;
                }
                byte[] result = new byte[addrLength];
                for (int j = 0; j < addrLength; ++j) {
                    result[j] = (byte)this.read(1);
                }
                addrs.add(new HostAddress(addrType, result));
            }
            return addrs.toArray(new HostAddress[addrs.size()]);
        }
        return null;
    }

    AuthorizationDataEntry[] readAuth() throws IOException {
        int num = this.readLength4();
        if (num > 0) {
            ArrayList<AuthorizationDataEntry> auData = new ArrayList<AuthorizationDataEntry>();
            byte[] data = null;
            for (int i = 0; i < num; ++i) {
                int adtype = this.read(2);
                int adlength = this.readLength4();
                data = IOUtils.readExactlyNBytes(this, adlength);
                auData.add(new AuthorizationDataEntry(adtype, data));
            }
            return auData.toArray(new AuthorizationDataEntry[auData.size()]);
        }
        return null;
    }

    byte[] readData() throws IOException {
        int length = this.readLength4();
        if (length == 0) {
            return null;
        }
        return IOUtils.readExactlyNBytes(this, length);
    }

    boolean[] readFlags() throws IOException {
        boolean[] flags = new boolean[32];
        int ticketFlags = this.read(4);
        if ((ticketFlags & 0x40000000) == 0x40000000) {
            flags[1] = true;
        }
        if ((ticketFlags & 0x20000000) == 0x20000000) {
            flags[2] = true;
        }
        if ((ticketFlags & 0x10000000) == 0x10000000) {
            flags[3] = true;
        }
        if ((ticketFlags & 0x8000000) == 0x8000000) {
            flags[4] = true;
        }
        if ((ticketFlags & 0x4000000) == 0x4000000) {
            flags[5] = true;
        }
        if ((ticketFlags & 0x2000000) == 0x2000000) {
            flags[6] = true;
        }
        if ((ticketFlags & 0x1000000) == 0x1000000) {
            flags[7] = true;
        }
        if ((ticketFlags & 0x800000) == 0x800000) {
            flags[8] = true;
        }
        if ((ticketFlags & 0x400000) == 0x400000) {
            flags[9] = true;
        }
        if ((ticketFlags & 0x200000) == 0x200000) {
            flags[10] = true;
        }
        if ((ticketFlags & 0x100000) == 0x100000) {
            flags[11] = true;
        }
        if (DEBUG) {
            String msg = ">>> CCacheInputStream: readFlags() ";
            if (flags[1]) {
                msg = msg + " FORWARDABLE;";
            }
            if (flags[2]) {
                msg = msg + " FORWARDED;";
            }
            if (flags[3]) {
                msg = msg + " PROXIABLE;";
            }
            if (flags[4]) {
                msg = msg + " PROXY;";
            }
            if (flags[5]) {
                msg = msg + " MAY_POSTDATE;";
            }
            if (flags[6]) {
                msg = msg + " POSTDATED;";
            }
            if (flags[7]) {
                msg = msg + " INVALID;";
            }
            if (flags[8]) {
                msg = msg + " RENEWABLE;";
            }
            if (flags[9]) {
                msg = msg + " INITIAL;";
            }
            if (flags[10]) {
                msg = msg + " PRE_AUTH;";
            }
            if (flags[11]) {
                msg = msg + " HW_AUTH;";
            }
            System.out.println(msg);
        }
        return flags;
    }

    Object readCred(int version) throws IOException, RealmException, KrbApErrException, Asn1Exception {
        KerberosTime renewTill;
        PrincipalName cpname = null;
        try {
            cpname = this.readPrincipal(version);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (DEBUG) {
            System.out.println(">>>DEBUG <CCacheInputStream>  client principal is " + cpname);
        }
        PrincipalName spname = null;
        try {
            spname = this.readPrincipal(version);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (DEBUG) {
            System.out.println(">>>DEBUG <CCacheInputStream> server principal is " + spname);
        }
        EncryptionKey key = this.readKey(version);
        if (DEBUG) {
            System.out.println(">>>DEBUG <CCacheInputStream> key type: " + key.getEType());
        }
        long[] times = this.readTimes();
        KerberosTime authtime = new KerberosTime(times[0]);
        KerberosTime starttime = times[1] == 0L ? null : new KerberosTime(times[1]);
        KerberosTime endtime = new KerberosTime(times[2]);
        KerberosTime kerberosTime = renewTill = times[3] == 0L ? null : new KerberosTime(times[3]);
        if (DEBUG) {
            System.out.println(">>>DEBUG <CCacheInputStream> auth time: " + authtime.toDate().toString());
            System.out.println(">>>DEBUG <CCacheInputStream> start time: " + (starttime == null ? "null" : starttime.toDate().toString()));
            System.out.println(">>>DEBUG <CCacheInputStream> end time: " + endtime.toDate().toString());
            System.out.println(">>>DEBUG <CCacheInputStream> renew_till time: " + (renewTill == null ? "null" : renewTill.toDate().toString()));
        }
        boolean skey = this.readskey();
        boolean[] flags = this.readFlags();
        TicketFlags tFlags = new TicketFlags(flags);
        HostAddress[] addr = this.readAddr();
        HostAddresses addrs = null;
        if (addr != null) {
            addrs = new HostAddresses(addr);
        }
        AuthorizationDataEntry[] auDataEntry = this.readAuth();
        AuthorizationData auData = null;
        if (auDataEntry != null) {
            auData = new AuthorizationData(auDataEntry);
        }
        byte[] ticketData = this.readData();
        byte[] ticketData2 = this.readData();
        if (cpname == null || spname == null) {
            return null;
        }
        try {
            String[] nameParts;
            if (spname.getRealmString().equals("X-CACHECONF:") && (nameParts = spname.getNameStrings())[0].equals("krb5_ccache_conf_data")) {
                return new CredentialsCache.ConfigEntry(nameParts[1], nameParts.length > 2 ? new PrincipalName(nameParts[2]) : null, ticketData);
            }
            return new Credentials(cpname, spname, key, authtime, starttime, endtime, renewTill, skey, tFlags, addrs, auData, ticketData != null ? new Ticket(ticketData) : null, ticketData2 != null ? new Ticket(ticketData2) : null);
        }
        catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace(System.out);
            }
            return null;
        }
    }
}

