/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.security;

import com.sun.jmx.remote.security.MBeanServerAccessController;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class MBeanServerFileAccessController
extends MBeanServerAccessController {
    static final String READONLY = "readonly";
    static final String READWRITE = "readwrite";
    static final String CREATE = "create";
    static final String UNREGISTER = "unregister";
    private Map<String, Access> accessMap;
    private Properties originalProps;
    private String accessFileName;

    public MBeanServerFileAccessController(String accessFileName) throws IOException {
        this.accessFileName = accessFileName;
        Properties props = MBeanServerFileAccessController.propertiesFromFile(accessFileName);
        this.parseProperties(props);
    }

    public MBeanServerFileAccessController(String accessFileName, MBeanServer mbs) throws IOException {
        this(accessFileName);
        this.setMBeanServer(mbs);
    }

    public MBeanServerFileAccessController(Properties accessFileProps) throws IOException {
        if (accessFileProps == null) {
            throw new IllegalArgumentException("Null properties");
        }
        this.originalProps = accessFileProps;
        this.parseProperties(accessFileProps);
    }

    public MBeanServerFileAccessController(Properties accessFileProps, MBeanServer mbs) throws IOException {
        this(accessFileProps);
        this.setMBeanServer(mbs);
    }

    @Override
    public void checkRead() {
        this.checkAccess(AccessType.READ, null);
    }

    @Override
    public void checkWrite() {
        this.checkAccess(AccessType.WRITE, null);
    }

    @Override
    public void checkCreate(String className) {
        this.checkAccess(AccessType.CREATE, className);
    }

    @Override
    public void checkUnregister(ObjectName name) {
        this.checkAccess(AccessType.UNREGISTER, null);
    }

    public synchronized void refresh() throws IOException {
        Properties props = this.accessFileName == null ? this.originalProps : MBeanServerFileAccessController.propertiesFromFile(this.accessFileName);
        this.parseProperties(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties propertiesFromFile(String fname) throws IOException {
        try (FileInputStream fin = new FileInputStream(fname);){
            Properties p = new Properties();
            p.load(fin);
            Properties properties = p;
            return properties;
        }
    }

    private synchronized void checkAccess(AccessType requiredAccess, String arg) {
        final AccessControlContext acc = AccessController.getContext();
        Subject s = AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                return Subject.getSubject(acc);
            }
        });
        if (s == null) {
            return;
        }
        Set<Principal> principals = s.getPrincipals();
        String newPropertyValue = null;
        for (Principal p : principals) {
            boolean ok;
            Access access = this.accessMap.get(p.getName());
            if (access == null) continue;
            switch (requiredAccess) {
                case READ: {
                    ok = true;
                    break;
                }
                case WRITE: {
                    ok = access.write;
                    break;
                }
                case UNREGISTER: {
                    ok = access.unregister;
                    if (ok || !access.write) break;
                    newPropertyValue = UNREGISTER;
                    break;
                }
                case CREATE: {
                    ok = MBeanServerFileAccessController.checkCreateAccess(access, arg);
                    if (ok || !access.write) break;
                    newPropertyValue = "create " + arg;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (!ok) continue;
            return;
        }
        SecurityException se = new SecurityException("Access denied! Invalid access level for requested MBeanServer operation.");
        if (newPropertyValue != null) {
            SecurityException se2 = new SecurityException("Access property for this identity should be similar to: readwrite " + newPropertyValue);
            se.initCause(se2);
        }
        throw se;
    }

    private static boolean checkCreateAccess(Access access, String className) {
        for (String classNamePattern : access.createPatterns) {
            if (!MBeanServerFileAccessController.classNameMatch(classNamePattern, className)) continue;
            return true;
        }
        return false;
    }

    private static boolean classNameMatch(String pattern, String className) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer stok = new StringTokenizer(pattern, "*", true);
        while (stok.hasMoreTokens()) {
            String tok = stok.nextToken();
            if (tok.equals("*")) {
                sb.append("[^.]*");
                continue;
            }
            sb.append(Pattern.quote(tok));
        }
        return className.matches(sb.toString());
    }

    private void parseProperties(Properties props) {
        this.accessMap = new HashMap<String, Access>();
        for (Map.Entry entry : props.entrySet()) {
            String identity = (String)entry.getKey();
            String accessString = (String)entry.getValue();
            Access access = Parser.parseAccess(identity, accessString);
            this.accessMap.put(identity, access);
        }
    }

    private static class Parser {
        private static final int EOS = -1;
        private final String identity;
        private final String s;
        private final int len;
        private int i;
        private int c;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Parser(String identity, String s) {
            this.identity = identity;
            this.s = s;
            this.len = s.length();
            this.i = 0;
            this.c = this.i < this.len ? s.codePointAt(this.i) : -1;
        }

        static Access parseAccess(String identity, String s) {
            return new Parser(identity, s).parseAccess();
        }

        private Access parseAccess() {
            Access access;
            this.skipSpace();
            String type = this.parseWord();
            if (type.equals(MBeanServerFileAccessController.READONLY)) {
                access = new Access(false, false, null);
            } else if (type.equals(MBeanServerFileAccessController.READWRITE)) {
                access = this.parseReadWrite();
            } else {
                throw this.syntax("Expected readonly or readwrite: " + type);
            }
            if (this.c != -1) {
                throw this.syntax("Extra text at end of line");
            }
            return access;
        }

        private Access parseReadWrite() {
            boolean unregister;
            ArrayList<String> createClasses;
            block2: {
                String type;
                createClasses = new ArrayList<String>();
                unregister = false;
                while (true) {
                    this.skipSpace();
                    if (this.c == -1) break block2;
                    type = this.parseWord();
                    if (type.equals(MBeanServerFileAccessController.UNREGISTER)) {
                        unregister = true;
                        continue;
                    }
                    if (!type.equals(MBeanServerFileAccessController.CREATE)) break;
                    this.parseCreate(createClasses);
                }
                throw this.syntax("Unrecognized keyword " + type);
            }
            return new Access(true, unregister, createClasses);
        }

        private void parseCreate(List<String> createClasses) {
            while (true) {
                this.skipSpace();
                createClasses.add(this.parseClassName());
                this.skipSpace();
                if (this.c != 44) break;
                this.next();
            }
        }

        private String parseClassName() {
            int start = this.i;
            boolean dotOK = false;
            while (true) {
                if (this.c == 46) {
                    if (!dotOK) {
                        throw this.syntax("Bad . in class name");
                    }
                    dotOK = false;
                } else {
                    if (this.c != 42 && !Character.isJavaIdentifierPart(this.c)) break;
                    dotOK = true;
                }
                this.next();
            }
            String className = this.s.substring(start, this.i);
            if (!dotOK) {
                throw this.syntax("Bad class name " + className);
            }
            return className;
        }

        private void next() {
            if (this.c != -1) {
                this.i += Character.charCount(this.c);
                this.c = this.i < this.len ? this.s.codePointAt(this.i) : -1;
            }
        }

        private void skipSpace() {
            while (Character.isWhitespace(this.c)) {
                this.next();
            }
        }

        private String parseWord() {
            this.skipSpace();
            if (this.c == -1) {
                throw this.syntax("Expected word at end of line");
            }
            int start = this.i;
            while (this.c != -1 && !Character.isWhitespace(this.c)) {
                this.next();
            }
            String word = this.s.substring(start, this.i);
            this.skipSpace();
            return word;
        }

        private IllegalArgumentException syntax(String msg) {
            return new IllegalArgumentException(msg + " [" + this.identity + " " + this.s + "]");
        }

        static {
            boolean bl = $assertionsDisabled = !MBeanServerFileAccessController.class.desiredAssertionStatus();
            if (!$assertionsDisabled && Character.isWhitespace(-1)) {
                throw new AssertionError();
            }
        }
    }

    private static class Access {
        final boolean write;
        final String[] createPatterns;
        private boolean unregister;
        private final String[] NO_STRINGS = new String[0];

        Access(boolean write, boolean unregister, List<String> createPatternList) {
            this.write = write;
            int npats = createPatternList == null ? 0 : createPatternList.size();
            this.createPatterns = npats == 0 ? this.NO_STRINGS : createPatternList.toArray(new String[npats]);
            this.unregister = unregister;
        }
    }

    private static enum AccessType {
        READ,
        WRITE,
        CREATE,
        UNREGISTER;

    }
}

