/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.concurrent.atomic.AtomicInteger;
import sun.misc.Unsafe;

public final class InnocuousThread
extends Thread {
    private static final Unsafe UNSAFE;
    private static final long THREAD_LOCALS;
    private static final long INHERITABLE_THREAD_LOCALS;
    private static final ThreadGroup INNOCUOUSTHREADGROUP;
    private static final AccessControlContext ACC;
    private static final long INHERITEDACCESSCONTROLCONTEXT;
    private static final long CONTEXTCLASSLOADER;
    private static final AtomicInteger threadNumber;
    private volatile boolean hasRun;

    private static String newName() {
        return "InnocuousThread-" + threadNumber.getAndIncrement();
    }

    public static Thread newSystemThread(Runnable target) {
        return InnocuousThread.newSystemThread(InnocuousThread.newName(), target);
    }

    public static Thread newSystemThread(final String name, final Runnable target) {
        return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                return new InnocuousThread(INNOCUOUSTHREADGROUP, target, name, null);
            }
        });
    }

    public InnocuousThread(Runnable target) {
        super(INNOCUOUSTHREADGROUP, target, InnocuousThread.newName());
        UNSAFE.putOrderedObject(this, INHERITEDACCESSCONTROLCONTEXT, ACC);
        this.eraseThreadLocals();
    }

    private InnocuousThread(ThreadGroup group, Runnable target, String name, ClassLoader tccl) {
        super(group, target, name, 0L);
        UNSAFE.putOrderedObject(this, INHERITEDACCESSCONTROLCONTEXT, ACC);
        UNSAFE.putOrderedObject(this, CONTEXTCLASSLOADER, tccl);
        this.eraseThreadLocals();
    }

    @Override
    public ClassLoader getContextClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler x) {
    }

    @Override
    public void setContextClassLoader(ClassLoader cl) {
        throw new SecurityException("setContextClassLoader");
    }

    @Override
    public void run() {
        if (Thread.currentThread() == this && !this.hasRun) {
            this.hasRun = true;
            super.run();
        }
    }

    public void eraseThreadLocals() {
        UNSAFE.putObject((Object)this, THREAD_LOCALS, null);
        UNSAFE.putObject((Object)this, INHERITABLE_THREAD_LOCALS, null);
    }

    static {
        threadNumber = new AtomicInteger(1);
        try {
            ThreadGroup parent;
            ACC = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, null)});
            UNSAFE = Unsafe.getUnsafe();
            Class<Thread> tk = Thread.class;
            Class<ThreadGroup> gk = ThreadGroup.class;
            THREAD_LOCALS = UNSAFE.objectFieldOffset(tk.getDeclaredField("threadLocals"));
            INHERITABLE_THREAD_LOCALS = UNSAFE.objectFieldOffset(tk.getDeclaredField("inheritableThreadLocals"));
            INHERITEDACCESSCONTROLCONTEXT = UNSAFE.objectFieldOffset(tk.getDeclaredField("inheritedAccessControlContext"));
            CONTEXTCLASSLOADER = UNSAFE.objectFieldOffset(tk.getDeclaredField("contextClassLoader"));
            long tg = UNSAFE.objectFieldOffset(tk.getDeclaredField("group"));
            long gp = UNSAFE.objectFieldOffset(gk.getDeclaredField("parent"));
            ThreadGroup group = (ThreadGroup)UNSAFE.getObject((Object)Thread.currentThread(), tg);
            while (group != null && (parent = (ThreadGroup)UNSAFE.getObject((Object)group, gp)) != null) {
                group = parent;
            }
            final ThreadGroup root = group;
            INNOCUOUSTHREADGROUP = AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

                @Override
                public ThreadGroup run() {
                    return new ThreadGroup(root, "InnocuousThreadGroup");
                }
            });
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

