/*
 * Decompiled with CFR 0.152.
 */
package sun.net.sdp;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Scanner;
import sun.net.NetHooks;
import sun.net.sdp.SdpSupport;
import sun.security.action.GetPropertyAction;

public class SdpProvider
extends NetHooks.Provider {
    private static final int MAX_PORT = 65535;
    private final boolean enabled;
    private final List<Rule> rules;
    private PrintStream log;

    public SdpProvider() {
        String file = AccessController.doPrivileged(new GetPropertyAction("com.sun.sdp.conf"));
        if (file == null) {
            this.enabled = false;
            this.rules = null;
            return;
        }
        List<Rule> list = null;
        if (file != null) {
            try {
                list = SdpProvider.loadRulesFromFile(file);
            }
            catch (IOException e) {
                SdpProvider.fail("Error reading %s: %s", file, e.getMessage());
            }
        }
        PrintStream out = null;
        String logfile = AccessController.doPrivileged(new GetPropertyAction("com.sun.sdp.debug"));
        if (logfile != null) {
            out = System.out;
            if (logfile.length() > 0) {
                try {
                    out = new PrintStream(logfile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.enabled = !list.isEmpty();
        this.rules = list;
        this.log = out;
    }

    private static int[] parsePortRange(String s) {
        int pos = s.indexOf(45);
        try {
            int[] result = new int[2];
            if (pos < 0) {
                boolean all = s.equals("*");
                result[0] = all ? 0 : Integer.parseInt(s);
                result[1] = all ? 65535 : result[0];
            } else {
                String high;
                String low = s.substring(0, pos);
                if (low.length() == 0) {
                    low = "*";
                }
                if ((high = s.substring(pos + 1)).length() == 0) {
                    high = "*";
                }
                result[0] = low.equals("*") ? 0 : Integer.parseInt(low);
                result[1] = high.equals("*") ? 65535 : Integer.parseInt(high);
            }
            return result;
        }
        catch (NumberFormatException e) {
            return new int[0];
        }
    }

    private static void fail(String msg, Object ... args) {
        Formatter f = new Formatter();
        f.format(msg, args);
        throw new RuntimeException(f.out().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static List<Rule> loadRulesFromFile(String file) throws IOException {
        try (Scanner scanner = new Scanner(new File(file));){
            ArrayList<Rule> result = new ArrayList<Rule>();
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                if (line.length() == 0 || line.charAt(0) == '#') continue;
                String[] s = line.split("\\s+");
                if (s.length != 3) {
                    SdpProvider.fail("Malformed line '%s'", line);
                    continue;
                }
                Action action = null;
                for (Action action2 : Action.values()) {
                    if (!s[0].equalsIgnoreCase(action2.name())) continue;
                    action = action2;
                    break;
                }
                if (action == null) {
                    SdpProvider.fail("Action '%s' not recognized", s[0]);
                    continue;
                }
                int[] ports = SdpProvider.parsePortRange(s[2]);
                if (ports.length == 0) {
                    SdpProvider.fail("Malformed port range '%s'", s[2]);
                    continue;
                }
                if (s[1].equals("*")) {
                    result.add(new PortRangeRule(action, ports[0], ports[1]));
                    continue;
                }
                int pos = s[1].indexOf(47);
                try {
                    void var9_17;
                    if (pos < 0) {
                        InetAddress[] addresses;
                        for (InetAddress address : addresses = InetAddress.getAllByName(s[1])) {
                            int prefix = address instanceof Inet4Address ? 32 : 128;
                            result.add(new AddressPortRangeRule(action, address, prefix, ports[0], ports[1]));
                        }
                        continue;
                    }
                    InetAddress address = InetAddress.getByName(s[1].substring(0, pos));
                    int n = -1;
                    try {
                        int n2 = Integer.parseInt(s[1].substring(pos + 1));
                        if (address instanceof Inet4Address) {
                            if (n2 < 0 || n2 > 32) {
                                int n3 = -1;
                            }
                        } else if (n2 < 0 || n2 > 128) {
                            int n4 = -1;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (var9_17 > 0) {
                        result.add(new AddressPortRangeRule(action, address, (int)var9_17, ports[0], ports[1]));
                        continue;
                    }
                    SdpProvider.fail("Malformed prefix '%s'", s[1]);
                }
                catch (UnknownHostException uhe) {
                    SdpProvider.fail("Unknown host or malformed IP address '%s'", s[1]);
                }
            }
            ArrayList<Rule> arrayList = result;
            return arrayList;
        }
    }

    private void convertTcpToSdpIfMatch(FileDescriptor fdObj, Action action, InetAddress address, int port) throws IOException {
        boolean matched = false;
        for (Rule rule : this.rules) {
            if (!rule.match(action, address, port)) continue;
            SdpSupport.convertSocket(fdObj);
            matched = true;
            break;
        }
        if (this.log != null) {
            String addr;
            String string = addr = address instanceof Inet4Address ? address.getHostAddress() : "[" + address.getHostAddress() + "]";
            if (matched) {
                this.log.format("%s to %s:%d (socket converted to SDP protocol)\n", new Object[]{action, addr, port});
            } else {
                this.log.format("%s to %s:%d (no match)\n", new Object[]{action, addr, port});
            }
        }
    }

    @Override
    public void implBeforeTcpBind(FileDescriptor fdObj, InetAddress address, int port) throws IOException {
        if (this.enabled) {
            this.convertTcpToSdpIfMatch(fdObj, Action.BIND, address, port);
        }
    }

    @Override
    public void implBeforeTcpConnect(FileDescriptor fdObj, InetAddress address, int port) throws IOException {
        if (this.enabled) {
            this.convertTcpToSdpIfMatch(fdObj, Action.CONNECT, address, port);
        }
    }

    private static class AddressPortRangeRule
    extends PortRangeRule {
        private final byte[] addressAsBytes;
        private final int prefixByteCount;
        private final byte mask;

        AddressPortRangeRule(Action action, InetAddress address, int prefix, int port, int end) {
            super(action, port, end);
            this.addressAsBytes = address.getAddress();
            this.prefixByteCount = prefix >> 3;
            this.mask = (byte)(255 << 8 - prefix % 8);
        }

        @Override
        public boolean match(Action action, InetAddress address, int port) {
            if (action != this.action()) {
                return false;
            }
            byte[] candidate = address.getAddress();
            if (candidate.length != this.addressAsBytes.length) {
                return false;
            }
            for (int i = 0; i < this.prefixByteCount; ++i) {
                if (candidate[i] == this.addressAsBytes[i]) continue;
                return false;
            }
            if (this.prefixByteCount < this.addressAsBytes.length && (candidate[this.prefixByteCount] & this.mask) != (this.addressAsBytes[this.prefixByteCount] & this.mask)) {
                return false;
            }
            return super.match(action, address, port);
        }
    }

    private static class PortRangeRule
    implements Rule {
        private final Action action;
        private final int portStart;
        private final int portEnd;

        PortRangeRule(Action action, int portStart, int portEnd) {
            this.action = action;
            this.portStart = portStart;
            this.portEnd = portEnd;
        }

        Action action() {
            return this.action;
        }

        @Override
        public boolean match(Action action, InetAddress address, int port) {
            return action == this.action && port >= this.portStart && port <= this.portEnd;
        }
    }

    private static interface Rule {
        public boolean match(Action var1, InetAddress var2, int var3);
    }

    private static enum Action {
        BIND,
        CONNECT;

    }
}

