/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.nio.fs.AbstractFileTypeDetector;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.UnixPath;

class MagicFileTypeDetector
extends AbstractFileTypeDetector {
    private static final String UNKNOW_MIME_TYPE = "application/octet-stream";
    private final boolean libmagicAvailable = MagicFileTypeDetector.initialize0();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String implProbeContentType(Path obj) throws IOException {
        if (!this.libmagicAvailable || !(obj instanceof UnixPath)) {
            return null;
        }
        UnixPath path = (UnixPath)obj;
        path.checkRead();
        NativeBuffer buffer = NativeBuffers.asNativeBuffer(path.getByteArrayForSysCalls());
        try {
            byte[] type = MagicFileTypeDetector.probe0(buffer.address());
            String mimeType = type == null ? null : new String(type);
            String string = UNKNOW_MIME_TYPE.equals(mimeType) ? null : mimeType;
            return string;
        }
        finally {
            buffer.release();
        }
    }

    private static native boolean initialize0();

    private static native byte[] probe0(long var0);

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("nio");
                return null;
            }
        });
    }
}

