/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.generics.repository;

import java.lang.reflect.Type;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.parser.SignatureParser;
import sun.reflect.generics.repository.GenericDeclRepository;
import sun.reflect.generics.tree.ClassSignature;
import sun.reflect.generics.tree.ClassTypeSignature;
import sun.reflect.generics.visitor.Reifier;

public class ClassRepository
extends GenericDeclRepository<ClassSignature> {
    public static final ClassRepository NONE = ClassRepository.make("Ljava/lang/Object;", null);
    private volatile Type superclass;
    private volatile Type[] superInterfaces;

    private ClassRepository(String rawSig, GenericsFactory f) {
        super(rawSig, f);
    }

    @Override
    protected ClassSignature parse(String s) {
        return SignatureParser.make().parseClassSig(s);
    }

    public static ClassRepository make(String rawSig, GenericsFactory f) {
        return new ClassRepository(rawSig, f);
    }

    public Type getSuperclass() {
        Type superclass = this.superclass;
        if (superclass == null) {
            Reifier r = this.getReifier();
            ((ClassSignature)this.getTree()).getSuperclass().accept(r);
            this.superclass = superclass = r.getResult();
        }
        return superclass;
    }

    public Type[] getSuperInterfaces() {
        Type[] superInterfaces = this.superInterfaces;
        if (superInterfaces == null) {
            ClassTypeSignature[] ts = ((ClassSignature)this.getTree()).getSuperInterfaces();
            superInterfaces = new Type[ts.length];
            for (int i = 0; i < ts.length; ++i) {
                Reifier r = this.getReifier();
                ts[i].accept(r);
                superInterfaces[i] = r.getResult();
            }
            this.superInterfaces = superInterfaces;
        }
        return (Type[])superInterfaces.clone();
    }
}

