/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.LastReq;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.TicketFlags;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class EncKDCRepPart {
    public EncryptionKey key;
    public LastReq lastReq;
    public int nonce;
    public KerberosTime keyExpiration;
    public TicketFlags flags;
    public KerberosTime authtime;
    public KerberosTime starttime;
    public KerberosTime endtime;
    public KerberosTime renewTill;
    public PrincipalName sname;
    public HostAddresses caddr;
    public PAData[] pAData;
    public int msgType;

    public EncKDCRepPart(EncryptionKey new_key, LastReq new_lastReq, int new_nonce, KerberosTime new_keyExpiration, TicketFlags new_flags, KerberosTime new_authtime, KerberosTime new_starttime, KerberosTime new_endtime, KerberosTime new_renewTill, PrincipalName new_sname, HostAddresses new_caddr, PAData[] new_pAData, int new_msgType) {
        this.key = new_key;
        this.lastReq = new_lastReq;
        this.nonce = new_nonce;
        this.keyExpiration = new_keyExpiration;
        this.flags = new_flags;
        this.authtime = new_authtime;
        this.starttime = new_starttime;
        this.endtime = new_endtime;
        this.renewTill = new_renewTill;
        this.sname = new_sname;
        this.caddr = new_caddr;
        this.pAData = new_pAData;
        this.msgType = new_msgType;
    }

    public EncKDCRepPart() {
    }

    public EncKDCRepPart(byte[] data, int rep_type) throws Asn1Exception, IOException, RealmException {
        this.init(new DerValue(data), rep_type);
    }

    public EncKDCRepPart(DerValue encoding, int rep_type) throws Asn1Exception, IOException, RealmException {
        this.init(encoding, rep_type);
    }

    protected void init(DerValue encoding, int rep_type) throws Asn1Exception, IOException, RealmException {
        this.msgType = encoding.getTag() & 0x1F;
        if (this.msgType != 25 && this.msgType != 26) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if (der.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        this.key = EncryptionKey.parse(der.getData(), (byte)0, false);
        this.lastReq = LastReq.parse(der.getData(), (byte)1, false);
        DerValue subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) != 2) {
            throw new Asn1Exception(906);
        }
        this.nonce = subDer.getData().getBigInteger().intValue();
        this.keyExpiration = KerberosTime.parse(der.getData(), (byte)3, true);
        this.flags = TicketFlags.parse(der.getData(), (byte)4, false);
        this.authtime = KerberosTime.parse(der.getData(), (byte)5, false);
        this.starttime = KerberosTime.parse(der.getData(), (byte)6, true);
        this.endtime = KerberosTime.parse(der.getData(), (byte)7, false);
        this.renewTill = KerberosTime.parse(der.getData(), (byte)8, true);
        Realm srealm = Realm.parse(der.getData(), (byte)9, false);
        this.sname = PrincipalName.parse(der.getData(), (byte)10, false, srealm);
        if (der.getData().available() > 0) {
            this.caddr = HostAddresses.parse(der.getData(), (byte)11, true);
        }
        if (der.getData().available() > 0) {
            this.pAData = PAData.parseSequence(der.getData(), (byte)12, true);
        }
    }

    public byte[] asn1Encode(int rep_type) throws Asn1Exception, IOException {
        DerOutputStream bytes;
        DerOutputStream temp = new DerOutputStream();
        DerOutputStream out = new DerOutputStream();
        out.write(DerValue.createTag((byte)-128, true, (byte)0), this.key.asn1Encode());
        out.write(DerValue.createTag((byte)-128, true, (byte)1), this.lastReq.asn1Encode());
        temp.putInteger(BigInteger.valueOf(this.nonce));
        out.write(DerValue.createTag((byte)-128, true, (byte)2), temp);
        if (this.keyExpiration != null) {
            out.write(DerValue.createTag((byte)-128, true, (byte)3), this.keyExpiration.asn1Encode());
        }
        out.write(DerValue.createTag((byte)-128, true, (byte)4), this.flags.asn1Encode());
        out.write(DerValue.createTag((byte)-128, true, (byte)5), this.authtime.asn1Encode());
        if (this.starttime != null) {
            out.write(DerValue.createTag((byte)-128, true, (byte)6), this.starttime.asn1Encode());
        }
        out.write(DerValue.createTag((byte)-128, true, (byte)7), this.endtime.asn1Encode());
        if (this.renewTill != null) {
            out.write(DerValue.createTag((byte)-128, true, (byte)8), this.renewTill.asn1Encode());
        }
        out.write(DerValue.createTag((byte)-128, true, (byte)9), this.sname.getRealm().asn1Encode());
        out.write(DerValue.createTag((byte)-128, true, (byte)10), this.sname.asn1Encode());
        if (this.caddr != null) {
            out.write(DerValue.createTag((byte)-128, true, (byte)11), this.caddr.asn1Encode());
        }
        if (this.pAData != null && this.pAData.length > 0) {
            temp = new DerOutputStream();
            for (int i = 0; i < this.pAData.length; ++i) {
                temp.write(this.pAData[i].asn1Encode());
            }
            bytes = new DerOutputStream();
            bytes.write((byte)48, temp);
            out.write(DerValue.createTag((byte)-128, true, (byte)12), bytes);
        }
        temp = new DerOutputStream();
        temp.write((byte)48, out);
        bytes = new DerOutputStream();
        bytes.write(DerValue.createTag((byte)64, true, (byte)this.msgType), temp);
        return bytes.toByteArray();
    }
}

