/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddressImpl;
import java.net.InetAddressImplFactory;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import sun.misc.Unsafe;
import sun.net.InetAddressCachePolicy;
import sun.net.spi.nameservice.NameService;
import sun.net.spi.nameservice.NameServiceDescriptor;
import sun.net.util.IPAddressUtil;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;

public class InetAddress
implements Serializable {
    static final int IPv4 = 1;
    static final int IPv6 = 2;
    static transient boolean preferIPv6Address;
    final transient InetAddressHolder holder = new InetAddressHolder();
    private static List<NameService> nameServices;
    private transient String canonicalHostName = null;
    private static final long serialVersionUID = 3286316764910316507L;
    private static final ConcurrentMap<String, Addresses> cache;
    private static final NavigableSet<CachedAddresses> expirySet;
    static InetAddressImpl impl;
    private static volatile CachedLocalHost cachedLocalHost;
    private static final long FIELDS_OFFSET;
    private static final Unsafe UNSAFE;
    private static final ObjectStreamField[] serialPersistentFields;

    InetAddressHolder holder() {
        return this.holder;
    }

    InetAddress() {
    }

    private Object readResolve() throws ObjectStreamException {
        return new Inet4Address(this.holder().getHostName(), this.holder().getAddress());
    }

    public boolean isMulticastAddress() {
        return false;
    }

    public boolean isAnyLocalAddress() {
        return false;
    }

    public boolean isLoopbackAddress() {
        return false;
    }

    public boolean isLinkLocalAddress() {
        return false;
    }

    public boolean isSiteLocalAddress() {
        return false;
    }

    public boolean isMCGlobal() {
        return false;
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCLinkLocal() {
        return false;
    }

    public boolean isMCSiteLocal() {
        return false;
    }

    public boolean isMCOrgLocal() {
        return false;
    }

    public boolean isReachable(int timeout) throws IOException {
        return this.isReachable(null, 0, timeout);
    }

    public boolean isReachable(NetworkInterface netif, int ttl, int timeout) throws IOException {
        if (ttl < 0) {
            throw new IllegalArgumentException("ttl can't be negative");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        return impl.isReachable(this, timeout, netif, ttl);
    }

    public String getHostName() {
        return this.getHostName(true);
    }

    String getHostName(boolean check) {
        if (this.holder().getHostName() == null) {
            this.holder().hostName = InetAddress.getHostFromNameService(this, check);
        }
        return this.holder().getHostName();
    }

    public String getCanonicalHostName() {
        if (this.canonicalHostName == null) {
            this.canonicalHostName = InetAddress.getHostFromNameService(this, true);
        }
        return this.canonicalHostName;
    }

    private static String getHostFromNameService(InetAddress addr, boolean check) {
        String host = null;
        for (NameService nameService : nameServices) {
            try {
                SecurityManager sec;
                host = nameService.getHostByAddr(addr.getAddress());
                if (check && (sec = System.getSecurityManager()) != null) {
                    sec.checkConnect(host, -1);
                }
                InetAddress[] arr = InetAddress.getAllByName0(host, check);
                boolean ok = false;
                if (arr != null) {
                    for (int i = 0; !ok && i < arr.length; ++i) {
                        ok = addr.equals(arr[i]);
                    }
                }
                if (!ok) {
                    host = addr.getHostAddress();
                    return host;
                }
                break;
            }
            catch (SecurityException e) {
                host = addr.getHostAddress();
                break;
            }
            catch (UnknownHostException e) {
                host = addr.getHostAddress();
            }
        }
        return host;
    }

    public byte[] getAddress() {
        return null;
    }

    public String getHostAddress() {
        return null;
    }

    public int hashCode() {
        return -1;
    }

    public boolean equals(Object obj) {
        return false;
    }

    public String toString() {
        String hostName = this.holder().getHostName();
        return (hostName != null ? hostName : "") + "/" + this.getHostAddress();
    }

    private static NameService createNSProvider(String provider) {
        if (provider == null) {
            return null;
        }
        NameService nameService = null;
        if (provider.equals("default")) {
            nameService = new NameService(){

                @Override
                public InetAddress[] lookupAllHostAddr(String host) throws UnknownHostException {
                    InetAddress.validate(host);
                    return impl.lookupAllHostAddr(host);
                }

                @Override
                public String getHostByAddr(byte[] addr) throws UnknownHostException {
                    return impl.getHostByAddr(addr);
                }
            };
        } else {
            final String providerName = provider;
            try {
                nameService = AccessController.doPrivileged(new PrivilegedExceptionAction<NameService>(){

                    @Override
                    public NameService run() {
                        for (NameServiceDescriptor nsd : ServiceLoader.load(NameServiceDescriptor.class)) {
                            if (!providerName.equalsIgnoreCase(nsd.getType() + "," + nsd.getProviderName())) continue;
                            try {
                                return nsd.createNameService();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                System.err.println("Cannot create name service:" + providerName + ": " + e);
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
        }
        return nameService;
    }

    public static InetAddress getByAddress(String host, byte[] addr) throws UnknownHostException {
        if (host != null && host.length() > 0 && host.charAt(0) == '[' && host.charAt(host.length() - 1) == ']') {
            host = host.substring(1, host.length() - 1);
        }
        if (addr != null) {
            if (addr.length == 4) {
                return new Inet4Address(host, addr);
            }
            if (addr.length == 16) {
                byte[] newAddr = IPAddressUtil.convertFromIPv4MappedAddress(addr);
                if (newAddr != null) {
                    return new Inet4Address(host, newAddr);
                }
                return new Inet6Address(host, addr);
            }
        }
        throw new UnknownHostException("addr is of illegal length");
    }

    public static InetAddress getByName(String host) throws UnknownHostException {
        return InetAddress.getAllByName(host)[0];
    }

    private static InetAddress getByName(String host, InetAddress reqAddr) throws UnknownHostException {
        return InetAddress.getAllByName(host, reqAddr)[0];
    }

    public static InetAddress[] getAllByName(String host) throws UnknownHostException {
        return InetAddress.getAllByName(host, null);
    }

    private static InetAddress[] getAllByName(String host, InetAddress reqAddr) throws UnknownHostException {
        if (host == null || host.length() == 0) {
            InetAddress[] ret = new InetAddress[]{impl.loopbackAddress()};
            return ret;
        }
        InetAddress.validate(host);
        boolean ipv6Expected = false;
        if (host.charAt(0) == '[') {
            if (host.length() > 2 && host.charAt(host.length() - 1) == ']') {
                host = host.substring(1, host.length() - 1);
                ipv6Expected = true;
            } else {
                throw InetAddress.invalidIPv6LiteralException(host, false);
            }
        }
        if (IPAddressUtil.digit(host.charAt(0), 16) != -1 || host.charAt(0) == ':') {
            byte[] addr = null;
            int numericZone = -1;
            String ifname = null;
            if (!ipv6Expected) {
                try {
                    addr = IPAddressUtil.validateNumericFormatV4(host);
                }
                catch (IllegalArgumentException iae) {
                    UnknownHostException uhe = new UnknownHostException(host);
                    uhe.initCause(iae);
                    throw uhe;
                }
            }
            if (addr == null) {
                int pos = host.indexOf(37);
                if (pos != -1 && (numericZone = InetAddress.checkNumericZone(host)) == -1) {
                    ifname = host.substring(pos + 1);
                }
                if ((addr = IPAddressUtil.textToNumericFormatV6(host)) == null && (host.contains(":") || ipv6Expected)) {
                    throw InetAddress.invalidIPv6LiteralException(host, ipv6Expected);
                }
            }
            if (addr != null) {
                InetAddress[] ret = new InetAddress[1];
                if (addr.length == 4) {
                    if (numericZone != -1 || ifname != null) {
                        throw new UnknownHostException(host + ": invalid IPv4-mapped address");
                    }
                    ret[0] = new Inet4Address(null, addr);
                } else {
                    ret[0] = ifname != null ? new Inet6Address(null, addr, ifname) : new Inet6Address(null, addr, numericZone);
                }
                return ret;
            }
        } else if (ipv6Expected) {
            throw InetAddress.invalidIPv6LiteralException(host, true);
        }
        return InetAddress.getAllByName0(host, reqAddr, true, true);
    }

    private static UnknownHostException invalidIPv6LiteralException(String host, boolean wrapInBrackets) {
        String hostString = wrapInBrackets ? "[" + host + "]" : host;
        return new UnknownHostException(hostString + ": invalid IPv6 address literal");
    }

    public static InetAddress getLoopbackAddress() {
        return impl.loopbackAddress();
    }

    private static int checkNumericZone(String s) throws UnknownHostException {
        int percent = s.indexOf(37);
        int slen = s.length();
        int zone = 0;
        int multmax = 0xCCCCCCC;
        if (percent == -1) {
            return -1;
        }
        for (int i = percent + 1; i < slen; ++i) {
            char c = s.charAt(i);
            int digit = IPAddressUtil.parseAsciiDigit(c, 10);
            if (digit < 0) {
                return -1;
            }
            if (zone > multmax) {
                return -1;
            }
            if ((zone = zone * 10 + digit) >= 0) continue;
            return -1;
        }
        return zone;
    }

    private static InetAddress[] getAllByName0(String host) throws UnknownHostException {
        return InetAddress.getAllByName0(host, true);
    }

    static InetAddress[] getAllByName0(String host, boolean check) throws UnknownHostException {
        return InetAddress.getAllByName0(host, null, check, true);
    }

    private static InetAddress[] getAllByName0(String host, InetAddress reqAddr, boolean check, boolean useCache) throws UnknownHostException {
        Addresses oldAddrs;
        Addresses addrs;
        SecurityManager security;
        if (check && (security = System.getSecurityManager()) != null) {
            security.checkConnect(host, -1);
        }
        long now = System.nanoTime();
        for (CachedAddresses caddrs : expirySet) {
            if (caddrs.expiryTime - now >= 0L) break;
            if (!expirySet.remove(caddrs)) continue;
            cache.remove(caddrs.host, caddrs);
        }
        if (useCache) {
            addrs = (Addresses)cache.get(host);
        } else {
            addrs = (Addresses)cache.remove(host);
            if (addrs != null) {
                if (addrs instanceof CachedAddresses) {
                    expirySet.remove(addrs);
                }
                addrs = null;
            }
        }
        if (addrs == null && (oldAddrs = cache.putIfAbsent(host, addrs = new NameServiceAddresses(host, reqAddr))) != null) {
            addrs = oldAddrs;
        }
        return (InetAddress[])addrs.get().clone();
    }

    static InetAddress[] getAddressesFromNameService(String host, InetAddress reqAddr) throws UnknownHostException {
        InetAddress[] addresses = null;
        UnknownHostException ex = null;
        for (NameService nameService : nameServices) {
            try {
                addresses = nameService.lookupAllHostAddr(host);
                break;
            }
            catch (UnknownHostException uhe) {
                if (host.equalsIgnoreCase("localhost")) {
                    addresses = new InetAddress[]{impl.loopbackAddress()};
                    break;
                }
                ex = uhe;
            }
        }
        if (addresses == null) {
            throw ex == null ? new UnknownHostException(host) : ex;
        }
        if (reqAddr != null && addresses.length > 1 && !addresses[0].equals(reqAddr)) {
            int i;
            for (i = 1; i < addresses.length && !addresses[i].equals(reqAddr); ++i) {
            }
            if (i < addresses.length) {
                InetAddress tmp2 = reqAddr;
                for (int j = 0; j < i; ++j) {
                    InetAddress tmp = addresses[j];
                    addresses[j] = tmp2;
                    tmp2 = tmp;
                }
                addresses[i] = tmp2;
            }
        }
        return addresses;
    }

    public static InetAddress getByAddress(byte[] addr) throws UnknownHostException {
        return InetAddress.getByAddress(null, addr);
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        SecurityManager security = System.getSecurityManager();
        try {
            InetAddress localAddr;
            CachedLocalHost clh = cachedLocalHost;
            if (clh != null && clh.expiryTime - System.nanoTime() >= 0L) {
                if (security != null) {
                    security.checkConnect(clh.host, -1);
                }
                return clh.addr;
            }
            String local = impl.getLocalHostName();
            if (security != null) {
                security.checkConnect(local, -1);
            }
            if (local.equals("localhost")) {
                localAddr = impl.loopbackAddress();
            } else {
                try {
                    localAddr = InetAddress.getAllByName0(local, null, false, false)[0];
                }
                catch (UnknownHostException uhe) {
                    UnknownHostException uhe2 = new UnknownHostException(local + ": " + uhe.getMessage());
                    uhe2.initCause(uhe);
                    throw uhe2;
                }
            }
            cachedLocalHost = new CachedLocalHost(local, localAddr);
            return localAddr;
        }
        catch (SecurityException e) {
            return impl.loopbackAddress();
        }
    }

    private static native void init();

    static InetAddress anyLocalAddress() {
        return impl.anyLocalAddress();
    }

    static InetAddressImpl loadImpl(String implName) {
        Object impl = null;
        String prefix = AccessController.doPrivileged(new GetPropertyAction("impl.prefix", ""));
        try {
            impl = Class.forName("java.net." + prefix + implName).newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.println("Class not found: java.net." + prefix + implName + ":\ncheck impl.prefix property in your properties file.");
        }
        catch (InstantiationException e) {
            System.err.println("Could not instantiate: java.net." + prefix + implName + ":\ncheck impl.prefix property in your properties file.");
        }
        catch (IllegalAccessException e) {
            System.err.println("Cannot access class: java.net." + prefix + implName + ":\ncheck impl.prefix property in your properties file.");
        }
        if (impl == null) {
            try {
                impl = Class.forName(implName).newInstance();
            }
            catch (Exception e) {
                throw new Error("System property impl.prefix incorrect");
            }
        }
        return impl;
    }

    private void readObjectNoData(ObjectInputStream s) throws IOException, ClassNotFoundException {
        if (this.getClass().getClassLoader() != null) {
            throw new SecurityException("invalid address type");
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        if (this.getClass().getClassLoader() != null) {
            throw new SecurityException("invalid address type");
        }
        ObjectInputStream.GetField gf = s.readFields();
        String host = (String)gf.get("hostName", null);
        int address = gf.get("address", 0);
        int family = gf.get("family", 0);
        if (family != 1 && family != 2) {
            throw new InvalidObjectException("invalid address family type: " + family);
        }
        InetAddressHolder h = new InetAddressHolder(host, address, family);
        UNSAFE.putObject((Object)this, FIELDS_OFFSET, (Object)h);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.getClass().getClassLoader() != null) {
            throw new SecurityException("invalid address type");
        }
        ObjectOutputStream.PutField pf = s.putFields();
        pf.put("hostName", this.holder().getHostName());
        pf.put("address", this.holder().getAddress());
        pf.put("family", this.holder().getFamily());
        s.writeFields();
    }

    private static void validate(String host) throws UnknownHostException {
        if (host.indexOf(0) != -1) {
            throw new UnknownHostException("NUL character not allowed in hostname");
        }
    }

    static {
        NameService ns;
        preferIPv6Address = false;
        nameServices = null;
        preferIPv6Address = AccessController.doPrivileged(new GetBooleanAction("java.net.preferIPv6Addresses"));
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("net");
                return null;
            }
        });
        InetAddress.init();
        cache = new ConcurrentHashMap<String, Addresses>();
        expirySet = new ConcurrentSkipListSet<CachedAddresses>();
        impl = InetAddressImplFactory.create();
        String provider = null;
        String propPrefix = "sun.net.spi.nameservice.provider.";
        int n = 1;
        nameServices = new ArrayList<NameService>();
        provider = AccessController.doPrivileged(new GetPropertyAction(propPrefix + n));
        while (provider != null) {
            ns = InetAddress.createNSProvider(provider);
            if (ns != null) {
                nameServices.add(ns);
            }
            provider = AccessController.doPrivileged(new GetPropertyAction(propPrefix + ++n));
        }
        if (nameServices.size() == 0) {
            ns = InetAddress.createNSProvider("default");
            nameServices.add(ns);
        }
        try {
            Unsafe unsafe = Unsafe.getUnsafe();
            FIELDS_OFFSET = unsafe.objectFieldOffset(InetAddress.class.getDeclaredField("holder"));
            UNSAFE = unsafe;
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("hostName", String.class), new ObjectStreamField("address", Integer.TYPE), new ObjectStreamField("family", Integer.TYPE)};
    }

    private static final class CachedLocalHost {
        final String host;
        final InetAddress addr;
        final long expiryTime = System.nanoTime() + 5000000000L;

        CachedLocalHost(String host, InetAddress addr) {
            this.host = host;
            this.addr = addr;
        }
    }

    private static final class NameServiceAddresses
    implements Addresses {
        private final String host;
        private final InetAddress reqAddr;

        NameServiceAddresses(String host, InetAddress reqAddr) {
            this.host = host;
            this.reqAddr = reqAddr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InetAddress[] get() throws UnknownHostException {
            Addresses addresses;
            NameServiceAddresses nameServiceAddresses = this;
            synchronized (nameServiceAddresses) {
                addresses = cache.putIfAbsent(this.host, this);
                if (addresses == null) {
                    addresses = this;
                }
                if (addresses == this) {
                    int cachePolicy;
                    UnknownHostException ex;
                    InetAddress[] inetAddresses;
                    try {
                        inetAddresses = InetAddress.getAddressesFromNameService(this.host, this.reqAddr);
                        ex = null;
                        cachePolicy = InetAddressCachePolicy.get();
                    }
                    catch (UnknownHostException uhe) {
                        inetAddresses = null;
                        ex = uhe;
                        cachePolicy = InetAddressCachePolicy.getNegative();
                    }
                    if (cachePolicy == 0) {
                        cache.remove(this.host, this);
                    } else {
                        CachedAddresses cachedAddresses = new CachedAddresses(this.host, inetAddresses, cachePolicy == -1 ? 0L : System.nanoTime() + 1000000000L * (long)cachePolicy);
                        if (cache.replace(this.host, this, cachedAddresses) && cachePolicy != -1) {
                            expirySet.add(cachedAddresses);
                        }
                    }
                    if (inetAddresses == null) {
                        throw ex == null ? new UnknownHostException(this.host) : ex;
                    }
                    return inetAddresses;
                }
            }
            return addresses.get();
        }
    }

    private static final class CachedAddresses
    implements Addresses,
    Comparable<CachedAddresses> {
        private static final AtomicLong seq = new AtomicLong();
        final String host;
        final InetAddress[] inetAddresses;
        final long expiryTime;
        final long id = seq.incrementAndGet();

        CachedAddresses(String host, InetAddress[] inetAddresses, long expiryTime) {
            this.host = host;
            this.inetAddresses = inetAddresses;
            this.expiryTime = expiryTime;
        }

        @Override
        public InetAddress[] get() throws UnknownHostException {
            if (this.inetAddresses == null) {
                throw new UnknownHostException(this.host);
            }
            return this.inetAddresses;
        }

        @Override
        public int compareTo(CachedAddresses other) {
            long diff = this.expiryTime - other.expiryTime;
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return Long.compare(this.id, other.id);
        }
    }

    private static interface Addresses {
        public InetAddress[] get() throws UnknownHostException;
    }

    static class InetAddressHolder {
        String originalHostName;
        String hostName;
        int address;
        int family;

        InetAddressHolder() {
        }

        InetAddressHolder(String hostName, int address, int family) {
            this.originalHostName = hostName;
            this.hostName = hostName;
            this.address = address;
            this.family = family;
        }

        void init(String hostName, int family) {
            this.originalHostName = hostName;
            this.hostName = hostName;
            if (family != -1) {
                this.family = family;
            }
        }

        String getHostName() {
            return this.hostName;
        }

        String getOriginalHostName() {
            return this.originalHostName;
        }

        int getAddress() {
            return this.address;
        }

        int getFamily() {
            return this.family;
        }
    }
}

