/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.util.LinkedList;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.Credentials;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbTgsReq;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.PAForUserEnc;
import sun.security.krb5.internal.PaPacOptions;
import sun.security.krb5.internal.ReferralsCache;
import sun.security.krb5.internal.Ticket;

public class CredentialsUtil {
    private static boolean DEBUG = Krb5.DEBUG;

    public static Credentials acquireS4U2selfCreds(PrincipalName user, Credentials ccreds) throws KrbException, IOException {
        Credentials creds;
        String localRealm;
        if (!ccreds.isForwardable()) {
            throw new KrbException("S4U2self needs a FORWARDABLE ticket");
        }
        PrincipalName sname = ccreds.getClient();
        String uRealm = user.getRealmString();
        if (!uRealm.equals(localRealm = ccreds.getClient().getRealmString())) {
            if (Config.DISABLE_REFERRALS) {
                throw new KrbException("Cross-realm S4U2Self request not possible when referrals are disabled.");
            }
            if (ccreds.getClientAlias() != null) {
                sname = ccreds.getClientAlias();
            }
            sname = new PrincipalName(sname.getNameType(), sname.getNameStrings(), new Realm(uRealm));
        }
        if (!(creds = CredentialsUtil.serviceCreds(KDCOptions.with(1), ccreds, ccreds.getClient(), sname, user, null, new PAData[]{new PAData(129, new PAForUserEnc(user, ccreds.getSessionKey()).asn1Encode()), new PAData(167, new PaPacOptions().setResourceBasedConstrainedDelegation(true).setClaims(true).asn1Encode())}, S4U2Type.SELF)).getClient().equals(user)) {
            throw new KrbException("S4U2self request not honored by KDC");
        }
        if (!creds.isForwardable()) {
            throw new KrbException("S4U2self ticket must be FORWARDABLE");
        }
        return creds;
    }

    public static Credentials acquireS4U2proxyCreds(String backend, Ticket second, PrincipalName client, Credentials ccreds) throws KrbException, IOException {
        Credentials creds;
        String localRealm;
        PrincipalName backendPrincipal = new PrincipalName(backend);
        String backendRealm = backendPrincipal.getRealmString();
        if (!backendRealm.equals(localRealm = ccreds.getClient().getRealmString())) {
            if (Config.DISABLE_REFERRALS) {
                throw new KrbException("Cross-realm S4U2Proxy request not possible when referrals are disabled.");
            }
            backendPrincipal = new PrincipalName(backendPrincipal.getNameType(), backendPrincipal.getNameStrings(), new Realm(localRealm));
        }
        if (!(creds = CredentialsUtil.serviceCreds(KDCOptions.with(14, 1), ccreds, ccreds.getClient(), backendPrincipal, null, new Ticket[]{second}, new PAData[]{new PAData(167, new PaPacOptions().setResourceBasedConstrainedDelegation(true).setClaims(true).asn1Encode())}, S4U2Type.PROXY)).getClient().equals(client)) {
            throw new KrbException("S4U2proxy request not honored by KDC");
        }
        return creds;
    }

    public static Credentials acquireServiceCreds(String service, Credentials ccreds) throws KrbException, IOException {
        PrincipalName sname = new PrincipalName(service, 0);
        return CredentialsUtil.serviceCreds(sname, ccreds);
    }

    private static Credentials getTGTforRealm(String localRealm, String serviceRealm, Credentials ccreds, boolean[] okAsDelegate) throws KrbException {
        String[] realms = Realm.getRealmsList(localRealm, serviceRealm);
        int i = 0;
        int k = 0;
        Credentials cTgt = null;
        Credentials newTgt = null;
        Credentials theTgt = null;
        PrincipalName tempService = null;
        String newTgtRealm = null;
        okAsDelegate[0] = true;
        cTgt = ccreds;
        i = 0;
        while (i < realms.length) {
            tempService = PrincipalName.tgsService(serviceRealm, realms[i]);
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: main loop: [" + i + "] tempService=" + tempService);
            }
            try {
                newTgt = CredentialsUtil.serviceCreds(tempService, cTgt);
            }
            catch (Exception exc) {
                newTgt = null;
            }
            if (newTgt == null) {
                if (DEBUG) {
                    System.out.println(">>> Credentials acquireServiceCreds: no tgt; searching thru capath");
                }
                newTgt = null;
                for (k = i + 1; newTgt == null && k < realms.length; ++k) {
                    tempService = PrincipalName.tgsService(realms[k], realms[i]);
                    if (DEBUG) {
                        System.out.println(">>> Credentials acquireServiceCreds: inner loop: [" + k + "] tempService=" + tempService);
                    }
                    try {
                        newTgt = CredentialsUtil.serviceCreds(tempService, cTgt);
                        continue;
                    }
                    catch (Exception exc) {
                        newTgt = null;
                    }
                }
            }
            if (newTgt == null) {
                if (!DEBUG) break;
                System.out.println(">>> Credentials acquireServiceCreds: no tgt; cannot get creds");
                break;
            }
            newTgtRealm = newTgt.getServer().getInstanceComponent();
            if (okAsDelegate[0] && !newTgt.checkDelegate()) {
                if (DEBUG) {
                    System.out.println(">>> Credentials acquireServiceCreds: global OK-AS-DELEGATE turned off at " + newTgt.getServer());
                }
                okAsDelegate[0] = false;
            }
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: got tgt");
            }
            if (newTgtRealm.equals(serviceRealm)) {
                theTgt = newTgt;
                break;
            }
            for (k = i + 1; k < realms.length && !newTgtRealm.equals(realms[k]); ++k) {
            }
            if (k >= realms.length) break;
            i = k;
            cTgt = newTgt;
            if (!DEBUG) continue;
            System.out.println(">>> Credentials acquireServiceCreds: continuing with main loop counter reset to " + i);
        }
        return theTgt;
    }

    private static Credentials serviceCreds(PrincipalName service, Credentials ccreds) throws KrbException, IOException {
        return CredentialsUtil.serviceCreds(new KDCOptions(), ccreds, ccreds.getClient(), service, null, null, null, S4U2Type.NONE);
    }

    private static Credentials serviceCreds(KDCOptions options, Credentials asCreds, PrincipalName cname, PrincipalName sname, PrincipalName user, Ticket[] additionalTickets, PAData[] extraPAs, S4U2Type s4u2Type) throws KrbException, IOException {
        if (!Config.DISABLE_REFERRALS) {
            try {
                return CredentialsUtil.serviceCredsReferrals(options, asCreds, cname, sname, s4u2Type, user, additionalTickets, extraPAs);
            }
            catch (KrbException krbException) {
                // empty catch block
            }
        }
        return CredentialsUtil.serviceCredsSingle(options, asCreds, cname, asCreds.getClientAlias(), sname, sname, s4u2Type, user, additionalTickets, extraPAs);
    }

    private static Credentials serviceCredsReferrals(KDCOptions options, Credentials asCreds, PrincipalName cname, PrincipalName sname, S4U2Type s4u2Type, PrincipalName user, Ticket[] additionalTickets, PAData[] extraPAs) throws KrbException, IOException {
        options = new KDCOptions(options.toBooleanArray());
        options.set(15, true);
        PrincipalName cSname = sname;
        PrincipalName refSname = sname;
        Credentials creds = null;
        boolean isReferral = false;
        LinkedList<String> referrals = new LinkedList<String>();
        PrincipalName clientAlias = asCreds.getClientAlias();
        while (referrals.size() <= Config.MAX_REFERRALS) {
            ReferralsCache.ReferralCacheEntry ref = ReferralsCache.get(cname, sname, user, additionalTickets, refSname.getRealmString());
            String toRealm = null;
            if (ref == null) {
                String[] serverNameStrings;
                creds = CredentialsUtil.serviceCredsSingle(options, asCreds, cname, clientAlias, refSname, cSname, s4u2Type, user, additionalTickets, extraPAs);
                PrincipalName server = creds.getServer();
                if (!refSname.equals(server) && (serverNameStrings = server.getNameStrings()).length == 2 && serverNameStrings[0].equals("krbtgt") && !refSname.getRealmAsString().equals(serverNameStrings[1])) {
                    ReferralsCache.put(cname, sname, user, additionalTickets, server.getRealmString(), serverNameStrings[1], creds);
                    toRealm = serverNameStrings[1];
                    isReferral = true;
                }
            } else {
                creds = ref.getCreds();
                toRealm = ref.getToRealm();
                isReferral = true;
            }
            if (!isReferral) break;
            if (s4u2Type == S4U2Type.PROXY) {
                Credentials[] credsInOut = new Credentials[]{creds, null};
                toRealm = CredentialsUtil.handleS4U2ProxyReferral(asCreds, credsInOut, sname);
                creds = credsInOut[0];
                if (additionalTickets == null || additionalTickets.length == 0 || credsInOut[1] == null) {
                    throw new KrbException("Additional tickets expected for S4U2Proxy.");
                }
                additionalTickets[0] = credsInOut[1].getTicket();
            } else if (s4u2Type == S4U2Type.SELF) {
                CredentialsUtil.handleS4U2SelfReferral(extraPAs, user, creds);
            }
            if (referrals.contains(toRealm)) {
                return null;
            }
            asCreds = creds;
            refSname = new PrincipalName(refSname.getNameString(), refSname.getNameType(), toRealm);
            referrals.add(toRealm);
            isReferral = false;
        }
        return creds;
    }

    private static Credentials serviceCredsSingle(KDCOptions options, Credentials asCreds, PrincipalName cname, PrincipalName clientAlias, PrincipalName refSname, PrincipalName sname, S4U2Type s4u2Type, PrincipalName user, Ticket[] additionalTickets, PAData[] extraPAs) throws KrbException, IOException {
        Credentials theCreds = null;
        boolean[] okAsDelegate = new boolean[]{true};
        String[] serverAsCredsNames = asCreds.getServer().getNameStrings();
        String tgtRealm = serverAsCredsNames[1];
        String serviceRealm = refSname.getRealmString();
        if (!serviceRealm.equals(tgtRealm)) {
            Credentials newTgt;
            if (DEBUG) {
                System.out.println(">>> serviceCredsSingle: cross-realm authentication");
                System.out.println(">>> serviceCredsSingle: obtaining credentials from " + tgtRealm + " to " + serviceRealm);
            }
            if ((newTgt = CredentialsUtil.getTGTforRealm(tgtRealm, serviceRealm, asCreds, okAsDelegate)) == null) {
                throw new KrbApErrException(63, "No service creds");
            }
            if (DEBUG) {
                System.out.println(">>> Cross-realm TGT Credentials serviceCredsSingle: ");
                Credentials.printDebug(newTgt);
            }
            if (s4u2Type == S4U2Type.SELF) {
                CredentialsUtil.handleS4U2SelfReferral(extraPAs, user, newTgt);
            }
            asCreds = newTgt;
            cname = asCreds.getClient();
        } else if (DEBUG) {
            System.out.println(">>> Credentials serviceCredsSingle: same realm");
        }
        KrbTgsReq req = new KrbTgsReq(options, asCreds, cname, clientAlias, refSname, sname, additionalTickets, extraPAs);
        theCreds = req.sendAndGetCreds();
        if (theCreds != null) {
            if (DEBUG) {
                System.out.println(">>> TGS credentials serviceCredsSingle:");
                Credentials.printDebug(theCreds);
            }
            if (!okAsDelegate[0]) {
                theCreds.resetDelegate();
            }
        }
        return theCreds;
    }

    private static void handleS4U2SelfReferral(PAData[] pas, PrincipalName user, Credentials newCreds) throws Asn1Exception, KrbException, IOException {
        if (DEBUG) {
            System.out.println(">>> Handling S4U2Self referral");
        }
        for (int i = 0; i < pas.length; ++i) {
            PAData pa = pas[i];
            if (pa.getType() != 129) continue;
            pas[i] = new PAData(129, new PAForUserEnc(user, newCreds.getSessionKey()).asn1Encode());
            break;
        }
    }

    private static String handleS4U2ProxyReferral(Credentials asCreds, Credentials[] credsInOut, PrincipalName sname) throws KrbException, IOException {
        if (DEBUG) {
            System.out.println(">>> Handling S4U2Proxy referral");
        }
        Credentials refTGT = null;
        Credentials middleSvcCredsInBackendRealm = CredentialsUtil.serviceCreds(sname, asCreds);
        String backendRealm = middleSvcCredsInBackendRealm.getServer().getRealmString();
        String toRealm = credsInOut[0].getServer().getNameStrings()[1];
        refTGT = !toRealm.equals(backendRealm) ? CredentialsUtil.getTGTforRealm(toRealm, backendRealm, credsInOut[0], new boolean[1]) : credsInOut[0];
        credsInOut[0] = CredentialsUtil.getTGTforRealm(asCreds.getClient().getRealmString(), backendRealm, asCreds, new boolean[1]);
        credsInOut[1] = refTGT;
        return backendRealm;
    }

    private static enum S4U2Type {
        NONE,
        SELF,
        PROXY;

    }
}

