/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.ScrollbarPeer;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XHorizontalScrollbar;
import sun.awt.X11.XScrollbar;
import sun.awt.X11.XScrollbarClient;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XVerticalScrollbar;
import sun.util.logging.PlatformLogger;

class XScrollbarPeer
extends XComponentPeer
implements ScrollbarPeer,
XScrollbarClient {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XScrollbarPeer");
    private static final int DEFAULT_LENGTH = 50;
    private static final int DEFAULT_WIDTH_SOLARIS = 19;
    private static final int DEFAULT_WIDTH_LINUX = XToolkit.getUIDefaults().getInt("ScrollBar.defaultWidth");
    XScrollbar tsb;

    @Override
    public void preInit(XCreateWindowParams params) {
        super.preInit(params);
        Scrollbar target = (Scrollbar)this.target;
        this.tsb = target.getOrientation() == 1 ? new XVerticalScrollbar(this) : new XHorizontalScrollbar(this);
        int min = target.getMinimum();
        int max = target.getMaximum();
        int vis = target.getVisibleAmount();
        int val = target.getValue();
        int line = target.getLineIncrement();
        int page = target.getPageIncrement();
        this.tsb.setValues(val, vis, min, max, line, page);
    }

    XScrollbarPeer(Scrollbar target) {
        super(target);
        this.target = target;
        this.xSetVisible(true);
    }

    private int getDefaultDimension() {
        if (System.getProperty("os.name").equals("Linux")) {
            return DEFAULT_WIDTH_LINUX;
        }
        return 19;
    }

    @Override
    public Dimension getMinimumSize() {
        Scrollbar sb = (Scrollbar)this.target;
        return sb.getOrientation() == 1 ? new Dimension(this.getDefaultDimension(), 50) : new Dimension(50, this.getDefaultDimension());
    }

    @Override
    void paintPeer(Graphics g) {
        Color[] colors = this.getGUIcolors();
        g.setColor(colors[0]);
        this.tsb.paint(g, colors, true);
    }

    @Override
    public void repaintScrollbarRequest(XScrollbar sb) {
        this.repaint();
    }

    @Override
    public void notifyValue(XScrollbar obj, int type, int value, boolean isAdjusting) {
        Scrollbar sb = (Scrollbar)this.target;
        sb.setValue(value);
        this.postEvent(new AdjustmentEvent(sb, 601, type, value, isAdjusting));
    }

    @Override
    public void handleJavaMouseEvent(MouseEvent mouseEvent) {
        super.handleJavaMouseEvent(mouseEvent);
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        int modifiers = mouseEvent.getModifiers();
        int id = mouseEvent.getID();
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                this.target.requestFocus();
                this.tsb.handleMouseEvent(id, modifiers, x, y);
                break;
            }
            case 502: {
                this.tsb.handleMouseEvent(id, modifiers, x, y);
                break;
            }
            case 506: {
                this.tsb.handleMouseEvent(id, modifiers, x, y);
            }
        }
    }

    @Override
    public void handleJavaKeyEvent(KeyEvent event) {
        super.handleJavaKeyEvent(event);
        if (log.isLoggable(PlatformLogger.Level.FINER)) {
            log.finer("KeyEvent on scrollbar: " + event);
        }
        if (!event.isConsumed() && event.getID() == 402) {
            switch (event.getKeyCode()) {
                case 38: {
                    log.finer("Scrolling up");
                    this.tsb.notifyValue(this.tsb.getValue() - this.tsb.getUnitIncrement());
                    break;
                }
                case 40: {
                    log.finer("Scrolling down");
                    this.tsb.notifyValue(this.tsb.getValue() + this.tsb.getUnitIncrement());
                    break;
                }
                case 37: {
                    log.finer("Scrolling up");
                    this.tsb.notifyValue(this.tsb.getValue() - this.tsb.getUnitIncrement());
                    break;
                }
                case 39: {
                    log.finer("Scrolling down");
                    this.tsb.notifyValue(this.tsb.getValue() + this.tsb.getUnitIncrement());
                    break;
                }
                case 33: {
                    log.finer("Scrolling page up");
                    this.tsb.notifyValue(this.tsb.getValue() - this.tsb.getBlockIncrement());
                    break;
                }
                case 34: {
                    log.finer("Scrolling page down");
                    this.tsb.notifyValue(this.tsb.getValue() + this.tsb.getBlockIncrement());
                    break;
                }
                case 36: {
                    log.finer("Scrolling to home");
                    this.tsb.notifyValue(0);
                    break;
                }
                case 35: {
                    log.finer("Scrolling to end");
                    this.tsb.notifyValue(this.tsb.getMaximum());
                }
            }
        }
    }

    public void setValue(int value) {
        this.tsb.setValue(value);
        this.repaint();
    }

    @Override
    public void setValues(int value, int visible, int minimum, int maximum) {
        this.tsb.setValues(value, visible, minimum, maximum);
        this.repaint();
    }

    @Override
    public void setLineIncrement(int l) {
        this.tsb.setUnitIncrement(l);
    }

    @Override
    public void setPageIncrement(int p) {
        this.tsb.setBlockIncrement(p);
    }

    @Override
    public void layout() {
        super.layout();
        this.tsb.setSize(this.width, this.height);
    }
}

