/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.internal.KerberosTime;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class PAEncTSEnc {
    public KerberosTime pATimeStamp;
    public Integer pAUSec;

    public PAEncTSEnc(KerberosTime new_pATimeStamp, Integer new_pAUSec) {
        this.pATimeStamp = new_pATimeStamp;
        this.pAUSec = new_pAUSec;
    }

    public PAEncTSEnc() {
        KerberosTime now;
        this.pATimeStamp = now = KerberosTime.now();
        this.pAUSec = new Integer(now.getMicroSeconds());
    }

    public PAEncTSEnc(DerValue encoding) throws Asn1Exception, IOException {
        if (encoding.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        this.pATimeStamp = KerberosTime.parse(encoding.getData(), (byte)0, false);
        if (encoding.getData().available() > 0) {
            DerValue der = encoding.getData().getDerValue();
            if ((der.getTag() & 0x1F) == 1) {
                this.pAUSec = new Integer(der.getData().getBigInteger().intValue());
            } else {
                throw new Asn1Exception(906);
            }
        }
        if (encoding.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), this.pATimeStamp.asn1Encode());
        if (this.pAUSec != null) {
            temp = new DerOutputStream();
            temp.putInteger(BigInteger.valueOf(this.pAUSec.intValue()));
            bytes.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
        }
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        return temp.toByteArray();
    }
}

