/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.InfoFromMemberName;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleInfo;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.security.Permission;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.VerifyAccess;
import sun.invoke.util.Wrapper;
import sun.misc.VM;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;
import sun.security.util.SecurityConstants;

public class MethodHandles {
    private static final MemberName.Factory IMPL_NAMES = MemberName.getFactory();
    private static final Permission ACCESS_PERMISSION;
    private static final MethodHandle[] IDENTITY_MHS;
    private static final MethodHandle[] ZERO_MHS;

    private MethodHandles() {
    }

    @CallerSensitive
    public static Lookup lookup() {
        return new Lookup(Reflection.getCallerClass());
    }

    public static Lookup publicLookup() {
        return Lookup.PUBLIC_LOOKUP;
    }

    public static <T extends Member> T reflectAs(Class<T> expected, MethodHandle target) {
        SecurityManager smgr = System.getSecurityManager();
        if (smgr != null) {
            smgr.checkPermission(ACCESS_PERMISSION);
        }
        Lookup lookup = Lookup.IMPL_LOOKUP;
        return lookup.revealDirect(target).reflectAs(expected, lookup);
    }

    public static MethodHandle arrayElementGetter(Class<?> arrayClass) throws IllegalArgumentException {
        return MethodHandleImpl.makeArrayElementAccessor(arrayClass, false);
    }

    public static MethodHandle arrayElementSetter(Class<?> arrayClass) throws IllegalArgumentException {
        return MethodHandleImpl.makeArrayElementAccessor(arrayClass, true);
    }

    public static MethodHandle spreadInvoker(MethodType type, int leadingArgCount) {
        if (leadingArgCount < 0 || leadingArgCount > type.parameterCount()) {
            throw MethodHandleStatics.newIllegalArgumentException("bad argument count", leadingArgCount);
        }
        type = type.asSpreaderType(Object[].class, type.parameterCount() - leadingArgCount);
        return type.invokers().spreadInvoker(leadingArgCount);
    }

    public static MethodHandle exactInvoker(MethodType type) {
        return type.invokers().exactInvoker();
    }

    public static MethodHandle invoker(MethodType type) {
        return type.invokers().genericInvoker();
    }

    static MethodHandle basicInvoker(MethodType type) {
        return type.invokers().basicInvoker();
    }

    public static MethodHandle explicitCastArguments(MethodHandle target, MethodType newType) {
        MethodHandles.explicitCastArgumentsChecks(target, newType);
        MethodType oldType = target.type();
        if (oldType == newType) {
            return target;
        }
        if (oldType.explicitCastEquivalentToAsType(newType)) {
            return target.asFixedArity().asType(newType);
        }
        return MethodHandleImpl.makePairwiseConvert(target, newType, false);
    }

    private static void explicitCastArgumentsChecks(MethodHandle target, MethodType newType) {
        if (target.type().parameterCount() != newType.parameterCount()) {
            throw new WrongMethodTypeException("cannot explicitly cast " + target + " to " + newType);
        }
    }

    public static MethodHandle permuteArguments(MethodHandle target, MethodType newType, int ... reorder) {
        int ddIdx;
        reorder = (int[])reorder.clone();
        MethodType oldType = target.type();
        MethodHandles.permuteArgumentChecks(reorder, newType, oldType);
        int[] originalReorder = reorder;
        BoundMethodHandle result = target.rebind();
        LambdaForm form = result.form;
        int newArity = newType.parameterCount();
        while ((ddIdx = MethodHandles.findFirstDupOrDrop(reorder, newArity)) != 0) {
            if (ddIdx > 0) {
                int val;
                int srcPos;
                int dstPos = srcPos = ddIdx;
                int dupVal = reorder[srcPos];
                boolean killFirst = false;
                while ((val = reorder[--dstPos]) != dupVal) {
                    if (dupVal <= val) continue;
                    killFirst = true;
                }
                if (!killFirst) {
                    srcPos = dstPos;
                    dstPos = ddIdx;
                }
                form = form.editor().dupArgumentForm(1 + srcPos, 1 + dstPos);
                assert (reorder[srcPos] == reorder[dstPos]);
                oldType = oldType.dropParameterTypes(dstPos, dstPos + 1);
                int tailPos = dstPos + 1;
                System.arraycopy(reorder, tailPos, reorder, dstPos, reorder.length - tailPos);
                reorder = Arrays.copyOf(reorder, reorder.length - 1);
            } else {
                int insPos;
                int dropVal = ~ddIdx;
                for (insPos = 0; insPos < reorder.length && reorder[insPos] < dropVal; ++insPos) {
                }
                Class<?> ptype = newType.parameterType(dropVal);
                form = form.editor().addArgumentForm(1 + insPos, LambdaForm.BasicType.basicType(ptype));
                oldType = oldType.insertParameterTypes(insPos, ptype);
                int tailPos = insPos + 1;
                reorder = Arrays.copyOf(reorder, reorder.length + 1);
                System.arraycopy(reorder, insPos, reorder, tailPos, reorder.length - tailPos);
                reorder[insPos] = dropVal;
            }
            assert (MethodHandles.permuteArgumentChecks(reorder, newType, oldType));
        }
        assert (reorder.length == newArity);
        form = form.editor().permuteArgumentsForm(1, reorder);
        if (newType == result.type() && form == result.internalForm()) {
            return result;
        }
        return result.copyWith(newType, form);
    }

    private static int findFirstDupOrDrop(int[] reorder, int newArity) {
        int BIT_LIMIT = 63;
        if (newArity < 63) {
            long mask = 0L;
            for (int i = 0; i < reorder.length; ++i) {
                int arg = reorder[i];
                if (arg >= newArity) {
                    return reorder.length;
                }
                long bit = 1L << arg;
                if ((mask & bit) != 0L) {
                    return i;
                }
                mask |= bit;
            }
            if (mask == (1L << newArity) - 1L) {
                assert (Long.numberOfTrailingZeros(Long.lowestOneBit(mask ^ 0xFFFFFFFFFFFFFFFFL)) == newArity);
                return 0;
            }
            long zeroBit = Long.lowestOneBit(mask ^ 0xFFFFFFFFFFFFFFFFL);
            int zeroPos = Long.numberOfTrailingZeros(zeroBit);
            assert (zeroPos <= newArity);
            if (zeroPos == newArity) {
                return 0;
            }
            return ~zeroPos;
        }
        BitSet mask = new BitSet(newArity);
        for (int i = 0; i < reorder.length; ++i) {
            int arg = reorder[i];
            if (arg >= newArity) {
                return reorder.length;
            }
            if (mask.get(arg)) {
                return i;
            }
            mask.set(arg);
        }
        int zeroPos = mask.nextClearBit(0);
        assert (zeroPos <= newArity);
        if (zeroPos == newArity) {
            return 0;
        }
        return ~zeroPos;
    }

    private static boolean permuteArgumentChecks(int[] reorder, MethodType newType, MethodType oldType) {
        if (newType.returnType() != oldType.returnType()) {
            throw MethodHandleStatics.newIllegalArgumentException("return types do not match", oldType, newType);
        }
        if (reorder.length == oldType.parameterCount()) {
            int limit = newType.parameterCount();
            boolean bad = false;
            for (int j = 0; j < reorder.length; ++j) {
                Class<?> dst;
                int i = reorder[j];
                if (i < 0 || i >= limit) {
                    bad = true;
                    break;
                }
                Class<?> src = newType.parameterType(i);
                if (src == (dst = oldType.parameterType(j))) continue;
                throw MethodHandleStatics.newIllegalArgumentException("parameter types do not match after reorder", oldType, newType);
            }
            if (!bad) {
                return true;
            }
        }
        throw MethodHandleStatics.newIllegalArgumentException("bad reorder array: " + Arrays.toString(reorder));
    }

    public static MethodHandle constant(Class<?> type, Object value) {
        if (type.isPrimitive()) {
            if (type == Void.TYPE) {
                throw MethodHandleStatics.newIllegalArgumentException("void type");
            }
            Wrapper w = Wrapper.forPrimitiveType(type);
            value = w.convert(value, type);
            if (w.zero().equals(value)) {
                return MethodHandles.zero(w, type);
            }
            return MethodHandles.insertArguments(MethodHandles.identity(type), 0, value);
        }
        if (value == null) {
            return MethodHandles.zero(Wrapper.OBJECT, type);
        }
        return MethodHandles.identity(type).bindTo(value);
    }

    public static MethodHandle identity(Class<?> type) {
        Wrapper btw = type.isPrimitive() ? Wrapper.forPrimitiveType(type) : Wrapper.OBJECT;
        int pos = btw.ordinal();
        MethodHandle ident = IDENTITY_MHS[pos];
        if (ident == null) {
            ident = MethodHandles.setCachedMethodHandle(IDENTITY_MHS, pos, MethodHandles.makeIdentity(btw.primitiveType()));
        }
        if (ident.type().returnType() == type) {
            return ident;
        }
        assert (btw == Wrapper.OBJECT);
        return MethodHandles.makeIdentity(type);
    }

    private static MethodHandle makeIdentity(Class<?> ptype) {
        MethodType mtype = MethodType.methodType(ptype, ptype);
        LambdaForm lform = LambdaForm.identityForm(LambdaForm.BasicType.basicType(ptype));
        return MethodHandleImpl.makeIntrinsic(mtype, lform, MethodHandleImpl.Intrinsic.IDENTITY);
    }

    private static MethodHandle zero(Wrapper btw, Class<?> rtype) {
        int pos = btw.ordinal();
        MethodHandle zero = ZERO_MHS[pos];
        if (zero == null) {
            zero = MethodHandles.setCachedMethodHandle(ZERO_MHS, pos, MethodHandles.makeZero(btw.primitiveType()));
        }
        if (zero.type().returnType() == rtype) {
            return zero;
        }
        assert (btw == Wrapper.OBJECT);
        return MethodHandles.makeZero(rtype);
    }

    private static MethodHandle makeZero(Class<?> rtype) {
        MethodType mtype = MethodType.methodType(rtype);
        LambdaForm lform = LambdaForm.zeroForm(LambdaForm.BasicType.basicType(rtype));
        return MethodHandleImpl.makeIntrinsic(mtype, lform, MethodHandleImpl.Intrinsic.ZERO);
    }

    private static synchronized MethodHandle setCachedMethodHandle(MethodHandle[] cache, int pos, MethodHandle value) {
        MethodHandle prev = cache[pos];
        if (prev != null) {
            return prev;
        }
        cache[pos] = value;
        return cache[pos];
    }

    public static MethodHandle insertArguments(MethodHandle target, int pos, Object ... values) {
        int insCount = values.length;
        Class<?>[] ptypes = MethodHandles.insertArgumentsChecks(target, insCount, pos);
        if (insCount == 0) {
            return target;
        }
        BoundMethodHandle result = target.rebind();
        for (int i = 0; i < insCount; ++i) {
            Object value = values[i];
            Class<?> ptype = ptypes[pos + i];
            if (ptype.isPrimitive()) {
                result = MethodHandles.insertArgumentPrimitive(result, pos, ptype, value);
                continue;
            }
            value = ptype.cast(value);
            result = result.bindArgumentL(pos, value);
        }
        return result;
    }

    private static BoundMethodHandle insertArgumentPrimitive(BoundMethodHandle result, int pos, Class<?> ptype, Object value) {
        Wrapper w = Wrapper.forPrimitiveType(ptype);
        value = w.convert(value, ptype);
        switch (w) {
            case INT: {
                return result.bindArgumentI(pos, (Integer)value);
            }
            case LONG: {
                return result.bindArgumentJ(pos, (Long)value);
            }
            case FLOAT: {
                return result.bindArgumentF(pos, ((Float)value).floatValue());
            }
            case DOUBLE: {
                return result.bindArgumentD(pos, (Double)value);
            }
        }
        return result.bindArgumentI(pos, ValueConversions.widenSubword(value));
    }

    private static Class<?>[] insertArgumentsChecks(MethodHandle target, int insCount, int pos) throws RuntimeException {
        MethodType oldType = target.type();
        int outargs = oldType.parameterCount();
        int inargs = outargs - insCount;
        if (inargs < 0) {
            throw MethodHandleStatics.newIllegalArgumentException("too many values to insert");
        }
        if (pos < 0 || pos > inargs) {
            throw MethodHandleStatics.newIllegalArgumentException("no argument type to append");
        }
        return oldType.ptypes();
    }

    public static MethodHandle dropArguments(MethodHandle target, int pos, List<Class<?>> valueTypes) {
        valueTypes = MethodHandles.copyTypes(valueTypes);
        MethodType oldType = target.type();
        int dropped = MethodHandles.dropArgumentChecks(oldType, pos, valueTypes);
        MethodType newType = oldType.insertParameterTypes(pos, valueTypes);
        if (dropped == 0) {
            return target;
        }
        BoundMethodHandle result = target.rebind();
        LambdaForm lform = result.form;
        int insertFormArg = 1 + pos;
        for (Class<?> ptype : valueTypes) {
            lform = lform.editor().addArgumentForm(insertFormArg++, LambdaForm.BasicType.basicType(ptype));
        }
        result = result.copyWith(newType, lform);
        return result;
    }

    private static List<Class<?>> copyTypes(List<Class<?>> types) {
        Object[] a = types.toArray();
        return Arrays.asList(Arrays.copyOf(a, a.length, Class[].class));
    }

    private static int dropArgumentChecks(MethodType oldType, int pos, List<Class<?>> valueTypes) {
        int dropped = valueTypes.size();
        MethodType.checkSlotCount(dropped);
        int outargs = oldType.parameterCount();
        int inargs = outargs + dropped;
        if (pos < 0 || pos > outargs) {
            throw MethodHandleStatics.newIllegalArgumentException("no argument type to remove" + Arrays.asList(oldType, pos, valueTypes, inargs, outargs));
        }
        return dropped;
    }

    public static MethodHandle dropArguments(MethodHandle target, int pos, Class<?> ... valueTypes) {
        return MethodHandles.dropArguments(target, pos, Arrays.asList(valueTypes));
    }

    public static MethodHandle filterArguments(MethodHandle target, int pos, MethodHandle ... filters) {
        MethodHandles.filterArgumentsCheckArity(target, pos, filters);
        MethodHandle adapter = target;
        int curPos = pos - 1;
        for (MethodHandle filter : filters) {
            ++curPos;
            if (filter == null) continue;
            adapter = MethodHandles.filterArgument(adapter, curPos, filter);
        }
        return adapter;
    }

    static MethodHandle filterArgument(MethodHandle target, int pos, MethodHandle filter) {
        MethodHandles.filterArgumentChecks(target, pos, filter);
        MethodType targetType = target.type();
        MethodType filterType = filter.type();
        BoundMethodHandle result = target.rebind();
        Class<?> newParamType = filterType.parameterType(0);
        LambdaForm lform = result.editor().filterArgumentForm(1 + pos, LambdaForm.BasicType.basicType(newParamType));
        MethodType newType = targetType.changeParameterType(pos, newParamType);
        result = result.copyWithExtendL(newType, lform, filter);
        return result;
    }

    private static void filterArgumentsCheckArity(MethodHandle target, int pos, MethodHandle[] filters) {
        MethodType targetType = target.type();
        int maxPos = targetType.parameterCount();
        if (pos + filters.length > maxPos) {
            throw MethodHandleStatics.newIllegalArgumentException("too many filters");
        }
    }

    private static void filterArgumentChecks(MethodHandle target, int pos, MethodHandle filter) throws RuntimeException {
        MethodType targetType = target.type();
        MethodType filterType = filter.type();
        if (filterType.parameterCount() != 1 || filterType.returnType() != targetType.parameterType(pos)) {
            throw MethodHandleStatics.newIllegalArgumentException("target and filter types do not match", targetType, filterType);
        }
    }

    public static MethodHandle collectArguments(MethodHandle target, int pos, MethodHandle filter) {
        LambdaForm lform;
        MethodType newType = MethodHandles.collectArgumentsChecks(target, pos, filter);
        MethodType collectorType = filter.type();
        BoundMethodHandle result = target.rebind();
        if (collectorType.returnType().isArray() && filter.intrinsicName() == MethodHandleImpl.Intrinsic.NEW_ARRAY && (lform = result.editor().collectArgumentArrayForm(1 + pos, filter)) != null) {
            return result.copyWith(newType, lform);
        }
        lform = result.editor().collectArgumentsForm(1 + pos, collectorType.basicType());
        return result.copyWithExtendL(newType, lform, filter);
    }

    private static MethodType collectArgumentsChecks(MethodHandle target, int pos, MethodHandle filter) throws RuntimeException {
        MethodType targetType = target.type();
        MethodType filterType = filter.type();
        Class<?> rtype = filterType.returnType();
        List<Class<?>> filterArgs = filterType.parameterList();
        if (rtype == Void.TYPE) {
            return targetType.insertParameterTypes(pos, filterArgs);
        }
        if (rtype != targetType.parameterType(pos)) {
            throw MethodHandleStatics.newIllegalArgumentException("target and filter types do not match", targetType, filterType);
        }
        return targetType.dropParameterTypes(pos, pos + 1).insertParameterTypes(pos, filterArgs);
    }

    public static MethodHandle filterReturnValue(MethodHandle target, MethodHandle filter) {
        MethodType targetType = target.type();
        MethodType filterType = filter.type();
        MethodHandles.filterReturnValueChecks(targetType, filterType);
        BoundMethodHandle result = target.rebind();
        LambdaForm.BasicType rtype = LambdaForm.BasicType.basicType(filterType.returnType());
        LambdaForm lform = result.editor().filterReturnForm(rtype, false);
        MethodType newType = targetType.changeReturnType(filterType.returnType());
        result = result.copyWithExtendL(newType, lform, filter);
        return result;
    }

    private static void filterReturnValueChecks(MethodType targetType, MethodType filterType) throws RuntimeException {
        Class<?> rtype = targetType.returnType();
        int filterValues = filterType.parameterCount();
        if (filterValues == 0 ? rtype != Void.TYPE : rtype != filterType.parameterType(0) || filterValues != 1) {
            throw MethodHandleStatics.newIllegalArgumentException("target and filter types do not match", targetType, filterType);
        }
    }

    public static MethodHandle foldArguments(MethodHandle target, MethodHandle combiner) {
        int foldPos = 0;
        MethodType targetType = target.type();
        MethodType combinerType = combiner.type();
        Class<?> rtype = MethodHandles.foldArgumentChecks(foldPos, targetType, combinerType);
        BoundMethodHandle result = target.rebind();
        boolean dropResult = rtype == Void.TYPE;
        LambdaForm lform = result.editor().foldArgumentsForm(1 + foldPos, dropResult, combinerType.basicType());
        MethodType newType = targetType;
        if (!dropResult) {
            newType = newType.dropParameterTypes(foldPos, foldPos + 1);
        }
        result = result.copyWithExtendL(newType, lform, combiner);
        return result;
    }

    private static Class<?> foldArgumentChecks(int foldPos, MethodType targetType, MethodType combinerType) {
        boolean ok;
        int foldArgs = combinerType.parameterCount();
        Class<?> rtype = combinerType.returnType();
        int foldVals = rtype == Void.TYPE ? 0 : 1;
        int afterInsertPos = foldPos + foldVals;
        boolean bl = ok = targetType.parameterCount() >= afterInsertPos + foldArgs;
        if (ok && !combinerType.parameterList().equals(targetType.parameterList().subList(afterInsertPos, afterInsertPos + foldArgs))) {
            ok = false;
        }
        if (ok && foldVals != 0 && combinerType.returnType() != targetType.parameterType(0)) {
            ok = false;
        }
        if (!ok) {
            throw MethodHandles.misMatchedTypes("target and combiner types", targetType, combinerType);
        }
        return rtype;
    }

    public static MethodHandle guardWithTest(MethodHandle test, MethodHandle target, MethodHandle fallback) {
        List<Class<?>> gargs;
        MethodType ftype;
        MethodType gtype = test.type();
        MethodType ttype = target.type();
        if (!ttype.equals((Object)(ftype = fallback.type()))) {
            throw MethodHandles.misMatchedTypes("target and fallback types", ttype, ftype);
        }
        if (gtype.returnType() != Boolean.TYPE) {
            throw MethodHandleStatics.newIllegalArgumentException("guard type is not a predicate " + gtype);
        }
        List<Class<?>> targs = ttype.parameterList();
        if (!targs.equals(gargs = gtype.parameterList())) {
            int tpc;
            int gpc = gargs.size();
            if (gpc >= (tpc = targs.size()) || !targs.subList(0, gpc).equals(gargs)) {
                throw MethodHandles.misMatchedTypes("target and test types", ttype, gtype);
            }
            test = MethodHandles.dropArguments(test, gpc, targs.subList(gpc, tpc));
            gtype = test.type();
        }
        return MethodHandleImpl.makeGuardWithTest(test, target, fallback);
    }

    static RuntimeException misMatchedTypes(String what, MethodType t1, MethodType t2) {
        return MethodHandleStatics.newIllegalArgumentException(what + " must match: " + t1 + " != " + t2);
    }

    public static MethodHandle catchException(MethodHandle target, Class<? extends Throwable> exType, MethodHandle handler) {
        MethodType ttype = target.type();
        MethodType htype = handler.type();
        if (htype.parameterCount() < 1 || !htype.parameterType(0).isAssignableFrom(exType)) {
            throw MethodHandleStatics.newIllegalArgumentException("handler does not accept exception type " + exType);
        }
        if (htype.returnType() != ttype.returnType()) {
            throw MethodHandles.misMatchedTypes("target and handler return types", ttype, htype);
        }
        List<Class<?>> targs = ttype.parameterList();
        List<Class<?>> hargs = htype.parameterList();
        if (!targs.equals(hargs = hargs.subList(1, hargs.size()))) {
            int tpc;
            int hpc = hargs.size();
            if (hpc >= (tpc = targs.size()) || !targs.subList(0, hpc).equals(hargs)) {
                throw MethodHandles.misMatchedTypes("target and handler types", ttype, htype);
            }
            handler = MethodHandles.dropArguments(handler, 1 + hpc, targs.subList(hpc, tpc));
            htype = handler.type();
        }
        return MethodHandleImpl.makeGuardWithCatch(target, exType, handler);
    }

    public static MethodHandle throwException(Class<?> returnType, Class<? extends Throwable> exType) {
        if (!Throwable.class.isAssignableFrom(exType)) {
            throw new ClassCastException(exType.getName());
        }
        return MethodHandleImpl.throwException(MethodType.methodType(returnType, exType));
    }

    static {
        MethodHandleImpl.initStatics();
        ACCESS_PERMISSION = new ReflectPermission("suppressAccessChecks");
        IDENTITY_MHS = new MethodHandle[Wrapper.values().length];
        ZERO_MHS = new MethodHandle[Wrapper.values().length];
    }

    public static final class Lookup {
        private final Class<?> lookupClass;
        private final int allowedModes;
        public static final int PUBLIC = 1;
        public static final int PRIVATE = 2;
        public static final int PROTECTED = 4;
        public static final int PACKAGE = 8;
        private static final int ALL_MODES = 15;
        private static final int TRUSTED = -1;
        static final Lookup PUBLIC_LOOKUP;
        static final Lookup IMPL_LOOKUP;
        private static final boolean ALLOW_NESTMATE_ACCESS = false;
        static ConcurrentHashMap<MemberName, DirectMethodHandle> LOOKASIDE_TABLE;

        private static int fixmods(int mods) {
            return (mods &= 7) != 0 ? mods : 8;
        }

        public Class<?> lookupClass() {
            return this.lookupClass;
        }

        private Class<?> lookupClassOrNull() {
            return this.allowedModes == -1 ? null : this.lookupClass;
        }

        public int lookupModes() {
            return this.allowedModes & 0xF;
        }

        Lookup(Class<?> lookupClass) {
            this(lookupClass, 15);
            Lookup.checkUnprivilegedlookupClass(lookupClass, 15);
        }

        private Lookup(Class<?> lookupClass, int allowedModes) {
            this.lookupClass = lookupClass;
            this.allowedModes = allowedModes;
        }

        public Lookup in(Class<?> requestedLookupClass) {
            requestedLookupClass.getClass();
            if (this.allowedModes == -1) {
                return new Lookup(requestedLookupClass, 15);
            }
            if (requestedLookupClass == this.lookupClass) {
                return this;
            }
            int newModes = this.allowedModes & 0xB;
            if ((newModes & 8) != 0 && !VerifyAccess.isSamePackage(this.lookupClass, requestedLookupClass)) {
                newModes &= 0xFFFFFFF5;
            }
            if ((newModes & 2) != 0 && !VerifyAccess.isSamePackageMember(this.lookupClass, requestedLookupClass)) {
                newModes &= 0xFFFFFFFD;
            }
            if ((newModes & 1) != 0 && !VerifyAccess.isClassAccessible(requestedLookupClass, this.lookupClass, this.allowedModes)) {
                newModes = 0;
            }
            Lookup.checkUnprivilegedlookupClass(requestedLookupClass, newModes);
            return new Lookup(requestedLookupClass, newModes);
        }

        private static void checkUnprivilegedlookupClass(Class<?> lookupClass, int allowedModes) {
            String name = lookupClass.getName();
            if (name.startsWith("java.lang.invoke.")) {
                throw MethodHandleStatics.newIllegalArgumentException("illegal lookupClass: " + lookupClass);
            }
            if (allowedModes == 15 && lookupClass.getClassLoader() == null && (name.startsWith("java.") || name.startsWith("sun.") && !name.startsWith("sun.invoke.") && !name.equals("sun.reflect.ReflectionFactory"))) {
                throw MethodHandleStatics.newIllegalArgumentException("illegal lookupClass: " + lookupClass);
            }
        }

        public String toString() {
            String cname = this.lookupClass.getName();
            switch (this.allowedModes) {
                case 0: {
                    return cname + "/noaccess";
                }
                case 1: {
                    return cname + "/public";
                }
                case 9: {
                    return cname + "/package";
                }
                case 11: {
                    return cname + "/private";
                }
                case 15: {
                    return cname;
                }
                case -1: {
                    return "/trusted";
                }
            }
            cname = cname + "/" + Integer.toHexString(this.allowedModes);
            assert (false) : cname;
            return cname;
        }

        public MethodHandle findStatic(Class<?> refc, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            MemberName method = this.resolveOrFail((byte)6, refc, name, type);
            return this.getDirectMethod((byte)6, refc, method, this.findBoundCallerClass(method));
        }

        public MethodHandle findVirtual(Class<?> refc, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            MethodHandle mh;
            if (refc == MethodHandle.class && (mh = this.findVirtualForMH(name, type)) != null) {
                return mh;
            }
            byte refKind = refc.isInterface() ? (byte)9 : 5;
            MemberName method = this.resolveOrFail(refKind, refc, name, type);
            return this.getDirectMethod(refKind, refc, method, this.findBoundCallerClass(method));
        }

        private MethodHandle findVirtualForMH(String name, MethodType type) {
            if ("invoke".equals(name)) {
                return MethodHandles.invoker(type);
            }
            if ("invokeExact".equals(name)) {
                return MethodHandles.exactInvoker(type);
            }
            assert (!MemberName.isMethodHandleInvokeName(name));
            return null;
        }

        public MethodHandle findConstructor(Class<?> refc, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            if (refc.isArray()) {
                throw new NoSuchMethodException("no constructor for array class: " + refc.getName());
            }
            String name = "<init>";
            MemberName ctor = this.resolveOrFail((byte)8, refc, name, type);
            return this.getDirectConstructor(refc, ctor);
        }

        public MethodHandle findSpecial(Class<?> refc, String name, MethodType type, Class<?> specialCaller) throws NoSuchMethodException, IllegalAccessException {
            this.checkSpecialCaller(specialCaller);
            Lookup specialLookup = this.in(specialCaller);
            MemberName method = specialLookup.resolveOrFail((byte)7, refc, name, type);
            return specialLookup.getDirectMethod((byte)7, refc, method, this.findBoundCallerClass(method));
        }

        public MethodHandle findGetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail((byte)1, refc, name, type);
            return this.getDirectField((byte)1, refc, field);
        }

        public MethodHandle findSetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail((byte)3, refc, name, type);
            return this.getDirectField((byte)3, refc, field);
        }

        public MethodHandle findStaticGetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail((byte)2, refc, name, type);
            return this.getDirectField((byte)2, refc, field);
        }

        public MethodHandle findStaticSetter(Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            MemberName field = this.resolveOrFail((byte)4, refc, name, type);
            return this.getDirectField((byte)4, refc, field);
        }

        public MethodHandle bind(Object receiver, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            Class<?> refc = receiver.getClass();
            MemberName method = this.resolveOrFail((byte)7, refc, name, type);
            MethodHandle mh = this.getDirectMethodNoRestrict((byte)7, refc, method, this.findBoundCallerClass(method));
            return mh.bindArgumentL(0, receiver).setVarargs(method);
        }

        public MethodHandle unreflect(Method m) throws IllegalAccessException {
            MethodHandle mh;
            if (m.getDeclaringClass() == MethodHandle.class && (mh = this.unreflectForMH(m)) != null) {
                return mh;
            }
            MemberName method = new MemberName(m);
            byte refKind = method.getReferenceKind();
            if (refKind == 7) {
                refKind = 5;
            }
            assert (method.isMethod());
            Lookup lookup = m.isAccessible() ? IMPL_LOOKUP : this;
            return lookup.getDirectMethodNoSecurityManager(refKind, method.getDeclaringClass(), method, this.findBoundCallerClass(method));
        }

        private MethodHandle unreflectForMH(Method m) {
            if (MemberName.isMethodHandleInvokeName(m.getName())) {
                return MethodHandleImpl.fakeMethodHandleInvoke(new MemberName(m));
            }
            return null;
        }

        public MethodHandle unreflectSpecial(Method m, Class<?> specialCaller) throws IllegalAccessException {
            this.checkSpecialCaller(specialCaller);
            Lookup specialLookup = this.in(specialCaller);
            MemberName method = new MemberName(m, true);
            assert (method.isMethod());
            return specialLookup.getDirectMethodNoSecurityManager((byte)7, method.getDeclaringClass(), method, this.findBoundCallerClass(method));
        }

        public MethodHandle unreflectConstructor(Constructor<?> c) throws IllegalAccessException {
            MemberName ctor = new MemberName(c);
            assert (ctor.isConstructor());
            Lookup lookup = c.isAccessible() ? IMPL_LOOKUP : this;
            return lookup.getDirectConstructorNoSecurityManager(ctor.getDeclaringClass(), ctor);
        }

        public MethodHandle unreflectGetter(Field f) throws IllegalAccessException {
            return this.unreflectField(f, false);
        }

        private MethodHandle unreflectField(Field f, boolean isSetter) throws IllegalAccessException {
            MemberName field = new MemberName(f, isSetter);
            assert (!isSetter ? MethodHandleNatives.refKindIsGetter(field.getReferenceKind()) : MethodHandleNatives.refKindIsSetter(field.getReferenceKind()));
            Lookup lookup = f.isAccessible() ? IMPL_LOOKUP : this;
            return lookup.getDirectFieldNoSecurityManager(field.getReferenceKind(), f.getDeclaringClass(), field);
        }

        public MethodHandle unreflectSetter(Field f) throws IllegalAccessException {
            return this.unreflectField(f, true);
        }

        public MethodHandleInfo revealDirect(MethodHandle target) {
            MemberName member = target.internalMemberName();
            if (member == null || !member.isResolved() && !member.isMethodHandleInvoke()) {
                throw MethodHandleStatics.newIllegalArgumentException("not a direct method handle");
            }
            Class<?> defc = member.getDeclaringClass();
            byte refKind = member.getReferenceKind();
            assert (MethodHandleNatives.refKindIsValid(refKind));
            if (refKind == 7 && !target.isInvokeSpecial()) {
                refKind = 5;
            }
            if (refKind == 5 && defc.isInterface()) {
                refKind = 9;
            }
            try {
                this.checkAccess(refKind, defc, member);
                this.checkSecurityManager(defc, member);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException(ex);
            }
            if (this.allowedModes != -1 && member.isCallerSensitive()) {
                Class<?> callerClass = target.internalCallerClass();
                if (!this.hasPrivateAccess() || callerClass != this.lookupClass()) {
                    throw new IllegalArgumentException("method handle is caller sensitive: " + callerClass);
                }
            }
            return new InfoFromMemberName(this, member, refKind);
        }

        MemberName resolveOrFail(byte refKind, Class<?> refc, String name, Class<?> type) throws NoSuchFieldException, IllegalAccessException {
            this.checkSymbolicClass(refc);
            name.getClass();
            type.getClass();
            return IMPL_NAMES.resolveOrFail(refKind, new MemberName(refc, name, type, refKind), this.lookupClassOrNull(), NoSuchFieldException.class);
        }

        MemberName resolveOrFail(byte refKind, Class<?> refc, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            this.checkSymbolicClass(refc);
            name.getClass();
            type.getClass();
            this.checkMethodName(refKind, name);
            return IMPL_NAMES.resolveOrFail(refKind, new MemberName(refc, name, type, refKind), this.lookupClassOrNull(), NoSuchMethodException.class);
        }

        MemberName resolveOrFail(byte refKind, MemberName member) throws ReflectiveOperationException {
            this.checkSymbolicClass(member.getDeclaringClass());
            member.getName().getClass();
            member.getType().getClass();
            return IMPL_NAMES.resolveOrFail(refKind, member, this.lookupClassOrNull(), ReflectiveOperationException.class);
        }

        void checkSymbolicClass(Class<?> refc) throws IllegalAccessException {
            refc.getClass();
            Class<?> caller = this.lookupClassOrNull();
            if (caller != null && !VerifyAccess.isClassAccessible(refc, caller, this.allowedModes)) {
                throw new MemberName(refc).makeAccessException("symbolic reference class is not public", this);
            }
        }

        void checkMethodName(byte refKind, String name) throws NoSuchMethodException {
            if (name.startsWith("<") && refKind != 8) {
                throw new NoSuchMethodException("illegal method name: " + name);
            }
        }

        Class<?> findBoundCallerClass(MemberName m) throws IllegalAccessException {
            Class<?> callerClass = null;
            if (MethodHandleNatives.isCallerSensitive(m)) {
                if (this.hasPrivateAccess()) {
                    callerClass = this.lookupClass;
                } else {
                    throw new IllegalAccessException("Attempt to lookup caller-sensitive method using restricted lookup object");
                }
            }
            return callerClass;
        }

        private boolean hasPrivateAccess() {
            return (this.allowedModes & 2) != 0;
        }

        void checkSecurityManager(Class<?> refc, MemberName m) {
            SecurityManager smgr = System.getSecurityManager();
            if (smgr == null) {
                return;
            }
            if (this.allowedModes == -1) {
                return;
            }
            boolean fullPowerLookup = this.hasPrivateAccess();
            if (!fullPowerLookup || !VerifyAccess.classLoaderIsAncestor(this.lookupClass, refc)) {
                ReflectUtil.checkPackageAccess(refc);
            }
            if (m.isPublic()) {
                return;
            }
            if (!fullPowerLookup) {
                smgr.checkPermission(SecurityConstants.CHECK_MEMBER_ACCESS_PERMISSION);
            }
            Class<?> defc = m.getDeclaringClass();
            if (!fullPowerLookup && defc != refc) {
                ReflectUtil.checkPackageAccess(defc);
            }
        }

        void checkMethod(byte refKind, Class<?> refc, MemberName m) throws IllegalAccessException {
            String message;
            boolean wantStatic;
            boolean bl = wantStatic = refKind == 6;
            if (m.isConstructor()) {
                message = "expected a method, not a constructor";
            } else if (!m.isMethod()) {
                message = "expected a method";
            } else if (wantStatic != m.isStatic()) {
                message = wantStatic ? "expected a static method" : "expected a non-static method";
            } else {
                this.checkAccess(refKind, refc, m);
                return;
            }
            throw m.makeAccessException(message, this);
        }

        void checkField(byte refKind, Class<?> refc, MemberName m) throws IllegalAccessException {
            boolean wantStatic;
            boolean bl = wantStatic = !MethodHandleNatives.refKindHasReceiver(refKind);
            if (wantStatic == m.isStatic()) {
                this.checkAccess(refKind, refc, m);
                return;
            }
            String message = wantStatic ? "expected a static field" : "expected a non-static field";
            throw m.makeAccessException(message, this);
        }

        void checkAccess(byte refKind, Class<?> refc, MemberName m) throws IllegalAccessException {
            assert (m.referenceKindIsConsistentWith(refKind) && MethodHandleNatives.refKindIsValid(refKind) && MethodHandleNatives.refKindIsField(refKind) == m.isField());
            int allowedModes = this.allowedModes;
            if (allowedModes == -1) {
                return;
            }
            int mods = m.getModifiers();
            if (Modifier.isProtected(mods) && refKind == 5 && m.getDeclaringClass() == Object.class && m.getName().equals("clone") && refc.isArray()) {
                mods ^= 5;
            }
            if (Modifier.isProtected(mods) && refKind == 8) {
                mods ^= 4;
            }
            if (Modifier.isFinal(mods) && MethodHandleNatives.refKindIsSetter(refKind)) {
                throw m.makeAccessException("unexpected set of a final field", this);
            }
            if (Modifier.isPublic(mods) && Modifier.isPublic(refc.getModifiers()) && allowedModes != 0) {
                return;
            }
            int requestedModes = Lookup.fixmods(mods);
            if ((requestedModes & allowedModes) != 0 ? VerifyAccess.isMemberAccessible(refc, m.getDeclaringClass(), mods, this.lookupClass(), allowedModes) : (requestedModes & 4) != 0 && (allowedModes & 8) != 0 && VerifyAccess.isSamePackage(m.getDeclaringClass(), this.lookupClass())) {
                return;
            }
            throw m.makeAccessException(this.accessFailedMessage(refc, m), this);
        }

        String accessFailedMessage(Class<?> refc, MemberName m) {
            boolean classOK;
            Class<?> defc = m.getDeclaringClass();
            int mods = m.getModifiers();
            boolean bl = classOK = Modifier.isPublic(defc.getModifiers()) && (defc == refc || Modifier.isPublic(refc.getModifiers()));
            if (!classOK && (this.allowedModes & 8) != 0) {
                boolean bl2 = classOK = VerifyAccess.isClassAccessible(defc, this.lookupClass(), 15) && (defc == refc || VerifyAccess.isClassAccessible(refc, this.lookupClass(), 15));
            }
            if (!classOK) {
                return "class is not public";
            }
            if (Modifier.isPublic(mods)) {
                return "access to public member failed";
            }
            if (Modifier.isPrivate(mods)) {
                return "member is private";
            }
            if (Modifier.isProtected(mods)) {
                return "member is protected";
            }
            return "member is private to package";
        }

        private void checkSpecialCaller(Class<?> specialCaller) throws IllegalAccessException {
            int allowedModes = this.allowedModes;
            if (allowedModes == -1) {
                return;
            }
            if (!this.hasPrivateAccess() || specialCaller != this.lookupClass()) {
                throw new MemberName(specialCaller).makeAccessException("no private access for invokespecial", this);
            }
        }

        private boolean restrictProtectedReceiver(MemberName method) {
            return method.isProtected() && !method.isStatic() && this.allowedModes != -1 && method.getDeclaringClass() != this.lookupClass() && !VerifyAccess.isSamePackage(method.getDeclaringClass(), this.lookupClass());
            {
            }
        }

        private MethodHandle restrictReceiver(MemberName method, DirectMethodHandle mh, Class<?> caller) throws IllegalAccessException {
            assert (!method.isStatic());
            if (!method.getDeclaringClass().isAssignableFrom(caller)) {
                throw method.makeAccessException("caller class must be a subclass below the method", caller);
            }
            MethodType rawType = mh.type();
            if (rawType.parameterType(0) == caller) {
                return mh;
            }
            MethodType narrowType = rawType.changeParameterType(0, caller);
            assert (!mh.isVarargsCollector());
            assert (mh.viewAsTypeChecks(narrowType, true));
            return mh.copyWith(narrowType, mh.form);
        }

        private MethodHandle getDirectMethod(byte refKind, Class<?> refc, MemberName method, Class<?> callerClass) throws IllegalAccessException {
            boolean doRestrict = true;
            boolean checkSecurity = true;
            return this.getDirectMethodCommon(refKind, refc, method, true, true, callerClass);
        }

        private MethodHandle getDirectMethodNoRestrict(byte refKind, Class<?> refc, MemberName method, Class<?> callerClass) throws IllegalAccessException {
            boolean doRestrict = false;
            boolean checkSecurity = true;
            return this.getDirectMethodCommon(refKind, refc, method, true, false, callerClass);
        }

        private MethodHandle getDirectMethodNoSecurityManager(byte refKind, Class<?> refc, MemberName method, Class<?> callerClass) throws IllegalAccessException {
            boolean doRestrict = true;
            boolean checkSecurity = false;
            return this.getDirectMethodCommon(refKind, refc, method, false, true, callerClass);
        }

        private MethodHandle getDirectMethodCommon(byte refKind, Class<?> refc, MemberName method, boolean checkSecurity, boolean doRestrict, Class<?> callerClass) throws IllegalAccessException {
            this.checkMethod(refKind, refc, method);
            if (checkSecurity) {
                this.checkSecurityManager(refc, method);
            }
            assert (!method.isMethodHandleInvoke());
            if (refKind == 7 && refc != this.lookupClass() && !refc.isInterface() && refc != this.lookupClass().getSuperclass() && refc.isAssignableFrom(this.lookupClass())) {
                MemberName m2;
                assert (!method.getName().equals("<init>"));
                Class<?> refcAsSuper = this.lookupClass();
                do {
                    refcAsSuper = refcAsSuper.getSuperclass();
                    m2 = new MemberName(refcAsSuper, method.getName(), method.getMethodType(), 7);
                } while ((m2 = IMPL_NAMES.resolveOrNull(refKind, m2, this.lookupClassOrNull())) == null && refc != refcAsSuper);
                if (m2 == null) {
                    throw new InternalError(method.toString());
                }
                method = m2;
                refc = refcAsSuper;
                this.checkMethod(refKind, refc, method);
            }
            DirectMethodHandle dmh = DirectMethodHandle.make(refKind, refc, method);
            MethodHandle mh = dmh;
            if (doRestrict && (refKind == 7 || MethodHandleNatives.refKindHasReceiver(refKind) && this.restrictProtectedReceiver(method))) {
                mh = this.restrictReceiver(method, dmh, this.lookupClass());
            }
            mh = this.maybeBindCaller(method, mh, callerClass);
            mh = mh.setVarargs(method);
            return mh;
        }

        private MethodHandle maybeBindCaller(MemberName method, MethodHandle mh, Class<?> callerClass) throws IllegalAccessException {
            if (this.allowedModes == -1 || !MethodHandleNatives.isCallerSensitive(method)) {
                return mh;
            }
            Class<?> hostClass = this.lookupClass;
            if (!this.hasPrivateAccess()) {
                hostClass = callerClass;
            }
            MethodHandle cbmh = MethodHandleImpl.bindCaller(mh, hostClass);
            return cbmh;
        }

        private MethodHandle getDirectField(byte refKind, Class<?> refc, MemberName field) throws IllegalAccessException {
            boolean checkSecurity = true;
            return this.getDirectFieldCommon(refKind, refc, field, true);
        }

        private MethodHandle getDirectFieldNoSecurityManager(byte refKind, Class<?> refc, MemberName field) throws IllegalAccessException {
            boolean checkSecurity = false;
            return this.getDirectFieldCommon(refKind, refc, field, false);
        }

        private MethodHandle getDirectFieldCommon(byte refKind, Class<?> refc, MemberName field, boolean checkSecurity) throws IllegalAccessException {
            boolean doRestrict;
            this.checkField(refKind, refc, field);
            if (checkSecurity) {
                this.checkSecurityManager(refc, field);
            }
            DirectMethodHandle dmh = DirectMethodHandle.make(refc, field);
            boolean bl = doRestrict = MethodHandleNatives.refKindHasReceiver(refKind) && this.restrictProtectedReceiver(field);
            if (doRestrict) {
                return this.restrictReceiver(field, dmh, this.lookupClass());
            }
            return dmh;
        }

        private MethodHandle getDirectConstructor(Class<?> refc, MemberName ctor) throws IllegalAccessException {
            boolean checkSecurity = true;
            return this.getDirectConstructorCommon(refc, ctor, true);
        }

        private MethodHandle getDirectConstructorNoSecurityManager(Class<?> refc, MemberName ctor) throws IllegalAccessException {
            boolean checkSecurity = false;
            return this.getDirectConstructorCommon(refc, ctor, false);
        }

        private MethodHandle getDirectConstructorCommon(Class<?> refc, MemberName ctor, boolean checkSecurity) throws IllegalAccessException {
            assert (ctor.isConstructor());
            this.checkAccess((byte)8, refc, ctor);
            if (checkSecurity) {
                this.checkSecurityManager(refc, ctor);
            }
            assert (!MethodHandleNatives.isCallerSensitive(ctor));
            return DirectMethodHandle.make(ctor).setVarargs(ctor);
        }

        MethodHandle linkMethodHandleConstant(byte refKind, Class<?> defc, String name, Object type) throws ReflectiveOperationException {
            if (!(type instanceof Class) && !(type instanceof MethodType)) {
                throw new InternalError("unresolved MemberName");
            }
            MemberName member = new MemberName(refKind, defc, name, type);
            MethodHandle mh = LOOKASIDE_TABLE.get(member);
            if (mh != null) {
                this.checkSymbolicClass(defc);
                return mh;
            }
            if (defc == MethodHandle.class && refKind == 5 && (mh = this.findVirtualForMH(member.getName(), member.getMethodType())) != null) {
                return mh;
            }
            MemberName resolved = this.resolveOrFail(refKind, member);
            mh = this.getDirectMethodForConstant(refKind, defc, resolved);
            if (mh instanceof DirectMethodHandle && this.canBeCached(refKind, defc, resolved)) {
                MemberName key = mh.internalMemberName();
                if (key != null) {
                    key = key.asNormalOriginal();
                }
                if (member.equals(key)) {
                    LOOKASIDE_TABLE.put(key, (DirectMethodHandle)mh);
                }
            }
            return mh;
        }

        private boolean canBeCached(byte refKind, Class<?> defc, MemberName member) {
            if (refKind == 7) {
                return false;
            }
            if (!Modifier.isPublic(defc.getModifiers()) || !Modifier.isPublic(member.getDeclaringClass().getModifiers()) || !member.isPublic() || member.isCallerSensitive()) {
                return false;
            }
            ClassLoader loader = defc.getClassLoader();
            if (!VM.isSystemDomainLoader(loader)) {
                boolean found = false;
                for (ClassLoader sysl = ClassLoader.getSystemClassLoader(); sysl != null; sysl = sysl.getParent()) {
                    if (loader != sysl) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
            }
            try {
                MemberName resolved2 = MethodHandles.publicLookup().resolveOrFail(refKind, new MemberName(refKind, defc, member.getName(), member.getType()));
                this.checkSecurityManager(defc, resolved2);
            }
            catch (ReflectiveOperationException | SecurityException ex) {
                return false;
            }
            return true;
        }

        private MethodHandle getDirectMethodForConstant(byte refKind, Class<?> defc, MemberName member) throws ReflectiveOperationException {
            if (MethodHandleNatives.refKindIsField(refKind)) {
                return this.getDirectFieldNoSecurityManager(refKind, defc, member);
            }
            if (MethodHandleNatives.refKindIsMethod(refKind)) {
                return this.getDirectMethodNoSecurityManager(refKind, defc, member, this.lookupClass);
            }
            if (refKind == 8) {
                return this.getDirectConstructorNoSecurityManager(defc, member);
            }
            throw MethodHandleStatics.newIllegalArgumentException("bad MethodHandle constant #" + member);
        }

        static {
            IMPL_NAMES.getClass();
            PUBLIC_LOOKUP = new Lookup(Object.class, 1);
            IMPL_LOOKUP = new Lookup(Object.class, -1);
            LOOKASIDE_TABLE = new ConcurrentHashMap();
        }
    }
}

