/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;
import javax.imageio.stream.MemoryCache;

public class MemoryCacheImageOutputStream
extends ImageOutputStreamImpl {
    private OutputStream stream;
    private MemoryCache cache = new MemoryCache();

    public MemoryCacheImageOutputStream(OutputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("stream == null!");
        }
        this.stream = stream;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        this.bitOffset = 0;
        int val = this.cache.read(this.streamPos);
        if (val != -1) {
            ++this.streamPos;
        }
        return val;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        if (b == null) {
            throw new NullPointerException("b == null!");
        }
        if (off < 0 || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off+len > b.length || off+len < 0!");
        }
        this.bitOffset = 0;
        if (len == 0) {
            return 0;
        }
        long bytesLeftInCache = this.cache.getLength() - this.streamPos;
        if (bytesLeftInCache <= 0L) {
            return -1;
        }
        len = (int)Math.min(bytesLeftInCache, (long)len);
        this.cache.read(b, off, len, this.streamPos);
        this.streamPos += (long)len;
        return len;
    }

    @Override
    public void write(int b) throws IOException {
        this.flushBits();
        this.cache.write(b, this.streamPos);
        ++this.streamPos;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.flushBits();
        this.cache.write(b, off, len, this.streamPos);
        this.streamPos += (long)len;
    }

    @Override
    public long length() {
        try {
            this.checkClosed();
            return this.cache.getLength();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public boolean isCachedFile() {
        return false;
    }

    @Override
    public boolean isCachedMemory() {
        return true;
    }

    @Override
    public void close() throws IOException {
        long length = this.cache.getLength();
        this.seek(length);
        this.flushBefore(length);
        super.close();
        this.cache.reset();
        this.cache = null;
        this.stream = null;
    }

    @Override
    public void flushBefore(long pos) throws IOException {
        long oFlushedPos = this.flushedPos;
        super.flushBefore(pos);
        long flushBytes = this.flushedPos - oFlushedPos;
        this.cache.writeToStream(this.stream, oFlushedPos, flushBytes);
        this.cache.disposeBefore(this.flushedPos);
        this.stream.flush();
    }
}

