/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SignatureException;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ECKeySizeParameterSpec;

public final class ECUtil {
    private static final Debug debug = Debug.getInstance("ecc");

    public static ECPoint decodePoint(byte[] data, EllipticCurve curve) throws IOException {
        if (data.length == 0 || data[0] != 4) {
            throw new IOException("Only uncompressed point format supported");
        }
        int n = (data.length - 1) / 2;
        if (n != curve.getField().getFieldSize() + 7 >> 3) {
            throw new IOException("Point does not match field size");
        }
        byte[] xb = Arrays.copyOfRange(data, 1, 1 + n);
        byte[] yb = Arrays.copyOfRange(data, n + 1, n + 1 + n);
        return new ECPoint(new BigInteger(1, xb), new BigInteger(1, yb));
    }

    public static byte[] encodePoint(ECPoint point, EllipticCurve curve) {
        int n = curve.getField().getFieldSize() + 7 >> 3;
        byte[] xb = ECUtil.trimZeroes(point.getAffineX().toByteArray());
        byte[] yb = ECUtil.trimZeroes(point.getAffineY().toByteArray());
        if (xb.length > n || yb.length > n) {
            throw new RuntimeException("Point coordinates do not match field size");
        }
        byte[] b = new byte[1 + (n << 1)];
        b[0] = 4;
        System.arraycopy(xb, 0, b, n - xb.length + 1, xb.length);
        System.arraycopy(yb, 0, b, b.length - yb.length, yb.length);
        return b;
    }

    public static byte[] trimZeroes(byte[] b) {
        int i;
        for (i = 0; i < b.length - 1 && b[i] == 0; ++i) {
        }
        if (i == 0) {
            return b;
        }
        return Arrays.copyOfRange(b, i, b.length);
    }

    public static AlgorithmParameters getECParameters(Provider p) {
        return ECUtil.getECParameters(p, false);
    }

    public static AlgorithmParameters getECParameters(Provider p, boolean throwException) {
        try {
            if (p != null) {
                return AlgorithmParameters.getInstance("EC", p);
            }
            return AlgorithmParameters.getInstance("EC");
        }
        catch (NoSuchAlgorithmException nsae) {
            if (throwException) {
                throw new RuntimeException(nsae);
            }
            if (debug != null) {
                debug.println("Provider unavailable: " + nsae);
            }
            return null;
        }
    }

    public static byte[] encodeECParameterSpec(Provider p, ECParameterSpec spec) {
        AlgorithmParameters parameters = ECUtil.getECParameters(p, true);
        try {
            parameters.init(spec);
        }
        catch (InvalidParameterSpecException ipse) {
            throw new RuntimeException("Not a known named curve: " + spec);
        }
        try {
            return parameters.getEncoded();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static ECParameterSpec getECParameterSpec(Provider p, ECParameterSpec spec) {
        AlgorithmParameters parameters = ECUtil.getECParameters(p);
        if (parameters == null) {
            return null;
        }
        try {
            parameters.init(spec);
            return parameters.getParameterSpec(ECParameterSpec.class);
        }
        catch (InvalidParameterSpecException ipse) {
            if (debug != null) {
                debug.println("Invalid parameter specification: " + ipse);
            }
            return null;
        }
    }

    public static ECParameterSpec getECParameterSpec(Provider p, byte[] params) throws IOException {
        AlgorithmParameters parameters = ECUtil.getECParameters(p);
        if (parameters == null) {
            return null;
        }
        parameters.init(params);
        try {
            return parameters.getParameterSpec(ECParameterSpec.class);
        }
        catch (InvalidParameterSpecException ipse) {
            if (debug != null) {
                debug.println("Invalid parameter specification: " + ipse);
            }
            return null;
        }
    }

    public static ECParameterSpec getECParameterSpec(Provider p, String name) {
        AlgorithmParameters parameters = ECUtil.getECParameters(p);
        if (parameters == null) {
            return null;
        }
        try {
            parameters.init(new ECGenParameterSpec(name));
            return parameters.getParameterSpec(ECParameterSpec.class);
        }
        catch (InvalidParameterSpecException ipse) {
            if (debug != null) {
                debug.println("Invalid parameter specification: " + ipse);
            }
            return null;
        }
    }

    public static ECParameterSpec getECParameterSpec(Provider p, int keySize) {
        AlgorithmParameters parameters = ECUtil.getECParameters(p);
        if (parameters == null) {
            return null;
        }
        try {
            parameters.init(new ECKeySizeParameterSpec(keySize));
            return parameters.getParameterSpec(ECParameterSpec.class);
        }
        catch (InvalidParameterSpecException ipse) {
            if (debug != null) {
                debug.println("Invalid parameter specification: " + ipse);
            }
            return null;
        }
    }

    public static String getCurveName(Provider p, ECParameterSpec spec) {
        ECGenParameterSpec nameSpec;
        AlgorithmParameters parameters = ECUtil.getECParameters(p);
        if (parameters == null) {
            return null;
        }
        try {
            parameters.init(spec);
            nameSpec = parameters.getParameterSpec(ECGenParameterSpec.class);
        }
        catch (InvalidParameterSpecException ipse) {
            if (debug != null) {
                debug.println("Invalid parameter specification: " + ipse);
            }
            return null;
        }
        if (nameSpec == null) {
            return null;
        }
        return nameSpec.getName();
    }

    public static boolean equals(ECParameterSpec spec1, ECParameterSpec spec2) {
        if (spec1 == spec2) {
            return true;
        }
        if (spec1 == null || spec2 == null) {
            return false;
        }
        return spec1.getCofactor() == spec2.getCofactor() && spec1.getOrder().equals(spec2.getOrder()) && spec1.getCurve().equals(spec2.getCurve()) && spec1.getGenerator().equals(spec2.getGenerator());
    }

    public static byte[] encodeSignature(byte[] signature) throws SignatureException {
        try {
            int n = signature.length >> 1;
            byte[] bytes = new byte[n];
            System.arraycopy(signature, 0, bytes, 0, n);
            BigInteger r = new BigInteger(1, bytes);
            System.arraycopy(signature, n, bytes, 0, n);
            BigInteger s = new BigInteger(1, bytes);
            DerOutputStream out = new DerOutputStream(signature.length + 10);
            out.putInteger(r);
            out.putInteger(s);
            DerValue result = new DerValue(48, out.toByteArray());
            return result.toByteArray();
        }
        catch (Exception e) {
            throw new SignatureException("Could not encode signature", e);
        }
    }

    public static byte[] decodeSignature(byte[] sig) throws SignatureException {
        try {
            DerInputStream in = new DerInputStream(sig, 0, sig.length, false);
            DerValue[] values = in.getSequence(2);
            if (values.length != 2 || in.available() != 0) {
                throw new IOException("Invalid encoding for signature");
            }
            BigInteger r = values[0].getPositiveBigInteger();
            BigInteger s = values[1].getPositiveBigInteger();
            byte[] rBytes = ECUtil.trimZeroes(r.toByteArray());
            byte[] sBytes = ECUtil.trimZeroes(s.toByteArray());
            int k = Math.max(rBytes.length, sBytes.length);
            byte[] result = new byte[k << 1];
            System.arraycopy(rBytes, 0, result, k - rBytes.length, rBytes.length);
            System.arraycopy(sBytes, 0, result, result.length - sBytes.length, sBytes.length);
            return result;
        }
        catch (Exception e) {
            throw new SignatureException("Invalid encoding for signature", e);
        }
    }

    private ECUtil() {
    }
}

