/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.net.ProgressSource;
import sun.net.www.MeteredStream;
import sun.net.www.http.HttpClient;
import sun.net.www.http.Hurryable;
import sun.net.www.http.KeepAliveCleanerEntry;
import sun.net.www.http.KeepAliveStreamCleaner;

public class KeepAliveStream
extends MeteredStream
implements Hurryable {
    HttpClient hc;
    boolean hurried;
    protected boolean queuedForCleanup = false;
    private static final KeepAliveStreamCleaner queue = new KeepAliveStreamCleaner();
    private static Thread cleanerThread;

    public KeepAliveStream(InputStream is, ProgressSource pi, long expected, HttpClient hc) {
        super(is, pi, expected);
        this.hc = hc;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.queuedForCleanup) {
            return;
        }
        try {
            if (this.expected > this.count) {
                long nskip = this.expected - this.count;
                if (nskip <= (long)this.available()) {
                    while ((nskip = this.expected - this.count) > 0L && this.skip(Math.min(nskip, (long)this.available())) > 0L) {
                    }
                } else if (this.expected <= (long)KeepAliveStreamCleaner.MAX_DATA_REMAINING && !this.hurried) {
                    KeepAliveStream.queueForCleanup(new KeepAliveCleanerEntry(this, this.hc));
                } else {
                    this.hc.closeServer();
                }
            }
            if (!(this.closed || this.hurried || this.queuedForCleanup)) {
                this.hc.finished();
            }
        }
        finally {
            if (this.pi != null) {
                this.pi.finishTracking();
            }
            if (!this.queuedForCleanup) {
                this.in = null;
                this.hc = null;
                this.closed = true;
            }
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int limit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public synchronized boolean hurry() {
        try {
            if (this.closed || this.count >= this.expected) {
                return false;
            }
            if ((long)this.in.available() < this.expected - this.count) {
                return false;
            }
            int size = (int)(this.expected - this.count);
            byte[] buf = new byte[size];
            DataInputStream dis = new DataInputStream(this.in);
            dis.readFully(buf);
            this.in = new ByteArrayInputStream(buf);
            this.hurried = true;
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void queueForCleanup(KeepAliveCleanerEntry kace) {
        KeepAliveStreamCleaner keepAliveStreamCleaner = queue;
        synchronized (keepAliveStreamCleaner) {
            boolean startCleanupThread;
            if (!kace.getQueuedForCleanup()) {
                if (!queue.offer(kace)) {
                    kace.getHttpClient().closeServer();
                    return;
                }
                kace.setQueuedForCleanup();
                queue.notifyAll();
            }
            boolean bl = startCleanupThread = cleanerThread == null;
            if (!startCleanupThread && !cleanerThread.isAlive()) {
                startCleanupThread = true;
            }
            if (startCleanupThread) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        ThreadGroup grp = Thread.currentThread().getThreadGroup();
                        ThreadGroup parent = null;
                        while ((parent = grp.getParent()) != null) {
                            grp = parent;
                        }
                        cleanerThread = new Thread(grp, queue, "Keep-Alive-SocketCleaner");
                        cleanerThread.setDaemon(true);
                        cleanerThread.setPriority(8);
                        cleanerThread.setContextClassLoader(null);
                        cleanerThread.start();
                        return null;
                    }
                });
            }
        }
    }

    protected long remainingToRead() {
        return this.expected - this.count;
    }

    protected void setClosed() {
        this.in = null;
        this.hc = null;
        this.closed = true;
    }
}

