/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.callback;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import sun.misc.Cleaner;

public class PasswordCallback
implements Callback,
Serializable {
    private static final long serialVersionUID = 2267422647454909926L;
    private final String prompt;
    private final boolean echoOn;
    private char[] inputPassword;
    private transient Cleaner cleaner;

    public PasswordCallback(String prompt, boolean echoOn) {
        if (prompt == null || prompt.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.prompt = prompt;
        this.echoOn = echoOn;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public boolean isEchoOn() {
        return this.echoOn;
    }

    public void setPassword(char[] password) {
        if (this.cleaner != null) {
            this.cleaner.clean();
            this.cleaner = null;
        }
        char[] cArray = this.inputPassword = password == null ? null : (char[])password.clone();
        if (this.inputPassword != null) {
            this.cleaner = Cleaner.create(this, PasswordCallback.cleanerFor(this.inputPassword));
        }
    }

    public char[] getPassword() {
        return this.inputPassword == null ? null : (char[])this.inputPassword.clone();
    }

    public void clearPassword() {
        if (this.cleaner != null) {
            this.cleaner.clean();
            this.cleaner = null;
        }
    }

    private static Runnable cleanerFor(char[] password) {
        return () -> Arrays.fill(password, ' ');
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.prompt == null || this.prompt.isEmpty()) {
            throw new InvalidObjectException("Missing prompt");
        }
        if (this.inputPassword != null) {
            this.inputPassword = (char[])this.inputPassword.clone();
            this.cleaner = Cleaner.create(this, PasswordCallback.cleanerFor(this.inputPassword));
        }
    }
}

